/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class DisjointSet {
    private Map elements = new HashMap();

    public void add(Object o) {
        if (this.elements.containsKey(o)) {
            return;
        }
        this.elements.put(o, new Node(o));
    }

    public boolean isSame(Object x, Object y) {
        return this.find(x).equals(this.find(y));
    }

    public Object find(Object o) {
        return this.findRoot((Object)o).object;
    }

    private Node findRoot(Object o) {
        Node node = (Node)this.elements.get(o);
        while (node.parent.parent != node.parent) {
            node = node.parent = node.parent.parent;
        }
        return node.parent;
    }

    public Object union(Object x, Object y) {
        Node rootX = this.findRoot(x);
        Node rootY = this.findRoot(y);
        if (rootX.rank > rootY.rank) {
            Node node = rootX;
            rootX = rootY;
            rootY = node;
        } else if (rootX.rank == rootY.rank) {
            ++rootY.rank;
        }
        rootX.parent = rootY;
        return rootY;
    }

    public Collection getEquivalanceSets() {
        HashMap equivalanceSets = new HashMap();
        for (Object x : this.elements.keySet()) {
            Object representative = this.find(x);
            HashSet equivalanceSet = (HashSet)equivalanceSets.get(representative);
            if (equivalanceSet == null) {
                equivalanceSet = new HashSet();
                equivalanceSets.put(representative, equivalanceSet);
            }
            equivalanceSet.add(x);
        }
        return equivalanceSets.values();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        Iterator i = this.elements.values().iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            buffer.append(node.object);
            buffer.append(" -> ");
            buffer.append(node.parent.object);
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}");
        return buffer.toString();
    }

    private class Node {
        Object object;
        Node parent = this;
        int rank = 0;

        Node(Object o) {
            this.object = o;
        }
    }
}

