/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.fsm;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.fsm.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State {
    static int next_unused_name = 0;
    int name = next_unused_name++;
    Set<Transition> transitions = new HashSet<Transition>();
    boolean marked;
    int partition_num;
    State rep;

    public void addTransition(Object transition, State s) {
        if (transition == null || s == null) {
            throw new NullPointerException();
        }
        if (!(transition instanceof Role)) {
            throw new ClassCastException();
        }
        Transition t = new Transition(transition, s);
        this.transitions.add(t);
    }

    public void addTransition(State s) {
        if (s == null) {
            throw new NullPointerException();
        }
        Transition t = new Transition(s);
        this.transitions.add(t);
    }

    public Set<Transition> getTransitions() {
        return this.transitions;
    }

    public State dMove(Object c) {
        for (Transition t : this.transitions) {
            if (!t.hasName(c)) continue;
            return t.getTo();
        }
        return null;
    }

    public String getName() {
        return String.valueOf(this.name);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name).append(": ");
        Iterator<Transition> i = this.transitions.iterator();
        while (i.hasNext()) {
            Transition t = i.next();
            buf.append(t);
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }
}

