/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.fsm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.fsm.State;
import org.mindswap.pellet.utils.fsm.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionGraph {
    private State initialState = null;
    private Set<State> allStates = new HashSet<State>();
    private Set<State> finalStates = new HashSet<State>();
    private Set<Object> alphabet = new HashSet<Object>();

    public TransitionGraph copy() {
        TransitionGraph copy = new TransitionGraph();
        copy.alphabet = new HashSet<Object>(this.alphabet);
        HashMap<State, State> newStates = new HashMap<State, State>();
        for (State s1 : this.allStates) {
            State n1 = (State)newStates.get(s1);
            if (n1 == null) {
                n1 = copy.newState();
                newStates.put(s1, n1);
            }
            if (this.finalStates.contains(s1)) {
                copy.finalStates.add(n1);
            }
            for (Transition t : s1.transitions) {
                State s2 = t.getTo();
                Object symbol = t.getName();
                State n2 = (State)newStates.get(s2);
                if (n2 == null) {
                    n2 = copy.newState();
                    newStates.put(s2, n2);
                }
                n1.addTransition(symbol, n2);
            }
        }
        copy.initialState = (State)newStates.get(this.initialState);
        return copy;
    }

    public int size() {
        return this.allStates.size();
    }

    public State newState() {
        State s = new State();
        this.allStates.add(s);
        return s;
    }

    public Set getAlpahabet() {
        return Collections.unmodifiableSet(this.alphabet);
    }

    public Set<State> getAllStates() {
        return Collections.unmodifiableSet(this.allStates);
    }

    public void setInitialState(State s) {
        this.initialState = s;
    }

    public State getInitialState() {
        return this.initialState;
    }

    public void addFinalState(State s) {
        this.finalStates.add(s);
    }

    public Set<State> getFinalStates() {
        return this.finalStates;
    }

    public State getFinalState() {
        int size = this.finalStates.size();
        if (size == 0) {
            throw new RuntimeException("There are no final states!");
        }
        if (size > 1) {
            throw new RuntimeException("There is more than one final state!");
        }
        return this.finalStates.iterator().next();
    }

    public void addTransition(State begin, Object transition, State end) {
        begin.addTransition(transition, end);
        if (transition != Transition.EPSILON) {
            this.alphabet.add(transition);
        } else if (transition == null) {
            throw new NullPointerException();
        }
    }

    public void addTransition(State begin, State end) {
        begin.addTransition(end);
    }

    public List<Pair<State, State>> findTransitions(Object transition) {
        ArrayList<Pair<State, State>> result = new ArrayList<Pair<State, State>>();
        for (State s1 : this.allStates) {
            State s2 = s1.dMove(transition);
            if (s2 == null) continue;
            result.add(new Pair<State, State>(s1, s2));
        }
        return result;
    }

    public boolean isFinal(State st) {
        return this.finalStates.contains(st);
    }

    public boolean isFinal(Set<State> ss) {
        for (State st : ss) {
            if (!this.finalStates.contains(st)) continue;
            return true;
        }
        return false;
    }

    public TransitionGraph epsilon() {
        TransitionGraph tg = new TransitionGraph();
        State s = tg.newState();
        State f = tg.newState();
        s.addTransition(f);
        tg.initialState = s;
        tg.finalStates.add(f);
        return tg;
    }

    public static TransitionGraph symbol(Object transition) {
        TransitionGraph tg = new TransitionGraph();
        State s = tg.newState();
        State f = tg.newState();
        s.addTransition(transition, f);
        tg.initialState = s;
        tg.finalStates.add(f);
        tg.alphabet.add(transition);
        return tg;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[Transition Graph\n");
        for (State st : this.allStates) {
            buf.append(st).append("\n");
        }
        buf.append("initial state: ");
        buf.append(this.initialState.getName());
        buf.append("\n");
        buf.append("final states: { ");
        Iterator<Object> i = this.finalStates.iterator();
        while (i.hasNext()) {
            State st;
            st = i.next();
            buf.append(st.getName());
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("}\n");
        buf.append("alphabet: { ");
        i = this.alphabet.iterator();
        while (i.hasNext()) {
            Object transition = i.next();
            buf.append(transition);
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(" }\n");
        buf.append("]\n");
        return buf.toString();
    }

    public TransitionGraph renumber() {
        for (State st : this.allStates) {
            st.marked = false;
            st.partition_num = 0;
        }
        LinkedList<State> workList = new LinkedList<State>();
        int val = 0;
        workList.addFirst(this.initialState);
        while (workList.size() > 0) {
            State s = (State)workList.removeFirst();
            s.name = val++;
            s.marked = true;
            for (Transition e : s.transitions) {
                if (e.getTo().marked) continue;
                workList.addLast(e.getTo());
            }
        }
        return this;
    }

    public boolean accepts(List str) {
        State s = this.initialState;
        for (Object ch : str) {
            if ((s = s.dMove(ch)) != null) continue;
            return false;
        }
        return this.finalStates.contains(s);
    }

    public TransitionGraph choice(TransitionGraph t) {
        State s = this.newState();
        State f = this.newState();
        this.allStates.addAll(t.allStates);
        this.finalStates.addAll(t.finalStates);
        s.addTransition(this.initialState);
        s.addTransition(t.initialState);
        this.initialState = s;
        for (State st : this.finalStates) {
            st.addTransition(f);
        }
        this.finalStates.clear();
        this.finalStates.add(f);
        this.alphabet.addAll(t.alphabet);
        return this;
    }

    public TransitionGraph concat(TransitionGraph t) {
        State s = this.newState();
        State f = this.newState();
        this.allStates.addAll(t.allStates);
        s.addTransition(this.initialState);
        this.initialState = s;
        for (State st : this.finalStates) {
            st.addTransition(t.initialState);
        }
        for (State st : t.finalStates) {
            st.addTransition(f);
        }
        this.finalStates.clear();
        this.finalStates.add(f);
        this.alphabet.addAll(t.alphabet);
        return this;
    }

    public TransitionGraph closure() {
        State s = this.newState();
        State f = this.newState();
        for (State st : this.finalStates) {
            st.addTransition(this.initialState);
            st.addTransition(f);
        }
        this.finalStates.clear();
        this.finalStates.add(f);
        s.addTransition(this.initialState);
        s.addTransition(f);
        this.initialState = s;
        return this;
    }

    public TransitionGraph insert(TransitionGraph t, State i, State f) {
        this.allStates.addAll(t.allStates);
        this.alphabet.addAll(t.alphabet);
        i.addTransition(t.getInitialState());
        for (State st : t.getFinalStates()) {
            st.addTransition(f);
        }
        return this;
    }

    public Set<State> move(Set<State> SS, Object c) {
        HashSet<State> result = new HashSet<State>();
        for (State st : SS) {
            for (Transition e : st.transitions) {
                if (!e.hasName(c)) continue;
                result.add(e.getTo());
            }
        }
        return result;
    }

    public Set<State> epsilonClosure(State s, Set<State> result) {
        Iterator<Transition> i = s.transitions.iterator();
        result.add(s);
        while (i.hasNext()) {
            Transition e = i.next();
            if (!e.hasName(Transition.EPSILON) || result.contains(e.getTo())) continue;
            result = this.epsilonClosure(e.getTo(), result);
        }
        return result;
    }

    public Set<State> epsilonClosure(Set<State> SS) {
        Set<State> result = new HashSet<State>();
        for (State st : SS) {
            result = this.epsilonClosure(st, result);
        }
        return result;
    }

    public boolean isDeterministic() {
        if (!this.allStates.contains(this.initialState)) {
            throw new InternalReasonerException();
        }
        for (State s : this.allStates) {
            HashSet<Object> seenSymbols = new HashSet<Object>();
            for (Transition t : s.transitions) {
                Object symbol = t.getName();
                if (symbol == Transition.EPSILON || seenSymbols.contains(symbol)) {
                    return false;
                }
                seenSymbols.add(symbol);
            }
        }
        return true;
    }

    public TransitionGraph determinize() {
        HashMap<Set, State> dStates = new HashMap<Set, State>();
        State s = new State();
        Set ss = this.epsilonClosure(this.initialState, new HashSet<State>());
        this.initialState = s;
        s.marked = false;
        dStates.put(ss, s);
        this.initialState = s;
        boolean hasUnmarked = true;
        while (hasUnmarked) {
            State u = null;
            Set<State> U = null;
            hasUnmarked = false;
            for (Map.Entry entry : dStates.entrySet()) {
                s = (State)entry.getValue();
                ss = (Set)entry.getKey();
                hasUnmarked = !s.marked;
                if (!hasUnmarked) continue;
                break;
            }
            if (!hasUnmarked) continue;
            for (Object a : this.alphabet) {
                U = this.epsilonClosure(this.move(ss, a));
                if (U.size() == 0) continue;
                u = (State)dStates.get(U);
                if (u == null) {
                    u = new State();
                    u.marked = false;
                    dStates.put(U, u);
                } else if (u.equals(s)) {
                    u = s;
                }
                s.addTransition(a, u);
            }
            s.marked = true;
            dStates.put(ss, s);
        }
        HashSet<State> acceptingStates = new HashSet<State>();
        this.allStates.clear();
        for (Map.Entry entry : dStates.entrySet()) {
            s = (State)entry.getValue();
            ss = (Set)entry.getKey();
            this.allStates.add(s);
            if (!this.isFinal(ss)) continue;
            acceptingStates.add(s);
        }
        this.finalStates.clear();
        this.finalStates = acceptingStates;
        return this;
    }

    public void setPartition(Set<State> stateSet, int num) {
        for (State st : stateSet) {
            st.partition_num = num;
        }
    }

    public TransitionGraph minimize() {
        State t;
        Set[] partitions = new Set[this.allStates.size()];
        int numPartitions = 1;
        partitions[0] = new HashSet();
        partitions[0].addAll(this.finalStates);
        this.setPartition(partitions[0], 0);
        if (partitions[0].size() < this.allStates.size()) {
            partitions[1] = new HashSet();
            partitions[1].addAll(this.allStates);
            partitions[1].removeAll(this.finalStates);
            this.setPartition(partitions[1], 1);
            ++numPartitions;
        }
        for (int p = 0; p < numPartitions; ++p) {
            Iterator i = partitions[p].iterator();
            State s = (State)i.next();
            boolean partitionCreated = false;
            block1: while (i.hasNext()) {
                t = (State)i.next();
                for (Object a : this.alphabet) {
                    int tn;
                    int sn = s.dMove(a) == null ? -1 : s.dMove((Object)a).partition_num;
                    if (sn == (tn = t.dMove(a) == null ? -1 : t.dMove((Object)a).partition_num)) continue;
                    if (!partitionCreated) {
                        partitions[numPartitions++] = new HashSet();
                    }
                    partitionCreated = true;
                    i.remove();
                    partitions[numPartitions - 1].add(t);
                    continue block1;
                }
            }
            if (!partitionCreated) continue;
            this.setPartition(partitions[numPartitions - 1], numPartitions - 1);
            p = 0;
        }
        int startPartition = this.initialState.partition_num;
        for (int p = 0; p < numPartitions; ++p) {
            State s;
            Iterator i = partitions[p].iterator();
            s.rep = s = (State)i.next();
            if (p == startPartition) {
                this.initialState = s;
            }
            while (i.hasNext()) {
                t = (State)i.next();
                this.allStates.remove(t);
                this.finalStates.remove(t);
                t.rep = s;
            }
        }
        for (State t2 : this.allStates) {
            for (Transition edge : t2.transitions) {
                edge.setTo(edge.getTo().rep);
            }
        }
        return this;
    }
}

