/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler;

import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerGroup;
import com.hp.hpl.jena.assembler.assemblers.ConnectionAssembler;
import com.hp.hpl.jena.assembler.assemblers.ContentAssembler;
import com.hp.hpl.jena.assembler.assemblers.DefaultModelAssembler;
import com.hp.hpl.jena.assembler.assemblers.DocumentManagerAssembler;
import com.hp.hpl.jena.assembler.assemblers.FileManagerAssembler;
import com.hp.hpl.jena.assembler.assemblers.FileModelAssembler;
import com.hp.hpl.jena.assembler.assemblers.InfModelAssembler;
import com.hp.hpl.jena.assembler.assemblers.LocationMapperAssembler;
import com.hp.hpl.jena.assembler.assemblers.MemoryModelAssembler;
import com.hp.hpl.jena.assembler.assemblers.ModelSourceAssembler;
import com.hp.hpl.jena.assembler.assemblers.OntModelAssembler;
import com.hp.hpl.jena.assembler.assemblers.OntModelSpecAssembler;
import com.hp.hpl.jena.assembler.assemblers.PrefixMappingAssembler;
import com.hp.hpl.jena.assembler.assemblers.RDBModelAssembler;
import com.hp.hpl.jena.assembler.assemblers.ReasonerFactoryAssembler;
import com.hp.hpl.jena.assembler.assemblers.RuleSetAssembler;
import com.hp.hpl.jena.assembler.assemblers.UnionModelAssembler;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;

public interface Assembler {
    public static final Assembler defaultModel = new DefaultModelAssembler();
    public static final Assembler memoryModel = new MemoryModelAssembler();
    public static final Assembler infModel = new InfModelAssembler();
    public static final Assembler rdbModel = new RDBModelAssembler();
    public static final Assembler ontModel = new OntModelAssembler();
    public static final Assembler reasonerFactory = new ReasonerFactoryAssembler();
    public static final Assembler content = new ContentAssembler();
    public static final Assembler connection = new ConnectionAssembler();
    public static final Assembler prefixMapping = new PrefixMappingAssembler();
    public static final Assembler fileModel = new FileModelAssembler();
    public static final Assembler unionModel = new UnionModelAssembler();
    public static final Assembler ontModelSpec = new OntModelSpecAssembler();
    public static final Assembler ruleSet = new RuleSetAssembler();
    public static final Assembler modelSource = new ModelSourceAssembler();
    public static final Assembler locationMapper = new LocationMapperAssembler();
    public static final Assembler fileManager = new FileManagerAssembler();
    public static final Assembler documentManager = new DocumentManagerAssembler();
    public static final AssemblerGroup general = AssemblerGroup.create().implementWith(JA.DefaultModel, defaultModel).implementWith(JA.MemoryModel, memoryModel).implementWith(JA.InfModel, infModel).implementWith(JA.ReasonerFactory, reasonerFactory).implementWith(JA.ModelSource, modelSource).implementWith(JA.Content, content).implementWith(JA.ContentItem, content).implementWith(JA.Connection, connection).implementWith(JA.RDBModel, rdbModel).implementWith(JA.UnionModel, unionModel).implementWith(JA.PrefixMapping, prefixMapping).implementWith(JA.FileModel, fileModel).implementWith(JA.OntModel, ontModel).implementWith(JA.OntModelSpec, ontModelSpec).implementWith(JA.RuleSet, ruleSet).implementWith(JA.LocationMapper, locationMapper).implementWith(JA.FileManager, fileManager).implementWith(JA.DocumentManager, documentManager);

    public Object open(Assembler var1, Resource var2, Mode var3);

    public Object open(Assembler var1, Resource var2);

    public Object open(Resource var1);

    public Model openModel(Resource var1);

    public Model openModel(Resource var1, Mode var2);
}

