/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.AssemblerHelp;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.exceptions.NoImplementationException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashMap;
import java.util.Map;

public abstract class AssemblerGroup
extends AssemblerBase
implements Assembler {
    public abstract AssemblerGroup implementWith(Resource var1, Assembler var2);

    public abstract Assembler assemblerFor(Resource var1);

    public Model openModel(Resource resource) {
        return (Model)this.open(resource);
    }

    public static AssemblerGroup create() {
        return new ExpandingAssemblerGroup();
    }

    public AssemblerGroup copy() {
        ExpandingAssemblerGroup result = (ExpandingAssemblerGroup)AssemblerGroup.create();
        result.internal.mappings.putAll(((ExpandingAssemblerGroup)this).internal.mappings);
        return result;
    }

    static class PlainAssemblerGroup
    extends AssemblerGroup {
        Map mappings = new HashMap();

        PlainAssemblerGroup() {
        }

        public Object open(Assembler a, Resource root, Mode mode) {
            Resource type = AssemblerHelp.findSpecificType(root);
            Assembler toUse = this.assemblerFor(type);
            if (toUse == null) {
                throw new NoImplementationException(this, root, type);
            }
            return toUse.open(a, root, mode);
        }

        public AssemblerGroup implementWith(Resource type, Assembler a) {
            this.mappings.put(type, a);
            return this;
        }

        public Assembler assemblerFor(Resource type) {
            return (Assembler)this.mappings.get(type);
        }
    }

    public static class ExpandingAssemblerGroup
    extends AssemblerGroup {
        PlainAssemblerGroup internal = new PlainAssemblerGroup();
        Model implementTypes = ModelFactory.createDefaultModel();

        public Object open(Assembler a, Resource suppliedRoot, Mode mode) {
            Resource root = AssemblerHelp.withFullModel(suppliedRoot);
            root.getModel().add(this.implementTypes);
            this.loadClasses(root.getModel());
            return this.internal.open(a, root, mode);
        }

        public void loadClasses(Model model) {
            AssemblerHelp.loadClasses(this, model);
        }

        public AssemblerGroup implementWith(Resource type, Assembler a) {
            this.implementTypes.add(type, RDFS.subClassOf, JA.Object);
            this.internal.implementWith(type, a);
            return this;
        }

        public Assembler assemblerFor(Resource type) {
            return this.internal.assemblerFor(type);
        }
    }
}

