/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import com.hp.hpl.jena.n3.RelURI;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.LogFactory;

public class IRIResolver {
    private String baseStr = null;

    public IRIResolver() {
        this(null);
    }

    public IRIResolver(String base) {
        if (base == null) {
            base = IRIResolver.chooseBaseURI();
        }
        this.baseStr = base;
    }

    public String getBaseIRI() {
        return this.baseStr;
    }

    public String resolve(String relURI) {
        return RelURI.resolve(relURI, this.baseStr);
    }

    public static String resolve(String base, String relative) {
        return RelURI.resolve(relative, base);
    }

    public static String resolveGlobal(String str) {
        return RelURI.resolve(str);
    }

    public static String resolveFileURL(String filename) {
        return RelURI.resolveFileURL(filename);
    }

    public static String chooseBaseURI() {
        return IRIResolver.chooseBaseURI(null);
    }

    public static String chooseBaseURI(String baseURI) {
        String scheme;
        if (baseURI == null) {
            baseURI = "file:.";
        }
        if ((scheme = FileUtils.getScheme(baseURI)) == null) {
            scheme = "file";
            baseURI = "file:" + baseURI;
        }
        if (scheme.equals("file") && !baseURI.startsWith("file:///")) {
            try {
                String tmp = baseURI.substring("file:".length());
                File f = new File(tmp);
                String s = f.getCanonicalPath();
                s = s.replace('\\', '/');
                if (s.indexOf(32) >= 0) {
                    s = s.replaceAll(" ", "%20");
                }
                baseURI = s.startsWith("/") ? "file://" + s : "file:///" + s;
                if (f.isDirectory() && !baseURI.endsWith("/")) {
                    baseURI = baseURI + "/";
                }
            }
            catch (IOException ex) {
                LogFactory.getLog((Class)RelURI.class).warn((Object)"IOException in chooseBase - ignored");
                return null;
            }
        }
        return baseURI;
    }
}

