/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.turtle;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.n3.turtle.TurtleEventInserter;
import com.hp.hpl.jena.n3.turtle.TurtleParseException;
import com.hp.hpl.jena.n3.turtle.parser.ParseException;
import com.hp.hpl.jena.n3.turtle.parser.TokenMgrError;
import com.hp.hpl.jena.n3.turtle.parser.TurtleParser;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;

public class ParserTurtle {
    public static void main(String[] argv) {
        try {
            FileInputStream f = new FileInputStream("WorkSpace/Turtle/T.ttl");
            ParserTurtle p = new ParserTurtle();
            p.parse(null, "http://loclhost/unset/", f);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void parse(Graph graph, String baseURI, InputStream in) {
        Reader reader = FileUtils.asUTF8(in);
        this.parse(graph, baseURI, reader);
    }

    public void parse(Graph graph, String baseURI, Reader reader) {
        try {
            TurtleParser parser = new TurtleParser(reader);
            parser.setEventHandler(new TurtleEventInserter(graph));
            parser.setBaseURI(baseURI);
            parser.parse();
        }
        catch (ParseException ex) {
            throw new TurtleParseException(ex.getMessage());
        }
        catch (TokenMgrError tErr) {
            throw new TurtleParseException(tErr.getMessage());
        }
        catch (JenaException ex) {
            throw new TurtleParseException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new TurtleParseException(err.getMessage(), err);
        }
        catch (Throwable th) {
            throw new TurtleParseException(th.getMessage(), th);
        }
    }
}

