/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.paintCommon;

import com.sri.panther.paintCommon.User;
import edu.usc.ksom.pm.panther.paintCommon.CurationStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;

public class Book
implements Comparable,
Serializable {
    protected String id;
    protected String name;
    protected int curationStatus;
    protected Date curationStatusUpdateDate;
    protected Date lastAnnotationUpdateDate;
    protected User lockedBy;
    protected int numLeaves;
    protected HashSet<String> orgSet;
    protected String comment;
    protected String commentUser;
    protected String commentOp;
    protected ArrayList<CurationStatus> curationStatusList;
    public static final int CURATION_STATUS_NOT_CURATED = 1;
    public static final int CURATION_STATUS_AUTOMATICALLY_CURATED = 2;
    public static final int CURATION_STATUS_MANUALLY_CURATED = 4;
    public static final int CURATION_STATUS_CURATION_REVIEWED = 8;
    public static final int CURATION_STATUS_QAED = 16;
    public static final int CURATION_STATUS_CHECKED_OUT = 32;
    public static final int CURATION_STATUS_PARTIALLY_CURATED = 64;
    public static final int CURATION_STATUS_UNKNOWN = 128;
    public static final int CURATION_STATUS_REQUIRE_PAINT_REVIEW = 256;
    public static final int CURATION_STATUS_REQUIRE_PAINT_REVIEW_PTN_NOT_MAPPED = 512;
    public static final int CURATION_STATUS_REQUIRE_PAINT_REVIEW_PTN_CHANGE_FAMILIES = 1024;
    public static final int CURATION_STATUS_REQUIRE_PAINT_REVIEW_TRACKED_TO_CHILD_NODE = 2048;
    public static final int[] availableStatuses = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048};
    public static final String LABEL_CURATION_STATUS_NOT_CURATED = "Not Curated";
    public static final String LABEL_CURATION_STATUS_AUTOMATICALLY_CURATED = "Automatically Curated";
    public static final String LABEL_CURATION_STATUS_MANUALLY_CURATED = "Manually Curated";
    public static final String LABEL_CURATION_STATUS_CURATION_REVIEWED = "Curation Reviewed";
    public static final String LABEL_CURATION_STATUS_QAED = "Curation QAed";
    public static final String LABEL_CURATION_STATUS_CHECKED_OUT = "Locked";
    public static final String LABEL_CURATION_STATUS_PARTIALLY_CURATED = "Partially Curated";
    public static final String LABEL_CURATION_STATUS_UNKNOWN = "Unknown";
    public static final String LABEL_CURATION_STATUS_REQUIRE_PAINT_REVIEW = "Require PAINT review";
    public static final String LABEL_CURATION_STATUS_REQUIRE_PAINT_REVIEW_PTN_NOT_MAPPED = "Review - PTN not mapped";
    public static final String LABEL_CURATION_STATUS_REQUIRE_PAINT_REVIEW_PTN_CHANGE_FAMILIES = "Review - PTN changed families";
    public static final String LABEL_CURATION_STATUS_REQUIRE_PAINT_REVIEW_PTN_TRACKED_TO_CHILD_NODE = "Review - PTN tracked to child node";

    public Book(String id, String name, int curationStatus, User lockedBy) {
        this.id = id;
        this.name = name;
        this.curationStatus = curationStatus;
        this.lockedBy = lockedBy;
    }

    public Book(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getCurationStatus() {
        return this.curationStatus;
    }

    public void setCurationStatus(int curationStatus) {
        this.curationStatus = curationStatus;
    }

    public User getLockedBy() {
        return this.lockedBy;
    }

    public void setLockedBy(User lockedBy) {
        this.lockedBy = lockedBy;
    }

    public int compareTo(Object o) {
        Book comp = (Book)o;
        return this.id.compareTo(comp.id);
    }

    public static String getCurationStatusString(int status) {
        ArrayList<String> statusList = new ArrayList<String>();
        if (0 != (status & 1)) {
            statusList.add(LABEL_CURATION_STATUS_NOT_CURATED);
        }
        if (0 != (status & 2)) {
            statusList.add(LABEL_CURATION_STATUS_AUTOMATICALLY_CURATED);
        }
        if (0 != (status & 4)) {
            statusList.add(LABEL_CURATION_STATUS_MANUALLY_CURATED);
        }
        if (0 != (status & 8)) {
            statusList.add(LABEL_CURATION_STATUS_CURATION_REVIEWED);
        }
        if (0 != (status & 0x10)) {
            statusList.add(LABEL_CURATION_STATUS_QAED);
        }
        if (0 != (status & 0x20)) {
            statusList.add(LABEL_CURATION_STATUS_CHECKED_OUT);
        }
        if (0 != (status & 0x40)) {
            statusList.add(LABEL_CURATION_STATUS_PARTIALLY_CURATED);
        }
        if (0 != (status & 0x80)) {
            statusList.add(LABEL_CURATION_STATUS_UNKNOWN);
        }
        if (0 != (status & 0x100)) {
            statusList.add(LABEL_CURATION_STATUS_REQUIRE_PAINT_REVIEW);
        }
        if (0 != (status & 0x200)) {
            statusList.add(LABEL_CURATION_STATUS_REQUIRE_PAINT_REVIEW_PTN_NOT_MAPPED);
        }
        if (0 != (status & 0x400)) {
            statusList.add(LABEL_CURATION_STATUS_REQUIRE_PAINT_REVIEW_PTN_CHANGE_FAMILIES);
        }
        if (0 != (status & 0x800)) {
            statusList.add(LABEL_CURATION_STATUS_REQUIRE_PAINT_REVIEW_PTN_TRACKED_TO_CHILD_NODE);
        }
        return String.join((CharSequence)", ", statusList);
    }

    public boolean hasStatus(int compStatus) {
        return 0 != (this.curationStatus & compStatus);
    }

    public Date getCurationStatusUpdateDate() {
        return this.curationStatusUpdateDate;
    }

    public void setCurationStatusUpdateDate(Date curationStatusUpdateDate) {
        this.curationStatusUpdateDate = curationStatusUpdateDate;
    }

    public Date getLastAnnotationUpdateDate() {
        return this.lastAnnotationUpdateDate;
    }

    public void setLastAnnotationUpdateDate(Date lastAnnotationUpdateDate) {
        this.lastAnnotationUpdateDate = lastAnnotationUpdateDate;
    }

    public int getNumLeaves() {
        return this.numLeaves;
    }

    public void setNumLeaves(int numLeaves) {
        this.numLeaves = numLeaves;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HashSet<String> getOrgSet() {
        return this.orgSet;
    }

    public boolean addOrg(String org) {
        if (null == org) {
            return false;
        }
        if (null == this.orgSet) {
            this.orgSet = new HashSet();
        }
        this.orgSet.add(org);
        return true;
    }

    public void setOrgSet(HashSet<String> orgSet) {
        this.orgSet = orgSet;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCommentUser() {
        return this.commentUser;
    }

    public void setCommentUser(String commentUser) {
        this.commentUser = commentUser;
    }

    public String getCommentOp() {
        return this.commentOp;
    }

    public void setCommentOp(String commentOp) {
        this.commentOp = commentOp;
    }

    public ArrayList<CurationStatus> getCurationStatusList() {
        return this.curationStatusList;
    }

    public void setCurationStatusList(ArrayList<CurationStatus> curationStatusList) {
        this.curationStatusList = curationStatusList;
    }

    public boolean addCurationStatus(CurationStatus cs) {
        if (null == cs) {
            return false;
        }
        if (null == this.curationStatusList) {
            this.curationStatusList = new ArrayList();
        }
        this.curationStatusList.add(cs);
        return true;
    }
}

