/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.paintCommon;

import com.sri.panther.paintCommon.util.Utils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Classification
implements Serializable,
Comparable {
    String id;
    String accession;
    Vector<Classification> children;
    Vector<Classification> parents;
    String name;
    String description;
    String type;
    Vector<String> relationshipTypeList;
    int rank;
    Hashtable<String, Classification> accToClsTbl;
    private static final int INDEX_ACCESSION = 0;
    private static final int INDEX_NAME = 1;
    private static final int INDEX_PARENT = 2;
    private static final int INDEX_RANK = 3;
    private static final int INDEX_RELATIOSHIP_TYPE = 4;
    public static final String DELIM_CLASSIFICATION = ";";
    public static final String DELIM_ACC_NAME = "=";
    public static final String CAT_MOLECULAR_FUNCTION = "molec";
    public static final String CAT_BIOLOGICAL_PROCESS = "biol";
    public static final String CAT_CELLULAR_COMPONENT = "cellul";
    public static final String CAT_PROTEIN_CLASS = "prote";
    public static final String CAT_TYPE_MF = "MF";
    public static final String CAT_TYPE_BP = "BP";
    public static final String CAT_TYPE_CC = "CC";
    public static final String CAT_TYPE_PC = "PC";

    public Classification(String id, String accession, String name, String description, int rank) {
        this.id = id;
        this.accession = accession;
        this.name = name;
        this.description = description;
        this.rank = rank;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setAccession(String accession) {
        this.accession = accession;
    }

    public String getAccession() {
        return this.accession;
    }

    public void setChildren(Vector<Classification> children) {
        this.children = children;
    }

    public Vector<Classification> getChildren() {
        return this.children;
    }

    public void addChild(Classification child) {
        if (null == this.children) {
            this.children = new Vector(1);
        }
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
    }

    public void setParents(Vector<Classification> parents) {
        this.parents = parents;
    }

    public Vector<Classification> getParents() {
        return this.parents;
    }

    public void addParent(Classification parent) {
        if (null == this.parents) {
            this.parents = new Vector(1);
        }
        if (!this.parents.contains(parent)) {
            this.parents.add(parent);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static Classification parseClassificationData(Vector info) {
        if (null == info) {
            return null;
        }
        Hashtable<String, Classification> accToClsTbl = new Hashtable<String, Classification>();
        for (int i = 0; i < info.size(); ++i) {
            String relationshipType;
            String aBlock = (String)info.get(i);
            String[] parts = Utils.tokenize(aBlock, "\t");
            String accession = parts[0];
            String parentAcc = parts[2];
            Classification aNode = (Classification)accToClsTbl.get(accession);
            if (null == aNode) {
                aNode = new Classification(null, accession, parts[1], null, Integer.parseInt(parts[3]));
                if (parts.length > 4) {
                    relationshipType = parts[4];
                    if (null != parts[4]) {
                        aNode.addRelationshipType(relationshipType);
                    }
                }
                accToClsTbl.put(accession, aNode);
            } else {
                aNode.setAccession(accession);
                aNode.setName(parts[1]);
                aNode.setRank(Integer.parseInt(parts[3]));
                if (parts.length > 4) {
                    relationshipType = parts[4];
                    if (null != parts[4]) {
                        aNode.addRelationshipType(relationshipType);
                    }
                }
            }
            Classification parent = (Classification)accToClsTbl.get(parentAcc);
            if (null == parent) {
                parent = new Classification(null, parentAcc, null, null, 0);
                accToClsTbl.put(parentAcc, parent);
            }
            aNode.addParent(parent);
            parent.addChild(aNode);
        }
        Classification root = null;
        Enumeration clsEnum = accToClsTbl.elements();
        while (clsEnum.hasMoreElements()) {
            Classification c = (Classification)clsEnum.nextElement();
            Vector<Classification> parents = c.getParents();
            if (null == parents) {
                root = c;
            } else if (0 == parents.size()) {
                root = c;
            }
            Vector<Classification> children = c.getChildren();
            if (null == children) continue;
            Object[] anArray = new Classification[children.size()];
            children.copyInto(anArray);
            Arrays.sort(anArray);
            Vector<Object> v = new Vector<Object>(Arrays.asList(anArray));
            c.setChildren(v);
        }
        Classification.setType(root);
        root.accToClsTbl = accToClsTbl;
        return root;
    }

    protected static void setType(Classification c) {
        Vector<Classification> children = c.getChildren();
        if (null == children) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            Classification child = children.get(i);
            String aType = child.getName();
            Classification.setType(child, aType);
        }
    }

    protected static void setType(Classification c, String aType) {
        if (null == c) {
            return;
        }
        c.type = aType;
        Vector<Classification> children = c.getChildren();
        if (null == children) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            Classification child = children.get(i);
            Classification.setType(child, aType);
        }
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int getRank() {
        return this.rank;
    }

    public Hashtable<String, Classification> getAccToClsTbl() {
        return this.accToClsTbl;
    }

    public int compareTo(Object o) {
        Classification comp = (Classification)o;
        if (this.rank == comp.rank) {
            return 0;
        }
        if (this.rank > comp.rank) {
            return 1;
        }
        return -1;
    }

    public Classification checkChildName(String name) {
        if (null == this.children) {
            return null;
        }
        String lower = name.toLowerCase().substring(0, 5);
        for (int i = 0; i < this.children.size(); ++i) {
            Classification child = this.children.get(i);
            if (!child.getName().toLowerCase().substring(0, 5).equals(lower)) continue;
            return child;
        }
        return null;
    }

    public void addRelationshipType(String relationshipType) {
        if (null == this.relationshipTypeList) {
            this.relationshipTypeList = new Vector(1);
        }
        Hashtable<String, String> tmpTbl = new Hashtable<String, String>();
        for (int i = 0; i < this.relationshipTypeList.size(); ++i) {
            String str = this.relationshipTypeList.get(i);
            tmpTbl.put(str, str);
        }
        if (null == tmpTbl.get(relationshipType)) {
            this.relationshipTypeList.add(relationshipType);
        }
    }

    public Vector getRelationshipTypeList() {
        return this.relationshipTypeList;
    }

    public String formatRelationshipTypeList() {
        if (null == this.relationshipTypeList) {
            return null;
        }
        return Utils.listToString(this.relationshipTypeList, "", ",");
    }

    public String getType() {
        return this.type;
    }

    public static String convertType(String s) {
        if (null == s) {
            return null;
        }
        if (0 == (s = s.toLowerCase()).indexOf(CAT_MOLECULAR_FUNCTION)) {
            return CAT_TYPE_MF;
        }
        if (0 == s.indexOf(CAT_BIOLOGICAL_PROCESS)) {
            return CAT_TYPE_BP;
        }
        if (0 == s.indexOf(CAT_CELLULAR_COMPONENT)) {
            return CAT_TYPE_CC;
        }
        if (0 == s.indexOf(CAT_PROTEIN_CLASS)) {
            return CAT_TYPE_CC;
        }
        return "--";
    }
}

