/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.paintCommon;

import com.sri.panther.paintCommon.Classification;
import com.sri.panther.paintCommon.util.ReadResources;
import com.sri.panther.paintCommon.util.Utils;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FixedInfo
implements Serializable {
    private static final long serialVersionUID = 4968764874968361727L;
    protected String seqColName;
    protected String subfamPrefix;
    protected int origSeqColIndex;
    protected String subfamilyAnnotName;
    protected String commentColName;
    protected String evidenceColName;
    protected String geneIdColumnName;
    protected String geneSymbolColumnName;
    protected String GOAnnotationColumnName;
    protected String GOInferenceColumnName;
    protected String orthoMCLColumnName;
    protected String pantherAnnotColumnName;
    protected String pantherNewAnnotColumnName;
    protected Vector classificationColNames;
    protected Classification clsRoot;
    protected Hashtable columnToLinksTable;
    protected Hashtable linksTable;
    protected Hashtable specialOrgs;
    protected Hashtable dbToUPLInfo;
    protected static final String pairs_delim = ",";
    protected static final String delim = ",";
    protected static transient Logger log = Logger.getLogger((String)FixedInfo.class.getName());
    protected static final String GENE_ID = "gene_id";
    protected static final String GENE_SYMBOL = "gene_symbol";
    protected static final String STR_EMPTY = "";
    protected static final String GO_ANNOT = "go_annot";
    protected static final String GO_INFERENCE = "go_infer";
    protected static final String ORTHO_MCL = "orthoMCL";
    protected static final String PROPERTY_ANNOT_INFO = "annotation_info";
    protected static final String PROPERTY_ANNOT_NEW = "annotation_new";
    public static final String PROPERTY_FILE_TREE = "treeViewer";

    public FixedInfo(ReadResources rr) throws Exception {
        if (null == rr) {
            return;
        }
        String key = STR_EMPTY;
        try {
            int length;
            String[] values;
            key = rr.getKey("seq_id");
            if (null != key && 0 != key.length()) {
                key = key.substring(1, key.length() - 1);
                values = Utils.tokenize(key, ",");
                this.seqColName = values[0];
                this.origSeqColIndex = Integer.parseInt(values[1]);
            }
            if (null != (key = rr.getKey("subfamiy_annot")) && 0 != key.length()) {
                this.subfamilyAnnotName = key = key.substring(1, key.length() - 1);
            }
            if (null != (key = rr.getKey("classification_info")) && 0 != key.length()) {
                key = key.substring(1, key.length() - 1);
                values = Utils.tokenize(key, ",");
                this.classificationColNames = new Vector();
                for (int i = 0; i < values.length; ++i) {
                    this.classificationColNames.addElement(values[i]);
                }
            }
            if (null != (key = rr.getKey("comment")) && 0 != key.length()) {
                this.commentColName = key = key.substring(1, key.length() - 1);
            }
            if (null != (key = rr.getKey("evidence")) && 0 != key.length()) {
                this.evidenceColName = key = key.substring(1, key.length() - 1);
            }
            if (null != (key = rr.getKey("subfam_prefix")) && 0 != key.length()) {
                this.subfamPrefix = key = key.substring(1, key.length() - 1);
            }
            if (null != (key = rr.getKey(GENE_ID)) && 0 != (length = key.length())) {
                this.geneIdColumnName = key.substring(1, length - 1);
            }
            if (null != (key = rr.getKey(GENE_SYMBOL)) && 0 != (length = key.length())) {
                this.geneSymbolColumnName = key.substring(1, length - 1);
            }
            if (null != (key = rr.getKey(GO_ANNOT)) && 2 < (length = key.length())) {
                this.GOAnnotationColumnName = key.substring(1, length - 1);
            }
            if (null != (key = rr.getKey(GO_INFERENCE)) && 2 < (length = key.length())) {
                this.GOInferenceColumnName = key.substring(1, length - 1);
            }
            if (null != (key = rr.getKey(ORTHO_MCL)) && 2 < (length = key.length())) {
                this.orthoMCLColumnName = key.substring(1, length - 1);
            }
            if (null != (key = rr.getKey(PROPERTY_ANNOT_INFO)) && 2 < (length = key.length())) {
                this.pantherAnnotColumnName = key.substring(1, length - 1);
            }
            if (null != (key = rr.getKey(PROPERTY_ANNOT_NEW)) && 2 < (length = key.length())) {
                this.pantherNewAnnotColumnName = key.substring(1, length - 1);
            }
            this.saveURLInfo(rr);
        }
        catch (Exception e) {
            log.error((Object)("Error reading fixed property after value:  " + key));
            throw e;
        }
    }

    protected void saveURLInfo(ReadResources rr) throws Exception {
        String key = STR_EMPTY;
        try {
            int i;
            this.specialOrgs = new Hashtable();
            key = rr.getKey("sp_org");
            key = key.substring(1, key.length() - 1);
            String[] values = Utils.tokenize(key, ",");
            for (int i2 = 0; i2 < values.length; ++i2) {
                this.specialOrgs.put(values[i2], values[i2]);
            }
            Hashtable<String, String> urlTable = new Hashtable<String, String>();
            key = rr.getKey("url_list");
            if (null == key) {
                return;
            }
            String[] urlTypeValues = Utils.tokenize(key, ",");
            for (i = 0; i < urlTypeValues.length; ++i) {
                urlTable.put(urlTypeValues[i], urlTypeValues[i]);
            }
            key = rr.getKey("sp_org");
            values = Utils.tokenize(key, ",");
            for (i = 0; i < values.length; ++i) {
                urlTable.put(values[i], values[i]);
            }
            String supportedTypes = rr.getKey("supported_types");
            String[] supValues = Utils.tokenize(supportedTypes, ",");
            this.columnToLinksTable = new Hashtable();
            this.linksTable = new Hashtable();
            for (int i3 = 0; i3 < supValues.length; ++i3) {
                key = rr.getKey(supValues[i3]);
                Vector<String> urlValues = new Vector<String>();
                values = Utils.tokenize(key, ",");
                for (int j = 0; j < values.length; ++j) {
                    if (null == urlTable.get(values[j])) continue;
                    urlValues.addElement(values[j]);
                    key = rr.getKey(values[j]);
                    this.linksTable.put(values[j], key);
                }
                if (urlValues.isEmpty()) continue;
                this.columnToLinksTable.put(supValues[i3], urlValues);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error reading fixed property after value:  " + key));
            throw e;
        }
    }

    public String getSeqColName() {
        return this.seqColName;
    }

    public int getOrigSeqColIndex() {
        return this.origSeqColIndex;
    }

    public String getSubfamilyAnnotColName() {
        return this.subfamilyAnnotName;
    }

    public String getCommentColName() {
        return this.commentColName;
    }

    public String getEvidenceColName() {
        return this.evidenceColName;
    }

    public String getGeneIdColumnName() {
        return this.geneIdColumnName;
    }

    public String getGeneSymbolColumnName() {
        return this.geneSymbolColumnName;
    }

    public String getSubfamPrefix() {
        return this.subfamPrefix;
    }

    public Vector getClassification_col_names() {
        return this.classificationColNames;
    }

    public void setClsRoot(Classification root) {
        this.clsRoot = root;
    }

    public Classification getClsRoot() {
        return this.clsRoot;
    }

    public Hashtable getColumnToLinksTable() {
        return this.columnToLinksTable;
    }

    public Hashtable getLinksTable() {
        return this.linksTable;
    }

    public Hashtable getSpecialOrgsTable() {
        return this.specialOrgs;
    }

    public void setDbToUPLInfo(Hashtable ht) {
        this.dbToUPLInfo = ht;
    }

    public Hashtable getDbToUploadInfo() {
        return this.dbToUPLInfo;
    }

    public String getGOAnnotationColName() {
        return this.GOAnnotationColumnName;
    }

    public String getGOInferenceColName() {
        return this.GOInferenceColumnName;
    }

    public String getOrthoMCLColName() {
        return this.orthoMCLColumnName;
    }

    public String getPANTHERAnnotColName() {
        return this.pantherAnnotColumnName;
    }

    public String getNewPANTHERAnnotColName() {
        return this.pantherNewAnnotColumnName;
    }

    public static String getDb(String dbUplVersion) {
        String[] dbUplInfo = Utils.tokenize(dbUplVersion, "|");
        if (2 != dbUplInfo.length) {
            return null;
        }
        return dbUplInfo[0];
    }

    public static String getCls(String dbUplVersion) {
        String[] dbUplInfo = Utils.tokenize(dbUplVersion, "|");
        if (2 != dbUplInfo.length) {
            return null;
        }
        return dbUplInfo[1];
    }

    public boolean UPLReleased(String dbUplVersion) {
        if (null == this.dbToUPLInfo || null == dbUplVersion) {
            return false;
        }
        String[] dbUplInfo = Utils.tokenize(dbUplVersion, "|");
        if (2 != dbUplInfo.length) {
            return false;
        }
        Enumeration dbs = this.dbToUPLInfo.keys();
        while (dbs.hasMoreElements()) {
            String key = (String)dbs.nextElement();
            if (0 != key.compareTo(dbUplInfo[0])) continue;
            Hashtable uplToUPLInfo = (Hashtable)this.dbToUPLInfo.get(key);
            Enumeration e = uplToUPLInfo.keys();
            while (e.hasMoreElements()) {
                String upl = (String)e.nextElement();
                Vector info = (Vector)uplToUPLInfo.get(upl);
                if (0 != dbUplInfo[0].compareTo((String)info.elementAt(0))) continue;
                return null != info.elementAt(1);
            }
        }
        return false;
    }

    public Integer getClsVersion(String dbUplVersion) {
        if (null == this.dbToUPLInfo || null == dbUplVersion) {
            return null;
        }
        String[] dbUplInfo = Utils.tokenize(dbUplVersion, "|");
        if (2 != dbUplInfo.length) {
            return null;
        }
        Enumeration dbs = this.dbToUPLInfo.keys();
        while (dbs.hasMoreElements()) {
            String key = (String)dbs.nextElement();
            if (0 != key.compareTo(dbUplInfo[0])) continue;
            Hashtable uplToUPLInfo = (Hashtable)this.dbToUPLInfo.get(key);
            Enumeration e = uplToUPLInfo.keys();
            while (e.hasMoreElements()) {
                String clsId = (String)e.nextElement();
                Vector info = (Vector)uplToUPLInfo.get(clsId);
                if (0 != dbUplInfo[1].compareTo((String)info.elementAt(0))) continue;
                return new Integer(clsId);
            }
        }
        return null;
    }

    public String getClsLabel(String dbUpl) {
        if (null == this.dbToUPLInfo || null == dbUpl) {
            return null;
        }
        String[] dbUplInfo = Utils.tokenize(dbUpl, "|");
        if (2 != dbUplInfo.length) {
            return null;
        }
        Enumeration dbs = this.dbToUPLInfo.keys();
        while (dbs.hasMoreElements()) {
            String key = (String)dbs.nextElement();
            if (0 != key.compareTo(dbUplInfo[0])) continue;
            Hashtable uplToUPLInfo = (Hashtable)this.dbToUPLInfo.get(key);
            Enumeration clsIds = uplToUPLInfo.keys();
            while (clsIds.hasMoreElements()) {
                String clsId = (String)clsIds.nextElement();
                Vector uplInfo = (Vector)uplToUPLInfo.get(clsId);
                if (0 != ((String)uplInfo.elementAt(0)).compareTo(dbUplInfo[1])) continue;
                return clsId;
            }
        }
        return null;
    }

    public String getClsVersion(String db, String clsId) {
        if (null == this.dbToUPLInfo) {
            return null;
        }
        Hashtable clsTbl = (Hashtable)this.dbToUPLInfo.get(db);
        if (null == clsTbl) {
            return null;
        }
        Vector clsInfo = (Vector)clsTbl.get(clsId);
        if (null == clsInfo) {
            return null;
        }
        return (String)clsInfo.elementAt(0);
    }

    public String getDbUpl(String db, String clsId) {
        String clsVersion = this.getClsVersion(db, clsId);
        if (null == clsVersion) {
            return null;
        }
        return db + "|" + clsVersion;
    }

    public boolean dbUploadValid(String dbUpl) {
        return null != this.getClsLabel(dbUpl);
    }

    public String getDbClsId(String dbUplVersion) {
        if (null == dbUplVersion) {
            return null;
        }
        Integer clsId = this.getClsVersion(dbUplVersion);
        if (null != clsId) {
            return FixedInfo.getDb(dbUplVersion) + "|" + clsId.toString();
        }
        return null;
    }

    public String combineDBAndClsId(String db, String clsId) {
        return db + "|" + clsId;
    }

    public static FixedInfo createFixedInfo() {
        ReadResources rr = new ReadResources();
        try {
            rr.setResource(PROPERTY_FILE_TREE);
            return new FixedInfo(rr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        FixedInfo.createFixedInfo();
    }
}

