/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.paintCommon.GO;

import com.sri.panther.paintCommon.GO.Evidence;
import com.sri.panther.paintCommon.User;
import com.sri.panther.paintCommon.util.Utils;
import java.io.Serializable;
import java.util.Vector;

public class EvidenceSpecifier
implements Serializable,
Comparable {
    public static final String EVIDENCE_NOT_SPECIFIED = "Evidence not specified";
    public static final String EVIDENCE_CODE_NOT_SPECIFIED = "Evidence code not specified";
    public static final String EVIDENCE_LONG_BRANCH_LENGTH = "long_branch";
    public static final String EVIDENCE_MISSING_DOMAIN_SEQUENCE_FEATURE = "missing_seq_feature";
    public static Object[] options = new Object[]{"Yes, enter Pubmed Id", "No, select predefined evidence type", "Cancel"};
    public static String[] EVIDENCE_POSSIBILITIES = new String[]{"long_branch", "missing_seq_feature"};
    public static String MSG_ENTER_EVIDENCE = "Enter Pubmed id (numeric) or select from choices.";
    public static String MSG_EVIDENCE = "Evidence";
    public static String MSG_ENTER_PUBMED_ID = "Enter Pubmed id";
    public static String MSG_CHOOSE_FROM_LIST = "Choose from list";
    public static final String DELIM_EVIDENCE_SPECIFIER = ",";
    public static final String GAF_PMID_SPECIFIER = "PMID";
    public static final String GAF_EVIDENCE_SEPARATOR = "|";
    public static final String GAF_EVIDENCE_SEPARATOR_TYPE_ID = ":";
    User createdBy;
    String with;
    String evidenceId;
    String comment;
    String evidenceCode;

    public EvidenceSpecifier(String with, User createdBy, String evidenceId, String comment, String evidenceCode) {
        this.with = with;
        this.createdBy = createdBy;
        this.evidenceId = evidenceId;
        this.comment = this.formatCommment(comment);
        this.evidenceCode = evidenceCode;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setEvidenceId(String evidenceId) {
        this.evidenceId = evidenceId;
    }

    public String getEvidenceId() {
        return this.evidenceId;
    }

    public void setComment(String comment) {
        this.comment = this.formatCommment(comment);
    }

    public String getComment() {
        return this.comment;
    }

    public String formatCommment(String cmtStr) {
        if (null == cmtStr) {
            return null;
        }
        cmtStr = Utils.replace(cmtStr, "\t", "");
        cmtStr = Utils.replace(cmtStr, GAF_EVIDENCE_SEPARATOR, "");
        cmtStr = Utils.replace(cmtStr, GAF_EVIDENCE_SEPARATOR_TYPE_ID, "");
        return cmtStr;
    }

    public void setEvidenceCode(String evidenceCode) {
        this.evidenceCode = evidenceCode;
    }

    public String getEvidenceCode() {
        return this.evidenceCode;
    }

    public String getWith() {
        return this.with;
    }

    public void setWith(String with) {
        this.with = with;
    }

    public int compareTo(Object o) {
        if (null == o) {
            return 1;
        }
        if (!(o instanceof EvidenceSpecifier)) {
            return 1;
        }
        EvidenceSpecifier comp = (EvidenceSpecifier)o;
        int diff = this.evidenceId.compareTo(comp.evidenceId);
        if (0 == diff) {
            return this.comment.compareTo(comp.comment);
        }
        return diff;
    }

    public Object clone() {
        if (null == this.createdBy) {
            return new EvidenceSpecifier(this.with, null, this.evidenceId, this.comment, this.evidenceCode);
        }
        return new EvidenceSpecifier(this.with, (User)this.createdBy.clone(), this.evidenceId, this.comment, this.evidenceCode);
    }

    public static Vector<EvidenceSpecifier> cloneList(Vector<EvidenceSpecifier> esList) {
        if (null == esList) {
            return null;
        }
        int size = esList.size();
        Vector<EvidenceSpecifier> newList = new Vector<EvidenceSpecifier>(size);
        for (int i = 0; i < size; ++i) {
            newList.add((EvidenceSpecifier)esList.get(i).clone());
        }
        return newList;
    }

    public static Vector<EvidenceSpecifier> copyList(Vector<EvidenceSpecifier> list) {
        if (null == list) {
            return null;
        }
        int size = list.size();
        Vector<EvidenceSpecifier> rtnList = new Vector<EvidenceSpecifier>(size);
        for (int i = 0; i < size; ++i) {
            rtnList.add((EvidenceSpecifier)list.get(i).clone());
        }
        return rtnList;
    }

    public static String formatEvidenceIdInfo(Vector<EvidenceSpecifier> list) {
        if (null == list) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(DELIM_EVIDENCE_SPECIFIER);
            }
            sb.append(list.get(i).getEvidenceId());
        }
        return sb.toString();
    }

    public static String formatEvidenceCodeInfo(Vector<EvidenceSpecifier> list) {
        if (null == list) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(DELIM_EVIDENCE_SPECIFIER);
            }
            sb.append(list.get(i).getEvidenceCode());
        }
        return sb.toString();
    }

    public static String formatEvidenceWith(Vector<EvidenceSpecifier> list) {
        if (null == list) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(DELIM_EVIDENCE_SPECIFIER);
            }
            sb.append(list.get(i).getWith());
        }
        return sb.toString();
    }

    public static boolean findWith(Vector<EvidenceSpecifier> list, String with) {
        if (null == list || null == with) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get((int)i).with.equals(with)) continue;
            return true;
        }
        return false;
    }

    public static void setWith(Vector<Evidence> evList, String with) {
        if (null == evList) {
            return;
        }
        for (int i = 0; i < evList.size(); ++i) {
            Evidence e = evList.get(i);
            Vector<EvidenceSpecifier> esList = e.getEvidenceSpecifierList();
            EvidenceSpecifier.setWithForList(esList, with);
        }
    }

    public static void setWithForList(Vector<EvidenceSpecifier> esList, String with) {
        if (null == esList || null == with) {
            return;
        }
        for (int j = 0; j < esList.size(); ++j) {
            esList.get((int)j).with = with;
        }
    }

    public static void setEvidenceCodeForList(Vector<EvidenceSpecifier> esList, String evidenceCode) {
        if (null == esList || null == evidenceCode) {
            return;
        }
        for (int j = 0; j < esList.size(); ++j) {
            esList.get((int)j).evidenceCode = evidenceCode;
        }
    }

    public static void setEvidenceIdForList(Vector<EvidenceSpecifier> esList, String evidenceId) {
        if (null == esList || null == evidenceId) {
            return;
        }
        for (int j = 0; j < esList.size(); ++j) {
            esList.get((int)j).evidenceId = evidenceId;
        }
    }

    public static Vector<String> getDistinctWithList(Vector<EvidenceSpecifier> esList) {
        if (null == esList) {
            return null;
        }
        Vector<String> rtnList = new Vector<String>();
        for (int i = 0; i < esList.size(); ++i) {
            EvidenceSpecifier es = esList.get(i);
            String with = es.getWith();
            if (Utils.search(rtnList, with)) continue;
            rtnList.add(with);
        }
        return rtnList;
    }

    public static String formatUserNameForGAF(Vector<EvidenceSpecifier> esList) {
        if (null == esList || 0 == esList.size()) {
            return "";
        }
        EvidenceSpecifier es = esList.get(0);
        User u = es.createdBy;
        return Utils.replace(u.getFirstName(), "\t", "");
    }

    public static String getEvidenceIdForGAF(EvidenceSpecifier es) {
        String id = es.evidenceId;
        if (!Utils.search(EVIDENCE_POSSIBILITIES, id)) {
            return "PMID:" + id;
        }
        if (id.equals(EVIDENCE_MISSING_DOMAIN_SEQUENCE_FEATURE)) {
            return "missing_seq_feature:" + es.comment;
        }
        return id + GAF_EVIDENCE_SEPARATOR_TYPE_ID;
    }

    public static String formatEvidenceIdListForGAF(Vector<EvidenceSpecifier> list) {
        if (null == list) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(EvidenceSpecifier.getEvidenceIdForGAF(list.get(i)));
            sb.append(GAF_EVIDENCE_SEPARATOR);
        }
        return sb.toString();
    }

    public static String formatWithListForGAF(Vector<EvidenceSpecifier> list) {
        if (null == list) {
            return "";
        }
        String withList = EvidenceSpecifier.getWithList(list);
        if (null != withList) {
            return withList;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                sb.append(GAF_EVIDENCE_SEPARATOR);
            }
            sb.append(list.get((int)i).with);
        }
        return sb.toString();
    }

    private static String getWithList(Vector<EvidenceSpecifier> list) {
        int size = list.size();
        String first = list.get(0).getWith();
        if (1 == size) {
            return first;
        }
        for (int i = 1; i < size; ++i) {
            EvidenceSpecifier es = list.get(i);
            if (first.equals(es.getWith())) continue;
            return null;
        }
        return first;
    }

    public static Vector<EvidenceSpecifier> generateEvidenceSpecifier(String gafEvidenceStr, String[] withs, String evidenceCode, String firstAndLastName) {
        User u = new User(firstAndLastName, null, null, null, -10, null);
        int size = withs.length;
        Vector<EvidenceSpecifier> rtnList = new Vector<EvidenceSpecifier>(size);
        for (int i = 0; i < size; ++i) {
            rtnList.add(new EvidenceSpecifier(withs[i], u, gafEvidenceStr, null, evidenceCode));
        }
        return rtnList;
    }
}

