/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.paintCommon.familyLibrary;

import com.sri.panther.paintCommon.familyLibrary.EntryType;
import com.sri.panther.paintCommon.familyLibrary.LibrarySettings;
import com.sri.panther.paintCommon.util.FileUtils;
import java.io.File;
import java.util.Vector;

public class FileNameGenerator {
    protected static final String ATTR_SUFFIX = "attr";
    protected static final String TREE_SUFFIX = "tree";
    public static final String PAINT_SUFFIX = "paint";
    protected static final String SFAN_SUFFIX = "sfan";
    protected static final String TAB_SUFFIX = "tab";
    protected static final String CLS_FILE_NAME = "PANTHER_GO_Slim";
    protected static final String BETE_TREE = "tree.";
    protected static final String PAINT_TREE = "tree.";
    protected static final String SFAN_RELATIONSHIP = "sfan";
    protected static final String PIR = "pir";
    protected static final String MIA = "mia";
    protected static final String PIR_FILE = "pir";
    protected static final String CLUSTER_FILE = "cluser.";
    protected static final String CLUSTER_WTS_FILE = "cluster.wts";
    protected static final String WTS = ".wts";
    protected static final String DIR_BOOKS = "books";
    protected static final String DIR_GLOBAL = "globals";
    protected static final String INFO = "info";
    protected static final String DIR_PAINT = "tree";
    protected static final String DIR_CLUSTS = "clusts";
    protected static final String DIR_WTS = "seqwt";
    protected static final String DOT = ".";
    protected static final String WEB_DIR_SEPARATOR = "/";
    protected static final String NAME_SF_SEQ = ".sfToSeq";
    protected static final String NAME_SF_TO_ONTOLOGY = ".sfToOnt";
    protected static final String NAME_ATTRIB = ".attr.tab";
    protected static final String NAME_ATTR_TAB = "attr.tab";
    protected static final String DIR_TREE = "tree";
    protected static final String DOT_TSV = ".tsv";
    protected static final String PREFIX_PFAM = "pfam";
    public static final int MSA_INDEX_PIR = 0;
    public static final int MSA_INDEX_MIA = 1;
    protected static final String STR_EMPTY = "";

    public static boolean IsPAINTFileNameValid(String PAINTFileName) {
        return PAINTFileName.endsWith(".paint");
    }

    public static String formatPAINTFileName(String PAINTFileName) {
        if (FileNameGenerator.IsPAINTFileNameValid(PAINTFileName)) {
            return PAINTFileName;
        }
        return PAINTFileName + ".paint";
    }

    public static String getAttribForPAINT(String PAINTFileName) {
        if (FileNameGenerator.IsPAINTFileNameValid(PAINTFileName)) {
            return PAINTFileName.substring(0, PAINTFileName.length() - PAINT_SUFFIX.length()) + ATTR_SUFFIX;
        }
        return null;
    }

    public static String getTreeForPAINT(String PAINTFileName) {
        if (FileNameGenerator.IsPAINTFileNameValid(PAINTFileName)) {
            return PAINTFileName.substring(0, PAINTFileName.length() - PAINT_SUFFIX.length()) + "tree";
        }
        return null;
    }

    public static String getSfAnForPAINT(String PAINTFileName) {
        if (FileNameGenerator.IsPAINTFileNameValid(PAINTFileName)) {
            return PAINTFileName.substring(0, PAINTFileName.length() - PAINT_SUFFIX.length()) + "sfan";
        }
        return null;
    }

    protected static String generatePath(LibrarySettings librarySettings, String dir) {
        String path = null;
        String libraryName = librarySettings.getLibraryName();
        path = null == libraryName || 0 == libraryName.length() ? librarySettings.getLibraryRoot() : FileUtils.appendPathToPath(librarySettings.getLibraryRoot(), libraryName);
        path = FileUtils.appendPathToPath(path, DIR_BOOKS);
        path = FileUtils.appendPathToPath(path, librarySettings.getBookName());
        if (null != librarySettings.getEntryType() && librarySettings.getEntryType().entry) {
            path = FileUtils.appendPathToPath(path, librarySettings.getEntryType().entryType);
            if (null != dir) {
                path = FileUtils.appendPathToPath(path, dir);
            }
        }
        return path;
    }

    protected static String generateInitialFileName(LibrarySettings librarySettings) {
        Object fileName = STR_EMPTY;
        if (null != librarySettings.getEntryType() && librarySettings.getEntryType().entry) {
            fileName = librarySettings.getBookName() + DOT + librarySettings.getEntryType().getEntryType() + DOT;
            String bookSuffix = librarySettings.getBookSufix();
            if (null != bookSuffix) {
                fileName = (String)fileName + bookSuffix + DOT;
            }
        }
        return fileName;
    }

    public static String getPAINTPathName(LibrarySettings librarySettings) {
        String path = FileNameGenerator.generatePath(librarySettings, "tree");
        Object fileName = FileNameGenerator.generateInitialFileName(librarySettings);
        if (0 == ((String)fileName).length()) {
            fileName = "tree.";
        }
        fileName = (String)fileName + PAINT_SUFFIX;
        path = FileUtils.appendFileToPath(path, (String)fileName);
        return path;
    }

    public static String getTreeName(LibrarySettings librarySettings) {
        if (null != librarySettings.getEntryType() && librarySettings.getEntryType().entry) {
            return librarySettings.bookName + DOT + librarySettings.getEntryType().entryType + ".tree";
        }
        return "tree.tree";
    }

    public static String getClassificationName(LibrarySettings librarySettings) {
        String path = FileUtils.appendPathToPath(librarySettings.getLibraryRoot(), librarySettings.getLibraryName());
        path = FileUtils.appendPathToPath(path, DIR_GLOBAL);
        path = FileUtils.appendFileToPath(path, CLS_FILE_NAME);
        return path;
    }

    protected static String[] listDir(File dir) {
        Object[] families = null;
        if (dir.isDirectory()) {
            families = dir.list();
            Vector<Object> dirVector = new Vector<Object>(families.length);
            for (int i = 0; i < families.length; ++i) {
                if (!new File(dir.getAbsolutePath() + File.separator + (String)families[i]).isDirectory()) continue;
                dirVector.addElement(families[i]);
            }
            families = new String[dirVector.size()];
            dirVector.copyInto(families);
        }
        return families;
    }

    public static String[] getBooks(LibrarySettings librarySettings) {
        String path = FileUtils.appendPathToPath(librarySettings.getLibraryRoot(), librarySettings.getLibraryName());
        path = FileUtils.appendPathToPath(path, DIR_BOOKS);
        File bookPath = new File(path);
        return FileNameGenerator.listDir(bookPath);
    }

    public static String getANSeqFileForPaint(String paintFilePath) {
        String path = FileUtils.getPath(paintFilePath);
        String paintName = FileUtils.getFileName(paintFilePath);
        return path + File.separator + paintName.substring(0, paintName.length() - PAINT_SUFFIX.length()) + MIA;
    }

    public static String[] getMSAFilesForPaint(LibrarySettings librarySettings) {
        String libraryName;
        if (null == librarySettings) {
            return null;
        }
        String[] urlList = new String[2];
        EntryType et = librarySettings.getEntryType();
        String libURL = null;
        libURL = null != librarySettings.getLibURL() ? librarySettings.getLibURL() : (null != (libraryName = librarySettings.getLibraryName()) ? FileUtils.appendFileToPath(librarySettings.getLibraryRoot(), libraryName) : librarySettings.getLibraryRoot());
        String bookName = librarySettings.getBookName();
        if (null == et) {
            urlList[0] = libURL + "/books/" + bookName + "/cluser.pir";
            urlList[1] = libURL + "/books/" + bookName + "/tree.mia";
        } else {
            Object bookSuffix = librarySettings.getBookSufix();
            bookSuffix = null == bookSuffix || 0 == ((String)bookSuffix).length() ? STR_EMPTY : (String)bookSuffix + DOT;
            urlList[0] = libURL + "/books/" + bookName + WEB_DIR_SEPARATOR + et.getEntryType() + "/clusts/" + librarySettings.getBookName() + DOT + et.getEntryType() + ".pir";
            urlList[1] = libURL + "/books/" + librarySettings.getBookName() + WEB_DIR_SEPARATOR + et.getEntryType() + "/tree/" + bookName + DOT + et.getEntryType() + DOT + (String)bookSuffix + MIA;
        }
        return urlList;
    }

    public static String getAttrFile(LibrarySettings librarySettings) {
        String libraryName;
        if (null == librarySettings) {
            return null;
        }
        EntryType et = librarySettings.getEntryType();
        String libURL = null;
        if (null != et) {
            return null;
        }
        libURL = null != librarySettings.getLibURL() ? librarySettings.getLibURL() : (null != (libraryName = librarySettings.getLibraryName()) ? FileUtils.appendFileToPath(librarySettings.getLibraryRoot(), libraryName) : librarySettings.getLibraryRoot());
        String bookName = librarySettings.getBookName();
        return libURL + "/books/" + bookName + "/attr.tab";
    }

    public static String getMSAWts(LibrarySettings librarySettings) {
        if (null == librarySettings) {
            return null;
        }
        String libURL = null;
        libURL = null != librarySettings.getLibURL() ? librarySettings.getLibURL() : FileUtils.appendPathToPath(librarySettings.getLibraryRoot(), librarySettings.getLibraryName());
        EntryType et = librarySettings.getEntryType();
        if (null == et) {
            return libURL + "/books/" + librarySettings.getBookName() + "/cluster.wts";
        }
        return libURL + "/books/" + librarySettings.getBookName() + WEB_DIR_SEPARATOR + et.getEntryType() + "/seqwt/" + librarySettings.getBookName() + DOT + et.getEntryType() + ".mag.wts";
    }

    public static Vector<String> getMSAFilesForPAINT(String paintFilePath) {
        Vector<String> v = new Vector<String>();
        String path = FileUtils.getPath(paintFilePath);
        String paintName = FileUtils.getFileName(paintFilePath);
        v.addElement(path + File.separator + paintName.substring(0, paintName.length() - PAINT_SUFFIX.length()) + "pir");
        File parent = new File(path);
        if (null != parent && null != (parent = new File(parent.getParent()))) {
            v.addElement(parent.getPath() + File.separator + DIR_CLUSTS + File.separator + paintName.substring(0, paintName.length() - PAINT_SUFFIX.length()) + "pir");
            return v;
        }
        v.addElement(STR_EMPTY);
        return v;
    }

    public static String getWtsFilePathForMSA(File f) {
        if (0 == "pir".compareTo(f.getName())) {
            return FileUtils.getPath(f.getPath()) + File.separator + WTS;
        }
        File parent = f.getParentFile();
        if (null != parent) {
            if (null == (parent = parent.getParentFile())) {
                return STR_EMPTY;
            }
            return parent.getPath() + File.separator + DIR_WTS + File.separator + f.getName().substring(0, f.getName().length() - "pir".length()) + "mag.wts";
        }
        return STR_EMPTY;
    }

    public static String getSfToSeqFileName(String directory, String id) {
        return FileUtils.appendFileToPath(directory, id + NAME_SF_SEQ);
    }

    public static String getSfToOntologyFileName(String directory, String id) {
        return FileUtils.appendFileToPath(directory, id + NAME_SF_TO_ONTOLOGY);
    }

    public static String getAttrFileName(String directory, String id) {
        return FileUtils.appendFileToPath(directory, id + NAME_ATTRIB);
    }

    public static String getPfamDomain(LibrarySettings librarySettings) {
        if (null == librarySettings) {
            return null;
        }
        EntryType et = librarySettings.getEntryType();
        String bookName = librarySettings.getBookName();
        if (null == et || null == et.getEntryType() || 0 == et.getEntryType().length()) {
            return librarySettings.getLibURL() + "/books/" + bookName + "/pfam.tsv";
        }
        return librarySettings.getLibURL() + "/books/" + bookName + WEB_DIR_SEPARATOR + et.getEntryType() + "/tree/" + bookName + DOT + et.getEntryType() + DOT_TSV;
    }

    public static void main(String[] args) {
        EntryType et = new EntryType();
        et.setEntryType("orig");
        LibrarySettings ls = new LibrarySettings("PTHR10000", et, STR_EMPTY, "http://23423/com/devupl4.0/");
        String[] msaFiles = FileNameGenerator.getMSAFilesForPaint(ls);
        System.out.println("Files are " + msaFiles[0] + " " + msaFiles[1]);
    }
}

