/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.paintCommon.familyLibrary;

import com.sri.panther.paintCommon.familyLibrary.FileNameGenerator;
import com.sri.panther.paintCommon.util.FileUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PAINTFile {
    protected String fileName;
    protected Properties prop = null;
    protected static Logger log = Logger.getLogger((String)PAINTFile.class.getName());
    protected static final String FILE_TREE = "tree";
    protected static final String FILE_SFAN = "sfan";
    protected static final String FILE_ATTR = "attr";
    protected String PAINTFilePath;
    protected static final String MSG_ERROR_LOADING_PAINT_FILE = "Error loading paint file ";
    protected static final String MSG_ERROR_WRITING_FILE = "Error writing file ";

    public PAINTFile(String paintFileName) {
        this.PAINTFilePath = FileUtils.getPath(paintFileName);
        this.fileName = FileUtils.getFileName(paintFileName);
        this.prop = new Properties();
        this.setProperty(FILE_TREE, FileNameGenerator.getTreeForPAINT(this.fileName));
        this.setProperty(FILE_ATTR, FileNameGenerator.getAttribForPAINT(this.fileName));
        this.setProperty(FILE_SFAN, FileNameGenerator.getSfAnForPAINT(this.fileName));
    }

    private PAINTFile() {
    }

    public static PAINTFile readPAINTFile(String fileName) {
        PAINTFile pf = new PAINTFile();
        if (!FileUtils.validPath(fileName)) {
            return null;
        }
        try {
            FileInputStream in = new FileInputStream(fileName);
            pf.prop = new Properties();
            pf.prop.loadFromXML(in);
            in.close();
            pf.PAINTFilePath = FileUtils.getPath(fileName);
            pf.fileName = FileUtils.getFileName(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)(MSG_ERROR_LOADING_PAINT_FILE + fileName));
        }
        return pf;
    }

    public static PAINTFile readPAINTFileURL(String url) {
        PAINTFile pf = new PAINTFile();
        try {
            URL aUrl = new URL(url);
            InputStream in = aUrl.openStream();
            pf.prop = new Properties();
            pf.prop.loadFromXML(in);
            in.close();
            pf.PAINTFilePath = FileUtils.getURLPath(url);
            pf.fileName = aUrl.getFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)(MSG_ERROR_LOADING_PAINT_FILE + url));
        }
        return pf;
    }

    protected void setProperty(String key, String value) {
        this.prop.setProperty(key, value);
    }

    public boolean savePAINT(String[] treeStr, String[] attr, String[] sfAn) {
        String completePath;
        Properties tmp = new Properties();
        if (null != treeStr) {
            String treeFileName = this.prop.getProperty(FILE_TREE);
            if (null == treeFileName) {
                treeFileName = FileNameGenerator.getTreeForPAINT(this.fileName);
                this.setProperty(FILE_TREE, treeFileName);
            }
            tmp.put(FILE_TREE, treeFileName);
            completePath = FileUtils.appendFileToPath(this.PAINTFilePath, treeFileName);
            try {
                FileUtils.writeFile(completePath, treeStr);
            }
            catch (IOException e) {
                return false;
            }
        }
        if (null != sfAn) {
            String sfAnFileName = this.prop.getProperty(FILE_SFAN);
            if (null == sfAnFileName) {
                sfAnFileName = FileNameGenerator.getSfAnForPAINT(this.fileName);
                this.setProperty(FILE_SFAN, sfAnFileName);
            }
            tmp.put(FILE_SFAN, sfAnFileName);
            completePath = FileUtils.appendFileToPath(this.PAINTFilePath, sfAnFileName);
            try {
                FileUtils.writeFile(completePath, sfAn);
            }
            catch (IOException e) {
                log.error((Object)(MSG_ERROR_WRITING_FILE + completePath));
                return false;
            }
        }
        if (null != attr) {
            String attrName = this.prop.getProperty(FILE_ATTR);
            if (null == attrName) {
                attrName = FileNameGenerator.getAttribForPAINT(this.fileName);
                this.setProperty(FILE_ATTR, attrName);
            }
            tmp.put(FILE_ATTR, attrName);
            completePath = FileUtils.appendFileToPath(this.PAINTFilePath, attrName);
            try {
                FileUtils.writeFile(completePath, attr);
            }
            catch (IOException e) {
                log.error((Object)(MSG_ERROR_WRITING_FILE + completePath));
                return false;
            }
        }
        String completePath2 = FileUtils.appendFileToPath(this.PAINTFilePath, this.fileName);
        try {
            FileOutputStream out = new FileOutputStream(completePath2);
            tmp.storeToXML(out, "");
            out.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)(MSG_ERROR_WRITING_FILE + completePath2));
            return false;
        }
    }

    public String getTreeFileName() {
        return this.prop.getProperty(FILE_TREE);
    }

    public String getSfanFileName() {
        return this.prop.getProperty(FILE_SFAN);
    }

    public String getAttrFileName() {
        return this.prop.getProperty(FILE_ATTR);
    }

    public String getPAINTFilePath() {
        return this.PAINTFilePath;
    }

    public String getPAINTFileName() {
        return this.fileName;
    }

    public static void main(String[] args) {
        PAINTFile pf = new PAINTFile("/Users/muruganu/svnTest/paint/data/test.paint");
        pf.savePAINT(new String[]{"((seq1,seq2)"}, new String[]{"gi name"}, new String[]{"sf1  an0"});
    }
}

