/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.paintCommon.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FileUtils {
    protected static Logger log = Logger.getLogger((String)FileUtils.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readFile(String fileName) {
        Vector<String> contents = new Vector<String>();
        BufferedReader bufReader = null;
        boolean error = false;
        try {
            bufReader = new BufferedReader(new FileReader(fileName));
            String line = bufReader.readLine();
            while (line != null) {
                contents.addElement(line);
                line = bufReader.readLine();
            }
        }
        catch (IOException ioex) {
            error = true;
            log.error((Object)("Exception " + ioex.getMessage() + " returned while attempting to read file " + fileName));
        }
        finally {
            try {
                if (null != bufReader) {
                    bufReader.close();
                }
            }
            catch (IOException ioex2) {
                error = true;
                log.error((Object)("Exception " + ioex2.getMessage() + " returned while attempting to close file " + fileName));
            }
        }
        if (error) {
            return null;
        }
        Object[] returnArray = new String[contents.size()];
        contents.copyInto(returnArray);
        return returnArray;
    }

    public static String[] readFileFromURL(URL url) throws IOException {
        BufferedReader bufReader = null;
        String line = "not inititialized";
        Vector<String> v = new Vector<String>();
        try {
            bufReader = new BufferedReader(new InputStreamReader(url.openStream()));
            line = bufReader.readLine();
            while (line != null) {
                v.addElement(line);
                line = bufReader.readLine();
            }
        }
        catch (IOException ioex) {
            System.out.println("Exception while reading");
            ioex.printStackTrace();
            throw ioex;
        }
        finally {
            try {
                bufReader.close();
            }
            catch (IOException ioex2) {
                System.out.println("Exception while closing");
                ioex2.printStackTrace();
                throw ioex2;
            }
        }
        Object[] returnArray = new String[v.size()];
        v.copyInto(returnArray);
        return returnArray;
    }

    public static void writeFile(String fileName, String[] contents) throws IOException {
        BufferedWriter bufWriter = null;
        bufWriter = new BufferedWriter(new FileWriter(fileName));
        for (int i = 0; i < contents.length; ++i) {
            String line = contents[i];
            bufWriter.write(line);
        }
        if (null != bufWriter) {
            bufWriter.close();
        }
    }

    public static void writeBufferToFile(String fileName, StringBuffer sb) throws IOException {
        BufferedWriter bwr = new BufferedWriter(new FileWriter(new File(fileName)));
        bwr.write(sb.toString());
        bwr.flush();
        bwr.close();
    }

    public static String getPath(String fileName) {
        File f = new File(fileName);
        if (f.isDirectory()) {
            return f.getPath();
        }
        int separatorIndex = f.getPath().lastIndexOf(File.separator);
        if (-1 == separatorIndex) {
            return null;
        }
        return f.getPath().substring(0, separatorIndex);
    }

    public static String getFileName(String path) {
        File f = new File(path);
        return f.getName();
    }

    public static String getURLPath(String url) {
        int separatorIndex = url.lastIndexOf(File.separator);
        if (-1 == separatorIndex) {
            return null;
        }
        return url.substring(0, separatorIndex);
    }

    public static String appendFileToPath(String path, String fileName) {
        return path + File.separator + fileName;
    }

    public static String appendPathToPath(String path1, String path2) {
        return path1 + File.separator + path2;
    }

    public static boolean validPath(String path) {
        if (null == path) {
            return false;
        }
        File f = new File(path);
        return f.canRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validURLPath(String url) {
        URL newURL;
        try {
            newURL = new URL(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
        InputStream is = null;
        boolean returnVal = false;
        try {
            is = newURL.openStream();
            returnVal = true;
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (IOException ioex2) {
                ioex2.printStackTrace();
            }
        }
        return returnVal;
    }

    public static String[] getSubDirectories(File dir) {
        Object[] directories = null;
        if (dir.isDirectory()) {
            directories = dir.list();
            Vector<Object> dirVector = new Vector<Object>(directories.length);
            for (int i = 0; i < directories.length; ++i) {
                if (!new File(dir.getAbsolutePath() + File.separator + (String)directories[i]).isDirectory()) continue;
                dirVector.addElement(directories[i]);
            }
            directories = new String[dirVector.size()];
            dirVector.copyInto(directories);
        }
        return directories;
    }
}

