/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.paintCommon.util;

import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class ReadResources {
    protected boolean isInitialized = false;
    protected String[] resourceNames;
    private ResourceBundle[] bundles;
    private ResourceBundle bundle;

    public ReadResources() {
    }

    public ReadResources(String name) throws Exception {
        String[] names = new String[]{name};
        this.initialize(names);
    }

    public ReadResources(String[] names) throws Exception {
        this.initialize(names);
    }

    protected void initialize(String[] names) throws Exception {
        this.resourceNames = names;
        this.isInitialized = false;
        this.bundles = new ResourceBundle[names.length];
        String resourceName = null;
        try {
            for (int i = 0; i < this.resourceNames.length; ++i) {
                resourceName = this.resourceNames[i];
                this.bundles[i] = ResourceBundle.getBundle(resourceName);
            }
        }
        catch (MissingResourceException mrex) {
            StringBuffer error = new StringBuffer("Can't find ");
            error.append(resourceName).append(" Maybe not in your CLASSPATH").append("\r\n");
            error.append("CLASSPATH used : ").append(System.getProperty("java.class.path"));
            throw new Exception(error.toString());
        }
        this.isInitialized = true;
    }

    public void setResource(String name) throws Exception {
        String[] names = new String[]{name};
        this.setResource(names);
    }

    public void setResource(String[] names) throws Exception {
        boolean reinitializeFlag = false;
        if (this.resourceNames == null) {
            reinitializeFlag = true;
        } else if (names.length != this.resourceNames.length) {
            reinitializeFlag = true;
        } else {
            for (int i = 0; i < names.length; ++i) {
                if (names[i].equals(this.resourceNames[i])) continue;
                reinitializeFlag = true;
                break;
            }
        }
        if (reinitializeFlag) {
            this.initialize(names);
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public String getKey(String key) throws Exception {
        return this.getKey(key, null);
    }

    public String getKey(String key, String defaultValue) throws Exception {
        this.bundle = null;
        String result = null;
        for (int i = 0; i < this.bundles.length; ++i) {
            try {
                result = this.bundles[i].getString(key);
                if (result == null) continue;
                this.bundle = this.bundles[i];
                break;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (result == null) {
            if (defaultValue == null) {
                throw new Exception("Key " + key + " doesn't exist in property file(s)");
            }
            result = defaultValue;
        }
        if (this.bundle == null) {
            throw new Exception("resource Name not Setup");
        }
        return result;
    }

    public Enumeration<String> getKeys() throws Exception {
        if (this.bundles == null) {
            throw new Exception("resource Name not Setup");
        }
        Vector<String> allKeys = new Vector<String>();
        for (int i = 0; i < this.bundles.length; ++i) {
            Enumeration<String> e = this.bundles[i].getKeys();
            while (e.hasMoreElements()) {
                allKeys.addElement(e.nextElement());
            }
        }
        return allKeys.elements();
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }
}

