/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.paintCommon.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class StringUtils {
    protected static Logger log = Logger.getLogger(StringUtils.class);
    public static final String XML10_ILLEGAL_CHARS_PATTERN = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";
    String XML11_ILLEGAL_CHARS_PATTERN = "[^\u0001-\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]+";

    public static String[] formatString(String s, int len) {
        int lastIndex = s.length() / len + 1;
        String[] strArray = new String[lastIndex];
        for (int i = 0; i < lastIndex - 1; ++i) {
            strArray[i] = s.substring(i * len, (i + 1) * len);
        }
        strArray[lastIndex - 1] = s.substring((lastIndex - 1) * len, s.length());
        return strArray;
    }

    public static String replaceFirst(String sOriginal, String sToken, String sReplace) {
        int index = sOriginal.indexOf(sToken);
        Object result = sOriginal;
        if (index != -1) {
            result = sOriginal.substring(0, index) + sReplace + sOriginal.substring(index + sToken.length());
        }
        return result;
    }

    public static Vector compareStringToVectorHash(Hashtable newTbl, Hashtable origTbl) {
        Hashtable<String, Vector> toAddTbl = new Hashtable<String, Vector>();
        Hashtable<String, Vector<Object>> toRemoveTbl = new Hashtable<String, Vector<Object>>();
        Enumeration eList = newTbl.keys();
        block0: while (eList.hasMoreElements()) {
            String key = (String)eList.nextElement();
            Vector newList = (Vector)newTbl.get(key);
            Vector origList = (Vector)origTbl.get(key);
            if (null == origList) {
                toAddTbl.put(key, newList);
                continue;
            }
            if (newList.size() != origList.size()) {
                toAddTbl.put(key, newList);
                toRemoveTbl.put(key, origList);
                continue;
            }
            Object[] newProtArray = new String[newList.size()];
            Object[] origArray = new String[origList.size()];
            newList.copyInto(newProtArray);
            origList.copyInto(origArray);
            Arrays.sort(newProtArray);
            Arrays.sort(origArray);
            for (int i = 0; i < newProtArray.length; ++i) {
                if (0 == ((String)newProtArray[i]).compareTo((String)origArray[i])) continue;
                toAddTbl.put(key, newList);
                toRemoveTbl.put(key, origList);
                continue block0;
            }
        }
        eList = origTbl.keys();
        while (eList.hasMoreElements()) {
            String sfName = (String)eList.nextElement();
            if (null != newTbl.get(sfName)) continue;
            toRemoveTbl.put(sfName, (Vector<Object>)origTbl.get(sfName));
        }
        if (toAddTbl.isEmpty() && toRemoveTbl.isEmpty()) {
            return null;
        }
        Vector<Hashtable<String, Vector<Object>>> returnList = new Vector<Hashtable<String, Vector<Object>>>(2);
        returnList.addElement(toAddTbl);
        returnList.addElement(toRemoveTbl);
        return returnList;
    }

    public static String listToString(Collection<String> c, String wrapper, String delim) {
        if (null == c || c.isEmpty() || null == wrapper || null == delim) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int size = c.size();
        Iterator<String> iter = c.iterator();
        for (int counter = 0; iter.hasNext() && counter < size - 1; ++counter) {
            sb.append(wrapper);
            sb.append(iter.next());
            sb.append(wrapper);
            sb.append(delim);
        }
        sb.append(wrapper);
        sb.append(iter.next());
        sb.append(wrapper);
        return sb.toString();
    }

    public static synchronized String[] concatenateArrays(String[] firstPart, String[] secondPart) {
        int fpl = firstPart.length;
        int spl = secondPart.length;
        String[] ret = new String[fpl + spl];
        System.arraycopy(firstPart, 0, ret, 0, fpl);
        System.arraycopy(secondPart, 0, ret, fpl, spl);
        return ret;
    }

    public static boolean compareLists(String[] list1, String[] list2) {
        if (null == list1 || null == list2) {
            return false;
        }
        int size = list1.length;
        if (size != list2.length) {
            return false;
        }
        Arrays.sort(list1);
        Arrays.sort(list2);
        boolean found = false;
        for (int i = 0; i < size; ++i) {
            found = false;
            for (int j = 0; j < size; ++j) {
                if (0 != list1[i].compareTo(list2[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean stringsSame(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }
}

