/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.paintCommon.util;

import com.sri.panther.paintCommon.Constant;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Utils {
    public static final Logger logger = Logger.getLogger((String)Utils.class.getName());
    public static final String MSG_INVALID_SF_ID = "Invalid subfamily id encountered ";
    public static final String MSG_INVALID_AN_ID = "Invalid annotation id encountered ";
    public static final String MSG_DUPLICATE_AN_ID_ENCOUNTERED_FOR_SUBFAMILY = " Duplicate anotation id encountered for subfamily ";
    public static final String MSG_DUPLICATE_SF_ID_ENCOUNTERED_FOR_ANNOTATION_ID = " Duplicate subfamily id encountered for annotation node ";
    public static final String MSG_SF_AN_INFO_IS_NULL = "Subfamily annotation node relationship information is null";
    public static final String MSG_SF_AN_INFO_INVALID = "Subfamily annotation node relationship information is invalid ";
    public static final String STR_NEWLINE = "\n";
    public static final String PAINT_REF = "PAINT_REF";

    public static String replace(String sOriginal, char cToken, char cReplace) {
        return sOriginal.replace(cToken, cReplace);
    }

    public static String replace(String sOriginal, String sToken, String sReplace) {
        if (sToken.length() == 1 && sReplace.length() == 1) {
            return Utils.replace(sOriginal, sToken.charAt(0), sReplace.charAt(0));
        }
        Object result = sOriginal;
        int index = ((String)result).indexOf(sToken);
        while (index != -1) {
            result = ((String)result).substring(0, index) + sReplace + ((String)result).substring(index + sToken.length(), ((String)result).length());
            index = ((String)result).indexOf(sToken);
        }
        return result;
    }

    public static String replace(String sOriginal, String sToken, String sReplace, boolean recusive) {
        if (recusive) {
            return Utils.replace(sOriginal, sToken, sReplace);
        }
        Object result = sOriginal;
        int index = ((String)result).indexOf(sToken);
        if (index != -1) {
            result = ((String)result).substring(0, index) + sReplace + ((String)result).substring(index + sToken.length(), ((String)result).length());
        }
        return result;
    }

    public static String listToString(Vector list, String wrapper, String delim) {
        if (list.isEmpty()) {
            return "";
        }
        int size = list.size();
        StringBuffer selection = new StringBuffer();
        for (int i = 0; i < size - 1; ++i) {
            selection.append(wrapper);
            selection.append((String)list.elementAt(i));
            selection.append(wrapper);
            selection.append(delim);
        }
        selection.append(wrapper);
        selection.append((String)list.elementAt(size - 1));
        selection.append(wrapper);
        return selection.toString();
    }

    public static String listToString(String[] list, String wrapper, String delim) {
        int size = list.length;
        StringBuffer selection = new StringBuffer();
        for (int i = 0; i < size - 1; ++i) {
            selection.append(wrapper);
            selection.append(list[i]);
            selection.append(wrapper);
            selection.append(delim);
        }
        selection.append(wrapper);
        selection.append(list[size - 1]);
        selection.append(wrapper);
        return selection.toString();
    }

    public static String[] embeddedTokenize(String original, String longDelimiter) {
        String unmatchedToken;
        ArrayList<String> resultList = new ArrayList<String>();
        int endOfLastDelimiter = 0;
        int startOfNextDelimiter = original.toLowerCase().indexOf(longDelimiter.toLowerCase(), endOfLastDelimiter);
        while (startOfNextDelimiter != -1) {
            unmatchedToken = original.substring(endOfLastDelimiter, startOfNextDelimiter);
            String matchedToken = original.substring(startOfNextDelimiter, startOfNextDelimiter + longDelimiter.length());
            resultList.add(unmatchedToken);
            resultList.add(matchedToken);
            endOfLastDelimiter = startOfNextDelimiter + longDelimiter.length();
            startOfNextDelimiter = original.toLowerCase().indexOf(longDelimiter.toLowerCase(), endOfLastDelimiter);
        }
        unmatchedToken = original.substring(endOfLastDelimiter);
        resultList.add(unmatchedToken);
        String[] result = new String[resultList.size()];
        result = resultList.toArray(result);
        return result;
    }

    public static String[] tokenize(String input, String delim) {
        Vector<String> v = new Vector<String>();
        StringTokenizer tk = new StringTokenizer(input, delim);
        while (tk.hasMoreTokens()) {
            v.addElement(tk.nextToken());
        }
        Object[] strArray = new String[v.size()];
        v.copyInto(strArray);
        return strArray;
    }

    public static Integer[] getSeparatorIndices(String s, String separator) {
        Vector<Integer> v = new Vector<Integer>();
        int length = separator.length();
        int i = 0;
        while (i + length < s.length()) {
            if (s.regionMatches(true, i, separator, 0, length)) {
                v.addElement(new Integer(i));
            }
            ++i;
        }
        Object[] integerArray = new Integer[v.size()];
        v.copyInto(integerArray);
        return integerArray;
    }

    public static boolean compare(String[] s1, String[] s2) {
        if (s1.length != s2.length) {
            return false;
        }
        for (int i = 0; i < s1.length; ++i) {
            if (s1[i].length() == s2[i].length()) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(Integer[] i1, Integer[] i2) {
        if (i1.length != i2.length) {
            return false;
        }
        for (int i = 0; i < i1.length; ++i) {
            if (0 == i1[i].compareTo(i2[i])) continue;
            return false;
        }
        return true;
    }

    public static String[][] readDelimitedFile(InputStream is, String delim) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        try {
            String currentLine;
            Vector<String[]> Strings = new Vector<String[]>();
            while (null != (currentLine = r.readLine())) {
                Strings.addElement(Utils.tokenize(currentLine, delim));
            }
            r.close();
            String[][] stringArray = new String[Strings.size()][];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String[])Strings.elementAt(i);
            }
            return stringArray;
        }
        catch (IOException ie) {
            ie.printStackTrace();
            throw ie;
        }
    }

    public static String trimFromEnds(String original, String trimString) {
        String returnStr = original;
        if (returnStr.startsWith(trimString)) {
            returnStr = returnStr.substring(trimString.length(), returnStr.length());
        }
        if (returnStr.endsWith(trimString)) {
            returnStr = returnStr.substring(0, returnStr.length() - 1);
        }
        return returnStr;
    }

    public static boolean isNumber(String inStr) {
        for (int i = 0; i < inStr.length(); ++i) {
            char tmp = inStr.charAt(i);
            if (Character.isDigit(tmp)) continue;
            return false;
        }
        return true;
    }

    public static String[][] readFile(String fileName, String fileDelimiter) throws IOException {
        File inputFile = new File(fileName);
        InputStream is = Utils.class.getResourceAsStream(fileName);
        if (null == is) {
            FileInputStream fs = new FileInputStream(inputFile);
            String[][] matrix = Utils.readDelimitedFile(fs, fileDelimiter);
            fs.close();
            return matrix;
        }
        String[][] matrix = Utils.readDelimitedFile(is, fileDelimiter);
        is.close();
        return matrix;
    }

    public static Vector fileToVector(String fileName, String delimiter) throws IOException {
        return Utils.fileToVector(fileName, delimiter, true);
    }

    public static Vector fileToVector(String fileName, String delimiter, boolean uniqueFlag) throws IOException {
        Vector<String> idList = new Vector<String>();
        Hashtable<String, String> ids = new Hashtable<String, String>();
        try {
            String line;
            BufferedReader fileStream;
            File inputFile = new File(fileName);
            InputStream is = Utils.class.getResourceAsStream(fileName);
            if (null == is) {
                FileInputStream fs = new FileInputStream(fileName);
                fileStream = new BufferedReader(new InputStreamReader(fs));
            } else {
                fileStream = new BufferedReader(new InputStreamReader(is));
            }
            while ((line = fileStream.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, delimiter);
                while (st.hasMoreTokens()) {
                    if (uniqueFlag) {
                        ids.put(st.nextToken(), "1");
                        continue;
                    }
                    idList.addElement(st.nextToken());
                }
            }
            if (uniqueFlag) {
                Enumeration e = ids.keys();
                while (e.hasMoreElements()) {
                    String id = (String)e.nextElement();
                    idList.addElement(id);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return idList;
    }

    public static BufferedReader getFile(String URL2, int portNumber, String localPath) {
        try {
            Socket s = new Socket(URL2, portNumber);
            BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
            PrintWriter out = new PrintWriter(s.getOutputStream());
            out.print("GET " + localPath + "\n\n");
            out.flush();
            return in;
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            return null;
        }
    }

    public static InputStream getFileAsInputStream(String URL2, int portNumber, String localPath) {
        try {
            Socket s = new Socket(URL2, portNumber);
            InputStream is = s.getInputStream();
            PrintWriter out = new PrintWriter(s.getOutputStream());
            out.print("GET " + localPath + "\n\n");
            out.flush();
            return is;
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(String fileName, String[] contents) {
        BufferedWriter bufWriter = null;
        boolean success = true;
        if (null == contents) {
            return false;
        }
        try {
            bufWriter = new BufferedWriter(new FileWriter(fileName));
            for (int i = 0; i < contents.length; ++i) {
                String line = contents[i];
                bufWriter.write(line);
            }
        }
        catch (IOException ioex) {
            success = false;
            System.out.println("Exception " + ioex.getMessage() + " returned while attempting to write file " + fileName);
        }
        finally {
            try {
                if (null != bufWriter) {
                    bufWriter.close();
                }
            }
            catch (IOException ioex2) {
                success = false;
                System.out.println("Exception " + ioex2.getMessage() + " returned while attempting to close file " + fileName);
            }
        }
        return success;
    }

    public static int getMaxValue(int[] numbers) {
        int max = numbers[0];
        for (int i = 0; i < numbers.length; ++i) {
            if (max >= numbers[i]) continue;
            max = numbers[i];
        }
        return max;
    }

    public static int getMinValue(int[] numbers) {
        int min = numbers[0];
        for (int i = 0; i < numbers.length; ++i) {
            if (min <= numbers[i]) continue;
            min = numbers[i];
        }
        return min;
    }

    public static String doubleToPercent(double value, int precision) {
        long tempValue = Math.round(value * Math.pow(10.0, precision + 2));
        Object percentValue = null;
        percentValue = precision == 0 ? String.valueOf((double)tempValue) : String.valueOf((double)tempValue / Math.pow(10.0, precision));
        percentValue = (String)percentValue + "%";
        return percentValue;
    }

    public static boolean search(String[] searchList, String s) {
        if (null == s || null == searchList) {
            return false;
        }
        for (int i = 0; i < searchList.length; ++i) {
            if (0 != searchList[i].compareTo(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean search(Vector searchList, String s) {
        if (null == s || null == searchList) {
            return false;
        }
        for (int i = 0; i < searchList.size(); ++i) {
            if (!((String)searchList.get(i)).equals(s)) continue;
            return true;
        }
        return false;
    }

    public static int getIndex(String[] searchList, String s) {
        if (null == s || null == searchList) {
            return -1;
        }
        for (int i = 0; i < searchList.length; ++i) {
            if (0 != searchList[i].compareTo(s)) continue;
            return i;
        }
        return -1;
    }

    public static int getIndex(List searchList, String s) {
        if (null == s || null == searchList) {
            return -1;
        }
        for (int i = 0; i < searchList.size(); ++i) {
            if (!((String)searchList.get(i)).equals(s)) continue;
            return i;
        }
        return -1;
    }

    public static String getHexColorString(Color color) {
        StringBuffer result = new StringBuffer();
        if (color.getRed() == 0) {
            result.append("00");
        } else {
            result.append(Integer.toHexString(color.getRed()));
        }
        if (color.getGreen() == 0) {
            result.append("00");
        } else {
            result.append(Integer.toHexString(color.getGreen()));
        }
        if (color.getBlue() == 0) {
            result.append("00");
        } else {
            result.append(Integer.toHexString(color.getBlue()));
        }
        return result.toString();
    }

    public static int howOften(String searchString, char c) {
        String regexp = "" + c;
        String s = null;
        try {
            s = searchString.replaceAll(regexp, "");
        }
        catch (Exception e) {
            regexp = "\\" + c;
            s = searchString.replaceAll(regexp, "");
        }
        return searchString.length() - s.length();
    }

    public static final String constructExternalSubfamilyId(String book, String subfamilyId) {
        if (null == book) {
            return null;
        }
        if (null == subfamilyId) {
            return book;
        }
        return book + ":" + subfamilyId;
    }

    public static final String getBookIdFromBookSubfamilyId(String bookSubfamilyId) {
        if (null == bookSubfamilyId) {
            return null;
        }
        int index = bookSubfamilyId.indexOf(":");
        if (index < 0) {
            return bookSubfamilyId;
        }
        return bookSubfamilyId.substring(0, index);
    }

    public static final String getSfIdFromBookSubfamilyId(String bookSubfamilyId) {
        if (null == bookSubfamilyId) {
            return null;
        }
        int index = bookSubfamilyId.indexOf(":");
        if (index < 0) {
            return null;
        }
        return bookSubfamilyId.substring(index + 1);
    }

    public static final String constructExternalAnnotId(String book, String annotId) {
        if (null == book) {
            return null;
        }
        if (null == annotId) {
            return book;
        }
        return book + ":" + annotId;
    }

    public static final String getBookId(String bookAnnotId) {
        if (null == bookAnnotId) {
            return null;
        }
        int index = bookAnnotId.indexOf(":");
        if (index < 0) {
            return bookAnnotId;
        }
        return bookAnnotId.substring(0, index);
    }

    public static final String getAnnotId(String bookAnnotId) {
        if (null == bookAnnotId) {
            return null;
        }
        int index = bookAnnotId.indexOf(":");
        if (index < 0) {
            return null;
        }
        return bookAnnotId.substring(index + 1);
    }

    public static ArrayList<String> readFile(String fileName) {
        ArrayList<String> contents = new ArrayList<String>();
        try {
            String sCurrentLine;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            while ((sCurrentLine = br.readLine()) != null) {
                contents.add(sCurrentLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return contents;
    }

    public static Hashtable<String, String> parseSfAnInfo(String[] sfAnInfo, boolean checkSFName) {
        if (null == sfAnInfo) {
            logger.error((Object)MSG_SF_AN_INFO_IS_NULL);
            return null;
        }
        int length = sfAnInfo.length;
        Hashtable<String, String> AnSfTbl = new Hashtable<String, String>(length);
        Hashtable<String, String> sfTbl = new Hashtable<String, String>(length);
        for (int i = 0; i < length; ++i) {
            String info = sfAnInfo[i];
            String[] infoStr = Utils.tokenize(info = info.trim(), "\t");
            int infoLen = infoStr.length;
            if (infoLen >= 1 && infoLen >= 0) {
                if (!checkSFName) {
                    AnSfTbl.put(infoStr[1], infoStr[0]);
                    continue;
                }
                String sfName = infoStr[0];
                if (null == sfName || !sfName.startsWith("SF")) {
                    logger.error((Object)(MSG_INVALID_SF_ID + sfName));
                    return null;
                }
                String numberPart = sfName.substring(Constant.NODE_SUBFAMILY_PREFIX_LENGTH, sfName.length());
                try {
                    Integer.parseInt(numberPart);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    logger.error((Object)(MSG_INVALID_SF_ID + sfName));
                    return null;
                }
                String anId = infoStr[1];
                if (null == anId || !anId.startsWith("AN")) {
                    logger.error((Object)(MSG_INVALID_AN_ID + anId));
                    return null;
                }
                numberPart = anId.substring(Constant.NODE_ANNOTATION_PREFIX_LENGTH, anId.length());
                try {
                    Integer.parseInt(numberPart);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    logger.error((Object)(MSG_INVALID_AN_ID + anId));
                    return null;
                }
                String previousSfId = AnSfTbl.put(anId, sfName);
                if (null != previousSfId) {
                    logger.error((Object)(anId + MSG_DUPLICATE_AN_ID_ENCOUNTERED_FOR_SUBFAMILY + previousSfId));
                    return null;
                }
                if (null == sfTbl.put(sfName, sfName)) continue;
                logger.error((Object)(sfName + MSG_DUPLICATE_SF_ID_ENCOUNTERED_FOR_ANNOTATION_ID + anId));
                return null;
            }
            logger.error((Object)(MSG_SF_AN_INFO_INVALID + info));
            return null;
        }
        return AnSfTbl;
    }

    public static String getPaintEvidenceAcc(String bookId) {
        int acc = Integer.valueOf(bookId.substring("PTHR".length()));
        String paint_id = String.format("%1$07d", acc);
        return paint_id;
    }

    public static String getTextFromXml(Element elem, String tag) {
        Node n;
        String s;
        Element textElement;
        NodeList textNodes;
        NodeList nodeList = elem.getElementsByTagName(tag);
        if (null == nodeList) {
            return null;
        }
        if (null != nodeList && 0 < nodeList.getLength() && null != (textNodes = (textElement = (Element)nodeList.item(0)).getChildNodes()) && textNodes.getLength() > 0 && null != (s = (n = textNodes.item(0)).getNodeValue())) {
            return s.trim();
        }
        return null;
    }

    public static String getTextFromElement(Element elem) {
        if (null == elem) {
            return null;
        }
        NodeList textNodes = elem.getChildNodes();
        if (null == textNodes) {
            return null;
        }
        if (textNodes.getLength() <= 0) {
            return null;
        }
        Node n = textNodes.item(0);
        String s = n.getNodeValue();
        if (null != s) {
            return s.trim();
        }
        return null;
    }

    public static Element createTextNode(Document doc, String elementTag, String text) {
        if (null == doc || null == elementTag || null == text) {
            return null;
        }
        Element elem = doc.createElement(elementTag);
        Text t = doc.createTextNode(text);
        elem.appendChild(t);
        return elem;
    }

    public static String readFromUrl(String urlStr, int connectionTimeout, int readTimeout) {
        if (null == urlStr || 0 == urlStr.length()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        URL url = null;
        URLConnection urlConn = null;
        InputStreamReader inStream = null;
        BufferedReader buff = null;
        try {
            String nextLine;
            url = new URL(urlStr);
            urlConn = url.openConnection();
            if (-1 != connectionTimeout) {
                urlConn.setConnectTimeout(connectionTimeout);
            }
            if (-1 != readTimeout) {
                urlConn.setReadTimeout(readTimeout);
            }
            inStream = new InputStreamReader(urlConn.getInputStream());
            buff = new BufferedReader(inStream);
            while ((nextLine = buff.readLine()) != null) {
                sb.append(nextLine + STR_NEWLINE);
            }
        }
        catch (MalformedURLException e) {
            System.out.println("Please check the URL: " + urlStr + " " + e.toString());
            return null;
        }
        catch (IOException e1) {
            System.out.println("Can't read  from url: " + urlStr + " " + e1.toString());
            return null;
        }
        catch (Exception e) {
            System.out.println("Can't read  from url: " + urlStr + " " + e.toString());
            return null;
        }
        return sb.toString();
    }
}

