/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paintCommon;

import edu.usc.ksom.pm.panther.paintCommon.AnnotationDetail;
import edu.usc.ksom.pm.panther.paintCommon.DBReference;
import edu.usc.ksom.pm.panther.paintCommon.Evidence;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.IWith;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import edu.usc.ksom.pm.panther.paintCommon.WithEvidence;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class Annotation
implements Serializable,
IWith {
    private String annotationId;
    private String annotationTypeId;
    private String date;
    private String annotationType;
    private boolean annotStoredInDb = false;
    private AnnotationDetail annotationDetail = new AnnotationDetail();
    private String goTerm;
    private HashSet<Qualifier> qualifierSet;
    private boolean expAnnotCreatedInPaint = false;
    private boolean experimental = false;

    public String getAnnotationId() {
        return this.annotationId;
    }

    public void setAnnotationId(String annotationId) {
        this.annotationId = annotationId;
    }

    public String getAnnotationTypeId() {
        return this.annotationTypeId;
    }

    public void setAnnotationTypeId(String annotationTypeId) {
        this.annotationTypeId = annotationTypeId;
    }

    public String getAnnotationType() {
        return this.annotationType;
    }

    public void setAnnotationType(String annotationType) {
        this.annotationType = annotationType;
    }

    public String getGoTerm() {
        return this.goTerm;
    }

    public void setGoTerm(String goTerm) {
        this.goTerm = goTerm;
    }

    public void addWithEvidence(WithEvidence we) {
        this.annotationDetail.addWithEvidence(we);
    }

    public String getSingleEvidenceCodeFromSet() {
        HashSet<String> codeSet = this.getEvidenceCodeSet();
        if (null == codeSet || 1 != codeSet.size()) {
            return null;
        }
        Iterator<String> iterator = codeSet.iterator();
        if (iterator.hasNext()) {
            String code = iterator.next();
            return code;
        }
        return null;
    }

    public static Annotation getSingleWithPropagatorAnnot(Annotation a) {
        HashSet<WithEvidence> withAnnotSet = a.getAnnotationDetail().getWithEvidenceAnnotSet();
        if (null == withAnnotSet || 1 != withAnnotSet.size()) {
            return null;
        }
        Iterator<WithEvidence> iterator = withAnnotSet.iterator();
        if (iterator.hasNext()) {
            WithEvidence we = iterator.next();
            return (Annotation)we.getWith();
        }
        return null;
    }

    public HashSet<String> getEvidenceCodeSet() {
        AnnotationDetail ad = this.annotationDetail;
        if (null == ad) {
            return null;
        }
        HashSet<String> codeSet = new HashSet<String>();
        if (null != ad.getWithEvidenceAnnotSet()) {
            for (WithEvidence cur : ad.getWithEvidenceAnnotSet()) {
                if (null == cur.getEvidenceCode()) continue;
                codeSet.add(cur.getEvidenceCode());
            }
        }
        if (null != ad.getWithEvidenceNodeSet()) {
            for (WithEvidence cur : ad.getWithEvidenceNodeSet()) {
                if (null == cur.getEvidenceCode()) continue;
                codeSet.add(cur.getEvidenceCode());
            }
        }
        if (null != ad.getWithEvidenceDBRefSet()) {
            for (WithEvidence cur : ad.getWithEvidenceDBRefSet()) {
                if (null == cur.getEvidenceCode()) continue;
                codeSet.add(cur.getEvidenceCode());
            }
        }
        return codeSet;
    }

    public HashSet<Qualifier> getQualifierSet() {
        if (null == this.qualifierSet) {
            return null;
        }
        return (HashSet)this.qualifierSet.clone();
    }

    public HashSet<Qualifier> getApplicableQualifierSet(GOTermHelper gth) {
        if (null == this.qualifierSet) {
            return null;
        }
        GOTerm term = gth.getTerm(this.goTerm);
        HashSet<Qualifier> applicableSet = new HashSet<Qualifier>();
        for (Qualifier q : this.qualifierSet) {
            if (!gth.isQualifierValidForTerm(term, q)) continue;
            applicableSet.add(q);
        }
        if (applicableSet.isEmpty()) {
            return null;
        }
        return applicableSet;
    }

    public void setQualifierSet(HashSet<Qualifier> qualifierSet) {
        this.qualifierSet = qualifierSet;
    }

    public void addQualifier(Qualifier q) {
        if (null == q) {
            return;
        }
        if (null == this.qualifierSet) {
            this.qualifierSet = new HashSet();
            this.qualifierSet.add(q);
            return;
        }
        for (Qualifier current : this.qualifierSet) {
            if (!current.equals(q)) continue;
            return;
        }
        this.qualifierSet.add(q);
    }

    public Annotation makeCopy() {
        Annotation newAnnot = new Annotation();
        newAnnot.annotationType = this.annotationType;
        newAnnot.annotationTypeId = this.annotationTypeId;
        newAnnot.goTerm = this.goTerm;
        if (null != this.qualifierSet) {
            HashSet<Qualifier> newQualifierSet = new HashSet<Qualifier>(this.qualifierSet.size());
            newAnnot.qualifierSet = newQualifierSet;
            for (Qualifier q : this.qualifierSet) {
                newQualifierSet.add(q.makeCopy());
            }
        }
        newAnnot.expAnnotCreatedInPaint = this.expAnnotCreatedInPaint;
        return newAnnot;
    }

    public boolean isAnnotStoredInDb() {
        return this.annotStoredInDb;
    }

    public void setAnnotStoredInDb(boolean annotStoredInDb) {
        this.annotStoredInDb = annotStoredInDb;
    }

    public AnnotationDetail getAnnotationDetail() {
        return this.annotationDetail;
    }

    public void setAnnotationDetail(AnnotationDetail annotationDetail) {
        this.annotationDetail = annotationDetail;
    }

    public boolean isCreatedByPaint() {
        HashSet<WithEvidence> withEvSet = this.annotationDetail.getWithEvidenceSet();
        if (null == withEvSet) {
            return false;
        }
        for (WithEvidence we : withEvSet) {
            if (!we.isPAINTType()) continue;
            return true;
        }
        return false;
    }

    public void removeFromWithEvidence(IWith iw) {
        HashSet<WithEvidence> withEvDBRefSet;
        HashSet<WithEvidence> withEvNodeSet;
        if (null == iw) {
            return;
        }
        HashSet<WithEvidence> withEvAnnotSet = this.annotationDetail.getWithEvidenceAnnotSet();
        if (null != withEvAnnotSet) {
            Iterator<WithEvidence> iter = withEvAnnotSet.iterator();
            while (iter.hasNext()) {
                WithEvidence we = iter.next();
                if (we.getWith() != iw) continue;
                iter.remove();
                this.removeWith((Annotation)iw);
                return;
            }
        }
        if (null != (withEvNodeSet = this.annotationDetail.getWithEvidenceNodeSet())) {
            Iterator<WithEvidence> iter = withEvNodeSet.iterator();
            while (iter.hasNext()) {
                WithEvidence we = iter.next();
                if (we.getWith() != iw) continue;
                iter.remove();
                HashSet<Node> nodeSet = this.annotationDetail.getWithNodeSet();
                if (null != nodeSet) {
                    nodeSet.remove((Node)iw);
                }
                return;
            }
        }
        if (null != (withEvDBRefSet = this.annotationDetail.getWithEvidenceDBRefSet())) {
            Iterator<WithEvidence> iter = withEvDBRefSet.iterator();
            while (iter.hasNext()) {
                WithEvidence we = iter.next();
                if (we.getWith() != iw) continue;
                iter.remove();
                HashSet<DBReference> dbRefSet = this.annotationDetail.getWithOtherSet();
                if (null != dbRefSet) {
                    dbRefSet.remove((DBReference)iw);
                }
                return;
            }
        }
    }

    public Annotation removeWith(Annotation a) {
        Annotation removeAnnot = this.annotationDetail.removeWithAnnotation(a);
        if (null == removeAnnot) {
            return null;
        }
        Set<Qualifier> qSet = this.annotationDetail.getQualifiers();
        if (null == qSet || qSet.isEmpty()) {
            this.qualifierSet = null;
            return removeAnnot;
        }
        this.qualifierSet = new HashSet();
        for (Qualifier q : qSet) {
            this.qualifierSet.add(q);
        }
        return removeAnnot;
    }

    public static boolean hasExperimentalWith(Annotation a) {
        HashSet<WithEvidence> withEvSet = a.getAnnotationDetail().getWithEvidenceSet();
        if (null == withEvSet) {
            return false;
        }
        for (WithEvidence we : withEvSet) {
            Annotation aWith;
            IWith with = we.getWith();
            if (!(with instanceof Annotation) || !(aWith = (Annotation)with).isExperimental()) continue;
            return true;
        }
        return false;
    }

    public boolean withExists(Annotation a) {
        HashSet<WithEvidence> withAnnotEvSet = this.annotationDetail.getWithEvidenceAnnotSet();
        if (null == withAnnotEvSet) {
            return false;
        }
        for (WithEvidence we : withAnnotEvSet) {
            Annotation with = (Annotation)we.getWith();
            if (with != a) continue;
            return true;
        }
        return false;
    }

    public boolean isRequired(Annotation a) {
        Collection<HashSet<Annotation>> values;
        HashSet<WithEvidence> withAnnotEvSet = this.annotationDetail.getWithEvidenceAnnotSet();
        if (null == withAnnotEvSet) {
            return false;
        }
        for (WithEvidence we : withAnnotEvSet) {
            Annotation with = (Annotation)we.getWith();
            if (with != a) continue;
            if (1 == withAnnotEvSet.size()) {
                return true;
            }
            String code = this.getSingleEvidenceCodeFromSet();
            if (!"IKR".equals(code) && !"IRD".equals(code) && !"TCV".equals(code)) continue;
            return true;
        }
        LinkedHashMap<Qualifier, HashSet<Annotation>> qualifierLookup = this.annotationDetail.getInheritedQualifierLookup();
        if (null != qualifierLookup) {
            values = qualifierLookup.values();
            for (HashSet<Annotation> val : values) {
                if (val.size() != 1 || !val.contains(a)) continue;
                return true;
            }
        }
        if (null != (qualifierLookup = this.annotationDetail.getAddedQualifierLookup())) {
            values = qualifierLookup.values();
            for (HashSet<Annotation> val : values) {
                if (val.size() != 1 || !val.contains(a)) continue;
                return true;
            }
        }
        if (null != (qualifierLookup = this.annotationDetail.getRemovedQualifierLookup())) {
            values = qualifierLookup.values();
            for (HashSet<Annotation> val : values) {
                if (val.size() != 1 || !val.contains(a)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPaint() {
        HashSet<String> codes = this.annotationDetail.getEvidenceCodes();
        if (null == codes) {
            return false;
        }
        for (String code : codes) {
            if (!Evidence.isPaint(code)) continue;
            return true;
        }
        return false;
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    public void setExperimental(boolean experimental) {
        this.experimental = experimental;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public boolean isExpAnnotCreatedInPaint() {
        return this.expAnnotCreatedInPaint;
    }

    public void setExpAnnotCreatedInPaint(boolean expAnnotCreatedInPaint) {
        this.expAnnotCreatedInPaint = expAnnotCreatedInPaint;
    }
}

