/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paintCommon;

import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.DBReference;
import edu.usc.ksom.pm.panther.paintCommon.IWith;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import edu.usc.ksom.pm.panther.paintCommon.WithEvidence;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class AnnotationDetail
implements Serializable {
    private Node annotatedNode;
    private HashSet<WithEvidence> withEvidenceAnnotSet;
    private HashSet<WithEvidence> withEvidenceNodeSet;
    private HashSet<WithEvidence> withEvidenceDBRefSet;
    private LinkedHashMap<Qualifier, HashSet<Annotation>> inheritedQualifierLookup = new LinkedHashMap();
    private LinkedHashMap<Qualifier, HashSet<Annotation>> addedQualifierLookup = new LinkedHashMap();
    private LinkedHashMap<Qualifier, HashSet<Annotation>> removedQualifierLookup = new LinkedHashMap();

    public void addWithEvidence(WithEvidence we) {
        if (null == we) {
            return;
        }
        IWith with = we.getWith();
        if (with instanceof Annotation) {
            if (null == this.withEvidenceAnnotSet) {
                this.withEvidenceAnnotSet = new HashSet();
                this.withEvidenceAnnotSet.add(we);
                return;
            }
            boolean found = false;
            for (WithEvidence cur : this.withEvidenceAnnotSet) {
                if (!cur.equals(we)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.withEvidenceAnnotSet.add(we);
            }
            return;
        }
        if (with instanceof DBReference) {
            if (null == this.withEvidenceDBRefSet) {
                this.withEvidenceDBRefSet = new HashSet();
                this.withEvidenceDBRefSet.add(we);
                return;
            }
            boolean found = false;
            for (WithEvidence cur : this.withEvidenceDBRefSet) {
                if (!cur.equals(we)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.withEvidenceDBRefSet.add(we);
            }
            return;
        }
        if (with instanceof Node) {
            if (null == this.withEvidenceNodeSet) {
                this.withEvidenceNodeSet = new HashSet();
                this.withEvidenceNodeSet.add(we);
                return;
            }
            boolean found = false;
            for (WithEvidence cur : this.withEvidenceNodeSet) {
                if (!cur.equals(we)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.withEvidenceNodeSet.add(we);
            }
        }
    }

    public Set<Qualifier> getQualifiers() {
        return this.getQualifierLookup().keySet();
    }

    public LinkedHashMap<Qualifier, HashSet<Annotation>> getQualifierLookup() {
        LinkedHashMap<Qualifier, HashSet<Annotation>> rtnLookup = new LinkedHashMap<Qualifier, HashSet<Annotation>>();
        Set<Qualifier> qSet = this.inheritedQualifierLookup.keySet();
        for (Qualifier q : qSet) {
            rtnLookup.put(q, (HashSet)this.inheritedQualifierLookup.get(q).clone());
        }
        qSet = this.addedQualifierLookup.keySet();
        for (Qualifier q : qSet) {
            HashSet<Annotation> annotSet = this.addedQualifierLookup.get(q);
            for (Annotation a : annotSet) {
                this.addQualifier(q, a, rtnLookup);
            }
        }
        qSet = this.removedQualifierLookup.keySet();
        Iterator<Qualifier> qIter = qSet.iterator();
        while (qIter.hasNext()) {
            this.removeQualifier(qIter.next(), rtnLookup);
        }
        return rtnLookup;
    }

    private void addQualifier(Qualifier q, Annotation a, LinkedHashMap<Qualifier, HashSet<Annotation>> lookup) {
        if (null == q || null == q.getText() || null == a || null == lookup) {
            return;
        }
        String qText = q.getText();
        HashSet<Annotation> associatedAnnot = null;
        Set<Qualifier> qSet = lookup.keySet();
        for (Qualifier curQ : qSet) {
            if (!qText.equals(curQ.getText())) continue;
            associatedAnnot = lookup.get(curQ);
            break;
        }
        if (null == associatedAnnot) {
            associatedAnnot = new HashSet<Annotation>();
            lookup.put(q, associatedAnnot);
        }
        associatedAnnot.add(a);
    }

    private void removeQualifier(Qualifier q, LinkedHashMap<Qualifier, HashSet<Annotation>> lookup) {
        if (null == q || null == q.getText() || null == lookup) {
            return;
        }
        String qText = q.getText();
        Set<Qualifier> qSet = lookup.keySet();
        Iterator<Qualifier> qIter = qSet.iterator();
        while (qIter.hasNext()) {
            Qualifier curQ = qIter.next();
            if (!qText.equals(curQ.getText())) continue;
            qIter.remove();
            break;
        }
    }

    public HashSet<WithEvidence> getWithEvidenceSet() {
        HashSet<WithEvidence> withEvSet = new HashSet<WithEvidence>();
        if (null != this.withEvidenceAnnotSet) {
            withEvSet.addAll(this.withEvidenceAnnotSet);
        }
        if (null != this.withEvidenceNodeSet) {
            withEvSet.addAll(this.withEvidenceNodeSet);
        }
        if (null != this.withEvidenceDBRefSet) {
            withEvSet.addAll(this.withEvidenceDBRefSet);
        }
        if (withEvSet.isEmpty()) {
            return null;
        }
        return withEvSet;
    }

    public Node getAnnotatedNode() {
        return this.annotatedNode;
    }

    public void setAnnotatedNode(Node annotatedNode) {
        this.annotatedNode = annotatedNode;
    }

    public LinkedHashMap<Qualifier, HashSet<Annotation>> getInheritedQualifierLookup() {
        return this.inheritedQualifierLookup;
    }

    public void setInheritedQualifierLookup(LinkedHashMap<Qualifier, HashSet<Annotation>> inheritedQualifierLookup) {
        this.inheritedQualifierLookup = inheritedQualifierLookup;
    }

    public void addToInheritedQualifierLookup(Qualifier q, Annotation a) {
        this.addQualifier(q, a, this.inheritedQualifierLookup);
    }

    public LinkedHashMap<Qualifier, HashSet<Annotation>> getAddedQualifierLookup() {
        return this.addedQualifierLookup;
    }

    public void setAddedQualifierLookup(LinkedHashMap<Qualifier, HashSet<Annotation>> addedQualifierLookup) {
        this.addedQualifierLookup = addedQualifierLookup;
    }

    public void addToAddedQualifierLookup(Qualifier q, Annotation a) {
        this.addQualifier(q, a, this.addedQualifierLookup);
    }

    public LinkedHashMap<Qualifier, HashSet<Annotation>> getRemovedQualifierLookup() {
        return this.removedQualifierLookup;
    }

    public void setRemovedQualifierLookup(LinkedHashMap<Qualifier, HashSet<Annotation>> removedQualifierLookup) {
        this.removedQualifierLookup = removedQualifierLookup;
    }

    public void addToRemovedQualifierLookup(Qualifier q, Annotation a) {
        this.addQualifier(q, a, this.removedQualifierLookup);
    }

    public boolean annotationHasNOTqualifier() {
        LinkedHashMap<Qualifier, HashSet<Annotation>> lookup = this.getQualifierLookup();
        Set<Qualifier> qSet = lookup.keySet();
        for (Qualifier q : qSet) {
            if (!q.isNot()) continue;
            return true;
        }
        return false;
    }

    protected Annotation removeWithAnnotation(Annotation with) {
        Annotation removedAnnot = null;
        if (null != this.withEvidenceAnnotSet) {
            Iterator<WithEvidence> weIter = this.withEvidenceAnnotSet.iterator();
            while (weIter.hasNext()) {
                Annotation a = (Annotation)weIter.next().getWith();
                if (with != a) continue;
                removedAnnot = a;
                weIter.remove();
            }
            if (this.withEvidenceAnnotSet.isEmpty()) {
                this.withEvidenceAnnotSet = null;
            }
        }
        if (null != this.removeWith(this.inheritedQualifierLookup, with)) {
            removedAnnot = with;
        }
        if (null != this.removeWith(this.addedQualifierLookup, with)) {
            removedAnnot = with;
        }
        if (null != this.removeWith(this.removedQualifierLookup, with)) {
            removedAnnot = with;
        }
        return removedAnnot;
    }

    private Annotation removeWith(LinkedHashMap<Qualifier, HashSet<Annotation>> lookup, Annotation with) {
        Annotation returnAnnot = null;
        Set<Qualifier> qSet = lookup.keySet();
        HashSet<Qualifier> removeSet = new HashSet<Qualifier>();
        for (Qualifier q : qSet) {
            HashSet<Annotation> associatedAnnotSet = lookup.get(q);
            if (!associatedAnnotSet.contains(with)) continue;
            associatedAnnotSet.remove(with);
            if (associatedAnnotSet.isEmpty()) {
                removeSet.add(q);
            }
            returnAnnot = with;
        }
        for (Qualifier q : removeSet) {
            lookup.remove(q);
        }
        return returnAnnot;
    }

    public HashSet<WithEvidence> getWithEvidenceAnnotSet() {
        return this.withEvidenceAnnotSet;
    }

    public void setWithEvidenceAnnotSet(HashSet<WithEvidence> withEvidenceAnnotSet) {
        this.withEvidenceAnnotSet = withEvidenceAnnotSet;
    }

    public HashSet<Annotation> getWithAnnotSet() {
        if (null == this.withEvidenceAnnotSet) {
            return null;
        }
        HashSet<Annotation> rtnSet = new HashSet<Annotation>();
        for (WithEvidence we : this.withEvidenceAnnotSet) {
            rtnSet.add((Annotation)we.getWith());
        }
        return rtnSet;
    }

    public HashSet<WithEvidence> getWithEvidenceNodeSet() {
        return this.withEvidenceNodeSet;
    }

    public void setWithEvidenceNodeSet(HashSet<WithEvidence> withEvidenceNodeSet) {
        this.withEvidenceNodeSet = withEvidenceNodeSet;
    }

    public HashSet<Node> getWithNodeSet() {
        if (null == this.withEvidenceNodeSet) {
            return null;
        }
        HashSet<Node> rtnSet = new HashSet<Node>();
        for (WithEvidence we : this.withEvidenceNodeSet) {
            rtnSet.add((Node)we.getWith());
        }
        return rtnSet;
    }

    public HashSet<WithEvidence> getWithEvidenceDBRefSet() {
        return this.withEvidenceDBRefSet;
    }

    public void setWithEvidenceDBRefSet(HashSet<WithEvidence> withEvidenceDBRefSet) {
        this.withEvidenceDBRefSet = withEvidenceDBRefSet;
    }

    public HashSet<DBReference> getWithOtherSet() {
        if (null == this.withEvidenceDBRefSet) {
            return null;
        }
        HashSet<DBReference> rtnSet = new HashSet<DBReference>();
        for (WithEvidence we : this.withEvidenceDBRefSet) {
            rtnSet.add((DBReference)we.getWith());
        }
        return rtnSet;
    }

    public HashSet<String> getEvidenceCodes() {
        HashSet<String> rtnCodes = new HashSet<String>();
        AnnotationDetail.addEvidenceCode(rtnCodes, this.withEvidenceAnnotSet);
        AnnotationDetail.addEvidenceCode(rtnCodes, this.withEvidenceNodeSet);
        AnnotationDetail.addEvidenceCode(rtnCodes, this.withEvidenceDBRefSet);
        return rtnCodes;
    }

    private static void addEvidenceCode(HashSet<String> codeSet, HashSet<WithEvidence> evdnceSet) {
        if (null == codeSet || null == evdnceSet) {
            return;
        }
        for (WithEvidence we : evdnceSet) {
            if (null == we.getEvidenceCode()) continue;
            codeSet.add(we.getEvidenceCode());
        }
    }
}

