/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paintCommon;

import edu.usc.ksom.pm.panther.paintCommon.AnnotQualifierGroup;
import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.AnnotationDetail;
import edu.usc.ksom.pm.panther.paintCommon.AnnotationNode;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeStaticInfo;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import edu.usc.ksom.pm.panther.paintCommon.Organism;
import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import edu.usc.ksom.pm.panther.paintCommon.QualifierDif;
import edu.usc.ksom.pm.panther.paintCommon.TaxonomyHelper;
import edu.usc.ksom.pm.panther.paintCommon.WithEvidence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;

public class AnnotationHelper
implements Serializable {
    public static final String KEY_RESIDUES_EC = "IKR";
    public static final String DIVERGENT_EC = "IRD";
    public static final String DESCENDANT_SEQUENCES_EC = "IBD";
    public static final String ANCESTRAL_EVIDENCE_CODE = "IBA";
    public static final String PAINT_REF = "PAINT_REF";
    public static final String TCV_MSG_PART_1 = "Info - Inserting TCV to prevent propagation of term ";
    public static final String TCV_MSG_PART_2 = " to node ";
    public static final String TCV_MSG_PART_3 = " with species ";
    public static final String TCV_MSG_PART_4 = ".\n";
    public static final String IBA_MSG_ANNOT_NEGATES_NOT_EXP_TO_TERM_PART_1 = "Info - IBA to term ";
    public static final String IBA_MSG_ANNOT_NEGATES_NOT_EXP_TO_TERM_PART_2 = " for node ";
    public static final String IBA_MSG_ANNOT_NEGATES_NOT_EXP_TO_TERM_PART_3 = " with species ";
    public static final String IBA_MSG_ANNOT_NEGATES_NOT_EXP_TO_TERM_PART_4 = " negates 'NOT' experimental evidence for term ";
    public static final String IBA_MSG_ANNOT_NEGATES_NOT_EXP_TO_TERM_PART_5 = ".\n";
    public static final String IBA_MSG_ANNOT_NEGATES_EXP_TO_TERM_PART_1 = "Info - IBA to term ";
    public static final String IBA_MSG_ANNOT_NEGATES_EXP_TO_TERM_PART_2 = " for node ";
    public static final String IBA_MSG_ANNOT_NEGATES_EXP_TO_TERM_PART_3 = " with species ";
    public static final String IBA_MSG_ANNOT_NEGATES_EXP_TO_TERM_PART_4 = " negates experimental evidence for term ";
    public static final String IBA_MSG_ANNOT_NEGATES_EXP_TO_TERM_PART_5 = ".\n";
    public static final String STR_COMMA = ",";
    public static final String MSG_INFO_POSSIBLE_TO_ANNOTATE__TO_DESCENDANT_PART_1 = "The following nodes:  ";
    public static final String MSG_INFO_POSSIBLE_TO_ANNOTATE__TO_DESCENDANT_PART_2 = " can be annotated with term ";
    public static final String MSG_INFO_POSSIBLE_TO_ANNOTATE__TO_DESCENDANT_PART_3 = " and qualifier ";
    public static final String MSG_INFO_POSSIBLE_TO_ANNOTATE__TO_DESCENDANT_PART_4 = ".\n";
    public static final String MSG_ERROR_NODE_VIOLATES_TAXONOMY_CONSTRAINT_1 = "Node ";
    public static final String MSG_ERROR_NODE_VIOLATES_TAXONOMY_CONSTRAINT_2 = " annotated to term ";
    public static final String MSG_ERROR_NODE_VIOLATES_TAXONOMY_CONSTRAINT_3 = " with species ";
    public static final String MSG_ERROR_NODE_VIOLATES_TAXONOMY_CONSTRAINT_4 = " violates taxonomy constraints.\n";
    public static final String ERROR_CDE_UNKNOWN_EVIDENCE_TYPE = "Unknown evidence type";
    public static final String ERROR_CDE_NO_ANNOTATION_DETAIL = "No annotation detail found";
    public static final String ERROR_CDE_INVALID_TERM = "Invalid term";
    public static final String ERROR_CDE_CANNOT_CREATE_IBD_USING_WITH = "Found invalid with annotation for IBD using with id ";
    public static final String ERROR_CDE_NO_WITH_FOUND = "No with found for annotation";
    public static final String ERROR_CDE_NO_IBD_PROP = "NO IBD propagator for IKR/IRD/TCV annotation";
    public static final String ERROR_CDE_IKR_IRD_TCV_ANNOT_QUALIFIER_NOT_OPPOSITE_IBD = "IKR/IRD/TCV annotation qualifier not opposite of IBD";
    public static final String ERROR_CDE_IBA_NO_PROPAGATOR = "No propagator for IBA";

    public static void allNonPrunedDescendents(AnnotationNode gNode, List<AnnotationNode> nodeList) {
        if (null == gNode || null == nodeList) {
            return;
        }
        Node n = gNode.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null != nvi && nvi.isPruned()) {
            return;
        }
        Vector children = gNode.getChildren();
        if (null == children) {
            return;
        }
        for (AnnotationNode child : children) {
            Node cn = child.getNode();
            NodeVariableInfo childNvi = cn.getVariableInfo();
            if (null != childNvi && childNvi.isPruned()) continue;
            nodeList.add(child);
            AnnotationHelper.allNonPrunedDescendents(child, nodeList);
        }
    }

    public static Annotation getSingleWithPropagatorAnnot(Annotation a) {
        HashSet<WithEvidence> withAnnotSet = a.getAnnotationDetail().getWithEvidenceAnnotSet();
        if (null == withAnnotSet || 1 != withAnnotSet.size()) {
            return null;
        }
        Iterator<WithEvidence> iterator = withAnnotSet.iterator();
        if (iterator.hasNext()) {
            WithEvidence we = iterator.next();
            return (Annotation)we.getWith();
        }
        return null;
    }

    public static boolean isIBAForIKRorIRD(Annotation ibaAnnot, Node node) {
        if (null == node) {
            return false;
        }
        Annotation ibaPropagator = AnnotationHelper.getSingleWithPropagatorAnnot(ibaAnnot);
        if (null == ibaPropagator) {
            return false;
        }
        NodeVariableInfo nvi = node.getVariableInfo();
        if (null == nvi) {
            return false;
        }
        ArrayList<Annotation> annotList = nvi.getGoAnnotationList();
        if (null == annotList) {
            return false;
        }
        for (Annotation a : annotList) {
            HashSet<Annotation> withAnnotSet;
            String code = a.getSingleEvidenceCodeFromSet();
            if (!KEY_RESIDUES_EC.equals(code) && !DIVERGENT_EC.equals(code) || null == (withAnnotSet = a.getAnnotationDetail().getWithAnnotSet())) continue;
            for (Annotation withAnnot : withAnnotSet) {
                if (ibaPropagator != withAnnot) continue;
                return true;
            }
        }
        return false;
    }

    public static Annotation getIBDpropagator(Annotation a) {
        HashSet<Annotation> withs = a.getAnnotationDetail().getWithAnnotSet();
        if (null == withs) {
            return null;
        }
        for (Annotation withAnnot : withs) {
            if (a == withAnnot || !DESCENDANT_SEQUENCES_EC.equals(withAnnot.getSingleEvidenceCodeFromSet())) continue;
            return withAnnot;
        }
        return null;
    }

    public static Annotation getPropagator(Annotation a) {
        HashSet<Annotation> withs = a.getAnnotationDetail().getWithAnnotSet();
        if (null == withs) {
            return null;
        }
        for (Annotation withAnnot : withs) {
            if (a == withAnnot) continue;
            return withAnnot;
        }
        return null;
    }

    public static Annotation getPropagatorAnnotForIBA(Annotation iba, Node n) {
        if (!ANCESTRAL_EVIDENCE_CODE.equals(iba.getSingleEvidenceCodeFromSet())) {
            return null;
        }
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            return null;
        }
        ArrayList<Annotation> annotList = nvi.getGoAnnotationList();
        if (null == annotList) {
            return null;
        }
        Annotation propagator = AnnotationHelper.getPropagator(iba);
        if (null == propagator) {
            return null;
        }
        for (Annotation a : annotList) {
            String code = a.getSingleEvidenceCodeFromSet();
            if (null == code || !KEY_RESIDUES_EC.equals(code) && !DIVERGENT_EC.equals(code) || propagator != AnnotationHelper.getPropagator(a)) continue;
            return a;
        }
        return null;
    }

    public String getPaintEvidenceAcc(String familyAcc) {
        int acc = Integer.valueOf(familyAcc.substring("PTHR".length()));
        String paint_id = String.format("%1$07d", acc);
        return paint_id;
    }

    public static boolean isQualifierSetValidForTerm(GOTerm term, Set<Qualifier> qSet, GOTermHelper gth) {
        if (null == term) {
            return false;
        }
        if (null == qSet) {
            return true;
        }
        for (Qualifier q : qSet) {
            if (gth.isQualifierValidForTerm(term, q)) continue;
            return false;
        }
        return true;
    }

    public static boolean canCreateIBDAnnotUsingWith(GOTerm toTerm, Set<Qualifier> toQualifierSet, Annotation withAnnot, GOTermHelper gth) {
        if (!withAnnot.isExperimental()) {
            return false;
        }
        GOTerm withTerm = gth.getTerm(withAnnot.getGoTerm());
        if (null == withTerm) {
            return false;
        }
        HashSet<Qualifier> withQualifierSet = withAnnot.getQualifierSet();
        if (null != toQualifierSet) {
            for (Qualifier q : toQualifierSet) {
                if (gth.isQualifierValidForTerm(toTerm, q)) continue;
                return false;
            }
        }
        if (null != withQualifierSet) {
            for (Qualifier q : withQualifierSet) {
                if (gth.isQualifierValidForTerm(withTerm, q)) continue;
                return false;
            }
        }
        if (toTerm.equals(withTerm) && QualifierDif.allQualifiersSame(toQualifierSet, withQualifierSet)) {
            return true;
        }
        boolean toIsNegative = false;
        boolean withIsNegative = false;
        if (null != toQualifierSet) {
            toIsNegative = QualifierDif.containsNegative(toQualifierSet);
        }
        if (null != withQualifierSet) {
            withIsNegative = QualifierDif.containsNegative(withQualifierSet);
        }
        if (toIsNegative != withIsNegative) {
            return false;
        }
        if (!toIsNegative) {
            if (!toTerm.equals(withTerm)) {
                ArrayList<GOTerm> withAncestors = gth.getAncestors(withTerm);
                if (!withAncestors.contains(toTerm)) {
                    return false;
                }
                if (null != toQualifierSet) {
                    for (Qualifier q : toQualifierSet) {
                        if (null != QualifierDif.find(withQualifierSet, q)) continue;
                        return false;
                    }
                }
            } else if (!QualifierDif.allQualifiersSame(toQualifierSet, withQualifierSet)) {
                return false;
            }
        } else if (!toTerm.equals(withTerm)) {
            ArrayList<GOTerm> toAncestors = gth.getAncestors(toTerm);
            if (!toAncestors.contains(toTerm)) {
                return false;
            }
            if (null != toQualifierSet) {
                for (Qualifier q : toQualifierSet) {
                    if (null != QualifierDif.find(withQualifierSet, q)) continue;
                    return false;
                }
            }
        } else if (!QualifierDif.allQualifiersSame(toQualifierSet, withQualifierSet)) {
            return false;
        }
        return true;
    }

    public static ArrayList<Annotation> getPossibleExperimentalAnnots(String term, Set<Qualifier> qSet, ArrayList<Node> leaves, GOTermHelper gth) {
        if (null == term || null == leaves) {
            return null;
        }
        GOTerm toTerm = gth.getTerm(term);
        ArrayList<Annotation> annots = new ArrayList<Annotation>();
        for (Node leaf : leaves) {
            ArrayList<Annotation> curAnnotList;
            NodeVariableInfo nvi = leaf.getVariableInfo();
            if (null == nvi || null == (curAnnotList = nvi.getGoAnnotationList())) continue;
            for (Annotation cur : curAnnotList) {
                if (!AnnotationHelper.canCreateIBDAnnotUsingWith(toTerm, qSet, cur, gth)) continue;
                annots.add(cur);
            }
        }
        if (annots.isEmpty()) {
            return annots;
        }
        Annotation temp = new Annotation();
        temp.setGoTerm(term);
        if (null != qSet) {
            temp.setQualifierSet(new HashSet<Qualifier>(qSet));
        }
        AnnotationDetail ad = temp.getAnnotationDetail();
        for (Annotation with : annots) {
            WithEvidence we = new WithEvidence();
            we.setEvidenceCode(DESCENDANT_SEQUENCES_EC);
            we.setEvidenceType("PAINT_EXP");
            we.setWith(with);
            we.setEvidenceId(with.getAnnotationId());
            ad.addWithEvidence(we);
        }
        return new ArrayList<Annotation>(ad.getWithAnnotSet());
    }

    public static String checkValidity(ArrayList<Annotation> annotList, GOTermHelper gth) {
        if (null == annotList) {
            return null;
        }
        for (Annotation a : annotList) {
            String err = AnnotationHelper.checkValidity(a, gth);
            if (null == err) continue;
            return err;
        }
        return null;
    }

    public static String checkValidity(Annotation a, GOTermHelper gth) {
        AnnotationDetail ad = a.getAnnotationDetail();
        String term = a.getGoTerm();
        if (null == term) {
            return ERROR_CDE_INVALID_TERM;
        }
        GOTerm goTerm = gth.getTerm(term);
        if (null == goTerm) {
            return ERROR_CDE_INVALID_TERM;
        }
        Set<Qualifier> qSet = ad.getQualifiers();
        String evCde = a.getSingleEvidenceCodeFromSet();
        if (DESCENDANT_SEQUENCES_EC.equals(evCde)) {
            if (null == ad) {
                return ERROR_CDE_NO_ANNOTATION_DETAIL;
            }
            HashSet<Annotation> withs = ad.getWithAnnotSet();
            if (null == withs || 0 == withs.size()) {
                return ERROR_CDE_NO_WITH_FOUND;
            }
            for (Annotation with : withs) {
                if (AnnotationHelper.canCreateIBDAnnotUsingWith(goTerm, qSet, with, gth)) continue;
                return ERROR_CDE_CANNOT_CREATE_IBD_USING_WITH + with.getAnnotationId();
            }
        } else if (KEY_RESIDUES_EC.equals(evCde) || DIVERGENT_EC.equals(evCde) || "TCV".equals(evCde)) {
            HashSet<Annotation> withs = ad.getWithAnnotSet();
            if (null == withs || 0 == withs.size()) {
                return ERROR_CDE_NO_WITH_FOUND;
            }
            Annotation IBDPropagator = AnnotationHelper.getIBDpropagator(a);
            if (null == IBDPropagator) {
                return ERROR_CDE_NO_IBD_PROP;
            }
            if (!QualifierDif.areOpposite(IBDPropagator.getQualifierSet(), qSet)) {
                return ERROR_CDE_IKR_IRD_TCV_ANNOT_QUALIFIER_NOT_OPPOSITE_IBD;
            }
        } else if (ANCESTRAL_EVIDENCE_CODE.equals(evCde)) {
            Annotation propagator = AnnotationHelper.getPropagator(a);
            if (null == propagator) {
                return ERROR_CDE_IBA_NO_PROPAGATOR;
            }
        } else {
            return ERROR_CDE_UNKNOWN_EVIDENCE_TYPE;
        }
        return null;
    }

    public static void propagateIBD(Annotation ibd, TaxonomyHelper taxonomyHelper, GOTermHelper goTermHelper, StringBuffer errorBuf, HashSet<Node> modifiedNodeSet, HashSet<Annotation> addedAnnotSet) {
        AnnotationDetail ad = ibd.getAnnotationDetail();
        Node annotNode = ad.getAnnotatedNode();
        HashSet<Annotation> annotWiths = ad.getWithAnnotSet();
        HashSet<Node> withNodeSet = new HashSet<Node>();
        for (Annotation with : annotWiths) {
            withNodeSet.add(with.getAnnotationDetail().getAnnotatedNode());
        }
        HashSet<Qualifier> qSet = ibd.getQualifierSet();
        ArrayList<Node> children = annotNode.getStaticInfo().getChildren();
        if (null != children) {
            for (Node child : children) {
                AnnotationHelper.propagateIBA(child, ibd.getGoTerm(), qSet, ibd, withNodeSet, taxonomyHelper, goTermHelper, errorBuf, modifiedNodeSet, addedAnnotSet);
            }
        }
    }

    public static void propagateIBA(Node n, String term, HashSet<Qualifier> qSet, Annotation with, HashSet<Node> withNodeSet, TaxonomyHelper taxonomyHelper, GOTermHelper goTermHelper, StringBuffer errorBuf, HashSet<Node> modifiedNodeSet, HashSet<Annotation> addedAnnotSet) {
        NodeStaticInfo nsi = n.getStaticInfo();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null != nvi && nvi.isPruned()) {
            return;
        }
        if (nvi != null && !AnnotationHelper.isIBABlockedViaIkrIrdTcv(with, term, qSet, nvi.getGoAnnotationList(), goTermHelper)) {
            System.out.println("Not propagating IBA for " + term + TCV_MSG_PART_2 + n.getStaticInfo().getPublicId() + " since it is blocked via IKR, IRD or TCV");
            return;
        }
        if ("PTN002597553".equals(nsi.getPublicId()) || "GO:0004568".equals(term)) {
            System.out.println("Here");
        }
        if (nvi != null && !AnnotationHelper.IBAValid(with, term, nvi.getGoAnnotationList())) {
            ArrayList<Node> children = nsi.getChildren();
            if (null != children) {
                for (Node child : children) {
                    AnnotationHelper.propagateIBA(child, term, qSet, with, withNodeSet, taxonomyHelper, goTermHelper, errorBuf, modifiedNodeSet, addedAnnotSet);
                }
            }
            return;
        }
        if (!taxonomyHelper.isTermAndQualifierValidForSpecies(term, nsi.getCalculatedSpecies(), qSet)) {
            errorBuf.insert(0, AnnotationHelper.generateTCVMsg(term, nsi.getPublicId(), nsi.getCalculatedSpecies()));
            HashSet<Qualifier> newSet = new HashSet<Qualifier>();
            if (null == qSet) {
                Qualifier notQualifier = new Qualifier();
                notQualifier.setText("NOT");
                newSet.add(notQualifier);
            } else {
                boolean containsNot = false;
                for (Qualifier q : qSet) {
                    if (q.isNot()) {
                        containsNot = true;
                        continue;
                    }
                    newSet.add(q);
                }
                if (!containsNot) {
                    Qualifier notQualifier = new Qualifier();
                    notQualifier.setText("NOT");
                    newSet.add(notQualifier);
                }
            }
            if (null == nvi) {
                nvi = new NodeVariableInfo();
                n.setVariableInfo(nvi);
            }
            Annotation newAnnot = new Annotation();
            nvi.addGOAnnotation(newAnnot);
            modifiedNodeSet.add(n);
            newAnnot.setGoTerm(term);
            newAnnot.setQualifierSet(newSet);
            AnnotationDetail newDetail = newAnnot.getAnnotationDetail();
            newDetail.setAnnotatedNode(n);
            WithEvidence propWithEv = new WithEvidence();
            propWithEv.setEvidenceCode("TCV");
            propWithEv.setEvidenceType("PAINT_ANCESTOR");
            propWithEv.setWith(with);
            newDetail.addWithEvidence(propWithEv);
            WithEvidence newAnnotWithEv = new WithEvidence();
            newAnnotWithEv.setEvidenceCode("TCV");
            newAnnotWithEv.setEvidenceType("PAINT_ANCESTOR");
            newAnnotWithEv.setWith(newAnnot);
            newDetail.addWithEvidence(newAnnotWithEv);
            if (null != qSet) {
                for (Qualifier q : qSet) {
                    newDetail.addToInheritedQualifierLookup(q, with);
                }
            }
            if (QualifierDif.containsNegative(newSet)) {
                newDetail.addToAddedQualifierLookup(QualifierDif.getNOT(newSet), newAnnot);
            } else {
                newDetail.addToRemovedQualifierLookup(QualifierDif.getNOT(qSet), newAnnot);
            }
            addedAnnotSet.add(newAnnot);
            return;
        }
        if (nsi.isLeaf() && null != nvi && null != nvi.getGoAnnotationList()) {
            ArrayList<Annotation> annots = nvi.getGoAnnotationList();
            boolean negAnnot = QualifierDif.containsNegative(qSet);
            GOTerm gTerm = goTermHelper.getTerm(term);
            ArrayList<GOTerm> ancestors = goTermHelper.getAncestors(gTerm);
            if (!negAnnot) {
                for (Annotation a : annots) {
                    if (!a.isExperimental() || !QualifierDif.containsNegative(a.getQualifierSet()) || !term.equals(a.getGoTerm()) && !ancestors.contains(goTermHelper.getTerm(a.getGoTerm()))) continue;
                    errorBuf.insert(0, AnnotationHelper.generateIBANegMsg(term, nsi.getPublicId(), nsi.getCalculatedSpecies(), a.getGoTerm()));
                }
            } else {
                for (Annotation a : annots) {
                    if (!a.isExperimental() || QualifierDif.containsNegative(a.getQualifierSet())) continue;
                    ArrayList<GOTerm> curAncestors = goTermHelper.getAncestors(goTermHelper.getTerm(a.getGoTerm()));
                    if (!term.equals(a.getGoTerm()) && !curAncestors.contains(gTerm)) continue;
                    errorBuf.insert(0, AnnotationHelper.generateIBAMsg(term, nsi.getPublicId(), nsi.getCalculatedSpecies(), a.getGoTerm()));
                }
            }
        }
        if (null == nvi) {
            nvi = new NodeVariableInfo();
            n.setVariableInfo(nvi);
        }
        Annotation newAnnot = new Annotation();
        nvi.addGOAnnotation(newAnnot);
        modifiedNodeSet.add(n);
        newAnnot.setGoTerm(term);
        AnnotationDetail newDetail = newAnnot.getAnnotationDetail();
        newDetail.setAnnotatedNode(n);
        WithEvidence we = new WithEvidence();
        we.setEvidenceType("PAINT_ANCESTOR");
        we.setEvidenceCode(ANCESTRAL_EVIDENCE_CODE);
        we.setWith(with);
        newAnnot.addWithEvidence(we);
        LinkedHashMap<Qualifier, HashSet<Annotation>> qualifierLookup = with.getAnnotationDetail().getQualifierLookup();
        for (Qualifier q : qualifierLookup.keySet()) {
            Qualifier newQ = new Qualifier();
            newQ.setText(q.getText());
            newDetail.addToInheritedQualifierLookup(newQ, with);
            newAnnot.addQualifier(newQ);
        }
        ArrayList<Node> children = nsi.getChildren();
        if (null != children) {
            for (Node child : children) {
                AnnotationHelper.propagateIBA(child, term, qSet, with, withNodeSet, taxonomyHelper, goTermHelper, errorBuf, modifiedNodeSet, addedAnnotSet);
            }
        }
    }

    public static String generateTCVMsg(String term, String publicId, String species) {
        return TCV_MSG_PART_1 + term + TCV_MSG_PART_2 + publicId + " with species " + species + ".\n";
    }

    public static String generateIBANegMsg(String ibaTerm, String publicId, String species, String term) {
        return "Info - IBA to term " + ibaTerm + " for node " + publicId + " with species " + species + IBA_MSG_ANNOT_NEGATES_NOT_EXP_TO_TERM_PART_4 + term + ".\n";
    }

    public static String generateIBAMsg(String ibaTerm, String publicId, String species, String term) {
        return "Info - IBA to term " + ibaTerm + " for node " + publicId + " with species " + species + IBA_MSG_ANNOT_NEGATES_EXP_TO_TERM_PART_4 + term + ".\n";
    }

    public static boolean IBDPossibleForNode(String term, Node node, TaxonomyHelper taxonomyHelper, GOTermHelper goTermHelper) {
        HashSet<String> errorMsgSet = new HashSet<String>();
        ArrayList<Node> nodeList = Node.getAllNonPrunedLeaves(node);
        for (Node leaf : nodeList) {
            ArrayList<Annotation> leafAnnots;
            NodeVariableInfo nvi = leaf.getVariableInfo();
            if (null == nvi || null == (leafAnnots = nvi.getGoAnnotationList())) continue;
            for (Annotation leafAnnot : leafAnnots) {
                HashSet<Annotation> possibleWiths = new HashSet<Annotation>();
                String errorMsg = AnnotationHelper.canNodeBeAnnotatedWithIBD(term, leafAnnot.getQualifierSet(), node, possibleWiths, taxonomyHelper, goTermHelper, false);
                if (null != errorMsg) {
                    errorMsgSet.add(errorMsg);
                    continue;
                }
                if (possibleWiths.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static AnnotQualifierGroup possibleToAnnotateWithIBD(String term, Node node, StringBuffer errorMsgBuf, TaxonomyHelper taxonomyHelper, GOTermHelper goTermHelper) {
        HashSet<Annotation> expWiths = new HashSet<Annotation>();
        HashSet<String> errorMsgSet = new HashSet<String>();
        ArrayList<Node> nodeList = Node.getAllNonPrunedLeaves(node);
        for (Node leaf : nodeList) {
            ArrayList<Annotation> leafAnnots;
            NodeVariableInfo nvi = leaf.getVariableInfo();
            if (null == nvi || null == (leafAnnots = nvi.getGoAnnotationList())) continue;
            for (Annotation leafAnnot : leafAnnots) {
                HashSet<Annotation> possibleWiths = new HashSet<Annotation>();
                String errorMsg = AnnotationHelper.canNodeBeAnnotatedWithIBD(term, leafAnnot.getQualifierSet(), node, possibleWiths, taxonomyHelper, goTermHelper, false);
                if (null != errorMsg) {
                    errorMsgSet.add(errorMsg);
                    continue;
                }
                expWiths.addAll(possibleWiths);
            }
        }
        if (!expWiths.isEmpty()) {
            return new AnnotQualifierGroup(expWiths);
        }
        for (String err : errorMsgSet) {
            errorMsgBuf.append(err);
        }
        return null;
    }

    public static String existingAnnotsAllowNewAnnotation(Set<Qualifier> qSet, String term, Node node, GOTermHelper goTermHelper) {
        List<Node> ancestors;
        boolean negQualifier = QualifierDif.containsNegative(qSet);
        GOTerm cur = goTermHelper.getTerm(term);
        if (null != node.getVariableInfo() && null != node.getVariableInfo().getGoAnnotationList()) {
            ArrayList<Annotation> curAnnotList = node.getVariableInfo().getGoAnnotationList();
            for (Annotation a : curAnnotList) {
                GOTerm existingGo;
                ArrayList<GOTerm> ancestors2;
                String existing = a.getGoTerm();
                if (term.equals(existing)) {
                    return " to " + node.getStaticInfo().getPublicId() + " for annotation to term " + term + " not allowed, since node is already annotated to the term.\n";
                }
                if (negQualifier || !(ancestors2 = goTermHelper.getAncestors(existingGo = goTermHelper.getTerm(existing))).contains(cur)) continue;
                return " to " + node.getStaticInfo().getPublicId() + " for annotation to term " + term + " not allowed, since node is already annotated to more specific term " + existing + ".\n";
            }
        }
        if (!negQualifier && null != (ancestors = Node.getAncestors(node))) {
            for (Node ancestor : ancestors) {
                if (null == ancestor.getVariableInfo() || null == ancestor.getVariableInfo().getGoAnnotationList()) continue;
                ArrayList<Annotation> ancesAnnotList = ancestor.getVariableInfo().getGoAnnotationList();
                for (Annotation a : ancesAnnotList) {
                    GOTerm existingGo;
                    ArrayList<GOTerm> ancestorAnnots;
                    if (QualifierDif.containsNegative(a.getQualifierSet()) || !(ancestorAnnots = goTermHelper.getAncestors(existingGo = goTermHelper.getTerm(a.getGoTerm()))).contains(cur)) continue;
                    return "IBD to " + node.getStaticInfo().getPublicId() + " for annotation to term " + term + " not allowed, since ancestor node " + ancestor.getStaticInfo().getPublicId() + " is already annotated to more specific term " + a.getGoTerm() + ".\n";
                }
            }
        }
        return null;
    }

    public static String canNodeBeAnnotatedWithIBD(String term, Set<Qualifier> qSet, Node node, HashSet<Annotation> expWiths, TaxonomyHelper taxonomyHelper, GOTermHelper goTermHelper, boolean checkDescendants) {
        Node copy = node;
        if (AnnotationHelper.inPrunedBranch(copy)) {
            return "IBD not allowed to node " + node.getStaticInfo().getPublicId() + " in pruned branch.\n";
        }
        if (node.getStaticInfo().isLeaf()) {
            return "IBD not allowed to leaf node " + node.getStaticInfo().getPublicId() + ".\n";
        }
        if (!taxonomyHelper.isTermAndQualifierValidForSpecies(term, node.getStaticInfo().getCalculatedSpecies(), qSet)) {
            String errMsg = "IBD to " + node.getStaticInfo().getPublicId() + " for annotation to term " + term + " for species " + node.getStaticInfo().getCalculatedSpecies() + MSG_ERROR_NODE_VIOLATES_TAXONOMY_CONSTRAINT_4;
            return errMsg;
        }
        String checkExisting = AnnotationHelper.existingAnnotsAllowNewAnnotation(qSet, term, node, goTermHelper);
        if (null != checkExisting) {
            return DESCENDANT_SEQUENCES_EC + checkExisting;
        }
        ArrayList<Node> leaves = Node.getAllNonPrunedLeaves(node);
        ArrayList<Annotation> withs = AnnotationHelper.getPossibleExperimentalAnnots(term, qSet, leaves, goTermHelper);
        if (null == withs || withs.isEmpty()) {
            return "IBD to " + node.getStaticInfo().getPublicId() + " for annotation to term " + term + " does not have associated experimental evidence.\n";
        }
        for (Annotation with : withs) {
            expWiths.add(with);
        }
        return null;
    }

    public static boolean inPrunedBranch(Node node) {
        if (node.getVariableInfo() != null && node.getVariableInfo().isPruned()) {
            return true;
        }
        Node parent = node.getStaticInfo().getParent();
        if (null == parent) {
            return false;
        }
        return AnnotationHelper.inPrunedBranch(parent);
    }

    public static void getIBAWithSameTermForNode(Node n, Annotation propagator, HashSet<Annotation> annotSet, String term) {
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null != nvi) {
            if (nvi.isPruned()) {
                return;
            }
            ArrayList<Annotation> annotList = nvi.getGoAnnotationList();
            if (null != annotList) {
                for (Annotation a : annotList) {
                    HashSet<Annotation> withSet;
                    if (!ANCESTRAL_EVIDENCE_CODE.equals(a.getSingleEvidenceCodeFromSet()) || null == a.getGoTerm() || !a.getGoTerm().equals(term) || null == (withSet = a.getAnnotationDetail().getWithAnnotSet()) || !withSet.contains(propagator)) continue;
                    annotSet.add(a);
                }
            }
        }
        if (null == annotSet) {
            System.out.println("Missing IBA from propagator for node");
        }
    }

    public static void removeAnnotFromNodeAndDescendants(Node n, Annotation remove, String term, StringBuffer errorBuf) {
        ArrayList<Node> children;
        NodeStaticInfo nsi;
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null != nvi) {
            if (nvi.isPruned()) {
                return;
            }
            ArrayList<Annotation> annotList = nvi.getGoAnnotationList();
            if (null != annotList) {
                boolean negAnnot = QualifierDif.containsNegative(remove.getQualifierSet());
                NodeStaticInfo nsi2 = n.getStaticInfo();
                HashSet<Annotation> removeSet = new HashSet<Annotation>();
                for (Annotation a : annotList) {
                    int index;
                    HashSet<Annotation> withSet;
                    if (null == a.getGoTerm() || !a.getGoTerm().equals(term) || null == (withSet = a.getAnnotationDetail().getWithAnnotSet()) || !withSet.contains(remove)) continue;
                    removeSet.add(a);
                    if (!ANCESTRAL_EVIDENCE_CODE.equals(a.getSingleEvidenceCodeFromSet())) continue;
                    String msg = AnnotationHelper.generateIBAMsg(term, nsi2.getPublicId(), nsi2.getCalculatedSpecies(), a.getGoTerm());
                    if (!negAnnot) {
                        msg = AnnotationHelper.generateIBANegMsg(term, nsi2.getPublicId(), nsi2.getCalculatedSpecies(), a.getGoTerm());
                    }
                    if ((index = errorBuf.indexOf(msg)) < 0) continue;
                    errorBuf.delete(index, index + msg.length());
                }
                annotList.removeAll(removeSet);
                if (annotList.isEmpty()) {
                    nvi.setGoAnnotationList(null);
                }
            }
        }
        if (null != (nsi = n.getStaticInfo()) && null != (children = nsi.getChildren())) {
            for (Node child : children) {
                AnnotationHelper.removeAnnotFromNodeAndDescendants(child, remove, term, errorBuf);
            }
        }
    }

    public static Annotation getIKRIRDTCVforPropagator(Node n, Annotation propagator) {
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            return null;
        }
        ArrayList<Annotation> annotList = nvi.getGoAnnotationList();
        if (null == annotList) {
            return null;
        }
        for (Annotation a : annotList) {
            HashSet<Annotation> withSet;
            String evCode = a.getSingleEvidenceCodeFromSet();
            if (!KEY_RESIDUES_EC.equals(evCode) && !DIVERGENT_EC.equals(evCode) && !"TCV".equals(evCode) || null == (withSet = a.getAnnotationDetail().getWithAnnotSet()) || !withSet.contains(propagator) || !QualifierDif.differenceIsNOTQualifier(a.getQualifierSet(), propagator.getQualifierSet())) continue;
            return a;
        }
        return null;
    }

    public static Annotation getAssociatedIBAForIKRorIRD(Annotation IKRorIRDAnnotation, Node n) {
        String code = IKRorIRDAnnotation.getSingleEvidenceCodeFromSet();
        if (!DIVERGENT_EC.equals(code) && !KEY_RESIDUES_EC.equals(code)) {
            System.out.println("Call to get associated IBA for non IKR or IRD");
            return null;
        }
        Annotation with = null;
        HashSet<Annotation> ikrIrdwithSet = IKRorIRDAnnotation.getAnnotationDetail().getWithAnnotSet();
        if (null == ikrIrdwithSet) {
            return null;
        }
        for (Annotation iw : ikrIrdwithSet) {
            HashSet<Annotation> withSet = iw.getAnnotationDetail().getWithAnnotSet();
            if (null == withSet || iw == IKRorIRDAnnotation) continue;
            with = iw;
            break;
        }
        if (null == with) {
            return null;
        }
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            return null;
        }
        ArrayList<Annotation> annotList = nvi.getGoAnnotationList();
        if (null == annotList) {
            return null;
        }
        for (Annotation a : annotList) {
            if (!ANCESTRAL_EVIDENCE_CODE.equals(a.getSingleEvidenceCodeFromSet()) || !a.getAnnotationDetail().getWithAnnotSet().contains(with)) continue;
            return a;
        }
        return null;
    }

    public static boolean isDirectAnnotation(Annotation a) {
        String code = a.getSingleEvidenceCodeFromSet();
        if (DESCENDANT_SEQUENCES_EC.equals(code) || DIVERGENT_EC.equals(code) || "TCV".equals(code)) {
            return true;
        }
        if (KEY_RESIDUES_EC.equals(code)) {
            HashSet<Annotation> withAnnotSet;
            AnnotationDetail ad = a.getAnnotationDetail();
            if (null != ad && null != (withAnnotSet = ad.getWithAnnotSet()) && withAnnotSet.contains(a)) {
                for (Annotation with : withAnnotSet) {
                    if (!DESCENDANT_SEQUENCES_EC.equals(with.getSingleEvidenceCodeFromSet())) continue;
                    return true;
                }
            }
            return false;
        }
        if (ANCESTRAL_EVIDENCE_CODE.equals(code)) {
            return AnnotationHelper.isIBAForIKRorIRD(a, a.getAnnotationDetail().getAnnotatedNode());
        }
        return false;
    }

    private static boolean isIBABlockedViaIkrIrdTcv(Annotation with, String term, HashSet<Qualifier> qSet, ArrayList<Annotation> goAnnotList, GOTermHelper goTermHelper) {
        if (null == goAnnotList) {
            return true;
        }
        for (Annotation a : goAnnotList) {
            ArrayList<GOTerm> ancestors;
            HashSet<Annotation> withSet;
            String code = a.getSingleEvidenceCodeFromSet();
            if (!KEY_RESIDUES_EC.equals(code) && !DIVERGENT_EC.equals(code) && !"TCV".equals(code) || null == (withSet = a.getAnnotationDetail().getWithAnnotSet()) || !withSet.contains(with) || (KEY_RESIDUES_EC.equals(code) || DIVERGENT_EC.equals(code)) && !QualifierDif.containsNegative(qSet) && null != (ancestors = goTermHelper.getAncestors(goTermHelper.getTerm(a.getGoTerm()))) && ancestors.contains(goTermHelper.getTerm(term))) continue;
            System.out.println("IBA not valid since there already exists annotation to " + a.getGoTerm() + " with " + a.getSingleEvidenceCodeFromSet());
            return false;
        }
        return true;
    }

    private static boolean IBAValid(Annotation with, String term, ArrayList<Annotation> goAnnotList) {
        if (null == goAnnotList) {
            return true;
        }
        for (Annotation a : goAnnotList) {
            HashSet<Annotation> withSet;
            String code = a.getSingleEvidenceCodeFromSet();
            if (!ANCESTRAL_EVIDENCE_CODE.equals(code) || null == (withSet = a.getAnnotationDetail().getWithAnnotSet()) || !withSet.contains(with)) continue;
            System.out.println("IBA to " + term + " not valid since there already exists annotation to " + a.getGoTerm() + " with " + a.getSingleEvidenceCodeFromSet());
            return false;
        }
        return true;
    }

    public static void fixNodesProvidingEvdnceForIKRIRD(Annotation ikrIrd, Node node, GOTermHelper goTermHelper, HashSet<String> modifiedAnnotSet, StringBuffer errorBuf) {
        ArrayList<Node> leaves = Node.getAllNonPrunedLeaves(node);
        AnnotationDetail ad = ikrIrd.getAnnotationDetail();
        HashSet<Node> origWithSet = ad.getWithNodeSet();
        ArrayList<Annotation> withs = AnnotationHelper.getPossibleExperimentalAnnots(ikrIrd.getGoTerm(), ikrIrd.getQualifierSet(), leaves, goTermHelper);
        if (null == withs || withs.isEmpty()) {
            ad.setWithEvidenceNodeSet(null);
        } else {
            HashSet<Node> includeSet = new HashSet<Node>();
            for (Annotation with : withs) {
                includeSet.add(with.getAnnotationDetail().getAnnotatedNode());
            }
            HashSet<WithEvidence> removeEvSet = new HashSet<WithEvidence>();
            if (null != origWithSet) {
                for (WithEvidence we : ad.getWithEvidenceNodeSet()) {
                    Node with = (Node)we.getWith();
                    if (!leaves.contains(with)) {
                        errorBuf.insert(0, ikrIrd.getSingleEvidenceCodeFromSet() + " for term " + ikrIrd.getGoTerm() + " to " + node.getStaticInfo().getPublicId() + " contains invalid node " + with.getStaticInfo().getPublicId() + " as evidence.\n");
                        removeEvSet.add(we);
                        continue;
                    }
                    includeSet.remove(with);
                }
            }
            for (Node include : includeSet) {
                WithEvidence we = new WithEvidence();
                we.setEvidenceCode(ikrIrd.getSingleEvidenceCodeFromSet());
                we.setEvidenceType(PAINT_REF);
                we.setWith(include);
                ad.addWithEvidence(we);
            }
        }
        HashSet<Node> newNodeSet = ad.getWithNodeSet();
        if (null != origWithSet && null != newNodeSet) {
            if (!origWithSet.equals(newNodeSet)) {
                modifiedAnnotSet.add(ikrIrd.getAnnotationId());
                errorBuf.insert(0, ikrIrd.getSingleEvidenceCodeFromSet() + " for term " + ikrIrd.getGoTerm() + " to " + node.getStaticInfo().getPublicId() + " - Modified list of nodes  providing evidence.\n");
            }
        } else if (null != origWithSet && null == newNodeSet || null == origWithSet && null != newNodeSet) {
            modifiedAnnotSet.add(ikrIrd.getAnnotationId());
            errorBuf.insert(0, String.join((CharSequence)STR_COMMA, ikrIrd.getEvidenceCodeSet()) + " for term " + ikrIrd.getGoTerm() + " to " + node.getStaticInfo().getPublicId() + " - Modified list of nodes  providing evidence.\n");
        }
    }

    public static void fixAnnotationsForGraftPruneExpOperation(Node n, Node graftPruneNode, TaxonomyHelper taxonHelper, GOTermHelper gth) {
        ArrayList<Annotation> annotList;
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null != nvi && null != (annotList = nvi.getGoAnnotationList())) {
            ArrayList annotCopy = (ArrayList)annotList.clone();
            for (Annotation a : annotCopy) {
                if (DESCENDANT_SEQUENCES_EC.equals(a.getSingleEvidenceCodeFromSet())) {
                    String term = a.getGoTerm();
                    HashSet<Qualifier> qSet = a.getQualifierSet();
                    ArrayList<Node> curLeaves = Node.getAllNonPrunedLeaves(n);
                    ArrayList<Annotation> newWiths = AnnotationHelper.getPossibleExperimentalAnnots(term, qSet, curLeaves, gth);
                    if (newWiths.isEmpty()) {
                        AnnotationHelper.deleteAnnotation(a, taxonHelper, gth);
                        continue;
                    }
                    AnnotationDetail ad = a.getAnnotationDetail();
                    ad.setWithEvidenceAnnotSet(null);
                    ad.getInheritedQualifierLookup().clear();
                    for (Annotation annotation : newWiths) {
                        WithEvidence we = new WithEvidence();
                        we.setEvidenceCode(DESCENDANT_SEQUENCES_EC);
                        we.setEvidenceType("PAINT_EXP");
                        we.setWith(annotation);
                        a.getAnnotationDetail().addWithEvidence(we);
                        if (null == qSet || null == annotation.getQualifierSet() || !QualifierDif.contains(qSet, annotation.getQualifierSet())) continue;
                        for (Qualifier q : annotation.getQualifierSet()) {
                            a.getAnnotationDetail().addToInheritedQualifierLookup(q, annotation);
                        }
                    }
                    AnnotationHelper.propagateIBD(a, taxonHelper, gth, new StringBuffer(), new HashSet<Node>(), new HashSet<Annotation>());
                    continue;
                }
                if (KEY_RESIDUES_EC.equals(a.getSingleEvidenceCodeFromSet())) {
                    HashSet<WithEvidence> withAnnotSet = a.getAnnotationDetail().getWithEvidenceAnnotSet();
                    if (null == withAnnotSet || 0 == withAnnotSet.size()) continue;
                    Annotation ibdPropagator = AnnotationHelper.getIBDpropagator(a);
                    AnnotationDetail ibdDetail = ibdPropagator.getAnnotationDetail();
                    HashSet<Annotation> withSet = ibdDetail.getWithAnnotSet();
                    HashSet evidenceNodes = new HashSet();
                    for (Annotation annotation : withSet) {
                        evidenceNodes.add(annotation.getAnnotationDetail().getAnnotatedNode());
                    }
                    ArrayList<Node> children = n.getStaticInfo().getChildren();
                    if (null != children) {
                        for (Node child : children) {
                            AnnotationHelper.propagateIBA(child, a.getGoTerm(), a.getQualifierSet(), a, evidenceNodes, taxonHelper, gth, new StringBuffer(), new HashSet<Node>(), new HashSet<Annotation>());
                        }
                    }
                    AnnotationHelper.fixNodesProvidingEvdnceForIKRIRD(a, n, gth, new HashSet<String>(), new StringBuffer());
                    continue;
                }
                if (DIVERGENT_EC.equals(a.getSingleEvidenceCodeFromSet())) {
                    AnnotationHelper.fixNodesProvidingEvdnceForIKRIRD(a, n, gth, new HashSet<String>(), new StringBuffer());
                    continue;
                }
                if (!ANCESTRAL_EVIDENCE_CODE.equals(a.getSingleEvidenceCodeFromSet()) || !AnnotationHelper.isDirectAnnotation(a)) continue;
                Annotation ibdPropagator = AnnotationHelper.getIBDpropagator(a);
                AnnotationDetail ibdDetail = ibdPropagator.getAnnotationDetail();
                HashSet<Annotation> withSet = ibdDetail.getWithAnnotSet();
                HashSet<Node> evidenceNodes = new HashSet<Node>();
                for (Annotation with : withSet) {
                    evidenceNodes.add(with.getAnnotationDetail().getAnnotatedNode());
                }
                ArrayList<Node> children = n.getStaticInfo().getChildren();
                if (null == children) continue;
                for (Node node : children) {
                    AnnotationHelper.propagateIBA(node, a.getGoTerm(), a.getQualifierSet(), ibdPropagator, evidenceNodes, taxonHelper, gth, new StringBuffer(), new HashSet<Node>(), new HashSet<Annotation>());
                }
            }
        }
        if (n == graftPruneNode) {
            return;
        }
        ArrayList<Node> children = n.getStaticInfo().getChildren();
        if (null != children) {
            for (Node child : children) {
                AnnotationHelper.fixAnnotationsForGraftPruneExpOperation(child, graftPruneNode, taxonHelper, gth);
            }
        }
    }

    public static void deletePropagatedIBA(Annotation iba, TaxonomyHelper taxonHelper, GOTermHelper gth) {
        Node n = iba.getAnnotationDetail().getAnnotatedNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null != nvi && !nvi.isPruned()) {
            Annotation propagator = AnnotationHelper.getPropagator(iba);
            ArrayList<Annotation> goAnnotList = nvi.getGoAnnotationList();
            if (null == goAnnotList || !goAnnotList.contains(iba)) {
                return;
            }
            AnnotationHelper.deleteAnnotation(iba, n);
            NodeStaticInfo nsi = n.getStaticInfo();
            ArrayList<Node> children = nsi.getChildren();
            if (null != children) {
                for (Node child : children) {
                    ArrayList<Annotation> childAnnotList;
                    NodeVariableInfo childNvi = child.getVariableInfo();
                    if (null == childNvi || nvi.isPruned() || null == (childAnnotList = childNvi.getGoAnnotationList())) continue;
                    ArrayList<Annotation> deleteDirect = new ArrayList<Annotation>();
                    ArrayList<Annotation> deleteIba = new ArrayList<Annotation>();
                    for (Annotation childAnnot : childAnnotList) {
                        Annotation childProp = AnnotationHelper.getPropagator(childAnnot);
                        boolean isDirect = AnnotationHelper.isDirectAnnotation(childAnnot);
                        if (childProp == propagator && isDirect) {
                            deleteDirect.add(childAnnot);
                            continue;
                        }
                        if (!ANCESTRAL_EVIDENCE_CODE.equals(childAnnot.getSingleEvidenceCodeFromSet()) || childProp != propagator || isDirect || !iba.getGoTerm().equals(childAnnot.getGoTerm())) continue;
                        deleteIba.add(childAnnot);
                    }
                    for (Annotation delete : deleteIba) {
                        AnnotationHelper.deletePropagatedIBA(delete, taxonHelper, gth);
                    }
                    for (Annotation delete : deleteDirect) {
                        AnnotationHelper.deleteAnnotation(delete, taxonHelper, gth);
                    }
                }
            }
        }
    }

    public static void deleteAnnotationAndRepropagate(Annotation a, TaxonomyHelper taxonHelper, GOTermHelper gth) {
        Annotation propAnnot = AnnotationHelper.getPropagator(a);
        AnnotationHelper.deleteAnnotation(a, taxonHelper, gth);
        if (!DESCENDANT_SEQUENCES_EC.equals(a.getSingleEvidenceCodeFromSet())) {
            Node n = a.getAnnotationDetail().getAnnotatedNode();
            Node propNode = propAnnot.getAnnotationDetail().getAnnotatedNode();
            AnnotationHelper.fixAnnotationsForGraftPruneExpOperation(propNode, n, taxonHelper, gth);
        }
    }

    private static void deleteAnnotation(Annotation a, TaxonomyHelper taxonHelper, GOTermHelper gth) {
        System.out.println("Attempting to remove " + a.getSingleEvidenceCodeFromSet() + " to term " + a.getGoTerm() + " from " + a.getAnnotationDetail().getAnnotatedNode().getStaticInfo().getPublicId());
        Node n = a.getAnnotationDetail().getAnnotatedNode();
        String code = a.getSingleEvidenceCodeFromSet();
        if (DESCENDANT_SEQUENCES_EC.equals(code)) {
            ArrayList<Annotation> directDepAnnotSet = AnnotationHelper.getDirectDependantAnnots(a, n);
            for (Annotation dep : directDepAnnotSet) {
                AnnotationHelper.deleteAnnotation(dep, taxonHelper, gth);
            }
            AnnotationHelper.deletePropagatorFromAll(a, a.getGoTerm(), n);
            AnnotationHelper.deleteAnnotation(a, n);
        } else if (KEY_RESIDUES_EC.equals(code)) {
            ArrayList<Annotation> directDepAnnotSet = AnnotationHelper.getDirectDependantAnnots(a, n);
            for (Annotation dep : directDepAnnotSet) {
                AnnotationHelper.deleteAnnotation(dep, taxonHelper, gth);
            }
            AnnotationHelper.deletePropagatorFromAll(a, a.getGoTerm(), n);
            AnnotationHelper.deleteAnnotation(a, n);
        } else if (DIVERGENT_EC.equals(code)) {
            ArrayList<Annotation> directDepAnnotSet = AnnotationHelper.getDirectDependantAnnots(a, n);
            for (Annotation dep : directDepAnnotSet) {
                AnnotationHelper.deleteAnnotation(dep, taxonHelper, gth);
            }
            AnnotationHelper.deleteAnnotation(a, n);
        } else if ("TCV".equals(code)) {
            AnnotationHelper.deleteAnnotation(a, n);
        } else if (ANCESTRAL_EVIDENCE_CODE.equals(code) && AnnotationHelper.isDirectAnnotation(a)) {
            Annotation propAnnot = AnnotationHelper.getPropagator(a);
            ArrayList<Annotation> directDepAnnotSet = AnnotationHelper.getDirectDependantAnnots(a, n);
            for (Annotation dep : directDepAnnotSet) {
                AnnotationHelper.deleteAnnotation(dep, taxonHelper, gth);
            }
            AnnotationHelper.deletePropagatorFromAll(propAnnot, a.getGoTerm(), n);
            AnnotationHelper.deleteAnnotation(a, n);
        } else {
            System.out.println("Unable to handle delete of " + code + TCV_MSG_PART_2 + n.getStaticInfo().getPublicId());
            return;
        }
    }

    public static ArrayList<Annotation> getDirectDependantAnnots(Annotation propagator, Node n) {
        NodeStaticInfo nsi;
        ArrayList<Node> children;
        ArrayList<Annotation> directDepAnnots = new ArrayList<Annotation>();
        String code = propagator.getSingleEvidenceCodeFromSet();
        System.out.println("Getting direct dependant annots for " + n.getStaticInfo().getPublicId() + " with code " + code + " for term " + propagator.getGoTerm());
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null != nvi && null != nvi.getGoAnnotationList() && !nvi.isPruned()) {
            ArrayList<Annotation> annotList = nvi.getGoAnnotationList();
            for (Annotation annot : annotList) {
                Annotation ibdPropagator;
                Annotation ikrIrdTcv;
                HashSet<Annotation> withSet;
                if (!AnnotationHelper.isDirectAnnotation(annot)) continue;
                String annotCode = annot.getSingleEvidenceCodeFromSet();
                if (DESCENDANT_SEQUENCES_EC.equals(code) && null != (withSet = annot.getAnnotationDetail().getWithAnnotSet()) && withSet.contains(propagator) && propagator.getGoTerm().equals(annot.getGoTerm()) && (KEY_RESIDUES_EC.equals(annotCode) || DIVERGENT_EC.equals(annotCode) || "TCV".equals(annotCode))) {
                    directDepAnnots.add(annot);
                    continue;
                }
                if (KEY_RESIDUES_EC.equals(code) || DIVERGENT_EC.equals(code)) {
                    if (!ANCESTRAL_EVIDENCE_CODE.equals(annotCode)) continue;
                    Annotation iba = AnnotationHelper.getAssociatedIBAForIKRorIRD(propagator, n);
                    if (annot == iba) {
                        directDepAnnots.add(annot);
                        continue;
                    }
                }
                if (!ANCESTRAL_EVIDENCE_CODE.equals(code) || !KEY_RESIDUES_EC.equals(annotCode) && !DIVERGENT_EC.equals(annotCode) && !"TCV".equals(annotCode) || annot != (ikrIrdTcv = AnnotationHelper.getIKRIRDTCVforPropagator(n, ibdPropagator = AnnotationHelper.getPropagator(propagator))) || !propagator.getGoTerm().equals(annot.getGoTerm())) continue;
                directDepAnnots.add(annot);
            }
        }
        if (null != (children = (nsi = n.getStaticInfo()).getChildren())) {
            for (Node child : children) {
                ArrayList<Annotation> childAnnotList = AnnotationHelper.getDirectDependantAnnots(propagator, child);
                if (null == childAnnotList) continue;
                directDepAnnots.addAll(childAnnotList);
            }
        }
        return directDepAnnots;
    }

    private static void deletePropagatorFromAll(Annotation propagator, String term, Node n) {
        ArrayList<Node> children;
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null != nvi && null != nvi.getGoAnnotationList() && !nvi.isPruned()) {
            ArrayList<Annotation> annotList = nvi.getGoAnnotationList();
            Iterator<Annotation> annotIter = annotList.iterator();
            while (annotIter.hasNext()) {
                HashSet<Annotation> withSet;
                Annotation a = annotIter.next();
                if (!a.getGoTerm().equals(term) || null == (withSet = a.getAnnotationDetail().getWithAnnotSet()) || !withSet.contains(propagator)) continue;
                System.out.println("Removing " + a.getSingleEvidenceCodeFromSet() + " to term " + a.getGoTerm() + " from " + a.getAnnotationDetail().getAnnotatedNode().getStaticInfo().getPublicId());
                annotIter.remove();
            }
            if (annotList.isEmpty()) {
                nvi.setGoAnnotationList(null);
            }
        }
        if (null != (children = n.getStaticInfo().getChildren())) {
            for (Node child : children) {
                AnnotationHelper.deletePropagatorFromAll(propagator, term, child);
            }
        }
    }

    private static boolean deleteAnnotation(Annotation a, Node n) {
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null != nvi && null != nvi.getGoAnnotationList()) {
            boolean success = nvi.getGoAnnotationList().remove(a);
            if (success) {
                System.out.println("Removing " + a.getSingleEvidenceCodeFromSet() + " to term " + a.getGoTerm() + " from " + a.getAnnotationDetail().getAnnotatedNode().getStaticInfo().getPublicId());
            }
            if (nvi.getGoAnnotationList().isEmpty()) {
                nvi.setGoAnnotationList(null);
            }
            return success;
        }
        return false;
    }

    public static void checkTaxonomyViolationsForNodeAndDescendants(Node n, String term, StringBuffer sb, TaxonomyHelper taxonomyHelper) {
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null != nvi && nvi.isPruned()) {
            return;
        }
        ArrayList<Annotation> annotList = nvi.getGoAnnotationList();
        if (null == annotList) {
            return;
        }
        NodeStaticInfo nsi = n.getStaticInfo();
        for (Annotation a : annotList) {
            if (!term.equals(a.getGoTerm()) || AnnotationHelper.termAndQualifierValidForSpeciesCheckTaxonomy(a, taxonomyHelper)) continue;
            sb.append(MSG_ERROR_NODE_VIOLATES_TAXONOMY_CONSTRAINT_1);
            sb.append(nsi.getPublicId());
            sb.append(MSG_ERROR_NODE_VIOLATES_TAXONOMY_CONSTRAINT_2);
            sb.append(term);
            sb.append(" with species ");
            sb.append(nsi.getCalculatedSpecies());
            sb.append(MSG_ERROR_NODE_VIOLATES_TAXONOMY_CONSTRAINT_4);
            return;
        }
        ArrayList<Node> children = nsi.getChildren();
        if (null != children) {
            for (Node child : children) {
                AnnotationHelper.checkTaxonomyViolationsForNodeAndDescendants(child, term, sb, taxonomyHelper);
            }
        }
    }

    public static boolean termAndQualifierValidForSpeciesCheckTaxonomy(Annotation a, TaxonomyHelper taxonomyHelper) {
        AnnotationDetail ad = a.getAnnotationDetail();
        Node n = ad.getAnnotatedNode();
        return taxonomyHelper.termAndQualifierValidForSpeciesCheckTaxonomy(a.getGoTerm(), n.getStaticInfo().getCalculatedSpecies(), ad.getQualifiers());
    }

    public static boolean ignoreAnnot(Annotation a, Node n, Hashtable<Organism, HashSet<String>> nonDisplayedAnnotMatrixOrgToEvdnceLookup) {
        if (null == nonDisplayedAnnotMatrixOrgToEvdnceLookup || 0 == nonDisplayedAnnotMatrixOrgToEvdnceLookup.size()) {
            return false;
        }
        AnnotationDetail ad = a.getAnnotationDetail();
        HashSet<WithEvidence> annotWithSet = ad.getWithEvidenceAnnotSet();
        HashSet<WithEvidence> annotNodeSet = ad.getWithEvidenceNodeSet();
        HashSet<WithEvidence> annotDBRefSet = ad.getWithEvidenceDBRefSet();
        if (null != annotWithSet || null != annotNodeSet || null == annotDBRefSet || null != annotDBRefSet && 0 == annotDBRefSet.size()) {
            return false;
        }
        String longGeneName = n.getStaticInfo().getLongGeneName();
        if (null == longGeneName) {
            return false;
        }
        String[] parts = longGeneName.split(Pattern.quote("|"));
        int length = parts.length;
        if (length < 2) {
            return false;
        }
        String shortOrg = parts[0];
        for (Organism o : nonDisplayedAnnotMatrixOrgToEvdnceLookup.keySet()) {
            if (!shortOrg.equals(o.getShortName())) continue;
            HashSet<String> nonDisplayCodeSet = nonDisplayedAnnotMatrixOrgToEvdnceLookup.get(o);
            for (WithEvidence we : annotDBRefSet) {
                String curCode = we.getEvidenceCode();
                if (nonDisplayCodeSet.contains(curCode)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

