/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paintCommon;

import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import java.util.Vector;

public class AnnotationNode {
    String accession;
    String publicId;
    String eventType;
    String nodeType;
    String familyId;
    String familyName;
    String annotationNodeId;
    String branchLength;
    String parentId;
    String sequence;
    Vector children;
    AnnotationNode parent;
    String type;
    String nodeName;
    String longName;
    String referenceSpeciationEvent;
    String geneSymbol;
    String geneName;
    String sfId;
    String sfName;
    Node node;
    public static final String NODE_TYPE_DUPLICATION = "1>0";
    public static final String NODE_TYPE_HORIZONTAL_TRANSFER = "0>0";
    public static final String NODE_TYPE_SPECIES = "S=";
    public static final String NODE_TYPE_ANNOTATION = "ID=";
    public static final int NODE_TYPE_ANNOTATION_LENGTH = "ID=".length();
    public static final String NODE_TYPE_INFO_SEPARATOR = ":";
    public static final String NODE_TYPE_INFO_PREFIX = "[";
    public static final String NODE_TYPE_INFO_SUFFIX = "]";
    public static final String DELIM_FAMILY_AN_ID = ":";
    public static final String DELIM_NAME = "\\|";

    public static String constructFullAnnotationId(String familyId, String anId) {
        return familyId + ":" + anId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setFamilyId(String familyId) {
        this.familyId = familyId;
    }

    public String getFamilyId() {
        return this.familyId;
    }

    public void setAnnotationNodeId(String annotationNodeId) {
        this.annotationNodeId = annotationNodeId;
    }

    public String getAnnotationNodeId() {
        return this.annotationNodeId;
    }

    public void setBranchLength(String branchLength) {
        this.branchLength = branchLength;
    }

    public String getBranchLength() {
        return this.branchLength;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setAccession(String accession) {
        this.accession = accession;
    }

    public String getAccession() {
        return this.accession;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setChildren(Vector children) {
        this.children = children;
    }

    public Vector getChildren() {
        return this.children;
    }

    public void setParent(AnnotationNode parent) {
        this.parent = parent;
    }

    public AnnotationNode getParent() {
        return this.parent;
    }

    public void setType(String type) {
        this.nodeType = type;
        String annotId = this.getAnnotIdFromNodeInfo();
        if (null != annotId) {
            this.annotationNodeId = annotId;
        }
    }

    private String getAnnotIdFromNodeInfo() {
        if (null == this.nodeType) {
            return null;
        }
        int index = this.nodeType.indexOf(NODE_TYPE_ANNOTATION);
        if (index < 0) {
            return null;
        }
        int endIndex = this.nodeType.indexOf(":", index);
        if (-1 == endIndex) {
            endIndex = this.nodeType.indexOf(NODE_TYPE_INFO_SUFFIX);
        }
        return new String(this.nodeType.substring(index + NODE_TYPE_ANNOTATION_LENGTH, endIndex));
    }

    public boolean isDuplicationNode() {
        if (null == this.nodeType) {
            return false;
        }
        int index = this.nodeType.indexOf(NODE_TYPE_DUPLICATION);
        return index >= 0;
    }

    public boolean isHorizontalTransferNode() {
        if (null == this.nodeType) {
            return false;
        }
        int index = this.nodeType.indexOf(NODE_TYPE_HORIZONTAL_TRANSFER);
        return index >= 0;
    }

    public String getSpecies() {
        if (null == this.nodeType) {
            return null;
        }
        int length = this.nodeType.length();
        int index = this.nodeType.indexOf(NODE_TYPE_SPECIES);
        if (index < 0 || index >= length) {
            return null;
        }
        int endIndex = this.nodeType.indexOf(":", index += NODE_TYPE_SPECIES.length());
        if (-1 == endIndex) {
            endIndex = this.nodeType.indexOf(NODE_TYPE_INFO_SUFFIX);
        }
        if (endIndex < index || endIndex >= length) {
            return null;
        }
        return new String(this.nodeType.substring(index, endIndex));
    }

    public String getType() {
        return this.type;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setReferenceSpeciationEvent(String referenceSpeciationEvent) {
        this.referenceSpeciationEvent = referenceSpeciationEvent;
    }

    public String getReferenceSpeciationEvent() {
        return this.referenceSpeciationEvent;
    }

    public void setGeneSymbol(String geneSymbol) {
        this.geneSymbol = geneSymbol;
    }

    public String getGeneSymbol() {
        return this.geneSymbol;
    }

    public void setSfId(String sfId) {
        this.sfId = sfId;
    }

    public String getSfId() {
        return this.sfId;
    }

    public void setSfName(String sfName) {
        this.sfName = sfName;
    }

    public String getSfName() {
        return this.sfName;
    }

    public void setGeneName(String geneName) {
        this.geneName = geneName;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public static String getShortSpeciesFromLongName(String longName) {
        if (null == longName) {
            return null;
        }
        String[] parts = longName.split(DELIM_NAME);
        int length = parts.length;
        if (length < 2) {
            return null;
        }
        return parts[0];
    }

    public String getSpeciesFromLongName() {
        if (null == this.longName) {
            return null;
        }
        String[] parts = this.longName.split(DELIM_NAME);
        int length = parts.length;
        if (length < 2) {
            return null;
        }
        return parts[0];
    }

    public String getProteinPartFromLongName() {
        if (null == this.longName) {
            return null;
        }
        String[] parts = this.longName.split(DELIM_NAME);
        int length = parts.length;
        if (length < 3) {
            return null;
        }
        return parts[2];
    }

    public String getLongName() {
        return this.longName;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public boolean isPruned() {
        if (null == this.node) {
            return false;
        }
        NodeVariableInfo nvi = this.node.getVariableInfo();
        if (null != nvi) {
            return nvi.isPruned();
        }
        return false;
    }
}

