/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paintCommon;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class Comment
implements Serializable {
    private String classificationId;
    private String nodeId;
    private String text;
    private String commentUserNotes;
    private String commentMfSection;
    private String commentBpSection;
    private String commentCcSection;
    private static final String PREFIX_SECTION_MF = "# molecular_function";
    private static final String PREFIX_SECTION_CC = "# cellular_component";
    private static final String PREFIX_SECTION_BP = "# biological_process";
    private static final String PREFIX_SECTION_NOTES = "# Notes";
    protected static final String DELIM_PARTS = "\t";
    protected static final int NUM_PARTS = 6;
    protected static int SIZE_DATE_OLD = 8;
    protected static int SIZE_DATE_NEW = 10;
    protected static final String NEW_DATE_CHAR = "-";
    public static final String REGEX_NUMBERS_ONLY = "[0-9]+";

    public Comment(String classificationId, String nodeId, String text) {
        this.classificationId = classificationId;
        this.nodeId = nodeId;
        if (null != text) {
            text = text.trim();
        }
        this.text = text;
        this.parse();
    }

    public String getClassificationId() {
        return this.classificationId;
    }

    public void setClassificationId(String classificationId) {
        this.classificationId = classificationId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getCommentUserNotes() {
        return this.commentUserNotes;
    }

    public void setCommentUserNotes(String commentUserNotes) {
        this.commentUserNotes = commentUserNotes;
    }

    public void appendCommentUserNotes(String appendStr) {
        if (null == this.commentUserNotes) {
            this.commentUserNotes = appendStr;
            return;
        }
        this.commentUserNotes = this.commentUserNotes.trim() + "\n" + appendStr;
    }

    public String getCommentMfSection() {
        return this.commentMfSection;
    }

    public void setCommentMfSection(String commentMfSection) {
        this.commentMfSection = commentMfSection;
    }

    public void prependCommentMfSection(String prependStr) {
        if (null == this.commentMfSection) {
            this.commentMfSection = prependStr;
            return;
        }
        this.commentMfSection = prependStr + "\n" + this.commentMfSection;
    }

    public String getCommentBpSection() {
        return this.commentBpSection;
    }

    public void setCommentBpSection(String commentBpSection) {
        this.commentBpSection = commentBpSection;
    }

    public void prependCommentBpSection(String prependStr) {
        if (null == this.commentBpSection) {
            this.commentBpSection = prependStr;
            return;
        }
        this.commentBpSection = prependStr + "\n" + this.commentBpSection;
    }

    public String getCommentCcSection() {
        return this.commentCcSection;
    }

    public void setCommentCcSection(String commentCcSection) {
        this.commentCcSection = commentCcSection;
    }

    public void prependCommentCcSection(String prependStr) {
        if (null == this.commentCcSection) {
            this.commentCcSection = prependStr;
            return;
        }
        this.commentCcSection = prependStr + "\n" + this.commentCcSection;
    }

    public void parse() {
        if (null == this.text) {
            return;
        }
        int indexMf = this.text.indexOf(PREFIX_SECTION_MF);
        int indexCc = this.text.indexOf(PREFIX_SECTION_CC);
        int indexBp = this.text.indexOf(PREFIX_SECTION_BP);
        int indexNotes = this.text.indexOf(PREFIX_SECTION_NOTES);
        if (0 > indexMf && 0 > indexBp && 0 > indexCc && 0 > indexNotes) {
            this.commentUserNotes = this.text;
            this.commentUserNotes = this.commentUserNotes.trim();
        } else {
            if (indexMf == 0) {
                if (indexCc > 0) {
                    this.commentMfSection = this.text.substring(indexMf + PREFIX_SECTION_MF.length(), indexCc).trim();
                    this.commentMfSection = Comment.orderEntries(this.commentMfSection).trim();
                    this.commentMfSection = this.commentMfSection + "\n";
                } else if (indexBp > 0) {
                    this.commentMfSection = this.text.substring(indexMf + PREFIX_SECTION_MF.length(), indexBp).trim();
                    this.commentMfSection = Comment.orderEntries(this.commentMfSection).trim();
                    this.commentMfSection = this.commentMfSection + "\n";
                } else if (indexNotes > 0) {
                    this.commentMfSection = this.text.substring(indexMf + PREFIX_SECTION_MF.length(), indexNotes).trim();
                    this.commentMfSection = Comment.orderEntries(this.commentMfSection).trim();
                    this.commentMfSection = this.commentMfSection + "\n";
                } else {
                    this.commentMfSection = this.text.substring(indexMf + PREFIX_SECTION_MF.length()).trim();
                    this.commentMfSection = Comment.orderEntries(this.commentMfSection).trim();
                    this.commentMfSection = this.commentMfSection + "\n";
                }
            }
            if (indexCc >= 0) {
                if (indexBp > indexCc) {
                    this.commentCcSection = this.text.substring(indexCc + PREFIX_SECTION_CC.length(), indexBp).trim();
                    this.commentCcSection = Comment.orderEntries(this.commentCcSection).trim();
                    this.commentCcSection = this.commentCcSection + "\n";
                } else if (indexNotes > indexCc) {
                    this.commentCcSection = this.text.substring(indexCc + PREFIX_SECTION_CC.length(), indexNotes).trim();
                    this.commentCcSection = Comment.orderEntries(this.commentCcSection).trim();
                    this.commentCcSection = this.commentCcSection + "\n";
                } else {
                    this.commentCcSection = this.text.substring(indexCc + PREFIX_SECTION_CC.length()).trim();
                    this.commentCcSection = Comment.orderEntries(this.commentCcSection).trim();
                    this.commentCcSection = this.commentCcSection + "\n";
                }
            }
            if (indexBp >= 0) {
                if (indexNotes > indexBp) {
                    this.commentBpSection = this.text.substring(indexBp + PREFIX_SECTION_BP.length(), indexNotes).trim();
                    this.commentBpSection = Comment.orderEntries(this.commentBpSection).trim();
                    this.commentBpSection = this.commentBpSection + "\n";
                } else {
                    this.commentBpSection = this.text.substring(indexBp + PREFIX_SECTION_BP.length()).trim();
                    this.commentBpSection = Comment.orderEntries(this.commentBpSection).trim();
                    this.commentBpSection = this.commentBpSection + "\n";
                }
            }
            if (indexNotes >= 0) {
                this.commentUserNotes = this.text.substring(indexNotes + PREFIX_SECTION_NOTES.length()).trim();
                this.commentUserNotes = this.commentUserNotes + "\n";
            }
        }
    }

    public static String orderEntries(String s) {
        if (null == s) {
            return s;
        }
        String[] lines = s.split("\n");
        if (null == lines) {
            return s;
        }
        try {
            HashMap<String, ArrayList<String>> dateToCmtLookup = new HashMap<String, ArrayList<String>>();
            for (String line : lines) {
                if (null == line || line.startsWith(PREFIX_SECTION_MF) || line.startsWith(PREFIX_SECTION_CC) || line.startsWith(PREFIX_SECTION_BP)) continue;
                String[] parts = line.split(DELIM_PARTS);
                if (null == parts || 0 == parts.length) {
                    ArrayList<String> values = (ArrayList<String>)dateToCmtLookup.get(line);
                    if (null == values) {
                        values = new ArrayList<String>();
                        dateToCmtLookup.put(line, values);
                    }
                    values.add(line);
                    continue;
                }
                if (6 >= parts.length) {
                    ArrayList<String> values = (ArrayList<String>)dateToCmtLookup.get(parts[0]);
                    if (null == values) {
                        values = new ArrayList<String>();
                        dateToCmtLookup.put(parts[0], values);
                    }
                    values.add(line);
                    continue;
                }
                if (6 >= parts.length) continue;
                int fixIndex = 5;
                ArrayList<String> fixedList = new ArrayList<String>(Arrays.asList(parts));
                boolean error = false;
                while (fixIndex < fixedList.size()) {
                    String fixPart = fixedList.get(fixIndex);
                    boolean newFormat = fixPart.contains(NEW_DATE_CHAR);
                    int size = SIZE_DATE_OLD;
                    if (newFormat) {
                        size = SIZE_DATE_NEW;
                    }
                    if (size < fixPart.length()) {
                        String newPart = fixPart.substring(fixPart.length() - size);
                        try {
                            Integer.parseInt(newPart);
                            String oldPart = fixPart.substring(0, fixPart.length() - size);
                            fixedList.set(fixIndex, oldPart);
                            fixedList.add(fixIndex + 1, newPart);
                            if (++fixIndex + 6 == fixedList.size()) break;
                            fixIndex = fixIndex + 6 - 1;
                            continue;
                        }
                        catch (Exception e) {
                            error = true;
                            break;
                        }
                    }
                    error = true;
                    break;
                }
                if (!error && 0 == fixedList.size() % 6) {
                    for (int i = 0; i < fixedList.size() / 6; ++i) {
                        int index = i * 6;
                        StringBuffer sb = new StringBuffer();
                        for (int j = index; j < index + 6; ++j) {
                            sb.append(fixedList.get(j));
                            sb.append(DELIM_PARTS);
                        }
                        ArrayList<String> values = (ArrayList<String>)dateToCmtLookup.get(fixedList.get(index));
                        if (null == values) {
                            values = new ArrayList<String>();
                            dateToCmtLookup.put(fixedList.get(index), values);
                        }
                        values.add(sb.toString().trim());
                    }
                    continue;
                }
                ArrayList<String> values = (ArrayList<String>)dateToCmtLookup.get(parts[0]);
                if (null == values) {
                    values = new ArrayList<String>();
                    dateToCmtLookup.put(parts[0], values);
                }
                values.add(line);
            }
            Set keys = dateToCmtLookup.keySet();
            ArrayList keyList = new ArrayList(keys);
            Collections.sort(keyList, Collections.reverseOrder());
            StringBuffer sb = new StringBuffer();
            for (String key : keyList) {
                ArrayList values = (ArrayList)dateToCmtLookup.get(key);
                for (String value : values) {
                    CharSequence[] parts = value.split(DELIM_PARTS);
                    if (0 < parts.length && null != parts[0] && parts[0].matches(REGEX_NUMBERS_ONLY) && parts[0].length() == SIZE_DATE_OLD) {
                        parts[0] = value.substring(0, 4) + NEW_DATE_CHAR + value.substring(4, 6) + NEW_DATE_CHAR + value.substring(6, 8);
                        value = String.join((CharSequence)DELIM_PARTS, parts);
                    }
                    sb.append(value);
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return s;
        }
    }

    public static boolean isPositiveNumber(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public String getFormattedComment() {
        StringBuffer sb = new StringBuffer();
        if (null != this.commentMfSection) {
            sb.append("# molecular_function\n");
            sb.append(this.commentMfSection.trim());
            sb.append("\n");
        }
        if (null != this.commentCcSection) {
            sb.append("# cellular_component\n");
            sb.append(this.commentCcSection.trim());
            sb.append("\n");
        }
        if (null != this.commentBpSection) {
            sb.append("# biological_process\n");
            sb.append(this.commentBpSection.trim());
            sb.append("\n");
        }
        if (null != this.commentUserNotes) {
            sb.append("# Notes\n");
            sb.append(this.commentUserNotes.trim());
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getRevisionHistoryInfo() {
        StringBuffer sb = new StringBuffer();
        if (null != this.commentMfSection) {
            sb.append("# molecular_function\n");
            sb.append(this.commentMfSection.trim());
            sb.append("\n");
        }
        if (null != this.commentBpSection) {
            sb.append("# biological_process\n");
            sb.append(this.commentBpSection.trim());
            sb.append("\n");
        }
        if (null != this.commentCcSection) {
            sb.append("# cellular_component\n");
            sb.append(this.commentCcSection.trim());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String test1 = "# molecular_function\n20141117: Euteleostomi_PTN000002099 lost/modified clathrin binding (GO:0030276) capacity\n20141117: Euteleostomi_PTN000001654 lost/modified clathrin binding (GO:0030276) capacity\n20141117: Euteleostomi_PTN000001677 lost/modified clathrin binding (GO:0030276) capacity\n20141117: root_PTN000001285 has function clathrin binding (GO:0030276)\n20141117: Tetrapoda_PTN000001864 has function phosphatidylinositol-4,5-bisphosphate binding (GO:0005546)\n20141117: Euteleostomi_PTN000002099 lost/modified syntaxin binding (GO:0019905) capacity\n20141117: Euteleostomi_PTN000001654 lost/modified syntaxin binding (GO:0019905) capacity\n20141117: Euteleostomi_PTN000001677 lost/modified syntaxin binding (GO:0019905) capacity\n20141117: root_PTN000001285 has function syntaxin binding (GO:0019905)\n20141117: Bilateria_PTN000001972 lost/modified calcium ion binding (GO:0005509) capacity\n20141117: Euteleostomi_PTN000740742 lost/modified calcium ion binding (GO:0005509) capacity\n20141117: root_PTN000001283 has function calcium ion binding (GO:0005509)\n20141117: Bilateria_PTN000001972 lost/modified calcium-dependent phospholipid binding (GO:0005544) capacity\n20141117: Euteleostomi_PTN000740742 lost/modified calcium-dependent phospholipid binding (GO:0005544) capacity\n20141117: Eumetazoa_PTN000797547 lost/modified calcium-dependent phospholipid binding (GO:0005544) capacity\n20141117: Euteleostomi_PTN000001422 lost/modified calcium-dependent phospholipid binding (GO:0005544) capacity\n20141117: root_PTN000001283 has function calcium-dependent phospholipid binding (GO:0005544)\n# cellular_component\n20141117: Eumetazoa_PTN000797746 located in exocytic vesicle (GO:0070382)\n20141117: root_PTN000001283 located in plasma membrane (GO:0005886)\n20141117: Bilateria_PTN000740739 located in synaptic vesicle membrane (GO:0030672)\n20141117: Bilateria_PTN000740739 located in synaptic vesicle (GO:0008021)\n# biological_process\n20141117: Euteleostomi_PTN000001485 lost/modified calcium ion-dependent exocytosis of neurotransmitter (GO:0048791) capacity\n20141117: Euteleostomi_PTN000001485 lost/modified regulation of calcium ion-dependent exocytosis (GO:0017158) capacity\n20141117: Bilateria_PTN000740739 participates in synaptic vesicle endocytosis (GO:0048488)\n20141117: Euteleostomi_PTN000002099 lost/modified calcium ion-dependent exocytosis of neurotransmitter (GO:0048791) capacity\n20141117: Euteleostomi_PTN000001654 lost/modified calcium ion-dependent exocytosis of neurotransmitter (GO:0048791) capacity\n20141117: Euteleostomi_PTN000001677 lost/modified calcium ion-dependent exocytosis of neurotransmitter (GO:0048791) capacity\n20141117: Eumetazoa_PTN000797547 lost/modified calcium ion-dependent exocytosis of neurotransmitter (GO:0048791) capacity\n20141117: root_PTN000001285 participates in calcium ion-dependent exocytosis of neurotransmitter (GO:0048791)\n20141117: Euteleostomi_PTN000002099 lost/modified vesicle fusion (GO:0006906) capacity\n20141117: Euteleostomi_PTN000001654 lost/modified vesicle fusion (GO:0006906) capacity\n20141117: Euteleostomi_PTN000001677 lost/modified vesicle fusion (GO:0006906) capacity\n20141117: root_PTN000001285 participates in vesicle fusion (GO:0006906)\n20141117: Eumetazoa_PTN000797547 lost/modified regulation of calcium ion-dependent exocytosis (GO:0017158) capacity\n20141117: Euteleostomi_PTN000740742 lost/modified regulation of calcium ion-dependent exocytosis (GO:0017158) capacity\n20141117: Bilateria_PTN000001972 lost/modified regulation of calcium ion-dependent exocytosis (GO:0017158) capacity\n20141117: Euteleostomi_PTN000002099 lost/modified regulation of calcium ion-dependent exocytosis (GO:0017158) capacity\n20141117: Euteleostomi_PTN000001654 lost/modified regulation of calcium ion-dependent exocytosis (GO:0017158) capacity\n20141117: Euteleostomi_PTN000001677 lost/modified regulation of calcium ion-dependent exocytosis (GO:0017158) capacity\n20141117: root_PTN000001285 participates in regulation of calcium ion-dependent exocytosis (GO:0017158)\n20141117: Euteleostomi_PTN000001677 lost/modified synaptic vesicle exocytosis (GO:0016079) capacity\n20141117: Euteleostomi_PTN000001654 lost/modified synaptic vesicle exocytosis (GO:0016079) capacity\n20141117: Euteleostomi_PTN000002099 lost/modified synaptic vesicle exocytosis (GO:0016079) capacity\n20141117: root_PTN000001285 participates in synaptic vesicle exocytosis (GO:0016079)\n# Notes\n1. There are a few C2CD proteins in the middle of the tree. These proteins contain C2 domain that are shared among all Syt proteins. Functionally they do not share any function with the Syt members except for Ca binding.\n2. A paper (PMID:17190793) shows that Syt12 does not bind to Ca and is not involved in Ca dependent exocytosis. \n\nNov. 17, 2014 - HM\n\nThis family was checked into svn in Feb. 2015, but it should be recurated once the paint software is updated, because some of the NOT annotations are not properly done due to the tool problem. See emails and PAINT call minutes back in November for details.\n\nFeb. 12, 2015, HM\n\n\nAnnotation inferences using phylogenetic trees\n\nThe goal of the GO Reference Genome Project, described in PMID 19578431, is to provide accurate, complete and consistent GO annotations for all genes in twelve model organism genomes. To this end, GO curators are annotating evolutionary trees from the PANTHER database with GO terms describing molecular function, biological process and cellular component. GO terms based on experimental data from the scientific literature are used to annotate ancestral genes in the phylogenetic tree by sequence similarity (ISS), and unannotated descendants of these ancestral genes are inferred to have inherited these same GO annotations by descent. The annotations are done using a tool called PAINT (Phylogenetic Annotation and INference Tool).\n";
        Comment c1 = new Comment(null, null, test1);
        System.out.println("MF section " + c1.getCommentMfSection());
        System.out.println("BP section " + c1.getCommentBpSection());
        System.out.println("CC section " + c1.getCommentCcSection());
        System.out.println("Notes section " + c1.getCommentUserNotes());
        String test2 = "1. There are a few C2CD proteins in the middle of the tree. These proteins contain C2 domain that are shared among all Syt proteins. Functionally they do not share any function with the Syt members except for Ca binding.\n2. A paper (PMID:17190793) shows that Syt12 does not bind to Ca and is not involved in Ca dependent exocytosis. \n\nNov. 17, 2014 - HM\n\nThis family was checked into svn in Feb. 2015, but it should be recurated once the paint software is updated, because some of the NOT annotations are not properly done due to the tool problem. See emails and PAINT call minutes back in November for details.\n\nFeb. 12, 2015, HM\n\n\nAnnotation inferences using phylogenetic trees\n\nThe goal of the GO Reference Genome Project, described in PMID 19578431, is to provide accurate, complete and consistent GO annotations for all genes in twelve model organism genomes. To this end, GO curators are annotating evolutionary trees from the PANTHER database with GO terms describing molecular function, biological process and cellular component. GO terms based on experimental data from the scientific literature are used to annotate ancestral genes in the phylogenetic tree by sequence similarity (ISS), and unannotated descendants of these ancestral genes are inferred to have inherited these same GO annotations by descent. The annotations are done using a tool called PAINT (Phylogenetic Annotation and INference Tool).\n";
        System.out.println("TEST 2 -----------------------------------");
        Comment c2 = new Comment(null, null, test2);
        System.out.println("MF section " + c2.getCommentMfSection());
        System.out.println("BP section " + c2.getCommentBpSection());
        System.out.println("CC section " + c2.getCommentCcSection());
        System.out.println("Notes section " + c2.getCommentUserNotes());
        String test3 = "# cellular_component\n20141117: Eumetazoa_PTN000797746 located in exocytic vesicle (GO:0070382)\n20141117: root_PTN000001283 located in plasma membrane (GO:0005886)\n20141117: Bilateria_PTN000740739 located in synaptic vesicle membrane (GO:0030672)\n20141117: Bilateria_PTN000740739 located in synaptic vesicle (GO:0008021)\n# biological_process\n20141117: Euteleostomi_PTN000001485 lost/modified calcium ion-dependent exocytosis of neurotransmitter (GO:0048791) capacity\n20141117: Euteleostomi_PTN000001485 lost/modified regulation of calcium ion-dependent exocytosis (GO:0017158) capacity\n20141117: Bilateria_PTN000740739 participates in synaptic vesicle endocytosis (GO:0048488)\n20141117: Euteleostomi_PTN000002099 lost/modified calcium ion-dependent exocytosis of neurotransmitter (GO:0048791) capacity\n20141117: Euteleostomi_PTN000001654 lost/modified calcium ion-dependent exocytosis of neurotransmitter (GO:0048791) capacity\n20141117: Euteleostomi_PTN000001677 lost/modified calcium ion-dependent exocytosis of neurotransmitter (GO:0048791) capacity\n20141117: Eumetazoa_PTN000797547 lost/modified calcium ion-dependent exocytosis of neurotransmitter (GO:0048791) capacity\n20141117: root_PTN000001285 participates in calcium ion-dependent exocytosis of neurotransmitter (GO:0048791)\n";
        System.out.println("TEST 3 -----------------------------------");
        Comment c3 = new Comment(null, null, test3);
        System.out.println("MF section " + c3.getCommentMfSection());
        System.out.println("BP section " + c3.getCommentBpSection());
        System.out.println("CC section " + c3.getCommentCcSection());
        System.out.println("Notes section " + c3.getCommentUserNotes());
        String test4 = "# molecular_function\n2019-04-24\tpgaudet\tObsolete\tIBD\tPTN002569912\tGO:0005515\n20190424\tpgaudet\tObsolete\tIBD\tPTN002569942\tGO:0005515\n20190424\tpgaudet\tObsolete\tIBD\tPTN002569901\tGO:0005515\n20190424\tpgaudet\tObsolete\tIBD\tPTN001308314\tGO:000551520190701\tmihn_s  Obsolete\tIBD\tPTN000036886\tGO:000443520190424\tpgaudet\tObsolete\tIBD\tPTN001308314\tGO:0005515fgdfg20190424\tpgaudet\tObsolete\tIBD\tPTN001308314\tGO:0005515\n20190701\tmihn_s\tObsolete\tIRD\tPTN000818466\tGO:0004435-(NOT)\n20190701\tmihn_s\tObsolete\t\tUnknown\tGO:0005515\n20190701\tmihn_s\tSave\tIRD\tPTN000818466\tGO:0004435-(NOT)\n# cellular_component\n20190424\tpgaudet\tObsolete\tIBD\tPTN000818645\tGO:0005886\n20190424\tpgaudet\tObsolete\tIBD\tPTN002569901\tGO:0005737\n20190424\tpgaudet\tObsolete\tIBD\tPTN002569901\tGO:0005829\n20190424\tpgaudet\tObsolete\tIBD\tPTN000818423\tGO:0005886\n# Notes\n2018-11-22 Reviewed PG\n2019-04-24 Removed protein binding annotations PG\n\\n2019-06-14: In the PANTHER14.1 update, PTN002569824 can not be directly mapped but their direct child nodes PTN000036886 can be mapped to . These nodes were annotated with GO terms GO:0004435 (IBD).\\n\\n2019-06-14: In the PANTHER14.1 update, PANTHER14.1 family PTHR10336 lost IBD annotations.  PTN002569901 (Eukaryota - SPECIATION, contains HUMAN_PLCD1), PTN002569912 (Opisthokonts - SPECIATION, contains HUMAN_PLCE1) that was annotated with GO terms GO:0005546 (IBD), GO:0007265 (IBD), GO:0017016 (IBD), GO:0004435 (IBD) can not be mapped to PANTHER14.1.\\n";
        System.out.println("TEST 4 -----------------------------------");
        Comment c4 = new Comment(null, null, test4);
        System.out.println("MF section " + c4.getCommentMfSection());
        System.out.println("BP section " + c4.getCommentBpSection());
        System.out.println("CC section " + c4.getCommentCcSection());
        System.out.println("Notes section " + c4.getCommentUserNotes());
    }
}

