/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paintCommon;

import edu.usc.ksom.pm.panther.paintCommon.DBReference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;

public class Evidence
implements Serializable {
    private String evidenceId;
    private ArrayList<DBReference> dbReferenceList;
    private String evidenceCodeid;
    private String evidenceCode;
    private ArrayList<DBReference> withs;
    private String date;
    public static final String CODE_IKR = "IKR";
    public static final String CODE_IRD = "IRD";
    public static final String CODE_IBA = "IBA";
    public static final String CODE_IBD = "IBD";
    public static final String CODE_IEA = "IEA";
    public static final String CODE_TCV = "TCV";
    private static final LinkedHashSet<String> experimentalCodes = Evidence.initExperimental();
    private static final HashSet<String> paintCodes = Evidence.initPaintCodes();

    public String getEvidenceId() {
        return this.evidenceId;
    }

    public void setEvidenceId(String evidenceId) {
        this.evidenceId = evidenceId;
    }

    public String getEvidenceCodeid() {
        return this.evidenceCodeid;
    }

    public void setEvidenceCodeid(String evidenceCodeid) {
        this.evidenceCodeid = evidenceCodeid;
    }

    public String getEvidenceCode() {
        return this.evidenceCode;
    }

    public void setEvidenceCode(String evidenceCode) {
        this.evidenceCode = evidenceCode;
    }

    public ArrayList<DBReference> getDbReferenceList() {
        return this.dbReferenceList;
    }

    public void setDbReferenceList(ArrayList<DBReference> dbReferenceList) {
        this.dbReferenceList = dbReferenceList;
    }

    public void addDbRef(DBReference reference) {
        if (null == this.dbReferenceList) {
            this.dbReferenceList = new ArrayList();
        }
        this.dbReferenceList.add(reference);
    }

    public ArrayList<DBReference> getWiths() {
        return this.withs;
    }

    public void setWiths(ArrayList<DBReference> withs) {
        this.withs = withs;
    }

    public void addWith(DBReference with) {
        if (null == this.withs) {
            this.withs = new ArrayList();
        }
        this.withs.add(with);
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    private static final LinkedHashSet<String> initExperimental() {
        LinkedHashSet<String> expSet = new LinkedHashSet<String>();
        expSet.add("EXP");
        expSet.add("IDA");
        expSet.add("IPI");
        expSet.add("IMP");
        expSet.add("IGI");
        expSet.add("IEP");
        expSet.add(CODE_IKR);
        expSet.add("HTP");
        expSet.add("HDA");
        expSet.add("HMP");
        expSet.add("HGI");
        expSet.add("HEP");
        return expSet;
    }

    public static LinkedHashSet<String> getExperimental() {
        if (null == experimentalCodes) {
            return null;
        }
        return (LinkedHashSet)experimentalCodes.clone();
    }

    public static HashSet<String> getPaintCodes() {
        if (null == paintCodes) {
            return null;
        }
        return paintCodes;
    }

    private static final HashSet<String> initPaintCodes() {
        HashSet<String> paintSet = new HashSet<String>();
        paintSet.add(CODE_IBD);
        paintSet.add(CODE_IRD);
        paintSet.add(CODE_IKR);
        paintSet.add(CODE_IBA);
        paintSet.add(CODE_TCV);
        return paintSet;
    }

    public static boolean isExperimental(String code) {
        if (null == code || null == experimentalCodes) {
            return false;
        }
        return experimentalCodes.contains(code);
    }

    public static boolean isExperimentalCodeValidForNode(String code, boolean isLeaf) {
        if (!isLeaf) {
            return false;
        }
        if (null == code || null == experimentalCodes) {
            return false;
        }
        return experimentalCodes.contains(code);
    }

    public static boolean isPaint(String code) {
        if (null == code || null == paintCodes) {
            return false;
        }
        return paintCodes.contains(code);
    }

    public static boolean isPAINTCodeValidForNode(String code, boolean isLeaf) {
        if (null == code || null == paintCodes) {
            return false;
        }
        if (isLeaf) {
            if (CODE_IKR.equals(code)) {
                return true;
            }
            if (CODE_IRD.equals(code)) {
                return true;
            }
            if (CODE_TCV.equals(code)) {
                return true;
            }
            if (CODE_IBD.equals(code)) {
                return false;
            }
        }
        return paintCodes.contains(code);
    }

    public Evidence makeCopy() {
        Evidence newEvidence = new Evidence();
        newEvidence.date = this.date;
        newEvidence.evidenceCode = this.evidenceCode;
        if (null != this.dbReferenceList) {
            ArrayList<DBReference> newDBRefList = new ArrayList<DBReference>(this.dbReferenceList.size());
            newEvidence.setDbReferenceList(newDBRefList);
            for (DBReference dbRef : this.dbReferenceList) {
                newDBRefList.add(dbRef.makeCopy());
            }
        }
        if (null != this.withs) {
            ArrayList<DBReference> newWithsList = new ArrayList<DBReference>(this.withs.size());
            newEvidence.setDbReferenceList(newWithsList);
            for (DBReference dbRef : this.withs) {
                newWithsList.add(dbRef.makeCopy());
            }
        }
        return newEvidence;
    }
}

