/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paintCommon;

import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GOTermHelper
implements Serializable {
    public static final String CAT_MOLECULAR_FUNCTION = "molec";
    public static final String CAT_BIOLOGICAL_PROCESS = "biol";
    public static final String CAT_CELLULAR_COMPONENT = "cellul";
    public static final String ASPECT_MF = "F";
    public static final String ASPECT_BP = "P";
    public static final String ASPECT_CC = "C";
    public static final HashSet<String> NON_ALLOWED_TERM_SET = new HashSet<String>(Arrays.asList("GO:0005515", "GO:0005488"));
    public static final String PREFIX_ACC = "GO:";
    private HashMap<String, GOTerm> clsToTerm;
    private ArrayList<GOTerm> topLevelTerms;
    public static final String DELIM_TERM = "-";
    private ArrayList<String> DISPLAY_LIST;

    public GOTermHelper(HashMap<String, GOTerm> clsToTerm, ArrayList<GOTerm> topLevelTerms) {
        this.clsToTerm = clsToTerm;
        this.topLevelTerms = topLevelTerms;
        this.DISPLAY_LIST = this.initDisplayList();
    }

    private ArrayList<String> initDisplayList() {
        ArrayList<CallSite> termNamedisplayList = new ArrayList<CallSite>();
        ArrayList<String> accDisplayList = new ArrayList<String>();
        ArrayList<GOTerm> allTerms = new ArrayList<GOTerm>(this.clsToTerm.values());
        Collections.sort(allTerms, new Comparator<GOTerm>(){

            @Override
            public int compare(GOTerm term1, GOTerm term2) {
                String name1 = term1.getName();
                String name2 = term2.getName();
                if (null == name1 || null == name2) {
                    return term1.getAcc().compareTo(term2.getAcc());
                }
                return name1.compareTo(name2);
            }
        });
        for (GOTerm goTerm : allTerms) {
            if (this.topLevelTerms.contains(goTerm) || NON_ALLOWED_TERM_SET.contains(goTerm.getAcc())) continue;
            String display = goTerm.getName();
            termNamedisplayList.add((CallSite)((Object)(display + DELIM_TERM + goTerm.getAcc())));
            accDisplayList.add(goTerm.getAcc() + DELIM_TERM + display);
        }
        Collections.sort(accDisplayList);
        accDisplayList.addAll(termNamedisplayList);
        return accDisplayList;
    }

    public GOTerm getTerm(String goId) {
        if (null == goId || null == this.clsToTerm) {
            return null;
        }
        return this.clsToTerm.get(goId);
    }

    public ArrayList<GOTerm> getAncestors(GOTerm term) {
        ArrayList<GOTerm> parents = new ArrayList<GOTerm>();
        this.getUniqueAncestors(term, parents);
        return parents;
    }

    private void getUniqueAncestors(GOTerm term, ArrayList<GOTerm> parents) {
        List<GOTerm> curParents = term.getParents();
        if (null == curParents) {
            return;
        }
        for (GOTerm parent : curParents) {
            if (parents.contains(parent) || !term.aspectSame(parent)) continue;
            parents.add(parent);
            this.getUniqueAncestors(parent, parents);
        }
    }

    public ArrayList<GOTerm> getAncestorsDoNotUse(GOTerm term) {
        ArrayList<GOTerm> parents = new ArrayList<GOTerm>();
        this.getUniqueAncestorsDoNotUse(term, parents);
        return parents;
    }

    private void getUniqueAncestorsDoNotUse(GOTerm term, ArrayList<GOTerm> parents) {
        List<GOTerm> curParents = term.getParents();
        if (null == curParents) {
            return;
        }
        for (GOTerm parent : curParents) {
            if (parents.contains(parent)) continue;
            parents.add(parent);
            this.getUniqueAncestorsDoNotUse(parent, parents);
        }
    }

    public HashSet<GOTerm> getDescendants(GOTerm term) {
        HashSet<GOTerm> children = new HashSet<GOTerm>();
        this.getUniqueChildren(term, children);
        return children;
    }

    private void getUniqueChildren(GOTerm term, HashSet<GOTerm> children) {
        List<GOTerm> curChildren = term.getChildren();
        if (null == curChildren) {
            return;
        }
        for (GOTerm child : curChildren) {
            if (children.contains(child) && !term.aspectSame(child)) continue;
            children.add(child);
            this.getUniqueChildren(child, children);
        }
    }

    public HashSet<GOTerm> getChildrenDoNotUse(GOTerm term) {
        HashSet<GOTerm> children = new HashSet<GOTerm>();
        this.getUniqueChildrenDoNotUse(term, children);
        return children;
    }

    private void getUniqueChildrenDoNotUse(GOTerm term, HashSet<GOTerm> children) {
        List<GOTerm> curChildren = term.getChildren();
        if (null == curChildren) {
            return;
        }
        for (GOTerm child : curChildren) {
            if (children.contains(child)) continue;
            children.add(child);
            this.getUniqueChildrenDoNotUse(child, children);
        }
    }

    public GOTermHelper() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public GOTerm getMolecularFunctionRoot() {
        for (int i = 0; i < this.topLevelTerms.size(); ++i) {
            GOTerm c = this.topLevelTerms.get(i);
            if (!c.getAcc().equals("GO:0003674")) continue;
            return c;
        }
        return null;
    }

    public GOTerm getBiologicalProcessRoot() {
        for (int i = 0; i < this.topLevelTerms.size(); ++i) {
            GOTerm c = this.topLevelTerms.get(i);
            if (!c.getAcc().equals("GO:0008150")) continue;
            return c;
        }
        return null;
    }

    public GOTerm getCellularComponentRoot() {
        for (int i = 0; i < this.topLevelTerms.size(); ++i) {
            GOTerm c = this.topLevelTerms.get(i);
            if (!c.getAcc().equals("GO:0005575")) continue;
            return c;
        }
        return null;
    }

    public static HashMap<String, ArrayList<ArrayList<GOTerm>>> organizeTerms(ArrayList<GOTerm> goTermList) {
        if (null == goTermList) {
            return null;
        }
        HashMap<String, ArrayList<ArrayList<GOTerm>>> lookup = new HashMap<String, ArrayList<ArrayList<GOTerm>>>();
        HashMap<String, ArrayList<GOTerm>> termLookup = new HashMap<String, ArrayList<GOTerm>>();
        for (int i = 0; i < goTermList.size(); ++i) {
            GOTerm term = goTermList.get(i);
            String aspect = term.getAspect();
            ArrayList<GOTerm> termList = (ArrayList<GOTerm>)termLookup.get(aspect);
            if (null == termList) {
                termList = new ArrayList<GOTerm>();
                termLookup.put(aspect, termList);
            }
            termList.add(term);
        }
        Set aspectSet = termLookup.keySet();
        for (String aspect : aspectSet) {
            ArrayList<ArrayList<GOTerm>> group = new ArrayList<ArrayList<GOTerm>>();
            lookup.put(aspect, group);
            ArrayList termList = (ArrayList)termLookup.get(aspect);
            while (termList.size() > 0) {
                ArrayList<GOTerm> groupList = new ArrayList<GOTerm>();
                GOTerm curTerm = (GOTerm)termList.remove(0);
                groupList.add(curTerm);
                GOTermHelper.addAncestors(groupList, 0, termList);
                group.add(groupList);
            }
        }
        return lookup;
    }

    private static void addAncestors(ArrayList<GOTerm> groupList, int index, ArrayList<GOTerm> termList) {
        if (index < 0 || index > groupList.size()) {
            return;
        }
        GOTerm curTerm = groupList.get(index);
        List<GOTerm> parents = curTerm.getParents();
        if (null == parents) {
            return;
        }
        int counter = index + 1;
        boolean added = false;
        for (int i = 0; i < parents.size(); ++i) {
            GOTerm parent = parents.get(i);
            int parentIndex = termList.indexOf(parent);
            if (parentIndex < 0) continue;
            groupList.add(counter, termList.remove(parentIndex));
            ++counter;
            added = true;
        }
        if (added && termList.size() > 0) {
            GOTermHelper.addAncestors(groupList, ++index, termList);
        }
    }

    public HashSet<Qualifier> getValidQualifiersForTerm(GOTerm term, HashSet<Qualifier> qualifierSet) {
        if (null == qualifierSet) {
            return null;
        }
        HashSet<Qualifier> rtnSet = new HashSet<Qualifier>();
        for (Qualifier q : qualifierSet) {
            if (!this.isQualifierValidForTerm(term, q)) continue;
            rtnSet.add(q);
        }
        if (rtnSet.isEmpty()) {
            return null;
        }
        return rtnSet;
    }

    public boolean canTermHaveQualifier(GOTerm term, String qualifier) {
        if (null == qualifier) {
            return true;
        }
        if ("NOT".equalsIgnoreCase(qualifier)) {
            return true;
        }
        String aspect = term.getAspect();
        if (null == aspect) {
            return false;
        }
        if (!ASPECT_MF.equalsIgnoreCase(aspect) && "CONTRIBUTES_TO".equalsIgnoreCase(qualifier)) {
            return false;
        }
        return false != ASPECT_CC.equalsIgnoreCase(aspect) || true != "COLOCALIZES_WITH".equalsIgnoreCase(qualifier);
    }

    public boolean isQualifierValidForTerm(GOTerm term, Qualifier q) {
        return this.canTermHaveQualifier(term, q.getText());
    }

    public static boolean isAnnotAllowedForTerm(String term) {
        if (null == term) {
            return false;
        }
        return true != NON_ALLOWED_TERM_SET.contains(term);
    }

    public ArrayList<GOTerm> getAllTerms() {
        return new ArrayList<GOTerm>(this.clsToTerm.values());
    }

    public ArrayList<String> getDisplayList() {
        return (ArrayList)this.DISPLAY_LIST.clone();
    }
}

