/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paintCommon;

import edu.usc.ksom.pm.panther.paintCommon.IWith;
import edu.usc.ksom.pm.panther.paintCommon.NodeStaticInfo;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Node
implements Serializable,
IWith {
    private NodeStaticInfo staticInfo;
    private NodeVariableInfo variableInfo;

    public NodeStaticInfo getStaticInfo() {
        return this.staticInfo;
    }

    public void setStaticInfo(NodeStaticInfo staticInfo) {
        this.staticInfo = staticInfo;
    }

    public NodeVariableInfo getVariableInfo() {
        return this.variableInfo;
    }

    public void setVariableInfo(NodeVariableInfo variableInfo) {
        this.variableInfo = variableInfo;
    }

    public static List<Node> getAncestors(Node n) {
        Node copy = n;
        ArrayList<Node> ancestors = new ArrayList<Node>();
        Node.getAncestor(copy, ancestors);
        return ancestors;
    }

    private static void getAncestor(Node n, List<Node> ancestors) {
        NodeStaticInfo nsi = n.getStaticInfo();
        if (null == nsi) {
            return;
        }
        Node parent = nsi.getParent();
        if (null == parent) {
            return;
        }
        ancestors.add(parent);
        Node.getAncestor(parent, ancestors);
    }

    public static void getDescendants(Node n, List<Node> nodeList) {
        if (null == n || null == nodeList) {
            return;
        }
        NodeStaticInfo nsi = n.getStaticInfo();
        ArrayList<Node> children = nsi.getChildren();
        if (null != children) {
            for (Node child : children) {
                nodeList.add(child);
                Node.getDescendants(child, nodeList);
            }
        }
    }

    public static void getNonPrunedDescendants(Node n, ArrayList<Node> nodeList) {
        if (null == n || null == nodeList) {
            return;
        }
        NodeStaticInfo nsi = n.getStaticInfo();
        ArrayList<Node> children = nsi.getChildren();
        if (null != children) {
            for (Node child : children) {
                NodeVariableInfo nvi = child.getVariableInfo();
                if (null != nvi && nvi.isPruned()) {
                    return;
                }
                nodeList.add(child);
                Node.getNonPrunedDescendants(child, nodeList);
            }
        }
    }

    public static ArrayList<Node> getAllNonPrunedLeaves(Node n) {
        ArrayList<Node> descendants = new ArrayList<Node>();
        Node copy = n;
        Node.getNonPrunedDescendants(copy, descendants);
        ArrayList<Node> leaves = new ArrayList<Node>();
        for (Node desc : descendants) {
            NodeStaticInfo nsi = desc.getStaticInfo();
            ArrayList<Node> children = nsi.getChildren();
            if (null != children && !children.isEmpty()) continue;
            leaves.add(desc);
        }
        return leaves;
    }

    public static Node getRoot(Node n) {
        Node copy = n;
        return Node.getTreeRoot(copy);
    }

    private static Node getTreeRoot(Node n) {
        Node parent = n.getStaticInfo().getParent();
        if (null == parent) {
            return n;
        }
        return Node.getTreeRoot(parent);
    }
}

