/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paintCommon;

import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class QualifierDif {
    public static final int QUALIFIERS_SAME = 0;
    public static final int QUALIFIERS_DIFFERENT = 1;
    private int difference;
    private HashSet<Qualifier> differentSet;

    public QualifierDif(HashSet<Qualifier> set1, HashSet<Qualifier> set2) {
        if (null == set1 && null != set2 && 0 != set2.size() || null == set2 && null != set1 && 0 != set1.size()) {
            this.difference = 1;
            return;
        }
        if (null == set1 && null == set2 || null == set1 && 0 == set2.size() || 0 == set1.size() && null == set2 || 0 == set1.size() && 0 == set2.size()) {
            this.difference = 0;
            return;
        }
        if (null == set1 && null != set2) {
            this.differentSet = new HashSet();
            this.differentSet.addAll(set2);
            this.difference = this.calculateDifference();
            return;
        }
        if (null == set2 && null != set1) {
            this.differentSet = new HashSet();
            this.differentSet.addAll(set1);
            this.difference = this.calculateDifference();
            return;
        }
        if (QualifierDif.allQualifiersSame(set1, set2)) {
            this.difference = 0;
            return;
        }
        this.difference = 1;
    }

    public QualifierDif() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getDifference() {
        return this.difference;
    }

    public static HashSet<Qualifier> getUniqueQualifiers(HashSet<Qualifier> qualifierSet) {
        if (null == qualifierSet || 0 == qualifierSet.size()) {
            return null;
        }
        HashSet<Qualifier> uniqueSet = new HashSet<Qualifier>();
        HashSet<String> handled = new HashSet<String>();
        boolean nullHandled = false;
        for (Qualifier q : qualifierSet) {
            if (null == q.getText()) {
                if (nullHandled) continue;
                nullHandled = true;
                uniqueSet.add(q);
                continue;
            }
            String curText = q.getText();
            if (handled.contains(curText)) continue;
            uniqueSet.add(q);
            handled.add(curText);
        }
        if (uniqueSet.isEmpty()) {
            return null;
        }
        return uniqueSet;
    }

    private int calculateDifference() {
        if (null == this.differentSet || 0 == this.differentSet.size()) {
            return 0;
        }
        return 1;
    }

    public static boolean contains(HashSet<Qualifier> set1, HashSet<Qualifier> set2) {
        if (null == set2) {
            return true;
        }
        if (null == set1 && set2.size() > 0) {
            return false;
        }
        if (null == set1 && set2.size() == 0) {
            return true;
        }
        if (null == set1 && null == set2) {
            return true;
        }
        for (Qualifier q1 : set1) {
            String text1 = q1.getText();
            boolean found = false;
            for (Qualifier q2 : set2) {
                String text2 = q2.getText();
                if (null != text1 && text1.equals(text2)) {
                    found = true;
                    break;
                }
                if (null != text1 || null != text2) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static void addIfNotPresent(HashSet<Qualifier> addSet, HashSet<Qualifier> toBeAddedSet) {
        if (null == addSet || null == toBeAddedSet) {
            return;
        }
        for (Qualifier q : toBeAddedSet) {
            QualifierDif.addIfNotPresent(addSet, q);
        }
    }

    public static Qualifier find(HashSet<Qualifier> set, Qualifier q) {
        if (null == set || null == q) {
            return null;
        }
        String qText = q.getText();
        for (Qualifier listQualifier : set) {
            String curText = listQualifier.getText();
            if (null == curText && null == q.getText()) {
                return listQualifier;
            }
            if (null == curText && null != qText || null != curText && null == qText || !curText.equals(qText)) continue;
            return listQualifier;
        }
        return null;
    }

    public static void addIfNotPresent(HashSet<Qualifier> set, Qualifier q) {
        String qText = q.getText();
        for (Qualifier listQualifier : set) {
            String curText = listQualifier.getText();
            if (null == curText && null == q.getText()) {
                return;
            }
            if (null == curText && null != qText || null != curText && null == qText || !curText.equals(qText)) continue;
            return;
        }
        set.add(q);
    }

    public static boolean exists(HashSet<Qualifier> set, Qualifier q) {
        if (null == set && null != q) {
            return false;
        }
        if (null == q) {
            return true;
        }
        String qText = q.getText();
        for (Qualifier listQualifier : set) {
            String curText = listQualifier.getText();
            if (null == curText && null == q.getText()) {
                return true;
            }
            if (null == curText && null != qText || null != curText && null == qText || !curText.equals(qText)) continue;
            return true;
        }
        return false;
    }

    public static boolean allPositive(Set<Qualifier> qualifierSet) {
        if (null == qualifierSet) {
            return true;
        }
        for (Qualifier qualifier : qualifierSet) {
            if (!qualifier.isNot()) continue;
            return false;
        }
        return true;
    }

    public static boolean allNot(HashSet<Qualifier> qualifierSet) {
        for (Qualifier qualifier : qualifierSet) {
            if (qualifier.isNot()) continue;
            return false;
        }
        return true;
    }

    public static boolean containsPositive(HashSet<Qualifier> qualifierSet) {
        if (null == qualifierSet) {
            return false;
        }
        for (Qualifier qualifier : qualifierSet) {
            if (qualifier.isNot()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNegative(Set<Qualifier> qualifierSet) {
        if (null == qualifierSet) {
            return false;
        }
        for (Qualifier qualifier : qualifierSet) {
            if (!qualifier.isNot()) continue;
            return true;
        }
        return false;
    }

    public static Qualifier getNOT(HashSet<Qualifier> qualifierSet) {
        if (null == qualifierSet) {
            return null;
        }
        for (Qualifier qualifier : qualifierSet) {
            if (!qualifier.isNot()) continue;
            return qualifier;
        }
        return null;
    }

    public static boolean allQualifiersSame(Set<Qualifier> set1, Set<Qualifier> set2) {
        if (null == set1 && null == set2 || null != set1 && 0 == set1.size() && null != set2 && 0 == set2.size()) {
            return true;
        }
        if (null == set1 && null != set2 && 0 != set2.size() || null != set1 && set1.size() != 0 && null == set2) {
            return false;
        }
        if (null == set1 && null != set2 && 0 == set2.size() || null != set1 && set1.size() == 0 && null == set2) {
            return true;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        HashSet<Qualifier> copy2 = new HashSet<Qualifier>();
        copy2.addAll(set2);
        for (Qualifier q1 : set1) {
            boolean found = false;
            Iterator q2Iter = copy2.iterator();
            while (q2Iter.hasNext()) {
                if (!q1.getText().equals(((Qualifier)q2Iter.next()).getText())) continue;
                found = true;
                q2Iter.remove();
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean differenceIsNOTQualifier(HashSet<Qualifier> propagatorQset, HashSet<Qualifier> newQSet) {
        if (!QualifierDif.areOpposite(propagatorQset, newQSet)) {
            return false;
        }
        if (QualifierDif.containsNegative(propagatorQset)) {
            HashSet<Qualifier> compSet = newQSet;
            if (compSet == null) {
                compSet = new HashSet();
            }
            Qualifier not = new Qualifier();
            not.setText("NOT");
            compSet.add(not);
            return false != QualifierDif.allQualifiersSame(propagatorQset, compSet);
        }
        HashSet<Qualifier> compSet = propagatorQset;
        if (compSet == null) {
            compSet = new HashSet();
        }
        Qualifier not = new Qualifier();
        not.setText("NOT");
        compSet.add(not);
        return false != QualifierDif.allQualifiersSame(newQSet, compSet);
    }

    public static boolean areOpposite(Set<Qualifier> set1, Set<Qualifier> set2) {
        if (null == set1 && null == set2) {
            return false;
        }
        if (null == set1 && null != set2) {
            return true == QualifierDif.containsNegative(set2);
        }
        if (null != set1 && null == set2) {
            return true == QualifierDif.containsNegative(set1);
        }
        return true == QualifierDif.allPositive(set1) && true == QualifierDif.containsNegative(set2) || true == QualifierDif.allPositive(set2) && true == QualifierDif.containsNegative(set1);
    }

    public static boolean containsOnlyOneNOT(HashSet<Qualifier> qualifierSet) {
        if (null == qualifierSet) {
            return false;
        }
        if (1 != qualifierSet.size()) {
            return false;
        }
        Iterator<Qualifier> iterator = qualifierSet.iterator();
        if (iterator.hasNext()) {
            Qualifier q = iterator.next();
            return true == q.isNot();
        }
        return false;
    }

    public static String getQualifierString(Set<Qualifier> qSet) {
        if (null == qSet) {
            return null;
        }
        if (qSet.isEmpty()) {
            return null;
        }
        ArrayList<String> qList = new ArrayList<String>(qSet.size());
        for (Qualifier q : qSet) {
            String text = q.getText();
            if (null == text || 0 == text.length()) continue;
            qList.add(text);
        }
        if (qList.isEmpty()) {
            return null;
        }
        Collections.sort(qList);
        return String.join((CharSequence)",", qList);
    }
}

