/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paintCommon;

import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import edu.usc.ksom.pm.panther.paintCommon.QualifierDif;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class TaxonomyHelper
implements Serializable {
    private LinkedHashMap<String, Integer> speciesToIndex;
    private LinkedHashMap<String, Integer> termToIndex;
    private int[][] valuesLookup;
    private boolean checkTaxonomy = true;

    public TaxonomyHelper(LinkedHashMap<String, Integer> speciesToIndex, LinkedHashMap<String, Integer> termToIndex, int[][] valuesLookup, boolean checkTaxonomy) {
        this.speciesToIndex = speciesToIndex;
        this.termToIndex = termToIndex;
        this.valuesLookup = valuesLookup;
        this.checkTaxonomy = checkTaxonomy;
    }

    public Set<String> getSupportedSpecies() {
        return new HashSet<String>(this.speciesToIndex.keySet());
    }

    public Set<String> getSupportedTerms() {
        return new HashSet<String>(this.termToIndex.keySet());
    }

    public TaxonomyHelper() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isTermAndQualifierValidForSpecies(String term, String species, Set<Qualifier> qSet) {
        if (!this.checkTaxonomy) {
            return true;
        }
        if (QualifierDif.containsNegative(qSet)) {
            return true;
        }
        return this.isTermValidForSpecies(term, species, true);
    }

    public boolean termAndQualifierValidForSpeciesCheckTaxonomy(String term, String species, Set<Qualifier> qSet) {
        if (QualifierDif.containsNegative(qSet)) {
            return true;
        }
        return this.isTermValidForSpecies(term, species, false);
    }

    private boolean isTermValidForSpecies(String term, String species, boolean useTaxonomyFlg) {
        if (useTaxonomyFlg && !this.checkTaxonomy) {
            return true;
        }
        if (null == species) {
            return true;
        }
        if (null == term) {
            return false;
        }
        Integer row = this.termToIndex.get(term);
        if (null == row) {
            System.out.println("TAXON ERROR - DID NOT FIND TERM " + term);
            return true;
        }
        Integer column = this.speciesToIndex.get(species);
        if (null == column) {
            System.out.println("TAXON ERROR - DID NOT FIND SPECIES " + species);
            return false;
        }
        if (row >= this.valuesLookup.length || column >= this.valuesLookup[row].length) {
            return false;
        }
        int value = this.valuesLookup[row][column];
        return value > 0;
    }

    public boolean isCheckingTaxonomy() {
        return this.checkTaxonomy;
    }
}

