/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paintCommon;

import edu.usc.ksom.pm.panther.paintCommon.VersionInfo;
import java.io.Serializable;
import java.util.HashMap;

public class VersionContainer
implements Serializable {
    public static final String COMP_OBJ_IS_NULL = "No Comparision information";
    public static final String COMP_OBJ_HAS_FEWER_ENTRIES = "Comparision information has fewer entries";
    public static final String COMP_OBJ_HAS_MORE_ENTRIES = "Comparision information has more entries";
    public static final String COMP_OBJ_DOES_NOT_HAVE_ENTRY_FOR = "Comparision information does not have version information for ";
    public static final String REF_OBJ_HAS_ENTRY_FOR = "Reference information does not have version information for ";
    public static final String DOWNLOAD_NEW_VERSION = "Download new version from server, ";
    public static final String COMP_OBJ_HAS_DIFFERENT_VERSION_INFORMATION_FOR = "Download new version from server, Found different version information for ";
    public static final String NOT_FOUND = " not found";
    public static final VersionedObj[] serverCompObjs = new VersionedObj[]{VersionedObj.CLIENT_SERVER_COMMON_VERSION, VersionedObj.FULL_GO_VERSION, VersionedObj.PANTHER_VERSION, VersionedObj.CLS_VERSION};
    HashMap<VersionedObj, VersionInfo> versionLookup = new HashMap();

    public boolean addInfo(VersionedObj vo, VersionInfo vi) {
        if (null == vo || null == vi) {
            return false;
        }
        this.versionLookup.put(vo, vi);
        return true;
    }

    public VersionInfo get(VersionedObj vo) {
        if (null == vo) {
            return null;
        }
        return this.versionLookup.get((Object)vo);
    }

    public String compareTo(Object o) {
        int compSize;
        if (null == o) {
            return COMP_OBJ_IS_NULL;
        }
        VersionContainer comp = (VersionContainer)o;
        int curSize = this.versionLookup.size();
        if (curSize > (compSize = comp.versionLookup.size())) {
            return COMP_OBJ_HAS_FEWER_ENTRIES;
        }
        if (curSize < compSize) {
            return COMP_OBJ_HAS_MORE_ENTRIES;
        }
        for (VersionedObj vo : this.versionLookup.keySet()) {
            VersionInfo vi = this.versionLookup.get((Object)vo);
            VersionInfo compObj = comp.versionLookup.get((Object)vo);
            if (null == compObj) {
                return COMP_OBJ_DOES_NOT_HAVE_ENTRY_FOR + vo.name();
            }
            String compInfo = vi.compareTo(compObj);
            if (null == compInfo) continue;
            return vo.name() + " " + compInfo;
        }
        return null;
    }

    public String compareForServerOps(VersionContainer comp) {
        for (VersionedObj vo : serverCompObjs) {
            String compInfo = this.compareVersoinedObj(comp, vo);
            if (null == compInfo) continue;
            return compInfo;
        }
        return null;
    }

    public String compareVersoinedObj(VersionContainer comp, VersionedObj vo) {
        VersionInfo versionObj = this.versionLookup.get((Object)vo);
        if (null == versionObj) {
            return DOWNLOAD_NEW_VERSION + vo.name() + NOT_FOUND;
        }
        if (null != versionObj && null != versionObj.compareTo(comp.get(vo))) {
            return COMP_OBJ_HAS_DIFFERENT_VERSION_INFORMATION_FOR + vo.name();
        }
        return null;
    }

    public static boolean VersionContainersEqual(VersionContainer vc1, VersionContainer vc2) {
        if (null == vc1 && null == vc2) {
            return true;
        }
        if (null == vc1 && null != vc2 || null != vc1 && null == vc2) {
            return false;
        }
        return vc1.equals(vc2);
    }

    public static enum VersionedObj {
        CLIENT_VERSION,
        CLIENT_SERVER_COMMON_VERSION,
        SERVER_VERSION,
        CLS_VERSION,
        FULL_GO_VERSION,
        PANTHER_VERSION;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

