/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paintCommon;

import com.sri.panther.paintCommon.util.StringUtils;
import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.AnnotationDetail;
import edu.usc.ksom.pm.panther.paintCommon.DBReference;
import edu.usc.ksom.pm.panther.paintCommon.Evidence;
import edu.usc.ksom.pm.panther.paintCommon.IWith;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeStaticInfo;
import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import edu.usc.ksom.pm.panther.paintCommon.QualifierDif;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class WithEvidence
implements Serializable {
    private String evidenceCodeid;
    private String evidenceCode;
    private String evidenceType;
    private String evidenceId;
    public static final String EVIDENCE_TYPE_ANNOT_PAINT_REF = "PAINT_REF";
    public static final String EVIDENCE_TYPE_ANNOT_PAINT_EXP = "PAINT_EXP";
    public static final String EVIDENCE_TYPE_ANNOT_PAINT_ANCESTOR = "PAINT_ANCESTOR";
    public static final String EVIDENCE_TYPE_ANNOT_PAINT_PMID = "PMID";
    private static final HashSet<String> PAINT_EVIDENCE_TYPE_SET = WithEvidence.initPaintEvidenceTypes();
    private IWith with;

    public String getEvidenceCodeid() {
        return this.evidenceCodeid;
    }

    public void setEvidenceCodeid(String evidenceCodeid) {
        this.evidenceCodeid = evidenceCodeid;
    }

    public String getEvidenceCode() {
        return this.evidenceCode;
    }

    public void setEvidenceCode(String evidenceCode) {
        this.evidenceCode = evidenceCode;
    }

    public String getEvidenceId() {
        return this.evidenceId;
    }

    public void setEvidenceId(String evidenceId) {
        this.evidenceId = evidenceId;
    }

    public String getEvidenceType() {
        return this.evidenceType;
    }

    public void setEvidenceType(String evidenceType) {
        this.evidenceType = evidenceType;
    }

    public IWith getWith() {
        return this.with;
    }

    public void setWith(IWith with) {
        this.with = with;
    }

    public boolean isExperimental() {
        return Evidence.isExperimental(this.evidenceCode);
    }

    public boolean equals(WithEvidence we) {
        if (null != this.evidenceCode && null != we.evidenceCode && false == this.evidenceCode.equals(we.evidenceCode) || null != this.evidenceCode && null == we.evidenceCode || null == this.evidenceCode && null != we.evidenceCode) {
            return false;
        }
        if (null == this.with && null != we.with || null != this.with && null == we.with) {
            return false;
        }
        if (null == this.with && null == we.with) {
            return true;
        }
        if (!this.with.getClass().toString().equals(we.with.getClass().toString())) {
            return false;
        }
        if (this.with instanceof Node) {
            return this.equals((Node)this.with, (Node)we.with);
        }
        if (this.with instanceof DBReference) {
            return this.equals((DBReference)this.with, (DBReference)we.with);
        }
        return this.equals((Annotation)this.with, (Annotation)we.with);
    }

    public boolean equals(Node n1, Node n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        if (n1 == null && n2 != null || n1 != null && n2 == null) {
            return false;
        }
        NodeStaticInfo nsi1 = n1.getStaticInfo();
        NodeStaticInfo nsi2 = n2.getStaticInfo();
        if (null == nsi1 && null == nsi2) {
            return true;
        }
        if (null == nsi1 && null != nsi2 || null != nsi1 && null == nsi2) {
            return false;
        }
        String id = nsi1.getPublicId();
        if (null != id && id.equals(nsi2.getPublicId())) {
            return true;
        }
        String acc = nsi1.getNodeAcc();
        return null != acc && true == acc.equals(nsi2.getNodeAcc());
    }

    private boolean equals(DBReference db1, DBReference db2) {
        if (!StringUtils.stringsSame(db1.getEvidenceType(), db2.getEvidenceType())) {
            return false;
        }
        return false != StringUtils.stringsSame(db1.getEvidenceValue(), db2.getEvidenceValue());
    }

    private boolean equals(Annotation a1, Annotation a2) {
        HashSet withAnnot2;
        if (null != a1.getGoTerm() && null != a2 && !a1.getGoTerm().equals(a2.getGoTerm())) {
            return false;
        }
        QualifierDif qf = new QualifierDif(a1.getQualifierSet(), a2.getQualifierSet());
        if (qf.getDifference() != 0) {
            return false;
        }
        AnnotationDetail ad1 = a1.getAnnotationDetail();
        AnnotationDetail ad2 = a2.getAnnotationDetail();
        if (!this.equals(ad1.getAnnotatedNode(), ad2.getAnnotatedNode())) {
            return false;
        }
        HashSet withAnnot1 = ad1.getWithAnnotSet();
        if (null != withAnnot1) {
            withAnnot1 = (HashSet)withAnnot1.clone();
            withAnnot1.remove(a1);
        }
        if (null != (withAnnot2 = ad2.getWithAnnotSet())) {
            withAnnot2 = (HashSet)withAnnot2.clone();
            withAnnot2.remove(a2);
        }
        if (!this.annotSetEquals(withAnnot1, withAnnot2)) {
            return false;
        }
        if (!this.linkedHashMapsSame(ad1.getInheritedQualifierLookup(), ad2.getInheritedQualifierLookup(), a1, a2)) {
            return false;
        }
        if (!this.linkedHashMapsSame(ad1.getAddedQualifierLookup(), ad2.getAddedQualifierLookup(), a1, a2)) {
            return false;
        }
        if (!this.linkedHashMapsSame(ad1.getRemovedQualifierLookup(), ad2.getRemovedQualifierLookup(), a1, a2)) {
            return false;
        }
        if (!this.nodeSetEquals(ad1.getWithNodeSet(), ad2.getWithNodeSet())) {
            return false;
        }
        return false != this.dbRefSetEquals(ad1.getWithOtherSet(), ad2.getWithOtherSet());
    }

    private boolean nodeSetEquals(HashSet<Node> set1, HashSet<Node> set2) {
        boolean found;
        if (null == set1 && null == set2) {
            return true;
        }
        if (set1 != null && set2 == null || set1 == null && set2 != null) {
            return false;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        block0: for (Node n1 : set1) {
            found = false;
            for (Node n2 : set2) {
                if (this.equals(n1, n2)) {
                    found = true;
                    continue block0;
                }
                if (found) continue;
                return false;
            }
        }
        for (Node n2 : set2) {
            found = false;
            for (Node n1 : set1) {
                if (!this.equals(n1, n2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean dbRefSetEquals(HashSet<DBReference> set1, HashSet<DBReference> set2) {
        boolean found;
        if (null == set1 && null == set2) {
            return true;
        }
        if (set1 != null && set2 == null || set1 == null && set2 != null) {
            return false;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        for (DBReference dbRef1 : set1) {
            found = false;
            for (DBReference dbRef2 : set2) {
                if (!this.equals(dbRef1, dbRef2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        for (DBReference dbRef2 : set2) {
            found = false;
            for (DBReference dbRef1 : set1) {
                if (!this.equals(dbRef1, dbRef2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean annotSetEquals(HashSet<Annotation> set1, HashSet<Annotation> set2) {
        boolean found;
        if (null == set1 && null == set2) {
            return true;
        }
        if (set1 != null && set2 == null || set1 == null && set2 != null) {
            return false;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        for (Annotation a1 : set1) {
            found = false;
            for (Annotation a2 : set2) {
                if (!this.equals(a1, a2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        for (Annotation a2 : set2) {
            found = false;
            for (Annotation a1 : set1) {
                if (!this.equals(a1, a2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean linkedHashMapsSame(LinkedHashMap<Qualifier, HashSet<Annotation>> map1, LinkedHashMap<Qualifier, HashSet<Annotation>> map2, Annotation a1, Annotation a2) {
        Set<Qualifier> set2;
        HashSet<Qualifier> hSet2;
        if (null == map1 && null == map2) {
            return true;
        }
        if (map1 != null && map2 == null || map1 == null && map2 != null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        Set<Qualifier> set1 = map1.keySet();
        HashSet<Qualifier> hSet1 = new HashSet<Qualifier>(set1);
        QualifierDif qd = new QualifierDif(hSet1, hSet2 = new HashSet<Qualifier>(set2 = map2.keySet()));
        if (0 != qd.getDifference()) {
            return false;
        }
        for (Qualifier q1 : hSet1) {
            HashSet annotSet2;
            Qualifier q2 = QualifierDif.find(hSet2, q1);
            if (null == q2) {
                return false;
            }
            HashSet annotSet1 = map1.get(q1);
            if (null != annotSet1) {
                annotSet1 = (HashSet)annotSet1.clone();
                annotSet1.remove(a1);
            }
            if (null != (annotSet2 = map2.get(q2))) {
                annotSet2 = (HashSet)annotSet2.clone();
                annotSet2.remove(a2);
            }
            if (this.annotSetEquals(annotSet1, annotSet2)) continue;
            return false;
        }
        return true;
    }

    public static HashSet<String> initPaintEvidenceTypes() {
        HashSet<String> rtnSet = new HashSet<String>(3);
        rtnSet.add(EVIDENCE_TYPE_ANNOT_PAINT_REF);
        rtnSet.add(EVIDENCE_TYPE_ANNOT_PAINT_EXP);
        rtnSet.add(EVIDENCE_TYPE_ANNOT_PAINT_ANCESTOR);
        return rtnSet;
    }

    public static final HashSet<String> getPAINTEvidenceTypeSet() {
        return PAINT_EVIDENCE_TYPE_SET;
    }

    public static boolean isPAINTEvidenceType(HashSet<WithEvidence> withEvidenceSet) {
        if (null == withEvidenceSet) {
            return false;
        }
        for (WithEvidence we : withEvidenceSet) {
            String evidenceType = we.getEvidenceType();
            if (null == evidenceType || !PAINT_EVIDENCE_TYPE_SET.contains(evidenceType)) continue;
            return true;
        }
        return false;
    }

    public boolean isPAINTType() {
        if (null == this.evidenceType) {
            return false;
        }
        return PAINT_EVIDENCE_TYPE_SET.contains(this.evidenceType);
    }
}

