/*
 * Decompiled with CFR 0.152.
 */
package org.obo.annotation.datamodel.impl;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.annotation.datamodel.Annotation;
import org.obo.annotation.datamodel.AnnotationOntology;
import org.obo.datamodel.Datatype;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkLinkedObject;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.PropertyValue;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.Type;
import org.obo.datamodel.impl.DatatypeValueImpl;
import org.obo.datamodel.impl.InstanceImpl;
import org.obo.datamodel.impl.InstancePropertyValue;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.history.AddPropertyValueHistoryItem;
import org.obo.history.CompletesHistoryItem;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.history.DeletePropertyValueHistoryItem;
import org.obo.history.HistoryItem;
import org.obo.history.TermMacroHistoryItem;
import org.obo.util.TermUtil;

public class AnnotationImpl
extends InstanceImpl
implements Annotation {
    protected static final Logger logger = Logger.getLogger(AnnotationImpl.class);

    public AnnotationImpl(String id) {
        super(id, AnnotationOntology.ANNOTATION());
    }

    public AnnotationImpl(Instance instance) {
        super(instance.getID());
        this.setName(instance.getName());
        this.setNamespace(instance.getNamespace());
        this.setDefinition(instance.getDefinition());
        this.setComment(instance.getComment());
        for (Dbxref ref : instance.getDbxrefs()) {
            this.addDbxref(ref);
        }
        for (Synonym synonym : instance.getSynonyms()) {
            this.addSynonym(synonym);
        }
        for (Dbxref ref : instance.getDefDbxrefs()) {
            this.addDefDbxref(ref);
        }
        for (PropertyValue pv : instance.getPropertyValues()) {
            this.addPropertyValue(pv);
        }
        for (Link link : instance.getParents()) {
            Link newLink = (Link)link.clone();
            newLink.setChild(this);
            this.addParent(newLink);
        }
    }

    public AnnotationImpl(Instance instance, Link link) {
        this(instance);
        this.setSubject(link.getChild());
        this.setObject(link.getParent());
        this.setRelationship(link.getType());
    }

    @Override
    public Type<OBOClass> getType() {
        OBOClass type = super.getType();
        if (type == null) {
            type = AnnotationOntology.ANNOTATION();
        }
        return type;
    }

    @Override
    public LinkedObject getAssignedBy() {
        return (LinkedObject)TermUtil.getPropValue(this, AnnotationOntology.ASSIGNED_BY_REL());
    }

    @Override
    public Collection<LinkedObject> getEvidence() {
        return TermUtil.getPropValues(this, AnnotationOntology.EVIDENCE_REL());
    }

    @Override
    public Collection<String> getDescriptions() {
        return TermUtil.getPropValues(this, AnnotationOntology.DESCRIPTION_REL());
    }

    @Override
    public Link getPositedLink() {
        LinkLinkedObject llo = (LinkLinkedObject)TermUtil.getPropValue(this, AnnotationOntology.POSITS_REL(), LinkedObject.class, true);
        return llo.getLink();
    }

    @Override
    public LinkedObject getObject() {
        LinkLinkedObject lo = (LinkLinkedObject)TermUtil.getPropValue(this, AnnotationOntology.POSITS_REL(), LinkedObject.class, true);
        if (lo == null) {
            return null;
        }
        Link link = lo.getLink();
        return link.getParent();
    }

    @Override
    public OBOProperty getRelationship() {
        LinkLinkedObject lo = (LinkLinkedObject)TermUtil.getPropValue(this, AnnotationOntology.POSITS_REL(), LinkedObject.class, true);
        if (lo == null) {
            return null;
        }
        Link link = lo.getLink();
        return link.getType();
    }

    @Override
    public Collection<LinkedObject> getSources() {
        return TermUtil.getPropValues(this, AnnotationOntology.SOURCE_REL());
    }

    @Override
    public LinkedObject getSubject() {
        LinkLinkedObject lo = (LinkLinkedObject)TermUtil.getPropValue(this, AnnotationOntology.POSITS_REL(), LinkedObject.class, true);
        if (lo == null) {
            return null;
        }
        Link link = lo.getLink();
        return link.getChild();
    }

    @Override
    public boolean getIsNegated() {
        String isNegatedStr = (String)TermUtil.getPropValue(this, AnnotationOntology.IS_NEGATED());
        if (isNegatedStr != null) {
            return isNegatedStr.equals("true");
        }
        return false;
    }

    @Override
    public HistoryItem getAssignedByChangeItem(LinkedObject assignedBy) {
        TermMacroHistoryItem item = new TermMacroHistoryItem();
        LinkedObject oldAssignedBy = this.getAssignedBy();
        return item;
    }

    @Override
    public HistoryItem addEvidenceHistoryItem(LinkedObject evidence) {
        return new CreateLinkHistoryItem(this, AnnotationOntology.EVIDENCE_REL(), evidence);
    }

    @Override
    public HistoryItem removeEvidenceHistoryItem(LinkedObject evidence) {
        return new DeleteLinkHistoryItem(evidence.getID(), this.getID(), AnnotationOntology.EVIDENCE_REL().getID());
    }

    @Override
    public HistoryItem getObjectChangeItem(LinkedObject object) {
        LinkLinkedObject lo = (LinkLinkedObject)TermUtil.getPropValue(this, AnnotationOntology.POSITS_REL(), LinkedObject.class, true);
        Link link = lo.getLink();
        TermMacroHistoryItem item = new TermMacroHistoryItem();
        DeletePropertyValueHistoryItem delitem = new DeletePropertyValueHistoryItem(this.getID(), AnnotationOntology.POSITS_REL().getID(), null, link.getID());
        DeleteLinkHistoryItem delLinkItem = new DeleteLinkHistoryItem(link);
        Link newLink = (Link)link.clone();
        newLink.setParent(object);
        CreateLinkHistoryItem copyItem = new CreateLinkHistoryItem(newLink.getChild().getID(), newLink.getType().getID(), newLink.getParent().getID());
        item.addItem(delitem);
        item.addItem(delLinkItem);
        item.addItem(copyItem);
        if (TermUtil.isIntersection(link)) {
            item.addItem(new CompletesHistoryItem((OBORestriction)newLink));
        }
        CreateLinkHistoryItem positsItem = new CreateLinkHistoryItem(this.getID(), AnnotationOntology.POSITS_REL().getID(), newLink.getID());
        item.addItem(positsItem);
        return item;
    }

    @Override
    public HistoryItem getSubjectChangeItem(LinkedObject subject) {
        LinkLinkedObject lo = (LinkLinkedObject)TermUtil.getPropValue(this, AnnotationOntology.POSITS_REL(), LinkedObject.class, true);
        Link link = lo.getLink();
        TermMacroHistoryItem item = new TermMacroHistoryItem();
        DeletePropertyValueHistoryItem delitem = new DeletePropertyValueHistoryItem(this.getID(), AnnotationOntology.POSITS_REL().getID(), null, link.getID());
        DeleteLinkHistoryItem delLinkItem = new DeleteLinkHistoryItem(link);
        Link newLink = (Link)link.clone();
        newLink.setChild(subject);
        CreateLinkHistoryItem copyItem = new CreateLinkHistoryItem(newLink.getChild().getID(), newLink.getType().getID(), newLink.getParent().getID());
        item.addItem(delitem);
        item.addItem(delLinkItem);
        item.addItem(copyItem);
        if (TermUtil.isIntersection(link)) {
            item.addItem(new CompletesHistoryItem((OBORestriction)newLink));
        }
        CreateLinkHistoryItem positsItem = new CreateLinkHistoryItem(this.getID(), AnnotationOntology.POSITS_REL().getID(), newLink.getID());
        item.addItem(positsItem);
        return item;
    }

    @Override
    public void setObject(LinkedObject object) {
        LinkLinkedObject lo = (LinkLinkedObject)TermUtil.getPropValue(this, AnnotationOntology.POSITS_REL(), LinkedObject.class, true);
        Link newLink = null;
        if (lo != null) {
            Link link = lo.getLink();
            newLink = (Link)link.clone();
            newLink.setParent(object);
            this.removePropertyValue(AnnotationOntology.POSITS_REL(), lo);
            if (link.getChild() != null) {
                link.getChild().removeParent(link);
            }
        } else {
            newLink = new OBORestrictionImpl((LinkedObject)null, null, object);
        }
        lo = new LinkLinkedObject(newLink);
        this.addPropertyValue(AnnotationOntology.POSITS_REL(), lo);
        if (newLink.getChild() != null) {
            newLink.getChild().addParent(newLink);
        }
    }

    @Override
    public HistoryItem getRelationshipChangeItem(OBOProperty relationship) {
        LinkLinkedObject lo = (LinkLinkedObject)TermUtil.getPropValue(this, AnnotationOntology.POSITS_REL(), LinkedObject.class, true);
        Link link = lo.getLink();
        TermMacroHistoryItem item = new TermMacroHistoryItem();
        DeletePropertyValueHistoryItem delitem = new DeletePropertyValueHistoryItem(this.getID(), AnnotationOntology.POSITS_REL().getID(), null, link.getID());
        DeleteLinkHistoryItem delLinkItem = new DeleteLinkHistoryItem(link);
        Link newLink = (Link)link.clone();
        newLink.setType(relationship);
        CreateLinkHistoryItem copyItem = new CreateLinkHistoryItem(newLink.getChild().getID(), newLink.getType().getID(), newLink.getParent().getID());
        item.addItem(delitem);
        item.addItem(delLinkItem);
        item.addItem(copyItem);
        if (TermUtil.isIntersection(link)) {
            item.addItem(new CompletesHistoryItem((OBORestriction)newLink));
        }
        CreateLinkHistoryItem positsItem = new CreateLinkHistoryItem(this.getID(), AnnotationOntology.POSITS_REL().getID(), newLink.getID());
        item.addItem(positsItem);
        return item;
    }

    public HistoryItem addSourceChangeItem(String source) {
        return new AddPropertyValueHistoryItem(this.getID(), AnnotationOntology.SOURCE_REL().getID(), Datatype.STRING.getID(), source);
    }

    @Override
    public HistoryItem addSourceChangeItem(LinkedObject source) {
        return new CreateLinkHistoryItem(this, AnnotationOntology.SOURCE_REL(), source);
    }

    public HistoryItem removeSourceChangeItem(String source) {
        return new DeletePropertyValueHistoryItem(this.getID(), AnnotationOntology.SOURCE_REL().getID(), Datatype.STRING.getID(), source);
    }

    @Override
    public HistoryItem removeSourceChangeItem(LinkedObject source) {
        return new DeleteLinkHistoryItem(source.getID(), this.getID(), AnnotationOntology.SOURCE_REL().getID());
    }

    @Override
    public void setAssignedBy(String assignedBy) {
        InstanceImpl i = new InstanceImpl(assignedBy, AnnotationOntology.AGENT());
        this.setAssignedBy(i);
    }

    @Override
    public void setAssignedBy(LinkedObject assignedBy) {
        for (Link link : this.getParents()) {
            if (link.getType() == null || !link.getType().equals(AnnotationOntology.ASSIGNED_BY_REL())) continue;
            this.removeParent(link);
            break;
        }
        if (assignedBy != null) {
            InstancePropertyValue link = new InstancePropertyValue(this, AnnotationOntology.ASSIGNED_BY_REL(), assignedBy);
            this.addParent(link);
        }
    }

    @Override
    public void addEvidence(LinkedObject evidence) {
        InstancePropertyValue link = new InstancePropertyValue(this, AnnotationOntology.EVIDENCE_REL(), evidence);
        this.addParent(link);
    }

    @Override
    public void removeEvidence(LinkedObject evidence) {
        InstancePropertyValue link = new InstancePropertyValue(this, AnnotationOntology.EVIDENCE_REL(), evidence);
        this.removeParent(link);
    }

    @Override
    public void addDescription(String desc) {
        InstancePropertyValue link = new InstancePropertyValue(this, AnnotationOntology.DESCRIPTION_REL(), new DatatypeValueImpl<String>(Datatype.STRING, desc));
        this.addParent(link);
    }

    @Override
    public void removeDescription(String desc) {
        InstancePropertyValue link = new InstancePropertyValue(this, AnnotationOntology.DESCRIPTION_REL(), new DatatypeValueImpl<String>(Datatype.STRING, desc));
        this.removeParent(link);
    }

    @Override
    public void addSource(String source) {
        InstanceImpl i = new InstanceImpl(source, AnnotationOntology.PUBLICATION());
        InstancePropertyValue link = new InstancePropertyValue(this, AnnotationOntology.SOURCE_REL(), i);
        this.addParent(link);
    }

    @Override
    public void addSource(LinkedObject source) {
        InstancePropertyValue link = new InstancePropertyValue(this, AnnotationOntology.SOURCE_REL(), source);
        this.addParent(link);
    }

    @Override
    public void removeSource(LinkedObject source) {
        InstancePropertyValue link = new InstancePropertyValue(this, AnnotationOntology.SOURCE_REL(), source);
        this.removeParent(link);
    }

    @Override
    public void setRelationship(OBOProperty relationship) {
        LinkLinkedObject lo = (LinkLinkedObject)TermUtil.getPropValue(this, AnnotationOntology.POSITS_REL(), LinkedObject.class, true);
        Link newLink = null;
        if (lo != null) {
            Link link = lo.getLink();
            newLink = (Link)link.clone();
            newLink.setType(relationship);
            this.removePropertyValue(AnnotationOntology.POSITS_REL(), lo);
            if (link.getChild() != null) {
                link.getChild().removeParent(link);
            }
        } else {
            newLink = new OBORestrictionImpl((LinkedObject)null, relationship, (LinkedObject)null);
        }
        lo = new LinkLinkedObject(newLink);
        this.addPropertyValue(AnnotationOntology.POSITS_REL(), lo);
        if (newLink.getChild() != null) {
            newLink.getChild().addParent(newLink);
        }
    }

    @Override
    public void setSubject(LinkedObject subject) {
        LinkedObject o = TermUtil.getPropValue(this, AnnotationOntology.POSITS_REL(), LinkedObject.class, true);
        if (o != null && !(o instanceof LinkLinkedObject)) {
            logger.info((Object)o);
        }
        LinkLinkedObject lo = (LinkLinkedObject)o;
        Link newLink = null;
        if (lo != null) {
            Link link = lo.getLink();
            newLink = (Link)link.clone();
            newLink.setChild(subject);
            this.removePropertyValue(AnnotationOntology.POSITS_REL(), lo);
            if (link.getChild() != null) {
                link.getChild().removeParent(link);
            }
        } else {
            newLink = new OBORestrictionImpl(subject, null, (LinkedObject)null);
        }
        lo = new LinkLinkedObject(newLink);
        this.addPropertyValue(AnnotationOntology.POSITS_REL(), lo);
        if (newLink.getChild() != null) {
            newLink.getChild().addParent(newLink);
        }
    }

    @Override
    public void setIsNegated(boolean isNegated) {
        for (Link link : this.getParents()) {
            if (!link.getType().equals(AnnotationOntology.IS_NEGATED())) continue;
            this.removeParent(link);
            break;
        }
        if (isNegated) {
            InstancePropertyValue link = new InstancePropertyValue(this, AnnotationOntology.IS_NEGATED(), new DatatypeValueImpl<Boolean>(Datatype.BOOLEAN, "true"));
            this.addParent(link);
        }
    }

    @Override
    public String toString() {
        return this.getID() + " posits: " + this.getSubject() + " [" + this.getRelationship() + "] " + this.getObject();
    }
}

