/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.bbop.io.IOUtil;
import org.bbop.util.AbstractProgressValued;
import org.obo.dataadapter.OBOParseException;
import org.obo.dataadapter.OBOSimpleParser;
import org.obo.dataadapter.ParseEngine;

public abstract class AbstractParseEngine
extends AbstractProgressValued
implements ParseEngine {
    protected OBOSimpleParser parser;
    protected List<String> paths = new LinkedList<String>();
    protected boolean halt = false;
    protected Stack<String> pathStack;
    protected boolean readIDForStanza = false;

    @Override
    public void cancel() {
        this.halt = true;
        this.parser.cancel();
    }

    protected static String convertPath(String path) {
        return IOUtil.getURL((String)path).toString();
    }

    @Override
    public void setPaths(Collection<String> paths) {
        this.paths = new LinkedList<String>();
        for (String path : paths) {
            this.paths.add(AbstractParseEngine.convertPath(path));
        }
    }

    @Override
    public void parse(String uri, boolean isImport) throws IOException, OBOParseException {
        this.pathStack.push(uri);
        this.parser.startFileParse(uri);
        this.doParse(uri, isImport);
        this.parser.endFileParse(uri);
        this.pathStack.pop();
    }

    protected abstract void doParse(String var1, boolean var2) throws IOException, OBOParseException;

    @Override
    public void setParser(OBOSimpleParser parser) {
        this.parser = parser;
        parser.setParseEngine(this);
    }

    @Override
    public void parse() throws IOException, OBOParseException {
        this.halt = false;
        if (this.parser == null) {
            throw new IOException("Could not parse; no parser installed!");
        }
        this.pathStack = new Stack();
        this.parser.startParse();
        for (String path : this.paths) {
            this.parse(path, false);
        }
        this.parser.endParse();
    }

    @Override
    public void setReadIDForCurrentBlock(boolean readIDForStanza) {
        this.readIDForStanza = readIDForStanza;
    }

    @Override
    public boolean getReadIDForCurrentBlock() {
        return this.readIDForStanza;
    }
}

