/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.obo.dataadapter.GOFlatFileParseException;

public class CompoundGOFlatFileParseException
extends GOFlatFileParseException {
    protected static final Logger logger = Logger.getLogger(CompoundGOFlatFileParseException.class);
    private static final long serialVersionUID = 1L;
    protected static final int MAX_ERRORS = 100;
    Vector exceptions = new Vector();
    protected boolean empty;
    protected boolean hideDownstream;
    protected String message;

    public CompoundGOFlatFileParseException(boolean hideDownstream) {
        super("compound exception");
        this.hideDownstream = hideDownstream;
        this.empty = true;
    }

    public CompoundGOFlatFileParseException() {
        this(false);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isFull() {
        return this.exceptions.size() >= 100;
    }

    public void addException(GOFlatFileParseException e) throws GOFlatFileParseException {
        GOFlatFileParseException last;
        if (this.empty) {
            this.lineNumber = e.getLineNumber();
            this.colNumber = e.getColNumber();
            this.line = e.getLine();
            this.message = e.getMessage();
            this.empty = false;
        }
        boolean ignoreException = false;
        if (this.exceptions.size() > 0 && (last = (GOFlatFileParseException)((Object)this.exceptions.elementAt(this.exceptions.size() - 1))).getLineNumber() == e.getLineNumber() && this.hideDownstream) {
            ignoreException = true;
        }
        if (!ignoreException) {
            this.exceptions.addElement(e);
        }
        if (this.isFull()) {
            throw this;
        }
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < this.exceptions.size(); ++i) {
            out.append(this.exceptions.elementAt(i).toString() + "\n\n");
        }
        out.append(this.exceptions.size() + " errors");
        if (this.isFull()) {
            out.append("\n(note: there may be more errors; only 100 errors are reported at a time)");
        }
        return out.toString();
    }
}

