/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.CancelledAdapterException;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.dataadapter.DataAdapterUI;
import org.bbop.dataadapter.FileAdapterConfiguration;
import org.bbop.dataadapter.FileAdapterUI;
import org.bbop.dataadapter.IOOperation;
import org.obo.dataadapter.HistoryDumper;
import org.obo.dataadapter.OBOAdapter;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.OBOSession;
import org.obo.history.HistoryItem;
import org.obo.history.HistoryList;
import org.obo.history.TermMacroHistoryItem;

public class DefaultHistoryDumper
implements OBOAdapter,
HistoryDumper {
    protected static final Logger logger = Logger.getLogger(DefaultHistoryDumper.class);
    private static int SPACEPADDING = 2;
    protected AdapterConfiguration config;
    protected String path;
    protected OBOSession history;
    protected IOOperation[] ops = new IOOperation[]{WRITE_HISTORY};
    protected boolean discardOldHistoriesOnSave = false;
    protected boolean loadAncientHistories = false;
    protected boolean applyAllHistories = false;
    protected boolean applyNewestHistory = false;
    protected boolean applyAllHistoriesAsMacro = false;
    protected boolean applyHistoryAsMacro = false;
    protected List listeners = new Vector();
    protected boolean cancelled = false;

    public void cancel() {
        this.cancelled = true;
    }

    public DataAdapterUI getPreferredUI() {
        FileAdapterUI ui = new FileAdapterUI();
        ui.setReadOperation(OBOAdapter.READ_HISTORY);
        ui.setWriteOperation(OBOAdapter.WRITE_HISTORY);
        return ui;
    }

    public void init() {
    }

    public String getName() {
        return "Plaintext History Adapter";
    }

    public String getType() {
        return "Plaintext History files";
    }

    public IOOperation[] getSupportedOperations() {
        return this.ops;
    }

    public List getHistories() throws DataAdapterException {
        throw new DataAdapterException("History reading is not supported");
    }

    public void writeHistory(HistoryList list) throws DataAdapterException {
        try {
            PrintStream stream = new PrintStream(new FileOutputStream(this.path));
            this.dumpHistory(stream, list);
            if (this.cancelled) {
                throw new CancelledAdapterException();
            }
        }
        catch (IOException ex) {
            throw new DataAdapterException((Throwable)ex, "Write error");
        }
    }

    public void writeHistories(List list) throws DataAdapterException {
        try {
            PrintStream stream = new PrintStream(new FileOutputStream(this.path));
            this.dumpHistories(stream, list, 0);
            if (this.cancelled) {
                throw new CancelledAdapterException();
            }
        }
        catch (IOException ex) {
            throw new DataAdapterException((Throwable)ex, "Write error");
        }
    }

    public AdapterConfiguration getConfiguration() {
        return this.config;
    }

    public Object doOperation(IOOperation op, AdapterConfiguration config, Object o) throws DataAdapterException {
        this.config = config;
        this.cancelled = false;
        if (op.equals(WRITE_HISTORY)) {
            this.path = ((FileAdapterConfiguration)config).getWritePath();
            Vector<Object> list = new Vector<Object>();
            if (o instanceof OBOSession) {
                OBOSession history = (OBOSession)o;
                list.add(history.getCurrentHistory());
                if (!this.discardOldHistoriesOnSave) {
                    list.addAll(history.getArchivedHistories());
                }
            } else if (o instanceof HistoryList) {
                list.add(o);
            }
            if (list.size() == 1) {
                this.writeHistory((HistoryList)list.get(0));
            } else {
                this.writeHistories(list);
            }
            return null;
        }
        if (op.equals(READ_HISTORY)) {
            this.path = (String)((FileAdapterConfiguration)config).getReadPaths().iterator().next();
            return this.getHistories();
        }
        throw new DataAdapterException("Operation " + op + " not supported");
    }

    public void dumpHistories(PrintStream stream, List list, int indentLevel) {
        for (HistoryList hl : list) {
            this.dumpHistory(stream, hl.getHistoryItems(), indentLevel + 2);
        }
    }

    public void setApplyNewestHistory(boolean applyNewestHistory) {
        this.applyNewestHistory = applyNewestHistory;
    }

    public boolean applyNewestHistory() {
        return this.applyNewestHistory;
    }

    public void setDiscardOldHistoriesOnSave(boolean discard) {
        this.discardOldHistoriesOnSave = discard;
    }

    public boolean discardOldHistoriesOnSave() {
        return this.discardOldHistoriesOnSave;
    }

    public boolean loadAncientHistories() {
        return this.loadAncientHistories;
    }

    public void setLoadAncientHistories(boolean loadAncientHistories) {
        this.loadAncientHistories = loadAncientHistories;
    }

    public boolean applyAllHistories() {
        return this.applyAllHistories;
    }

    public void setApplyAllHistories(boolean applyAllHistories) {
        this.applyAllHistories = applyAllHistories;
    }

    public boolean applyAllHistoriesAsMacro() {
        return this.applyAllHistoriesAsMacro;
    }

    public void setApplyAllHistoriesAsMacro(boolean applyAllHistoriesAsMacro) {
        this.applyAllHistoriesAsMacro = applyAllHistoriesAsMacro;
    }

    public void setApplyHistoryAsMacro(boolean applyHistoryAsMacro) {
        this.applyHistoryAsMacro = applyHistoryAsMacro;
    }

    public boolean applyHistoryAsMacro() {
        return this.applyHistoryAsMacro;
    }

    public void setDEHistory(OBOSession history) {
        this.history = history;
    }

    public void dumpHistory(PrintStream stream, OBOSession history) throws IOException {
        this.history = history;
        this.dumpHistory(stream, history.getCurrentHistory());
    }

    @Override
    public void dumpHistory(PrintStream stream, HistoryList list) {
        this.dumpHistory(stream, list.getHistoryItems(), 0);
    }

    protected void dumpHistory(PrintStream stream, Collection<HistoryItem> historyItems, int indentLevel) {
        for (HistoryItem item : historyItems) {
            if (this.cancelled) continue;
            for (int j = 0; j < SPACEPADDING * indentLevel; ++j) {
                stream.print(" ");
            }
            stream.println("* " + this.getItemDesc(item, this.history));
            if (!(item instanceof TermMacroHistoryItem)) continue;
            this.dumpHistory(stream, (TermMacroHistoryItem)item, indentLevel + 1);
        }
    }

    protected void dumpHistory(PrintStream stream, TermMacroHistoryItem mitem, int indentLevel) {
        for (int i = 0; i < mitem.size(); ++i) {
            HistoryItem item = mitem.getItemAt(i);
            for (int j = 0; j < SPACEPADDING * indentLevel; ++j) {
                stream.print(" ");
            }
            stream.println("* " + this.getItemDesc(item, this.history));
            if (!(item instanceof TermMacroHistoryItem)) continue;
            this.dumpHistory(stream, (TermMacroHistoryItem)item, indentLevel + 1);
        }
    }

    protected String getTerm(String id) {
        if (this.history == null) {
            return id;
        }
        IdentifiedObject term = this.history.getObject(id);
        if (term == null) {
            return id;
        }
        return this.getTermString(term);
    }

    protected String getTermString(IdentifiedObject term) {
        return term.getName() + " (" + term.getID() + ")";
    }

    @Override
    public String getItemDesc(HistoryItem item, OBOSession history) {
        return item.toString();
    }

    public String getID() {
        return "OBO:History_Dumper";
    }

    public Properties getStateInformation() {
        return null;
    }

    public void setStateInformation(Properties props) {
    }

    public String getProgressString() {
        return null;
    }

    public Number getProgressValue() {
        return null;
    }
}

