/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.dataadapter.HistoryDumper;
import org.obo.datamodel.OBOSession;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.CreateObjectHistoryItem;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.history.HistoryItem;
import org.obo.history.HistoryList;
import org.obo.history.StringRelationship;
import org.obo.history.TermMacroHistoryItem;
import org.obo.history.TermMoveHistoryItem;

public class HTMLHistoryDumper
implements HistoryDumper {
    protected static final Logger logger = Logger.getLogger(HTMLHistoryDumper.class);
    private static final int SPACEPADDING = 2;
    protected HistoryList history;
    protected boolean generateLink = true;

    public void setGenerateLink(boolean generateLink) {
        this.generateLink = generateLink;
    }

    @Override
    public void dumpHistory(PrintStream stream, HistoryList history) throws IOException {
        this.history = history;
        stream.println("<html><body>");
        this.dumpHistory(stream, history.getHistoryItems(), 0);
        stream.println("</body></html>");
    }

    protected void dumpHistory(PrintStream stream, Collection<HistoryItem> historyItems, int indentLevel) {
        stream.println("<ul>");
        for (HistoryItem item : historyItems) {
            for (int j = 0; j < 2 * indentLevel; ++j) {
                stream.print(" ");
            }
            if (item instanceof TermMacroHistoryItem) {
                stream.println("<ul>");
                this.dumpHistory(stream, (TermMacroHistoryItem)item, indentLevel + 1);
                stream.println("</ul>");
                continue;
            }
            stream.println("<li>" + this.getItemDesc(item, null));
        }
        stream.println("<ul>");
    }

    protected void dumpHistory(PrintStream stream, TermMacroHistoryItem mitem, int indentLevel) {
        for (int i = 0; i < mitem.size(); ++i) {
            HistoryItem item = mitem.getItemAt(i);
            for (int j = 0; j < 2 * indentLevel; ++j) {
                stream.print(" ");
            }
            if (item instanceof TermMacroHistoryItem) {
                stream.println("<ul>");
                this.dumpHistory(stream, (TermMacroHistoryItem)item, indentLevel + 1);
                stream.println("</ul>");
                continue;
            }
            stream.println("<li>" + this.getItemDesc(item, null));
        }
    }

    public String getLinkFromID(OBOSession history, String id) {
        if (this.generateLink) {
            return "<a href='file:" + id + "'>" + id + " (" + id + ")" + "</a>";
        }
        return id;
    }

    public String getLinkFromIDWithName(OBOSession history, String id, String name) {
        if (this.generateLink) {
            return "<a href='file:" + id + "'>" + name + " (" + id + ")" + "</a>";
        }
        return id;
    }

    @Override
    public String getItemDesc(HistoryItem item, OBOSession history) {
        if (item instanceof CreateObjectHistoryItem) {
            return "Created object " + this.getLinkFromID(history, ((CreateObjectHistoryItem)item).getObjectID()) + " of type " + ((CreateObjectHistoryItem)item).getObjectType() + ".";
        }
        if (item instanceof CreateLinkHistoryItem) {
            CreateLinkHistoryItem citem = (CreateLinkHistoryItem)item;
            StringBuffer out = new StringBuffer("");
            out.append("Copied ");
            out.append(this.getLinkFromIDWithName(history, citem.getTarget(), history.getObject(citem.getTarget()).getName()) + " (as " + citem.getTypeID() + "), ");
            out.append(" to ");
            out.append(this.getLinkFromIDWithName(history, citem.getParentID(), history.getObject(citem.getParentID()).getName()));
            return out.toString();
        }
        if (item instanceof TermMoveHistoryItem) {
            StringBuffer out = new StringBuffer("");
            out.append("Moved ");
            StringRelationship tr = ((TermMoveHistoryItem)item).getRelationship();
            out.append(this.getLinkFromIDWithName(history, tr.getChild(), history.getObject(tr.getChild()).getName()) + " (as " + tr.getType() + "), ");
            out.append(" to ");
            out.append(this.getLinkFromIDWithName(history, item.getTarget(), history.getObject(item.getTarget()).getName()));
            out.append(" from ");
            out.append(this.getLinkFromIDWithName(history, tr.getParent(), history.getObject(tr.getParent()).getName()));
            out.append("</body></html>");
            return out.toString();
        }
        if (item instanceof DeleteLinkHistoryItem) {
            StringBuffer out = new StringBuffer("");
            StringRelationship tr = ((DeleteLinkHistoryItem)item).getRel();
            out.append("Deleted " + this.getLinkFromIDWithName(history, tr.getChild(), tr.getChild() == null ? null : history.getObject(tr.getChild()).getName()) + " from " + this.getLinkFromIDWithName(history, tr.getParent(), tr.getParent() == null ? null : history.getObject(tr.getParent()).getName()) + " with " + tr.getType());
            return out.toString();
        }
        return item.toString();
    }
}

