/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OBOCatalog {
    private static final String CATALOG_FILE_NAME = "oboedit.catalog";
    private Map<String, String> mappings = Collections.emptyMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBOCatalog(File folder) {
        File catalogFile;
        if (folder.isDirectory() && (catalogFile = new File(folder, CATALOG_FILE_NAME)).isFile() && catalogFile.canRead()) {
            this.mappings = new HashMap<String, String>();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(catalogFile));
                while ((line = reader.readLine()) != null) {
                    String[] strings;
                    int totalLength = (line = line.trim()).length();
                    if (totalLength < 3 || line.charAt(0) == '#' || (strings = OBOCatalog.split(line)) == null || strings.length != 2) continue;
                    this.mappings.put(strings[0], strings[1]);
                }
            }
            catch (IOException e) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private static String[] split(String s) {
        int totalLength = s.length();
        int splitPos = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) continue;
            splitPos = i;
            break;
        }
        if (splitPos > 0 && splitPos < totalLength - 1) {
            String[] strings = new String[2];
            String local = s.substring(splitPos).trim();
            if (local.length() > 0) {
                strings[0] = s.substring(0, splitPos);
                strings[1] = local;
                return strings;
            }
        }
        return null;
    }

    public String map(String input) {
        String mapped = this.mappings.get(input);
        if (mapped != null) {
            return mapped;
        }
        return input;
    }
}

