/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.IOException;
import java.util.Comparator;
import org.apache.log4j.Logger;
import org.obo.dataadapter.OBO_1_2_Serializer;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymType;

public class OBO_1_0_Serializer
extends OBO_1_2_Serializer {
    protected static final Logger logger = Logger.getLogger(OBO_1_0_Serializer.class);
    protected Comparator<Synonym> synonymComparator = new Comparator<Synonym>(){

        @Override
        public int compare(Synonym sa, Synonym sb) {
            int compVal = sa.getScope() - sb.getScope();
            if (compVal == 0) {
                return Synonym.COMPARATOR.compare(sa, sb);
            }
            return compVal;
        }
    };

    @Override
    public Comparator getSynonymComparator() {
        return this.synonymComparator;
    }

    @Override
    public void writeFormatVersionHeaderTag() throws IOException {
        this.println("format-version: 1.0");
    }

    @Override
    public void writeDataVersionHeaderTag(String dataVersion) throws IOException {
        this.println("version: " + dataVersion);
    }

    @Override
    public void writeSynonymTypeDefHeaderTag(SynonymType category) throws IOException {
        this.print("!synonymtypedef: " + OBO_1_0_Serializer.escapeBeforeQuotes(category.getID()) + " \"" + OBO_1_0_Serializer.escapeQuoted(category.getName()) + "\"");
        if (category.getScope() != -1) {
            this.print(" " + OBO_1_0_Serializer.getScopeStr(category.getScope()));
        }
        this.print(" ! synonymtypedef not supported by OBO 1.0");
        this.println();
    }

    @Override
    public void writeSynonymTag(Synonym syn, boolean includeDesc, NestedValue nv) throws IOException {
        if (syn.getScope() == 1) {
            this.print("exact_synonym: ");
        } else if (syn.getScope() == 2) {
            this.print("narrow_synonym: ");
        } else if (syn.getScope() == 3) {
            this.print("broad_synonym: ");
        } else {
            this.print("related_synonym: ");
        }
        this.print("\"" + OBO_1_0_Serializer.escapeQuoted(syn.getText()) + "\"");
        this.writeDbxrefList(syn.getXrefs(), includeDesc);
        this.writeNestedValue(nv);
        if (syn.getSynonymType() != null) {
            this.print(" ! belonged to category " + syn.getSynonymType().getID());
        }
        this.println();
    }

    @Override
    public void writeXrefTag(Dbxref ref) throws IOException {
        this.print("xref_analog: ");
        this.writeDbxref(ref, true);
        this.println();
    }

    @Override
    public String getID() {
        return "OBO 1.0";
    }
}

