/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.obo.dataadapter.OBOConstants;
import org.obo.dataadapter.OBOSerializationEngine;
import org.obo.dataadapter.OBOSerializer;
import org.obo.datamodel.DatatypeValue;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.ObsoletableObject;
import org.obo.datamodel.PropertyValue;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymType;
import org.obo.datamodel.TermSubset;
import org.obo.datamodel.Type;
import org.obo.datamodel.ValueLink;
import org.obo.datamodel.impl.PropertyValueImpl;
import org.obo.util.TermUtil;

public class OBO_1_2_Serializer
implements OBOSerializer {
    protected static final Logger logger = Logger.getLogger(OBO_1_2_Serializer.class);
    protected PrintStream stream;
    LinkedList serializer_1_2_tagOrdering = new LinkedList();
    HashSet<OBOConstants.TagMapping> tagsToWrite;
    protected List<PropertyValue> scratch = new ArrayList<PropertyValue>();
    protected List<PropertyValue> writeNestedValueScratch = new ArrayList<PropertyValue>();
    protected Namespace defaultNamespace = new Namespace("<default namespace>");
    protected IdentifiedObject currentObject;
    protected OBOSerializationEngine engine;
    protected SimpleDateFormat oldDateFormat = new SimpleDateFormat("dd:MM:yyyy HH:mm");
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public LinkedList getSerializer_1_2_tagOrdering() {
        return this.serializer_1_2_tagOrdering;
    }

    public void setSerializer_1_2_tagOrdering(LinkedList serializer_1_2_tagOrdering) {
        this.serializer_1_2_tagOrdering = serializer_1_2_tagOrdering;
    }

    @Override
    public void setOutputStream(PrintStream stream) throws IOException {
        this.stream = stream;
    }

    @Override
    public void setEngine(OBOSerializationEngine engine) {
        this.engine = engine;
    }

    @Override
    public String mapID(IdentifiedObject io, String id) {
        return null;
    }

    @Override
    public void startSerialize() throws IOException {
    }

    @Override
    public void endSerialize() throws IOException {
    }

    @Override
    public List getHeaderTagOrdering() {
        return null;
    }

    @Override
    public List getStanzaOrdering() {
        return null;
    }

    @Override
    public List getTagOrdering() {
        this.getSerializer_1_2_tagOrdering();
        return this.serializer_1_2_tagOrdering;
    }

    @Override
    public void setTagOrdering(HashSet tagsToWrite) {
        if (tagsToWrite != null) {
            this.serializer_1_2_tagOrdering = this.getSerializer_1_2_tagOrdering();
            this.serializer_1_2_tagOrdering.clear();
            this.serializer_1_2_tagOrdering.addAll(OBOConstants.DEFAULT_TAG_ORDER);
            this.serializer_1_2_tagOrdering.retainAll(tagsToWrite);
            this.setSerializer_1_2_tagOrdering(this.serializer_1_2_tagOrdering);
        }
    }

    @Override
    public Comparator getObjectComparator() {
        return null;
    }

    @Override
    public Comparator getIDComparator() {
        return null;
    }

    @Override
    public Comparator getDbxrefComparator() {
        return null;
    }

    @Override
    public Comparator getSynonymComparator() {
        return null;
    }

    @Override
    public Comparator getSynonymCategoryComparator() {
        return null;
    }

    @Override
    public Comparator getCategoryComparator() {
        return null;
    }

    @Override
    public Comparator getXrefComparator() {
        return null;
    }

    @Override
    public Comparator getObsoleteComparator() {
        return null;
    }

    @Override
    public Comparator getLinkComparator() {
        return null;
    }

    public static String escapeSpaces(String s) {
        return OBOSerializationEngine.escapeSpaces(s);
    }

    public static String escapeQuoted(String s) {
        return OBOSerializationEngine.escapeQuoted(s, '\"');
    }

    public static String escapeQuoted(String s, char c) {
        return OBOSerializationEngine.escapeQuoted(s, c);
    }

    public static String escapeBeforeQuotes(String s) {
        return OBOSerializationEngine.escapeBeforeQuotes(s);
    }

    public static String escapePVName(String s) {
        return OBOSerializationEngine.escapePVName(s);
    }

    public static String escapePVValue(String s) {
        return "\"" + OBO_1_2_Serializer.escapeQuoted(s) + "\"";
    }

    public static String escapeDbxref(String s) {
        return OBOSerializationEngine.escapeDbxref(s);
    }

    public static String escape(String s) {
        return OBOSerializationEngine.escape(s);
    }

    public static String escapeBlocktext(String s) {
        return OBOSerializationEngine.escapeBlocktext(s);
    }

    @Override
    public void startHeader() throws IOException {
    }

    @Override
    public void endHeader() throws IOException {
        this.println();
    }

    @Override
    public void writeFormatVersionHeaderTag() throws IOException {
        this.print("format-version: 1.2\n");
    }

    @Override
    public void writeDataVersionHeaderTag(String dataVersion) throws IOException {
        this.print("data-version: " + dataVersion + "\n");
    }

    @Override
    public void writeDateHeaderTag(Date date) throws IOException {
        this.print("date: " + this.oldDateFormat.format(date) + "\n");
    }

    @Override
    public void writeSavedByHeaderTag(String user) throws IOException {
        this.print("saved-by: " + user + "\n");
    }

    @Override
    public void writeAutoGeneratedByHeaderTag(String generatedBy) throws IOException {
        this.println("auto-generated-by: " + generatedBy);
    }

    @Override
    public void writeSubsetDefHeaderTag(TermSubset category) throws IOException {
        this.print("subsetdef: " + OBO_1_2_Serializer.escapeBeforeQuotes(category.getName()) + " \"" + OBO_1_2_Serializer.escapeQuoted(category.getDesc(), '\"') + "\"\n");
    }

    @Override
    public void writeNamespaceIDRuleHeaderTag(String ns, String rule) throws IOException {
        String nsName = "*";
        if (ns != null) {
            nsName = ns;
        }
        this.print("namespace-id-rule: " + OBO_1_2_Serializer.escapeSpaces(nsName) + " " + rule + "\n");
    }

    @Override
    public void writeSynonymTypeDefHeaderTag(SynonymType category) throws IOException {
        this.print("synonymtypedef: " + OBO_1_2_Serializer.escapeBeforeQuotes(category.getID()) + " \"" + OBO_1_2_Serializer.escapeQuoted(category.getName()) + "\"");
        if (category.getScope() != -1) {
            this.print(" " + OBO_1_2_Serializer.getScopeStr(category.getScope()));
        }
        this.println();
    }

    @Override
    public void writeDefaultNamespaceHeaderTag(Namespace namespace) throws IOException {
        if (namespace != null) {
            this.defaultNamespace = namespace;
            this.print("default-namespace: " + OBO_1_2_Serializer.escape(namespace.getID()) + "\n");
        }
    }

    @Override
    public void writeRemarkHeaderTag(String remark) throws IOException {
        if (remark == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(remark, "\n");
        while (tokenizer.hasMoreTokens()) {
            String remarkLine = tokenizer.nextToken();
            this.print("remark: " + remarkLine);
            this.println();
        }
    }

    @Override
    public void startStanza(IdentifiedObject obj) throws IOException {
        if (TermUtil.isClass(obj)) {
            this.print("[Term]\n");
        } else if (TermUtil.isProperty(obj)) {
            this.print("[Typedef]\n");
        } else if (TermUtil.isInstance(obj)) {
            this.print("[Instance]\n");
        } else {
            this.print("[" + this.mapID(obj.getType(), obj.getType().getID()) + "]\n");
        }
        this.currentObject = obj;
    }

    @Override
    public void endStanza(IdentifiedObject obj) throws IOException {
        this.println();
        this.currentObject = null;
    }

    @Override
    public void writeIDTag(String id, NestedValue nv) throws IOException {
        this.print("id: " + id);
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeIsAnonymousTag(boolean value, NestedValue nv) throws IOException {
        if (value || nv != null) {
            this.print("is_anonymous: " + value);
            this.writeNestedValue(nv);
            this.println();
        }
    }

    @Override
    public void writeIsMetadataTag(boolean value, NestedValue nv) throws IOException {
        if (value || nv != null) {
            this.print("is_metadata_tag: " + value);
            this.writeNestedValue(nv);
            this.println();
        }
    }

    @Override
    public void writeNameTag(String name, NestedValue nv) throws IOException {
        if (name != null) {
            this.print("name: " + OBO_1_2_Serializer.escape(name));
            this.writeNestedValue(nv);
            this.println();
        }
    }

    @Override
    public void writeNamespaceTag(Namespace ns, NestedValue nv) throws IOException {
        if (nv == null && (ns == null || ns.equals(this.defaultNamespace))) {
            return;
        }
        if (ns == null) {
            ns = this.defaultNamespace;
        }
        this.print("namespace: " + ns.getID());
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeAltIDTag(String id, NestedValue nv) throws IOException {
        this.print("alt_id: " + id);
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeDefTag(String def, Collection dbxrefs, boolean includeDesc, NestedValue nv) throws IOException {
        if (def.length() > 0 || nv != null) {
            this.print("def: \"" + OBO_1_2_Serializer.escapeQuoted(def) + "\"");
            this.writeDbxrefList(dbxrefs, includeDesc);
            this.writeNestedValue(nv);
            this.println();
        }
    }

    @Override
    public void writeCommentTag(String comment, NestedValue nv) throws IOException {
        if (comment != null && comment.length() > 0 || nv != null) {
            this.print("comment: " + OBO_1_2_Serializer.escapeBlocktext(comment));
            this.writeNestedValue(nv);
            this.println();
        }
    }

    @Override
    public void writeSubsetTag(TermSubset category, NestedValue nv) throws IOException {
        this.print("subset: " + category.getName());
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeSynonymTag(Synonym syn, boolean includeDesc, NestedValue nv) throws IOException {
        this.print("synonym: \"" + OBO_1_2_Serializer.escapeQuoted(syn.getText()) + "\"");
        if (syn.getScope() != 0 || syn.getScope() != -1 || syn.getSynonymType() != null) {
            this.print(" " + OBO_1_2_Serializer.getScopeStr(syn.getScope()));
            if (syn.getSynonymType() != null) {
                this.print(" " + syn.getSynonymType().getID());
            }
        }
        ArrayList<Dbxref> dbxrefs = new ArrayList<Dbxref>(syn.getXrefs());
        Comparator c = this.getDbxrefComparator();
        if (c == null) {
            c = OBOConstants.DEFAULT_DBXREF_COMPARATOR;
        }
        Collections.sort(dbxrefs, c);
        this.writeDbxrefList(dbxrefs, includeDesc);
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeXrefTag(Dbxref ref) throws IOException {
        this.print("xref: ");
        this.writeDbxref(ref, true);
        this.println();
    }

    @Override
    public void writeInstanceOfTag(Type type, NestedValue nv) throws IOException {
        if (type != null) {
            this.print("instance_of: " + this.engine.mapID(type, type.getID()));
            this.writeNestedValue(nv);
            this.println();
        }
    }

    @Override
    public void writePropertyValueTag(PropertyValue pv, NestedValue nv, int depth) throws IOException {
        throw new UnsupportedOperationException("can't write operations");
    }

    @Override
    public void writeDomainTag(IdentifiedObject domain, NestedValue nv) throws IOException {
        this.print("domain: " + this.engine.mapID(domain, domain.getID()));
        this.writeNestedValue(nv);
        if (domain.getName() != null) {
            this.print(" ! " + domain.getName());
        }
        this.println();
    }

    @Override
    public void writeHoldsOverChainTag(List<OBOProperty> chain) throws IOException {
        this.print("holds_over_chain:");
        for (OBOProperty prop : chain) {
            this.print(" " + this.engine.mapID(prop, prop.getID()));
        }
        this.println();
    }

    @Override
    public void writeRangeTag(Type range, NestedValue nv) throws IOException {
        this.print("range: " + this.engine.mapID(range, range.getID()));
        this.writeNestedValue(nv);
        if (range.getName() != null) {
            this.print(" ! " + range.getName());
        }
        this.println();
    }

    @Override
    public void writeIsCyclicTag(boolean value, NestedValue nv) throws IOException {
        if (!value) {
            return;
        }
        this.print("is_cyclic: " + value);
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeIsReflexiveTag(boolean value, NestedValue nv) throws IOException {
        if (!value) {
            return;
        }
        this.print("is_reflexive: " + value);
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeAlwaysImpliesInverseTag(boolean value, NestedValue nv) throws IOException {
        if (!value) {
            return;
        }
        this.print("always_implies_inverse: " + value);
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeIsSymmetricTag(boolean value, NestedValue nv) throws IOException {
        if (!value) {
            return;
        }
        this.print("is_symmetric: " + value);
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeIsTransitiveTag(boolean value, NestedValue nv) throws IOException {
        if (!value) {
            return;
        }
        this.print("is_transitive: " + value);
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeValueLinkTag(ValueLink link, NestedValue nv) throws IOException {
        if (link.getValue() instanceof DatatypeValue) {
            DatatypeValue val = (DatatypeValue)link.getValue();
            this.stream.print("property_value: " + this.engine.mapID(link.getType()) + " \"" + OBO_1_2_Serializer.escapeQuoted(val.getValue()) + "\" " + this.engine.mapID(val.getType()) + "\n");
        } else if (link.getParent() != null) {
            this.stream.print("property_value: " + this.engine.mapID(link.getType()) + " " + this.engine.mapID(link.getParent()) + "\n");
        } else {
            throw new RuntimeException("Unexpected valuelink value from " + link);
        }
    }

    @Override
    public void writeLinkTag(Link link, NestedValue nv) throws IOException {
        OBORestriction r;
        this.scratch.clear();
        if (TermUtil.isIntersection(link)) {
            this.stream.print("intersection_of: ");
            if (!link.getType().equals(OBOProperty.IS_A)) {
                this.stream.print(this.engine.mapID(link.getType(), link.getType().getID()) + " ");
            }
        } else if (link.getType().equals(OBOProperty.IS_A)) {
            this.stream.print("is_a: ");
        } else if (link.getType().equals(OBOProperty.DISJOINT_FROM)) {
            this.stream.print("disjoint_from: ");
        } else if (link.getType().equals(OBOProperty.TRANSITIVE_OVER)) {
            this.stream.print("transitive_over: ");
        } else if (link.getType().equals(OBOProperty.DISJOINT_OVER)) {
            this.stream.print("disjoint_over: ");
        } else if (link.getType().equals(OBOProperty.UNION_OF)) {
            this.stream.print("union_of: ");
        } else if (link.getType().equals(OBOProperty.INVERSE_OF)) {
            this.stream.print("inverse_of: ");
        } else {
            if (link instanceof OBORestriction) {
                OBORestriction res = (OBORestriction)link;
                if (!res.isNecessarilyTrue()) {
                    this.scratch.add(new PropertyValueImpl("necessary", "false"));
                }
                if (res.isInverseNecessarilyTrue()) {
                    this.scratch.add(new PropertyValueImpl("inverse_necessary", "true"));
                }
                if (res.getCardinality() != null) {
                    this.scratch.add(new PropertyValueImpl("cardinality", res.getCardinality().toString()));
                }
                if (res.getMaxCardinality() != null) {
                    this.scratch.add(new PropertyValueImpl("maxCardinality", res.getMaxCardinality().toString()));
                }
                if (res.getMinCardinality() != null) {
                    this.scratch.add(new PropertyValueImpl("minCardinality", res.getMinCardinality().toString()));
                }
            }
            this.stream.print("relationship: " + this.engine.mapID(link.getType(), link.getType().getID()) + " ");
        }
        if (link.getNamespace() != null && !link.getNamespace().equals(link.getChild().getNamespace())) {
            this.scratch.add(new PropertyValueImpl("namespace", link.getNamespace().toString()));
        }
        if (TermUtil.isImplied(link)) {
            this.scratch.add(new PropertyValueImpl("implied", "true"));
        }
        if (link.getParent() == null) {
            logger.error((Object)("invalid link object: " + link));
        }
        this.stream.print(this.engine.mapID(link.getParent(), link.getParent().getID()));
        if (link instanceof OBORestriction && (r = (OBORestriction)link).getNumberOfAdditionalArguments() > 0) {
            for (LinkedObject a : r.getAdditionalArguments()) {
                this.stream.print(" " + this.engine.mapID(a, a.getID()));
            }
        }
        this.writeNestedValue(nv, this.scratch);
        if (link.getParent().getName() != null) {
            this.print(" ! " + link.getParent().getName());
        }
        this.println();
    }

    @Override
    public void writeIsObsoleteTag(boolean value, NestedValue nv) throws IOException {
        if (!value) {
            return;
        }
        this.print("is_obsolete: " + value);
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeReplacedByTag(ObsoletableObject replacedBy, NestedValue nv) throws IOException {
        this.print("replaced_by: " + this.engine.mapID(replacedBy, replacedBy.getID()));
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeConsiderTag(ObsoletableObject consider, NestedValue nv) throws IOException {
        this.print("consider: " + this.engine.mapID(consider, consider.getID()));
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeUnrecognizedTag(PropertyValue pv) throws IOException {
        this.println(pv.getProperty() + ": " + OBO_1_2_Serializer.escape(pv.getValue()));
    }

    protected void print(String s) throws IOException {
        this.stream.print(s);
    }

    protected void println(String s) throws IOException {
        this.stream.print(s + "\n");
    }

    protected void println() throws IOException {
        this.stream.print("\n");
    }

    protected static String getScopeStr(int scope) {
        if (scope == -1 || scope == 0) {
            return "RELATED";
        }
        if (scope == 1) {
            return "EXACT";
        }
        if (scope == 3) {
            return "BROAD";
        }
        if (scope == 2) {
            return "NARROW";
        }
        return null;
    }

    protected void writeDbxrefList(Collection dbxrefs, boolean includeDesc) throws IOException {
        this.print(" [");
        Iterator it = dbxrefs.iterator();
        boolean first = true;
        while (it.hasNext()) {
            Dbxref dbxref = (Dbxref)it.next();
            if (!first) {
                this.print(", ");
            }
            this.writeDbxref(dbxref, includeDesc);
            first = false;
        }
        this.print("]");
    }

    protected void writeDbxref(Dbxref dbxref, boolean includeDesc) throws IOException {
        this.print(OBO_1_2_Serializer.escapeDbxref(dbxref.getDatabase()));
        this.print(":");
        this.print(OBO_1_2_Serializer.escapeDbxref(dbxref.getDatabaseID()));
        if (includeDesc && dbxref.getDesc() != null && dbxref.getDesc().length() > 0) {
            this.print(" \"" + OBO_1_2_Serializer.escapeQuoted(dbxref.getDesc()) + "\"");
        }
        this.writeNestedValue(dbxref.getNestedValue());
    }

    protected void writeNestedValue(NestedValue nv) throws IOException {
        this.writeNestedValue(nv, null);
    }

    protected void writeNestedValue(NestedValue nv, List additionalVals) throws IOException {
        boolean notFirst = false;
        this.writeNestedValueScratch.clear();
        if (nv != null) {
            this.writeNestedValueScratch.addAll(nv.getPropertyValues());
        }
        if (additionalVals != null) {
            this.writeNestedValueScratch.addAll(additionalVals);
        }
        if (this.writeNestedValueScratch.size() == 0 && (nv == null || nv.getSuggestedComment() == null)) {
            return;
        }
        if (this.writeNestedValueScratch.size() > 0) {
            Collections.sort(this.writeNestedValueScratch, PropertyValue.COMPARATOR);
            Iterator<PropertyValue> it = this.writeNestedValueScratch.iterator();
            this.print(" {");
            for (PropertyValue pv : this.writeNestedValueScratch) {
                if (notFirst) {
                    this.print(", ");
                }
                this.print(OBO_1_2_Serializer.escapePVName(pv.getProperty()) + "=" + OBO_1_2_Serializer.escapePVValue(pv.getValue()));
                notFirst = true;
            }
            this.print("}");
        }
        if (nv != null && nv.getSuggestedComment() != null) {
            this.print(" ! " + nv.getSuggestedComment());
        }
    }

    @Override
    public String getID() {
        return "OBO 1.2";
    }

    public String toString() {
        return this.getID();
    }

    @Override
    public void writeCreatedByTag(String createdBy, NestedValue nv) throws IOException {
        this.print("created_by: " + OBO_1_2_Serializer.escape(createdBy));
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeCreationDateTag(Date date, NestedValue nv) throws IOException {
        this.print("creation_date: " + this.dateFormat.format(date));
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeModificationDateTag(Date date, NestedValue nv) throws IOException {
        this.print("modification_date: " + this.dateFormat.format(date));
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeModifiedByTag(String modifiedBy, NestedValue nv) throws IOException {
        this.print("modified_by: " + OBO_1_2_Serializer.escape(modifiedBy));
        this.writeNestedValue(nv);
        this.println();
    }

    @Override
    public void writeIDSpaceHeaderTag(String idspace, String uriPrefix) throws IOException {
        this.print("idspace: " + OBO_1_2_Serializer.escapeBeforeQuotes(idspace) + " " + uriPrefix);
        this.println();
    }

    @Override
    public void writeGenericHeaderTag(String property, String value) throws IOException {
        this.print(property + ": " + value);
        this.println();
    }
}

