/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.obo.dataadapter.DefaultOBOParser;
import org.obo.dataadapter.OBOConstants;
import org.obo.dataadapter.OBOParseException;
import org.obo.dataadapter.OBOSerializationEngine;
import org.obo.dataadapter.OBOSerializer;
import org.obo.dataadapter.OBOSerializerExtension;
import org.obo.dataadapter.ParseEngine;
import org.obo.dataadapter.ParserExtension;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.impl.DefaultOperationModel;
import org.obo.history.HistoryItem;
import org.obo.postcomp.ParseException;
import org.obo.postcomp.PostcompUtil;

public class PostcompParserExtension
implements ParserExtension,
OBOSerializerExtension {
    protected static final Logger logger = Logger.getLogger(PostcompParserExtension.class);
    protected OBOSession session;
    protected DefaultOBOParser parser;
    protected PrintStream stream;
    protected OBOSerializer serializer;
    protected Collection<HistoryItem> items = new LinkedList<HistoryItem>();
    protected Map<OBOClass, Collection<Link>> intersectionMap;

    @Override
    public IdentifiedObject createObject(String stanza, String id) {
        return null;
    }

    @Override
    public void setParser(DefaultOBOParser parser) {
        this.parser = parser;
    }

    @Override
    public void setSession(OBOSession session) {
        this.session = session;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void endFileParse(String uri) throws OBOParseException {
    }

    @Override
    public void endParse() throws OBOParseException {
        DefaultOperationModel model = new DefaultOperationModel();
        model.setSession(this.session);
        for (HistoryItem item : this.items) {
            model.apply(item);
        }
        this.intersectionMap = null;
    }

    @Override
    public String mapID(String id) {
        if (this.session.getObject(id) == null && id.contains("^")) {
            try {
                HistoryItem item = PostcompUtil.createPostcompItem(this.session, id, this.intersectionMap, null, true);
                String postcompItemID = item.getTarget();
                if (this.session.getObject(postcompItemID) != null) {
                    return postcompItemID;
                }
                OBOClass obj = (OBOClass)this.session.getObjectFactory().createObject(postcompItemID, OBOClass.OBO_CLASS, true);
                this.session.addObject(obj);
                this.items.add(item);
                return postcompItemID;
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void readBangComment(String comment) throws OBOParseException {
    }

    @Override
    public boolean readTagValue(String tag, String value, NestedValue nv, boolean handled) throws OBOParseException {
        return false;
    }

    @Override
    public void setParseEngine(ParseEngine engine) {
    }

    @Override
    public void startFileParse(String uri) throws OBOParseException {
    }

    @Override
    public void startParse() throws OBOParseException {
        this.items.clear();
        this.intersectionMap = new HashMap<OBOClass, Collection<Link>>();
    }

    @Override
    public void startSerialize() throws IOException {
    }

    @Override
    public boolean startStanza(String name) throws OBOParseException {
        return false;
    }

    @Override
    public void endSerialize() throws IOException {
    }

    @Override
    public void setOutputStream(PrintStream stream) throws IOException {
        this.stream = stream;
    }

    @Override
    public void setSerializer(OBOSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public String mapIDforWrite(IdentifiedObject io, String id) {
        if (PostcompUtil.isPostcompable(io)) {
            OBOClass oboClass = (OBOClass)io;
            return PostcompUtil.getPostcompID(oboClass);
        }
        return null;
    }

    @Override
    public boolean writeObject(LinkDatabase linkDatabase, IdentifiedObject obj) throws IOException {
        return PostcompUtil.isPostcompable(obj);
    }

    @Override
    public void changeHeaderTagOrder(List headerTagOrder) {
    }

    @Override
    public void changeStanzaOrder(List stanzaOrder) {
    }

    @Override
    public void changeTagOrder(List<OBOConstants.TagMapping> tagOrder) {
    }

    @Override
    public boolean writeTag(OBOConstants.TagMapping mapping, IdentifiedObject object, LinkDatabase linkDatabase) throws IOException {
        return false;
    }

    @Override
    public boolean endStanza(IdentifiedObject obj) throws IOException {
        return false;
    }

    @Override
    public boolean startStanza(IdentifiedObject obj) throws IOException {
        return false;
    }

    @Override
    public void setSerializationEngine(OBOSerializationEngine engine) {
    }
}

