/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.obo.datamodel.FieldPath;
import org.obo.datamodel.IdentifiedObject;
import org.obo.filters.SearchCriterion;

public class FieldPathSpec {
    protected static final Logger logger = Logger.getLogger(FieldPathSpec.class);
    protected List<SearchCriterion> elements = new LinkedList<SearchCriterion>();

    public FieldPathSpec(FieldPath path) {
        for (FieldPath.FieldPathElement e : path.getElements()) {
            this.elements.add(e.getField());
        }
    }

    public FieldPathSpec(SearchCriterion ... newElements) {
        this.readElements(newElements);
    }

    public FieldPathSpec(FieldPathSpec parentPath, SearchCriterion ... newElements) {
        for (SearchCriterion e : parentPath.getElements()) {
            this.elements.add(e);
        }
        this.readElements(newElements);
    }

    public FieldPathSpec getParent() {
        if (this.elements.size() == 0) {
            return null;
        }
        SearchCriterion[] vals = new SearchCriterion[this.elements.size() - 1];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = this.elements.get(i);
        }
        return new FieldPathSpec(vals);
    }

    protected void readElements(SearchCriterion[] newElements) {
        for (SearchCriterion sc : newElements) {
            this.elements.add(sc);
        }
    }

    public static Collection<FieldPath> createQueryPaths(Collection<FieldPathSpec> specs, IdentifiedObject io) {
        LinkedList<FieldPath> out = new LinkedList<FieldPath>();
        for (FieldPathSpec spec : specs) {
            out.add(FieldPathSpec.createQueryPath(spec, io));
        }
        return out;
    }

    public static FieldPath createQueryPath(FieldPathSpec spec) {
        return FieldPathSpec.createQueryPath(spec, null);
    }

    public static FieldPath createQueryPath(FieldPathSpec spec, IdentifiedObject io) {
        LinkedList<FieldPath.FieldPathElement> elements = new LinkedList<FieldPath.FieldPathElement>();
        for (SearchCriterion sc : spec.getElements()) {
            elements.add(new FieldPath.FieldPathElement(sc, null));
        }
        FieldPath out = new FieldPath(io);
        out.elements = elements;
        return out;
    }

    public FieldPath createQueryPath(IdentifiedObject io) {
        return FieldPathSpec.createQueryPath(this, io);
    }

    public List<SearchCriterion> getElements() {
        return this.elements;
    }

    public SearchCriterion getLastCriterion() {
        return this.elements.get(this.elements.size() - 1);
    }

    public String toString() {
        return this.elements.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldPathSpec) {
            FieldPathSpec spec = (FieldPathSpec)obj;
            if (spec.getElements().size() != this.getElements().size()) {
                return false;
            }
            for (int i = 0; i < spec.getElements().size(); ++i) {
                SearchCriterion sc2;
                SearchCriterion sc = spec.getElements().get(i);
                if (sc.equals(sc2 = this.getElements().get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.elements.hashCode();
    }
}

