/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.obo.datamodel.DanglingObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.Relationship;
import org.obo.datamodel.ValueLink;
import org.obo.datamodel.impl.DefaultLinkDatabase;
import org.obo.util.TermUtil;

public interface RootAlgorithm {
    public static final Logger logger = Logger.getLogger(RootAlgorithm.class);
    public static final RootAlgorithm STRICT = new AbstractRootAlgorithm(){

        @Override
        public boolean isRoot(LinkedObject lo) {
            if (lo instanceof Instance) {
                return true;
            }
            for (Link parent : lo.getParents()) {
                Relationship link = parent;
                if (link instanceof Link && ((Link)link).getParent() instanceof DanglingObject || link instanceof ValueLink && !(((ValueLink)link).getValue() instanceof IdentifiedObject) || link instanceof Link && (TermUtil.isObsolete(((Link)link).getParent()) || TermUtil.isObsolete(((Link)link).getType())) || link.getType().equals(OBOProperty.DISJOINT_FROM) || link.getType().equals(OBOProperty.UNION_OF)) continue;
                return false;
            }
            return GREEDY.isRoot(lo);
        }

        public String toString() {
            return "STRICT";
        }
    };
    public static final RootAlgorithm GREEDY = new AbstractRootAlgorithm(){

        @Override
        public boolean isRoot(LinkedObject lo) {
            if (lo instanceof Instance) {
                return true;
            }
            for (Link parent : this.linkDatabase.getParents(lo)) {
                Relationship parent_link = parent;
                LinkedObject parent_link_child = parent_link.getChild();
                LinkedObject parent_link_parent = parent_link.getParent();
                for (Link child : this.linkDatabase.getChildren(lo)) {
                    Relationship child_link = child;
                    LinkedObject child_link_child = child_link.getChild();
                    LinkedObject child_link_parent = child_link.getParent();
                    if (parent_link.getType().getID().equals(OBOProperty.INVERSE_OF.getID()) && parent_link_child.equals(child_link_parent) && parent_link_parent.equals(child_link_child)) {
                        return true;
                    }
                    if (!parent_link.getType().getID().equals(OBOProperty.HAS_PART.getID()) || !child_link.getType().getID().equals(OBOProperty.PART_OF.getID())) continue;
                    return true;
                }
                if (parent_link instanceof Link && ((Link)parent_link).getParent() instanceof DanglingObject || parent_link instanceof Link && (TermUtil.isObsolete(((Link)parent_link).getParent()) || TermUtil.isObsolete(((Link)parent_link).getType())) || parent_link instanceof ValueLink && !(((ValueLink)parent_link).getValue() instanceof IdentifiedObject) || parent_link.getType().equals(OBOProperty.DISJOINT_FROM) || parent_link.getType().equals(OBOProperty.UNION_OF)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "GREEDY";
        }
    };

    public boolean isRoot(LinkedObject var1);

    public void setLinkDatabase(LinkDatabase var1);

    public static abstract class AbstractRootAlgorithm
    implements RootAlgorithm {
        protected LinkDatabase linkDatabase = DefaultLinkDatabase.getDefault();
        protected Iterator sourceSet;

        @Override
        public void setLinkDatabase(LinkDatabase linkDatabase) {
            this.linkDatabase = linkDatabase;
        }

        public void setSources(Iterator sourceSet) {
            this.sourceSet = sourceSet;
        }
    }
}

