/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.util.TermUtil;

public abstract class AbstractLinkDatabase
implements LinkDatabase {
    OBOSession session;

    @Override
    public boolean hasChildren(LinkedObject lo) {
        return this.getChildren(lo).size() > 0;
    }

    @Override
    public boolean hasParents(LinkedObject lo) {
        return this.getParents(lo).size() > 0;
    }

    @Override
    public Link hasRelationship(LinkedObject a, OBOProperty b, LinkedObject c) {
        for (Link link : this.getParents(a)) {
            if (!link.getType().equals(b) || !link.getParent().equals(c)) continue;
            return link;
        }
        return null;
    }

    @Override
    public Collection<Link> getLinks(OBOProperty p) {
        ArrayList<Link> links = new ArrayList<Link>();
        for (IdentifiedObject io : this.getObjects()) {
            if (!(io instanceof LinkedObject)) continue;
            for (Link link : this.getParents((LinkedObject)io)) {
                if (!link.getType().equals(p)) continue;
                links.add(link);
            }
        }
        return links;
    }

    @Override
    public Collection<OBOProperty> getProperties() {
        return TermUtil.getProperties(this.session);
    }

    @Override
    public OBOSession getSession() {
        return this.session;
    }

    public void setSession(OBOSession session) {
        this.session = session;
    }
}

