/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.impl.DanglingObjectImpl;
import org.obo.datamodel.impl.DanglingPropertyImpl;

public class DanglingLinkImpl
implements Link {
    protected static final Logger logger = Logger.getLogger(DanglingLinkImpl.class);
    protected String childID;
    protected String parentID;
    protected String ancestorID;
    protected String typeID;

    public DanglingLinkImpl(String childID, String typeID, String parentID) {
        this.childID = childID;
        this.typeID = typeID;
        this.parentID = parentID;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isImplied() {
        return false;
    }

    @Override
    public LinkedObject getParent() {
        return new DanglingObjectImpl(this.parentID);
    }

    @Override
    public LinkedObject getChild() {
        return new DanglingObjectImpl(this.childID);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return new DanglingLinkImpl(this.childID, this.typeID, this.parentID);
        }
    }

    public String toString() {
        return "..." + this.getID() + "...";
    }

    @Override
    public OBOProperty getType() {
        return new DanglingPropertyImpl(this.typeID);
    }

    @Override
    public NestedValue getNestedValue() {
        return null;
    }

    @Override
    public Namespace getNamespace() {
        return null;
    }

    @Override
    public void setChild(LinkedObject child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNestedValue(NestedValue nv) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setType(OBOProperty type) {
        throw new UnsupportedOperationException();
    }

    public void setChild(String childID) {
        this.childID = childID;
    }

    public void setParent(String parentID) {
        this.parentID = parentID;
    }

    public void setType(String typeID) {
        this.typeID = typeID;
    }

    @Override
    public void setNamespace(Namespace namespace) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParent(LinkedObject parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getID() {
        char sepChar = '-';
        return this.childID + ' ' + sepChar + this.typeID + sepChar + '>' + ' ' + this.parentID;
    }
}

