/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obo.datamodel.DanglingObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.PropertyValue;
import org.obo.datamodel.Type;
import org.obo.datamodel.impl.OBOClassImpl;

public class DanglingObjectImpl
extends OBOClassImpl
implements DanglingObject {
    protected static final Logger logger = Logger.getLogger(DanglingObjectImpl.class);
    private static final long serialVersionUID = -5373912147333845047L;
    protected Set<Link> parents = new HashSet<Link>();
    protected Set<Link> children = new HashSet<Link>();
    protected String id;
    protected String name;
    protected Namespace namespace;
    protected boolean root;

    public DanglingObjectImpl(String id) {
        super(id);
        this.id = id;
        this.setName(null);
    }

    @Override
    public boolean isDangling() {
        return true;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public Type<OBOClass> getType() {
        return OBOClass.OBO_UNKNOWN;
    }

    @Override
    public boolean isBuiltIn() {
        return false;
    }

    @Override
    public Collection<Link> getParents() {
        return this.parents;
    }

    @Override
    public Collection<Link> getChildren() {
        return this.children;
    }

    public boolean isRoot() {
        return this.root;
    }

    public boolean rootHint() {
        return false;
    }

    @Override
    public void addChild(Link tr) {
        this.atomicAddChild(tr);
        if (tr.getChild() != null) {
            tr.getChild().atomicAddParent(tr);
        }
    }

    @Override
    public void removeChild(Link tr) {
        this.atomicRemoveChild(tr);
        if (tr.getChild() != null) {
            tr.getChild().atomicRemoveParent(tr);
        }
    }

    @Override
    public void addParent(Link tr) {
        this.atomicAddParent(tr);
        if (tr.getParent() != null) {
            tr.getParent().atomicAddChild(tr);
        }
    }

    @Override
    public void removeParent(Link tr) {
        this.atomicRemoveParent(tr);
        if (tr.getParent() != null) {
            tr.getParent().atomicRemoveChild(tr);
        }
    }

    @Override
    public void atomicAddChild(Link tr) {
        this.children.add(tr);
    }

    @Override
    public void atomicRemoveChild(Link tr) {
        this.children.remove(tr);
    }

    @Override
    public void atomicAddParent(Link tr) {
        this.parents.add(tr);
    }

    @Override
    public void atomicRemoveParent(Link tr) {
        this.parents.remove(tr);
    }

    @Override
    public NestedValue getTypeExtension() {
        return null;
    }

    @Override
    public NestedValue getNameExtension() {
        return null;
    }

    @Override
    public NestedValue getNamespaceExtension() {
        return null;
    }

    @Override
    public NestedValue getIDExtension() {
        return null;
    }

    @Override
    public NestedValue getAnonymousExtension() {
        return null;
    }

    @Override
    public Set getPropertyValues() {
        return Collections.EMPTY_SET;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    @Override
    public void setIsAnonymous(boolean isAnonymous) {
        throw new UnsupportedOperationException("Dangling objects cannot be anonymous");
    }

    @Override
    public void setTypeExtension(NestedValue value) {
        throw new UnsupportedOperationException("Dangling objects can never have extension information");
    }

    @Override
    public void setNameExtension(NestedValue value) {
        throw new UnsupportedOperationException("Dangling objects can never have extension information");
    }

    @Override
    public void setNamespaceExtension(NestedValue nv) {
        throw new UnsupportedOperationException("Dangling objects can never have extension information");
    }

    @Override
    public void setAnonymousExtension(NestedValue nv) {
        throw new UnsupportedOperationException("Dangling objects can never have extension information");
    }

    @Override
    public void setIDExtension(NestedValue nv) {
        throw new UnsupportedOperationException("Dangling objects can never have extension information");
    }

    @Override
    public void addPropertyValue(PropertyValue pv) {
        throw new UnsupportedOperationException("Dangling objects have no editable property values");
    }

    @Override
    public void removePropertyValue(PropertyValue pv) {
        throw new UnsupportedOperationException("Dangling objects have no editable property values");
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IdentifiedObject) {
            return ((IdentifiedObject)o).getID().equals(this.getID());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getID().hashCode();
    }

    @Override
    public String toString() {
        return "/" + this.getID() + "\\";
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }
}

