/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import org.bbop.util.ObjectUtil;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.Synonym;

public class DbxrefImpl
implements Dbxref {
    private static final long serialVersionUID = 7781970775816178223L;
    protected String databaseid;
    protected String database;
    protected String desc;
    protected String id;
    protected static int idgen = 0;
    protected int type;
    protected Synonym targetSynonym;
    protected NestedValue nestedValue;

    public DbxrefImpl() {
        this(null, null);
    }

    public DbxrefImpl(String database, String id) {
        this(database, id, null, 3, null);
    }

    public DbxrefImpl(String database, String id, int type) {
        this(database, id, null, type, null);
    }

    @Override
    public void setNestedValue(NestedValue nestedValue) {
        this.nestedValue = nestedValue;
    }

    @Override
    public NestedValue getNestedValue() {
        return this.nestedValue;
    }

    public static String getTypeStringFromInt(int type) {
        if (type == 0) {
            return "anatomical";
        }
        if (type == 1) {
            return "synonym";
        }
        if (type == 2) {
            return "definition";
        }
        if (type == 3) {
            return "analog";
        }
        return null;
    }

    public DbxrefImpl(String database, String id, String desc, int type) {
        this(database, id, desc, type, null);
    }

    public DbxrefImpl(String database, String databaseid, String desc, int type, Synonym targetSynonym) {
        this.databaseid = databaseid;
        this.database = database;
        this.type = type;
        this.desc = desc;
        this.targetSynonym = targetSynonym;
        this.id = "" + idgen++;
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public boolean isDefRef() {
        return this.type == 2;
    }

    @Override
    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setSynonym(Synonym syn) {
        this.targetSynonym = syn;
    }

    @Override
    public Synonym getSynonym() {
        return this.targetSynonym;
    }

    @Override
    public String getDatabaseID() {
        return this.databaseid;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabaseID(String id) {
        this.databaseid = id;
    }

    @Override
    public void setDatabase(String database) {
        this.database = database;
    }

    public String toString() {
        if (this.desc == null || this.desc.length() == 0) {
            return this.database + ":" + this.databaseid;
        }
        return this.desc + " (" + this.database + ":" + this.databaseid + ")";
    }

    public int compareTo(Object o) {
        return COMPARATOR.compare(this, o);
    }

    public boolean equals(Object in) {
        if (in instanceof Dbxref) {
            return ObjectUtil.equals((Object)((Dbxref)in).getDatabase(), (Object)this.database) && ObjectUtil.equals((Object)((Dbxref)in).getDatabaseID(), (Object)this.databaseid) && ((Dbxref)in).getType() == this.type && ObjectUtil.equals((Object)((Dbxref)in).getSynonym(), (Object)this.targetSynonym) && ObjectUtil.equals((Object)((Dbxref)in).getDesc(), (Object)this.desc);
        }
        return false;
    }

    public int hashCode() {
        return (this.database + ":" + this.databaseid + "|" + this.type + "|" + this.targetSynonym + "|" + this.desc).hashCode();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

