/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.IdentifiedObjectIndex;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.MutableLinkDatabase;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.impl.AbstractLinkDatabase;
import org.obo.util.TermUtil;

public class DefaultMutableLinkDatabase
extends AbstractLinkDatabase
implements MutableLinkDatabase {
    protected static final Logger logger = Logger.getLogger(DefaultMutableLinkDatabase.class);
    private static final long serialVersionUID = 3770486191021916503L;
    protected Map<LinkedObject, Collection<Link>> parentLinkMap = new LinkedHashMap<LinkedObject, Collection<Link>>(100, 0.75f, true);
    protected Map<LinkedObject, Collection<Link>> childLinkMap;
    protected Map<OBOProperty, Collection<Link>> propertyLinkMap;
    protected Map<String, IdentifiedObject> objects;
    protected IdentifiedObjectIndex index;
    protected boolean returnNulls;
    protected Collection<OBOProperty> properties;

    @Override
    public Collection<OBOProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Collection<OBOProperty> properties) {
        this.properties = properties;
    }

    public DefaultMutableLinkDatabase() {
        this(false, false);
        this.properties = TermUtil.getProperties(this.session);
    }

    @Override
    public void setIdentifiedObjectIndex(IdentifiedObjectIndex index) {
        this.index = index;
    }

    public DefaultMutableLinkDatabase(boolean cacheChildren) {
        this(cacheChildren, false);
    }

    public DefaultMutableLinkDatabase(boolean cacheChildren, boolean returnNulls) {
        if (cacheChildren) {
            this.childLinkMap = new HashMap<LinkedObject, Collection<Link>>();
        }
        this.propertyLinkMap = new HashMap<OBOProperty, Collection<Link>>();
        this.returnNulls = returnNulls;
    }

    @Override
    public Collection<IdentifiedObject> getObjects() {
        if (this.objects == null) {
            return Collections.emptySet();
        }
        return this.objects.values();
    }

    @Override
    public Collection<Link> getParents(LinkedObject lo) {
        Collection<Link> s = this.parentLinkMap.get(lo);
        if (s == null && !this.returnNulls) {
            s = Collections.emptySet();
        }
        return s;
    }

    @Override
    public Collection<Link> getChildren(LinkedObject lo) {
        if (this.childLinkMap != null) {
            Collection<Link> s = this.childLinkMap.get(lo);
            if (s == null && !this.returnNulls) {
                s = Collections.emptySet();
            }
            return s;
        }
        HashSet<Link> s = new HashSet<Link>();
        for (Collection<Link> parents : this.parentLinkMap.values()) {
            for (Link link : parents) {
                if (!link.getParent().equals(lo)) continue;
                s.add(link);
            }
        }
        return s;
    }

    @Override
    public void addParent(Link link) {
        Collection<Link> s = this.parentLinkMap.get(link.getChild());
        if (s == null) {
            s = new HashSet<Link>();
            this.parentLinkMap.put(link.getChild(), s);
        }
        s.add(link);
        this.addObject(link.getParent());
        this.addObject(link.getChild());
        if (this.childLinkMap != null) {
            Collection<Link> children = this.childLinkMap.get(link.getParent());
            if (children == null) {
                children = new HashSet<Link>();
                this.childLinkMap.put(link.getParent(), children);
            }
            children.add(link);
        }
        if (this.propertyLinkMap != null) {
            OBOProperty prop = link.getType();
            if (!this.propertyLinkMap.containsKey(prop)) {
                this.propertyLinkMap.put(prop, new HashSet());
            }
            this.propertyLinkMap.get(prop).add(link);
        }
    }

    @Override
    public void removeParent(Link link) {
        Collection<Link> children;
        Collection<Link> s = this.parentLinkMap.get(link.getChild());
        if (s != null) {
            s.remove(link);
            if (s.size() == 0) {
                this.parentLinkMap.remove(link.getChild());
            }
        }
        if (this.childLinkMap != null && (children = this.childLinkMap.get(link.getParent())) != null) {
            children.remove(link);
            if (children.size() == 0) {
                this.childLinkMap.remove(link.getParent());
            }
        }
        if (this.propertyLinkMap != null) {
            OBOProperty prop = link.getType();
            if (prop == null) {
                logger.error((Object)("no property in link " + link));
            } else {
                this.propertyLinkMap.get(prop).remove(link);
            }
        }
    }

    @Override
    public void setParents(LinkedObject lo, Collection<Link> parents) {
        this.clearParents(lo);
        for (Link link : parents) {
            this.addParent(link);
        }
    }

    @Override
    public void clearParents(LinkedObject lo) {
        LinkedList<Link> parents = new LinkedList<Link>();
        parents.addAll(this.getParents(lo));
        for (Link link : parents) {
            this.removeParent(link);
        }
    }

    @Override
    public void clear() {
        this.parentLinkMap.clear();
        if (this.childLinkMap != null) {
            this.childLinkMap.clear();
        }
        if (this.propertyLinkMap != null) {
            this.propertyLinkMap.clear();
        }
    }

    @Override
    public void addObject(IdentifiedObject lo) {
        if (this.objects == null) {
            this.objects = new HashMap<String, IdentifiedObject>();
        }
        this.objects.put(lo.getID(), lo);
    }

    public LinkedObject getLeastRecentlyAccessedLinkKey() {
        if (this.parentLinkMap.size() == 0) {
            return null;
        }
        return this.parentLinkMap.entrySet().iterator().next().getKey();
    }

    public void dropLinkKey(LinkedObject lo) {
        this.parentLinkMap.remove(lo);
        if (this.childLinkMap != null) {
            this.childLinkMap.remove(lo);
        }
    }

    @Override
    public void removeObject(IdentifiedObject lo) {
        if (this.objects != null) {
            this.objects.remove(lo.getID());
        }
    }

    @Override
    public IdentifiedObject getObject(String id) {
        if (this.index != null) {
            return this.index.getObject(id);
        }
        if (this.objects != null) {
            return this.objects.get(id);
        }
        return null;
    }

    @Override
    public Collection<Link> getLinks(OBOProperty p) {
        return this.propertyLinkMap.get(p);
    }
}

