/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.obo.datamodel.CommentedObject;
import org.obo.datamodel.Datatype;
import org.obo.datamodel.DbxrefedObject;
import org.obo.datamodel.DefinedObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.ModificationMetadataObject;
import org.obo.datamodel.MultiIDObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.ObsoletableObject;
import org.obo.datamodel.SubsetObject;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymType;
import org.obo.datamodel.SynonymedObject;
import org.obo.datamodel.TermSubset;
import org.obo.datamodel.Type;
import org.obo.datamodel.Value;
import org.obo.datamodel.impl.DanglingObjectImpl;
import org.obo.datamodel.impl.DanglingPropertyImpl;
import org.obo.datamodel.impl.DatatypeValueImpl;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.history.AddConsiderHistoryItem;
import org.obo.history.AddDbxrefHistoryItem;
import org.obo.history.AddPropertyValueHistoryItem;
import org.obo.history.AddReplacementHistoryItem;
import org.obo.history.AddSynonymHistoryItem;
import org.obo.history.CardinalityHistoryItem;
import org.obo.history.ChangeSynScopeHistoryItem;
import org.obo.history.ChangeSynTypeHistoryItem;
import org.obo.history.CommentChangeHistoryItem;
import org.obo.history.CompletesHistoryItem;
import org.obo.history.CreateIntersectionLinkHistoryItem;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.CreateObjectHistoryItem;
import org.obo.history.CyclicHistoryItem;
import org.obo.history.DefinitionChangeHistoryItem;
import org.obo.history.DelDbxrefHistoryItem;
import org.obo.history.DelSynonymHistoryItem;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.history.DeletePropertyValueHistoryItem;
import org.obo.history.DestroyObjectHistoryItem;
import org.obo.history.DomainHistoryItem;
import org.obo.history.HistoryItem;
import org.obo.history.InverseNecHistoryItem;
import org.obo.history.LinkTypeHistoryItem;
import org.obo.history.MaxCardinalityHistoryItem;
import org.obo.history.MinCardinalityHistoryItem;
import org.obo.history.NameChangeHistoryItem;
import org.obo.history.NamespaceHistoryItem;
import org.obo.history.NecessarilyTrueHistoryItem;
import org.obo.history.ObsoleteObjectHistoryItem;
import org.obo.history.OperationModel;
import org.obo.history.OperationWarning;
import org.obo.history.RangeHistoryItem;
import org.obo.history.RemoveConsiderHistoryItem;
import org.obo.history.RemoveReplacementHistoryItem;
import org.obo.history.SecondaryIDHistoryItem;
import org.obo.history.StringRelationship;
import org.obo.history.SubsetChangeHistoryItem;
import org.obo.history.SymmetricHistoryItem;
import org.obo.history.SynonymTypeHistoryItem;
import org.obo.history.TRNamespaceHistoryItem;
import org.obo.history.TermMacroHistoryItem;
import org.obo.history.TermNamespaceHistoryItem;
import org.obo.history.TermSubsetHistoryItem;
import org.obo.history.TransitiveHistoryItem;
import org.obo.util.HistoryUtil;

public class DefaultOperationModel
implements OperationModel,
Serializable {
    private static final long serialVersionUID = 5913604837564515607L;
    protected static final Logger logger = Logger.getLogger(DefaultOperationModel.class);
    protected OBOSession session;
    protected Collection<OperationModel> lockstepModels = new LinkedList<OperationModel>();
    protected String currentUser;
    protected boolean allowDangling = true;

    @Override
    public void setSession(OBOSession session) {
        this.session = session;
    }

    @Override
    public OperationWarning apply(HistoryItem item) {
        IdentifiedObject io;
        OperationWarning warning = item instanceof CreateObjectHistoryItem ? this.apply((CreateObjectHistoryItem)item) : (item instanceof CreateLinkHistoryItem ? this.apply((CreateLinkHistoryItem)item) : (item instanceof CreateIntersectionLinkHistoryItem ? this.apply((CreateIntersectionLinkHistoryItem)item) : (item instanceof DeleteLinkHistoryItem ? this.apply((DeleteLinkHistoryItem)item) : (item instanceof DestroyObjectHistoryItem ? this.apply((DestroyObjectHistoryItem)item) : (item instanceof ObsoleteObjectHistoryItem ? this.apply((ObsoleteObjectHistoryItem)item) : (item instanceof TermMacroHistoryItem ? this.apply((TermMacroHistoryItem)item) : (item instanceof LinkTypeHistoryItem ? this.apply((LinkTypeHistoryItem)item) : (item instanceof NamespaceHistoryItem ? this.apply((NamespaceHistoryItem)item) : (item instanceof NameChangeHistoryItem ? this.apply((NameChangeHistoryItem)item) : (item instanceof DefinitionChangeHistoryItem ? this.apply((DefinitionChangeHistoryItem)item) : (item instanceof TermSubsetHistoryItem ? this.apply((TermSubsetHistoryItem)item) : (item instanceof SynonymTypeHistoryItem ? this.apply((SynonymTypeHistoryItem)item) : (item instanceof ChangeSynTypeHistoryItem ? this.apply((ChangeSynTypeHistoryItem)item) : (item instanceof ChangeSynScopeHistoryItem ? this.apply((ChangeSynScopeHistoryItem)item) : (item instanceof TermNamespaceHistoryItem ? this.apply((TermNamespaceHistoryItem)item) : (item instanceof AddDbxrefHistoryItem ? this.apply((AddDbxrefHistoryItem)item) : (item instanceof DelDbxrefHistoryItem ? this.apply((DelDbxrefHistoryItem)item) : (item instanceof AddSynonymHistoryItem ? this.apply((AddSynonymHistoryItem)item) : (item instanceof DelSynonymHistoryItem ? this.apply((DelSynonymHistoryItem)item) : (item instanceof CommentChangeHistoryItem ? this.apply((CommentChangeHistoryItem)item) : (item instanceof SubsetChangeHistoryItem ? this.apply((SubsetChangeHistoryItem)item) : (item instanceof SecondaryIDHistoryItem ? this.apply((SecondaryIDHistoryItem)item) : (item instanceof NecessarilyTrueHistoryItem ? this.apply((NecessarilyTrueHistoryItem)item) : (item instanceof InverseNecHistoryItem ? this.apply((InverseNecHistoryItem)item) : (item instanceof CompletesHistoryItem ? this.apply((CompletesHistoryItem)item) : (item instanceof RangeHistoryItem ? this.apply((RangeHistoryItem)item) : (item instanceof DomainHistoryItem ? this.apply((DomainHistoryItem)item) : (item instanceof AddReplacementHistoryItem ? this.apply((AddReplacementHistoryItem)item) : (item instanceof RemoveReplacementHistoryItem ? this.apply((RemoveReplacementHistoryItem)item) : (item instanceof CyclicHistoryItem ? this.apply((CyclicHistoryItem)item) : (item instanceof CardinalityHistoryItem ? this.apply((CardinalityHistoryItem)item) : (item instanceof SymmetricHistoryItem ? this.apply((SymmetricHistoryItem)item) : (item instanceof TransitiveHistoryItem ? this.apply((TransitiveHistoryItem)item) : (item instanceof TRNamespaceHistoryItem ? this.apply((TRNamespaceHistoryItem)item) : (item instanceof CardinalityHistoryItem ? this.apply((CardinalityHistoryItem)item) : (item instanceof MinCardinalityHistoryItem ? this.apply((MinCardinalityHistoryItem)item) : (item instanceof MaxCardinalityHistoryItem ? this.apply((MaxCardinalityHistoryItem)item) : (item instanceof AddConsiderHistoryItem ? this.apply((AddConsiderHistoryItem)item) : (item instanceof RemoveConsiderHistoryItem ? this.apply((RemoveConsiderHistoryItem)item) : (item instanceof AddPropertyValueHistoryItem ? this.apply((AddPropertyValueHistoryItem)item) : (item instanceof DeletePropertyValueHistoryItem ? this.apply((DeletePropertyValueHistoryItem)item) : new OperationWarning("Unknown history item " + item + " found of type " + item.getClass() + "!"))))))))))))))))))))))))))))))))))))))))));
        for (OperationModel lockstepModel : this.lockstepModels) {
            OperationWarning lwarning = lockstepModel.apply(item);
            if (lwarning == null) continue;
            warning.addWarning(lwarning);
        }
        if (item.getTarget() != null && (io = this.getRealIDObject(item.getTarget())) instanceof ModificationMetadataObject) {
            ((ModificationMetadataObject)((Object)io)).setModificationDate(new Date());
            if (this.session.getCurrentUser() != null) {
                ((ModificationMetadataObject)((Object)io)).setModifiedBy(this.session.getCurrentUser());
            }
        }
        return warning;
    }

    public OperationWarning apply(AddPropertyValueHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not add property value to non-existant object " + item.getTarget());
        }
        if (!(target instanceof Instance)) {
            return new OperationWarning("Cannot add property value to non-instance " + target);
        }
        Instance instance = (Instance)target;
        LinkedObject property = this.getRealObject(item.getPropertyID());
        if (property == null) {
            return new OperationWarning("Cannot add property value with non-existant property " + item.getPropertyID());
        }
        if (!(property instanceof OBOProperty)) {
            return new OperationWarning("Cannot add property value with non-property " + item.getPropertyID());
        }
        OBOProperty oboProperty = (OBOProperty)property;
        Value value = null;
        if (item.getDatatypeID() == null) {
            value = this.getRealObject(item.getValue());
        } else {
            Datatype<?> type = null;
            for (int i = 0; i < Datatype.DATATYPES.length; ++i) {
                if (!Datatype.DATATYPES[i].getID().equals(item.getDatatypeID())) continue;
                type = Datatype.DATATYPES[i];
                break;
            }
            if (type == null) {
                return new OperationWarning("Cannot use unrecognized datatype " + item.getDatatypeID());
            }
            try {
                value = new DatatypeValueImpl(type, item.getValue());
            }
            catch (Exception ex) {
                return new OperationWarning("Value " + value + " is not a legal " + "value for datatype " + type);
            }
        }
        instance.addPropertyValue(oboProperty, value);
        return null;
    }

    public OperationWarning reverse(AddPropertyValueHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not undo add property value with non-existant object " + item.getTarget());
        }
        if (!(target instanceof Instance)) {
            return new OperationWarning("Cannot not undo add property value to non-instance " + target);
        }
        Instance instance = (Instance)target;
        LinkedObject property = this.getRealObject(item.getPropertyID());
        if (property == null) {
            return new OperationWarning("Cannot undo add property value to non-existant property " + item.getPropertyID());
        }
        if (!(property instanceof OBOProperty)) {
            return new OperationWarning("Cannot undo add property value to non-property " + item.getPropertyID());
        }
        OBOProperty oboProperty = (OBOProperty)property;
        Value value = null;
        if (item.getDatatypeID() == null) {
            value = this.getRealObject(item.getValue());
        } else {
            Datatype<?> type = null;
            for (int i = 0; i < Datatype.DATATYPES.length; ++i) {
                if (!Datatype.DATATYPES[i].getID().equals(item.getDatatypeID())) continue;
                type = Datatype.DATATYPES[i];
                break;
            }
            if (type == null) {
                return new OperationWarning("Cannot use unrecognized datatype " + item.getDatatypeID());
            }
            try {
                value = new DatatypeValueImpl(type, item.getValue());
            }
            catch (Exception ex) {
                return new OperationWarning("Value " + value + " is not a legal " + "value for datatype " + type);
            }
        }
        instance.removePropertyValue(oboProperty, value);
        return null;
    }

    public OperationWarning apply(DeletePropertyValueHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not delete property value from non-existant object " + item.getTarget());
        }
        if (!(target instanceof Instance)) {
            return new OperationWarning("Cannot delete property value from non-instance " + target);
        }
        Instance instance = (Instance)target;
        LinkedObject property = this.getRealObject(item.getPropertyID());
        if (property == null) {
            return new OperationWarning("Cannot delete property value from non-existant property " + item.getPropertyID());
        }
        if (!(property instanceof OBOProperty)) {
            return new OperationWarning("Cannot delete property value with non-property " + item.getPropertyID());
        }
        OBOProperty oboProperty = (OBOProperty)property;
        Value value = null;
        if (item.getDatatypeID() == null) {
            value = this.getRealObject(item.getValue());
        } else {
            Datatype<?> type = null;
            for (int i = 0; i < Datatype.DATATYPES.length; ++i) {
                if (!Datatype.DATATYPES[i].getID().equals(item.getDatatypeID())) continue;
                type = Datatype.DATATYPES[i];
                break;
            }
            if (type == null) {
                return new OperationWarning("Cannot use unrecognized datatype " + item.getDatatypeID());
            }
            try {
                value = new DatatypeValueImpl(type, item.getValue());
            }
            catch (Exception ex) {
                return new OperationWarning("Value " + value + " is not a legal " + "value for datatype " + type);
            }
        }
        instance.removePropertyValue(oboProperty, value);
        return null;
    }

    public OperationWarning reverse(DeletePropertyValueHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not undo delete property value from non-existant object " + item.getTarget());
        }
        if (!(target instanceof Instance)) {
            return new OperationWarning("Cannot undo delete property value from non-instance " + target);
        }
        Instance instance = (Instance)target;
        LinkedObject property = this.getRealObject(item.getPropertyID());
        if (property == null) {
            return new OperationWarning("Cannot undo delete property value from non-existant property " + item.getPropertyID());
        }
        if (!(property instanceof OBOProperty)) {
            return new OperationWarning("Cannot undo delete property value from non-property " + item.getPropertyID());
        }
        OBOProperty oboProperty = (OBOProperty)property;
        Value value = null;
        if (item.getDatatypeID() == null) {
            value = this.getRealObject(item.getValue());
        } else {
            Datatype<?> type = null;
            for (int i = 0; i < Datatype.DATATYPES.length; ++i) {
                if (!Datatype.DATATYPES[i].getID().equals(item.getDatatypeID())) continue;
                type = Datatype.DATATYPES[i];
                break;
            }
            if (type == null) {
                return new OperationWarning("Cannot use unrecognized datatype " + item.getDatatypeID());
            }
            try {
                value = new DatatypeValueImpl(type, item.getValue());
            }
            catch (Exception ex) {
                return new OperationWarning("Value " + value + " is not a legal " + "value for datatype " + type);
            }
        }
        instance.addPropertyValue(oboProperty, value);
        return null;
    }

    public OperationWarning apply(AddDbxrefHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not add dbxref to non-existant object " + item.getTarget());
        }
        if (item.isDef()) {
            if (!(target instanceof DefinedObject)) {
                return new OperationWarning("Could not add def dbxref to non-defined object " + item.getTarget());
            }
            ((DefinedObject)((Object)target)).addDefDbxref(item.getDbxref());
        } else if (item.getSynonym() != null) {
            if (!(target instanceof SynonymedObject)) {
                return new OperationWarning("Could not add synonym dbxref to non-synonymed object " + item.getTarget());
            }
            Synonym s = HistoryUtil.findSynonym((SynonymedObject)((Object)target), item.getSynonym());
            if (s == null) {
                return new OperationWarning("Could not modify non-existant synonym " + s + " of " + target);
            }
            s.addXref(item.getDbxref());
        } else {
            if (!(target instanceof DbxrefedObject)) {
                return new OperationWarning("Could not add dbxref to non-dbxrefed object " + item.getTarget());
            }
            ((DbxrefedObject)((Object)target)).addDbxref(item.getDbxref());
        }
        return null;
    }

    public OperationWarning reverse(AddDbxrefHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not remove dbxref from non-existant object " + item.getTarget());
        }
        if (item.isDef()) {
            if (!(target instanceof DefinedObject)) {
                return new OperationWarning("Could not remove def dbxref from non-defined object " + item.getTarget());
            }
            ((DefinedObject)((Object)target)).removeDefDbxref(item.getDbxref());
        } else if (item.getSynonym() != null) {
            if (!(target instanceof SynonymedObject)) {
                return new OperationWarning("Could not remove synonym dbxref from non-synonymed object " + item.getTarget());
            }
            Synonym s = HistoryUtil.findSynonym((SynonymedObject)((Object)target), item.getSynonym());
            s.removeXref(item.getDbxref());
        } else {
            if (!(target instanceof DbxrefedObject)) {
                return new OperationWarning("Could not remove dbxref from non-dbxrefed object " + item.getTarget());
            }
            ((DbxrefedObject)((Object)target)).removeDbxref(item.getDbxref());
        }
        return null;
    }

    public OperationWarning reverse(DelDbxrefHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not add dbxref to non-existant object " + item.getTarget());
        }
        if (item.isDef()) {
            if (!(target instanceof DefinedObject)) {
                return new OperationWarning("Could not add def dbxref to non-defined object " + item.getTarget());
            }
            ((DefinedObject)((Object)target)).addDefDbxref(item.getDbxref());
        } else if (item.getSynonym() != null) {
            if (!(target instanceof SynonymedObject)) {
                return new OperationWarning("Could not add synonym dbxref to non-synonymed object " + item.getTarget());
            }
            Synonym s = HistoryUtil.findSynonym((SynonymedObject)((Object)target), item.getSynonym());
            s.addXref(item.getDbxref());
        } else {
            if (!(target instanceof DbxrefedObject)) {
                return new OperationWarning("Could not add dbxref to non-dbxrefed object " + item.getTarget());
            }
            ((DbxrefedObject)((Object)target)).addDbxref(item.getDbxref());
        }
        return null;
    }

    public OperationWarning apply(DelDbxrefHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not remove dbxref from non-existant object " + item.getTarget());
        }
        if (item.isDef()) {
            if (!(target instanceof DefinedObject)) {
                return new OperationWarning("Could not remove def dbxref from non-defined object " + item.getTarget());
            }
            ((DefinedObject)((Object)target)).removeDefDbxref(item.getDbxref());
        } else if (item.getSynonym() != null) {
            if (!(target instanceof SynonymedObject)) {
                return new OperationWarning("Could not remove synonym dbxref from non-synonymed object " + item.getTarget());
            }
            Synonym s = HistoryUtil.findSynonym((SynonymedObject)((Object)target), item.getSynonym());
            s.removeXref(item.getDbxref());
        } else {
            if (!(target instanceof DbxrefedObject)) {
                return new OperationWarning("Could not remove dbxref from non-dbxrefed object " + item.getTarget());
            }
            ((DbxrefedObject)((Object)target)).removeDbxref(item.getDbxref());
        }
        return null;
    }

    public OperationWarning apply(TRNamespaceHistoryItem item) {
        StringRelationship sr = item.getRel();
        Link tr = this.getRealRel(sr);
        LinkedObject parent = tr.getParent();
        if (parent == null) {
            return new OperationWarning("Couldn't do relationship namespace change with missing parent " + sr.getParent());
        }
        if (tr.getChild() == null) {
            return new OperationWarning("Couldn't do relationship namespace change with missing child " + sr.getChild());
        }
        if (tr.getType() == null) {
            return new OperationWarning("Couldn't complete relationship namespace change with missing relationship type " + sr.getType());
        }
        tr = HistoryUtil.findChildRel(tr, tr.getParent());
        tr.setNamespace(this.session.getNamespace(item.getNewNamespace()));
        return null;
    }

    public OperationWarning reverse(TRNamespaceHistoryItem item) {
        StringRelationship sr = item.getRel();
        Link tr = this.getRealRel(sr);
        LinkedObject parent = tr.getParent();
        if (parent == null) {
            return new OperationWarning("Couldn't reverse relationship namespace change with missing parent " + sr.getParent());
        }
        if (tr.getChild() == null) {
            return new OperationWarning("Couldn't reverse relationship namespace change with missing child " + sr.getChild());
        }
        if (tr.getType() == null) {
            return new OperationWarning("Couldn't reverse relationship namespace change with missing relationship type " + sr.getType());
        }
        tr = HistoryUtil.findChildRel(tr, tr.getParent());
        tr.setNamespace(this.session.getNamespace(item.getOldNamespace()));
        return null;
    }

    public OperationWarning apply(CyclicHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not change cyclic quality of non-existant term " + item.getTarget());
        }
        if (!(target instanceof OBOProperty)) {
            return new OperationWarning("Could not change cyclic quality of non-type term " + item.getTarget());
        }
        OBOProperty type = (OBOProperty)target;
        type.setCyclic(!item.getOldCyclic());
        return null;
    }

    public OperationWarning reverse(CyclicHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not change cyclic quality of non-existant term " + item.getTarget());
        }
        if (!(target instanceof OBOProperty)) {
            return new OperationWarning("Could not change cyclic quality of non-type term " + item.getTarget());
        }
        OBOProperty type = (OBOProperty)target;
        type.setCyclic(item.getOldCyclic());
        return null;
    }

    public OperationWarning apply(SymmetricHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not change symmetric quality of non-existant term " + item.getTarget());
        }
        if (!(target instanceof OBOProperty)) {
            return new OperationWarning("Could not change symmetric quality of non-type term " + item.getTarget());
        }
        OBOProperty type = (OBOProperty)target;
        type.setSymmetric(!item.getOldSymmetric());
        return null;
    }

    public OperationWarning reverse(SymmetricHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not change symmetric quality of non-existant term " + item.getTarget());
        }
        if (!(target instanceof OBOProperty)) {
            return new OperationWarning("Could not change symmetric quality of non-type term " + item.getTarget());
        }
        OBOProperty type = (OBOProperty)target;
        type.setSymmetric(item.getOldSymmetric());
        return null;
    }

    public OperationWarning apply(TransitiveHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not change transitive quality of non-existant term " + item.getTarget());
        }
        if (!(target instanceof OBOProperty)) {
            return new OperationWarning("Could not change transitive quality of non-type term " + item.getTarget());
        }
        OBOProperty type = (OBOProperty)target;
        type.setTransitive(!item.getOldTransitive());
        return null;
    }

    public OperationWarning reverse(TransitiveHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not change transitive quality of non-existant term " + item.getTarget());
        }
        if (!(target instanceof OBOProperty)) {
            return new OperationWarning("Could not change transitive quality of non-type term " + item.getTarget());
        }
        OBOProperty type = (OBOProperty)target;
        type.setTransitive(item.getOldTransitive());
        return null;
    }

    public OperationWarning apply(TermSubsetHistoryItem item) {
        if (item.isAdd()) {
            this.session.addSubset(item.getNewSubset());
        } else if (item.isDel()) {
            this.session.removeCategory(item.getOldCategory());
        } else {
            for (TermSubset cat : this.session.getSubsets()) {
                if (!cat.equals(item.getOldCategory())) continue;
                cat.setName(item.getNewSubset().getName());
                cat.setDesc(item.getNewSubset().getDesc());
            }
        }
        return null;
    }

    public OperationWarning reverse(TermSubsetHistoryItem item) {
        if (item.isAdd()) {
            this.session.removeCategory(item.getNewSubset());
        } else if (item.isDel()) {
            this.session.addSubset(item.getOldCategory());
        } else {
            for (TermSubset cat : this.session.getSubsets()) {
                if (!cat.equals(item.getNewSubset())) continue;
                cat.setName(item.getOldCategory().getName());
                cat.setDesc(item.getOldCategory().getDesc());
            }
        }
        return null;
    }

    public OperationWarning apply(SynonymTypeHistoryItem item) {
        if (item.isAdd()) {
            this.session.addSynonymType(item.getNewCategory());
        } else if (item.isDel()) {
            this.session.removeSynonymCategory(item.getOldCategory());
        } else {
            for (SynonymType cat : this.session.getSynonymTypes()) {
                if (!cat.equals(item.getOldCategory())) continue;
                cat.setID(item.getNewCategory().getID());
                cat.setName(item.getNewCategory().getName());
                cat.setScope(item.getNewCategory().getScope());
            }
        }
        return null;
    }

    public OperationWarning reverse(SynonymTypeHistoryItem item) {
        if (item.isAdd()) {
            this.session.removeSynonymCategory(item.getNewCategory());
        } else if (item.isDel()) {
            this.session.addSynonymType(item.getOldCategory());
        } else {
            for (SynonymType cat : this.session.getSynonymTypes()) {
                if (!cat.equals(item.getNewCategory())) continue;
                cat.setID(item.getOldCategory().getID());
                cat.setName(item.getOldCategory().getName());
                cat.setScope(item.getOldCategory().getScope());
            }
        }
        return null;
    }

    public OperationWarning apply(TermNamespaceHistoryItem item) {
        if (item.isAdd()) {
            this.session.addNamespace(this.session.getObjectFactory().createNamespace(item.getNewID(), null));
        } else if (item.isDel()) {
            this.session.removeNamespace(this.session.getNamespace(item.getOldID()));
        } else {
            Namespace ns = this.session.getNamespace(item.getOldID());
            ns.setID(item.getNewID());
        }
        return null;
    }

    public OperationWarning reverse(TermNamespaceHistoryItem item) {
        if (item.isAdd()) {
            this.session.removeNamespace(this.session.getNamespace(item.getNewID()));
        } else if (item.isDel()) {
            this.session.addNamespace(this.session.getNamespace(item.getOldID()));
        } else {
            Namespace ns = this.session.getNamespace(item.getNewID());
            ns.setID(item.getOldID());
        }
        return null;
    }

    protected LinkedObject getRealObject(String term) {
        return (LinkedObject)this.getRealIDObject(term);
    }

    protected IdentifiedObject getRealIDObject(String term) {
        if (term == null) {
            return null;
        }
        IdentifiedObject out = this.session.getObject(term);
        if (out == null) {
            for (IdentifiedObject io : this.session.getObjects()) {
                if (!(io instanceof LinkedObject)) continue;
                for (Link link : ((LinkedObject)io).getParents()) {
                    if (link.getParent() == null || !link.getParent().getID().equals(term)) continue;
                    return link.getParent();
                }
            }
        }
        return out;
    }

    protected Link getRealRel(StringRelationship tr) {
        if (tr == null) {
            return null;
        }
        LinkedObject parent = this.getRealObject(tr.getParent());
        LinkedObject child = this.getRealObject(tr.getChild());
        OBOProperty type = (OBOProperty)this.getRealObject(tr.getType());
        if (parent == null && this.allowDangling) {
            parent = new DanglingObjectImpl(tr.getParent());
        }
        if (type == null && this.allowDangling) {
            type = new DanglingPropertyImpl(tr.getType());
        }
        Namespace ns = this.session.getNamespace(tr.getNamespace());
        OBORestrictionImpl realtr = new OBORestrictionImpl(child, parent, type);
        realtr.setNamespace(ns);
        realtr.setNecessarilyTrue(tr.isNecessary());
        realtr.setInverseNecessarilyTrue(tr.isInverseNecessary());
        realtr.setCompletes(tr.completes());
        realtr.setMinCardinality(tr.getMinCardinality());
        realtr.setMaxCardinality(tr.getMaxCardinality());
        realtr.setCardinality(tr.getCardinality());
        return realtr;
    }

    public OperationWarning apply(CreateObjectHistoryItem item) {
        IdentifiedObject type = this.session.getObject(item.getObjectType());
        if (type == null) {
            return new OperationWarning("Could not find type " + item.getObjectType() + ".");
        }
        if (!(type instanceof OBOClass)) {
            return new OperationWarning(item.getObjectType() + " is not a " + "type.");
        }
        if (this.session.getObject(item.getObjectID()) != null) {
            return new OperationWarning("Could not create object with ID " + item.getObjectID() + " because an object with that ID already exists.");
        }
        IdentifiedObject io = this.session.getObjectFactory().createObject(item.getObjectID(), (OBOClass)type, item.isAnonymous());
        if (io instanceof ModificationMetadataObject) {
            ((ModificationMetadataObject)((Object)io)).setCreationDate(new Date());
            ((ModificationMetadataObject)((Object)io)).setCreatedBy(this.session.getCurrentUser());
        }
        this.session.addObject(io);
        return null;
    }

    public OperationWarning reverse(CreateObjectHistoryItem item) {
        IdentifiedObject newObj = this.session.getObject(item.getObjectID());
        this.session.removeObject(newObj);
        return null;
    }

    public OperationWarning apply(SecondaryIDHistoryItem item) {
        LinkedObject t = this.getRealObject(item.getTarget());
        if (t == null) {
            return new OperationWarning("Could not assign secondary ID to unknown target " + item.getTarget());
        }
        if (!(t instanceof MultiIDObject)) {
            return new OperationWarning("Could not assign secondary ID to " + item.getTarget() + " because it does " + "not allow secondary IDs");
        }
        MultiIDObject target = (MultiIDObject)((Object)t);
        boolean hasSecondary = target.getSecondaryIDs().contains(item.getSecondaryID());
        if (item.isDelete()) {
            if (!hasSecondary) {
                return new OperationWarning("Could not remove secondary ID " + item.getSecondaryID() + " from target " + item.getTarget() + ", because the " + "term does not have that ID.");
            }
            target.removeSecondaryID(item.getSecondaryID());
        } else {
            if (hasSecondary) {
                return new OperationWarning("Could not add secondary ID " + item.getSecondaryID() + " to target " + item.getTarget() + ", because the " + "term already has that ID.");
            }
            target.addSecondaryID(item.getSecondaryID());
        }
        return null;
    }

    public OperationWarning reverse(SecondaryIDHistoryItem item) {
        LinkedObject t = this.getRealObject(item.getTarget());
        if (t == null) {
            return new OperationWarning("Could not reverse assignment of secondary ID to unknown target " + item.getTarget());
        }
        if (!(t instanceof MultiIDObject)) {
            return new OperationWarning("Could not reverse assignment of secondary ID to " + item.getTarget() + " because it does " + "not allow secondary IDs");
        }
        MultiIDObject target = (MultiIDObject)((Object)t);
        boolean hasSecondary = target.getSecondaryIDs().contains(item.getSecondaryID());
        if (item.isDelete()) {
            if (hasSecondary) {
                return new OperationWarning("Could not reverse deletion of secondary ID " + item.getSecondaryID() + " to target " + item.getTarget() + ", because the " + "term already has that ID.");
            }
            target.addSecondaryID(item.getSecondaryID());
        } else {
            if (!hasSecondary) {
                return new OperationWarning("Could not reverse addition of secondary ID " + item.getSecondaryID() + " from target " + item.getTarget() + ", because the " + "term does not have that ID.");
            }
            target.removeSecondaryID(item.getSecondaryID());
        }
        return null;
    }

    public OperationWarning apply(InverseNecHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change inverse necessary status of unknown term relationship " + item.getRel() + " to " + !item.getOldInverseNecessary());
            return cwarning;
        }
        if ((tr = (OBORestriction)HistoryUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change inverse necessary status of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setInverseNecessarilyTrue(!item.getOldInverseNecessary());
        return null;
    }

    public OperationWarning reverse(InverseNecHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change inverse necessary status of unknown term relationship " + item.getRel() + " back to " + item.getOldInverseNecessary());
            return cwarning;
        }
        if ((tr = (OBORestriction)HistoryUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change inverse necessary status of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setInverseNecessarilyTrue(item.getOldInverseNecessary());
        return null;
    }

    public OperationWarning apply(RangeHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        IdentifiedObject range = this.getRealIDObject(item.getRange());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't change range of " + item.getTarget() + " because it doesn't exist in the ontology" + item.getRange());
            return warning;
        }
        if (range == null) {
            OperationWarning warning = new OperationWarning("Could not apply change range of " + item.getTarget() + " to " + item.getRange() + ", because " + item.getRange() + " does not " + "exist in the ontology");
            return warning;
        }
        if (!(target instanceof OBOProperty)) {
            OperationWarning warning = new OperationWarning("Could not apply range change to non-property " + target);
            return warning;
        }
        if (range != null && !(range instanceof Type)) {
            OperationWarning warning = new OperationWarning("Could not apply range change to " + target + " with non-type object " + item.getRange());
            return warning;
        }
        OBOProperty type = (OBOProperty)target;
        type.setRange((Type)range);
        return null;
    }

    public OperationWarning reverse(RangeHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        IdentifiedObject range = this.getRealIDObject(item.getOldRange());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't reverse range change of " + item.getTarget() + " because it doesn't exist in the ontology" + item.getRange());
            return warning;
        }
        if (range == null) {
            OperationWarning warning = new OperationWarning("Could not reverse change range of " + item.getTarget() + " to " + item.getOldRange() + ", because " + item.getOldRange() + " does not " + "exist in the ontology");
            return warning;
        }
        if (!(target instanceof OBOProperty)) {
            OperationWarning warning = new OperationWarning("Could not reverse range change of non-type " + target);
            return warning;
        }
        if (range != null && !(range instanceof Type)) {
            OperationWarning warning = new OperationWarning("Could not reverse range change to " + target + " with non-type object " + item.getRange());
            return warning;
        }
        OBOProperty type = (OBOProperty)target;
        type.setRange((Type)range);
        return null;
    }

    public OperationWarning apply(AddReplacementHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        LinkedObject replacedBy = this.getRealObject(item.getReplace());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't change replacement for " + item.getTarget() + " because it doesn't exist in the ontology");
            return warning;
        }
        if (replacedBy == null && item.getReplace() != null) {
            OperationWarning warning = new OperationWarning("Could not change replacement of " + item.getTarget() + " to " + item.getReplace() + ", because " + item.getReplace() + " does not " + "exist in the ontology");
            return warning;
        }
        if (!(target instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not change replacement to non-obsoletable object " + item.getTarget());
            return warning;
        }
        if (replacedBy != null && !(replacedBy instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not change replacement of " + target + " to non-obsoletable object " + item.getTarget());
            return warning;
        }
        ((ObsoletableObject)((Object)target)).addReplacedBy((ObsoletableObject)((Object)replacedBy));
        return null;
    }

    public OperationWarning reverse(RemoveReplacementHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        LinkedObject replacedBy = this.getRealObject(item.getReplace());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't undo replacement for " + item.getTarget() + " because it doesn't exist in the ontology");
            return warning;
        }
        if (replacedBy == null && item.getReplace() != null) {
            OperationWarning warning = new OperationWarning("Could not undo replacement of " + item.getTarget() + " to " + item.getReplace() + ", because " + item.getReplace() + " does not " + "exist in the ontology");
            return warning;
        }
        if (!(target instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not undo replacement to non-obsoletable object " + item.getTarget());
            return warning;
        }
        if (replacedBy != null && !(replacedBy instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not undo replacement of " + target + " to non-obsoletable object " + item.getTarget());
            return warning;
        }
        ((ObsoletableObject)((Object)target)).addReplacedBy((ObsoletableObject)((Object)replacedBy));
        return null;
    }

    public OperationWarning apply(RemoveReplacementHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        LinkedObject replacedBy = this.getRealObject(item.getReplace());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't remove replacement for " + item.getTarget() + " because it doesn't exist in the ontology");
            return warning;
        }
        if (replacedBy == null && item.getReplace() != null) {
            OperationWarning warning = new OperationWarning("Could not remove replacement of " + item.getTarget() + " to " + item.getReplace() + ", because " + item.getReplace() + " does not exist in the ontology");
            return warning;
        }
        if (!(target instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not remove replacement for non-obsoletable object " + item.getTarget());
            return warning;
        }
        if (replacedBy != null && !(replacedBy instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not remove replacement for " + target + " of non-obsoletable object " + replacedBy);
            return warning;
        }
        ((ObsoletableObject)((Object)target)).removeReplacedBy((ObsoletableObject)((Object)replacedBy));
        return null;
    }

    public OperationWarning reverse(AddReplacementHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        LinkedObject replacedBy = this.getRealObject(item.getReplace());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't reverse replacement change for " + item.getTarget() + " because it doesn't exist in the ontology");
            return warning;
        }
        if (replacedBy == null && item.getReplace() != null) {
            OperationWarning warning = new OperationWarning("Could not reverse replacement change of " + item.getTarget() + " to " + item.getReplace() + ", because " + item.getReplace() + " does not exist in the ontology");
            return warning;
        }
        if (!(target instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not reverse replacement change to non-obsoletable object " + item.getTarget());
            return warning;
        }
        if (replacedBy != null && !(replacedBy instanceof ObsoletableObject)) {
            OperationWarning warning = new OperationWarning("Could not reverse replacement change of " + target + " to non-obsoletable object " + replacedBy);
            return warning;
        }
        ((ObsoletableObject)((Object)target)).removeReplacedBy((ObsoletableObject)((Object)replacedBy));
        return null;
    }

    public OperationWarning apply(DomainHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        IdentifiedObject domain = this.getRealIDObject(item.getDomain());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't change domain of " + item.getTarget() + " because it doesn't exist in the ontology" + item.getDomain());
            return warning;
        }
        if (domain == null && item.getDomain() != null) {
            OperationWarning warning = new OperationWarning("Could not apply change domain of " + item.getTarget() + " to " + item.getDomain() + ", because " + item.getDomain() + " does not " + "exist in the ontology");
            return warning;
        }
        if (!(target instanceof OBOProperty)) {
            OperationWarning warning = new OperationWarning("Could not apply domain change to non-type " + item.getTarget());
            return warning;
        }
        if (domain != null && !(domain instanceof OBOClass)) {
            OperationWarning warning = new OperationWarning("Could not apply domain change to " + target + " with non-type object " + item.getDomain());
            return warning;
        }
        OBOProperty type = (OBOProperty)target;
        type.setDomain(domain);
        return null;
    }

    public OperationWarning reverse(DomainHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        IdentifiedObject domain = this.getRealIDObject(item.getOldDomain());
        if (target == null) {
            OperationWarning warning = new OperationWarning("Couldn't reverse domain change of " + item.getTarget() + " because it doesn't exist in the ontology.");
            return warning;
        }
        if (domain == null && item.getOldDomain() != null) {
            OperationWarning warning = new OperationWarning("Could not reverse change domain of " + item.getTarget() + " back to " + item.getOldDomain() + ", because " + item.getOldDomain() + " does not " + "exist in the ontology");
            return warning;
        }
        if (!(target instanceof OBOProperty)) {
            OperationWarning warning = new OperationWarning("Could not reverse domain change to non-type " + item.getTarget());
            return warning;
        }
        if (domain != null && !(domain instanceof OBOClass)) {
            OperationWarning warning = new OperationWarning("Could not reverse domain change to " + target + " with non-type object " + item.getDomain());
            return warning;
        }
        OBOProperty type = (OBOProperty)target;
        type.setDomain(domain);
        return null;
    }

    public OperationWarning apply(CardinalityHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change cardinality of unknown term relationship " + item.getRel() + " to " + item.getOldValue());
            return cwarning;
        }
        if ((tr = (OBORestriction)HistoryUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change cardinality of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setCardinality(item.getNewValue());
        return null;
    }

    public OperationWarning reverse(CardinalityHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change cardinality of unknown term relationship " + item.getRel() + " to " + item.getOldValue());
            return cwarning;
        }
        if ((tr = (OBORestriction)HistoryUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change cardinality of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setCardinality(item.getOldValue());
        return null;
    }

    public OperationWarning apply(MinCardinalityHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + item.getRel() + " to " + item.getNewValue());
            return cwarning;
        }
        if ((tr = (OBORestriction)HistoryUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setMinCardinality(item.getNewValue());
        return null;
    }

    public OperationWarning reverse(MinCardinalityHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + item.getRel() + " to " + item.getOldValue());
            return cwarning;
        }
        if ((tr = (OBORestriction)HistoryUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setMinCardinality(item.getOldValue());
        return null;
    }

    public OperationWarning apply(MaxCardinalityHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + item.getRel() + " to " + item.getNewValue());
            return cwarning;
        }
        if ((tr = (OBORestriction)HistoryUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setMaxCardinality(item.getNewValue());
        return null;
    }

    public OperationWarning reverse(MaxCardinalityHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + item.getRel() + " to " + item.getOldValue());
            return cwarning;
        }
        if ((tr = (OBORestriction)HistoryUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change min cardinality of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setMaxCardinality(item.getOldValue());
        return null;
    }

    public OperationWarning apply(CompletesHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change completes status of unknown term relationship " + item.getRel() + " to " + !item.getOldCompletes());
            return cwarning;
        }
        if ((tr = (OBORestriction)HistoryUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change completes status of unknown term relationship " + item.getRel() + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.getChild().removeParent(tr);
        tr.setCompletes(!item.getOldCompletes());
        tr.getChild().addParent(tr);
        return null;
    }

    public OperationWarning reverse(CompletesHistoryItem item) {
        StringRelationship sr = (StringRelationship)item.getRel().clone();
        sr.setCompletes(!item.getOldCompletes());
        OBORestriction tr = (OBORestriction)this.getRealRel(sr);
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change completes status of unknown term relationship " + item.getRel() + " back to " + item.getOldCompletes());
            return cwarning;
        }
        if ((tr = (OBORestriction)HistoryUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change completes status of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.getParent().removeChild(tr);
        tr.setCompletes(item.getOldCompletes());
        tr.getParent().addChild(tr);
        return null;
    }

    public OperationWarning apply(NecessarilyTrueHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change necessary status of unknown term relationship " + item.getRel() + " to " + !item.getOldNecessary());
            return cwarning;
        }
        OBORestriction temp = tr;
        if ((tr = (OBORestriction)HistoryUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change necessary status of unknown term relationship " + item.getRel() + " because it doesn't exist in " + "the ontology. realRel = " + temp + ", tr.getChild().getParents() = " + temp.getChild().getParents());
            return cwarning;
        }
        tr.setNecessarilyTrue(!item.getOldNecessary());
        return null;
    }

    public OperationWarning reverse(NecessarilyTrueHistoryItem item) {
        OBORestriction tr = (OBORestriction)this.getRealRel(item.getRel());
        if (tr == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change necessary status of unknown term relationship " + item.getRel() + " back to " + item.getOldNecessary());
            return cwarning;
        }
        if ((tr = (OBORestriction)HistoryUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change necessary status of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setNecessarilyTrue(item.getOldNecessary());
        return null;
    }

    public void setAllowDangling(boolean allowDangling) {
        this.allowDangling = allowDangling;
    }

    public OperationWarning apply(CreateLinkHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not add parents to unknown term " + item.getTarget());
        }
        StringRelationship sr = new StringRelationship(item.getTarget(), item.getTypeID(), item.getParentID());
        Link tr = this.getRealRel(sr);
        if (tr.getParent() == null) {
            if (this.allowDangling) {
                tr.setParent(this.session.getObjectFactory().createDanglingObject(sr.getParent(), false));
            } else {
                return new OperationWarning("Couldn't do copy of unknown parent " + sr.getParent() + " to " + target + " with type " + sr.getType() + ".");
            }
        }
        if (tr.getType() == null) {
            if (this.allowDangling) {
                tr.setType((OBOProperty)((Object)this.session.getObjectFactory().createDanglingObject(sr.getType(), true)));
            } else {
                return new OperationWarning("Couldn't do copy of " + sr.getChild() + " to " + target + " with unknown type " + sr.getType() + ".");
            }
        }
        if (HistoryUtil.findParentRel(tr, target) != null) {
            OperationWarning cwarning = new OperationWarning("Could not create link " + tr + " because it already exists");
            return cwarning;
        }
        tr.getChild().addParent(tr);
        return null;
    }

    public OperationWarning apply(CreateIntersectionLinkHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not add parents to unknown term " + item.getTarget());
        }
        StringRelationship sr = new StringRelationship(item.getTarget(), item.getTypeID(), item.getParentID());
        sr.setCompletes(true);
        Link tr = this.getRealRel(sr);
        if (tr.getParent() == null) {
            if (this.allowDangling) {
                tr.setParent(this.session.getObjectFactory().createDanglingObject(sr.getParent(), false));
            } else {
                return new OperationWarning("Couldn't do copy of unknown parent " + sr.getParent() + " to " + target + " with type " + sr.getType() + ".");
            }
        }
        if (tr.getType() == null) {
            if (this.allowDangling) {
                tr.setType((OBOProperty)((Object)this.session.getObjectFactory().createDanglingObject(sr.getType(), true)));
            } else {
                return new OperationWarning("Couldn't do copy of " + sr.getChild() + " to " + target + " with unknown type " + sr.getType() + ".");
            }
        }
        if (HistoryUtil.findParentRel(tr, target) != null) {
            OperationWarning cwarning = new OperationWarning("Could not create link " + tr + " because it already exists");
            return cwarning;
        }
        tr.getChild().addParent(tr);
        return null;
    }

    public OperationWarning reverse(CreateLinkHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not remove parents to unknown term " + item.getTarget());
        }
        StringRelationship sr = new StringRelationship(item.getTarget(), item.getTypeID(), item.getParentID());
        Link tr = this.getRealRel(sr);
        if (tr.getParent() == null) {
            if (this.allowDangling) {
                tr.setParent(this.session.getObjectFactory().createDanglingObject(sr.getParent(), false));
            } else {
                return new OperationWarning("Couldn't undo copy of unknown parent " + sr.getParent() + " to " + target + " with type " + sr.getType() + ".");
            }
        }
        if (tr.getType() == null) {
            if (this.allowDangling) {
                tr.setType((OBOProperty)((Object)this.session.getObjectFactory().createDanglingObject(sr.getType(), false)));
            } else {
                return new OperationWarning("Couldn't undo copy of " + sr.getChild() + " to " + target + " with unknown type " + sr.getType() + ".");
            }
        }
        if (HistoryUtil.findParentRel(tr, target) == null) {
            OperationWarning cwarning = new OperationWarning("Could not remove link " + tr + " because it doesn't exist");
            return cwarning;
        }
        tr.getChild().removeParent(tr);
        return null;
    }

    public OperationWarning reverse(CreateIntersectionLinkHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not remove parents to unknown term " + item.getTarget());
        }
        StringRelationship sr = new StringRelationship(item.getTarget(), item.getTypeID(), item.getParentID());
        sr.setCompletes(true);
        Link tr = this.getRealRel(sr);
        if (tr.getParent() == null) {
            if (this.allowDangling) {
                tr.setParent(this.session.getObjectFactory().createDanglingObject(sr.getParent(), false));
            } else {
                return new OperationWarning("Couldn't undo copy of unknown parent " + sr.getParent() + " to " + target + " with type " + sr.getType() + ".");
            }
        }
        if (tr.getType() == null) {
            if (this.allowDangling) {
                tr.setType((OBOProperty)((Object)this.session.getObjectFactory().createDanglingObject(sr.getType(), false)));
            } else {
                return new OperationWarning("Couldn't undo copy of " + sr.getChild() + " to " + target + " with unknown type " + sr.getType() + ".");
            }
        }
        if (HistoryUtil.findParentRel(tr, target) == null) {
            OperationWarning cwarning = new OperationWarning("Could not remove link " + tr + " because it doesn't exist");
            return cwarning;
        }
        tr.getChild().removeParent(tr);
        return null;
    }

    public OperationWarning apply(ObsoleteObjectHistoryItem item) {
        IdentifiedObject io = this.session.getObject(item.getTarget());
        if (io == null) {
            return new OperationWarning("Cannot obsolete unknown object " + item.getTarget());
        }
        if (!(io instanceof ObsoletableObject)) {
            return new OperationWarning("Cannot obsolete non-obsoletable object " + item.getTarget());
        }
        if (((ObsoletableObject)io).isObsolete()) {
            return new OperationWarning("Cannot obsolete already obsolete object " + io);
        }
        ((ObsoletableObject)io).setObsolete(true);
        return null;
    }

    public OperationWarning reverse(ObsoleteObjectHistoryItem item) {
        IdentifiedObject io = this.session.getObject(item.getTarget());
        if (io == null) {
            return new OperationWarning("Cannot unobsolete unknown object " + item.getTarget());
        }
        if (!(io instanceof ObsoletableObject)) {
            return new OperationWarning("Cannot unobsolete non-obsoletable object " + item.getTarget());
        }
        if (!((ObsoletableObject)io).isObsolete()) {
            return new OperationWarning("Cannot unobsolete non-obsolete object " + io);
        }
        ((ObsoletableObject)io).setObsolete(false);
        return null;
    }

    public OperationWarning apply(DestroyObjectHistoryItem item) {
        IdentifiedObject io = this.session.getObject(item.getTarget());
        if (io == null) {
            return new OperationWarning("Cannot destroy unknown object " + io);
        }
        this.session.removeObject(io);
        return null;
    }

    public OperationWarning reverse(DestroyObjectHistoryItem item) {
        IdentifiedObject io = item.getObject();
        if (io == null) {
            return new OperationWarning("Cannot undestroy unknown object " + io);
        }
        this.session.addObject(io);
        return null;
    }

    public OperationWarning apply(DeleteLinkHistoryItem item) {
        StringRelationship sr = item.getRel();
        Link tr = this.getRealRel(sr);
        if ((tr = HistoryUtil.findChildRel(tr, tr.getParent())) == null) {
            return new OperationWarning("Couldn't find link " + sr + " in ontology");
        }
        if (tr.getChild() == null) {
            return new OperationWarning("Can't delete link with unknown child " + sr.getChild());
        }
        if (sr.getParent() != null && tr.getParent() == null) {
            return new OperationWarning("Couldn't delete relationship with unknown parent " + sr.getParent(), OperationWarning.DANGEROUS);
        }
        if (tr.getParent() != null) {
            if (tr.getType() == null) {
                return new OperationWarning("Can't delete relationship with unknown type " + sr.getType());
            }
            if (!HistoryUtil.hasChild(tr.getParent(), tr)) {
                return new OperationWarning("Couldn't delete non-existant relationship " + tr);
            }
        } else {
            return new OperationWarning("Can't delete link " + tr + " with NULL parent!");
        }
        tr.getChild().removeParent(tr);
        return null;
    }

    public OperationWarning reverse(DeleteLinkHistoryItem item) {
        StringRelationship sr = item.getRel();
        Link tr = this.getRealRel(sr);
        if (tr.getChild() == null) {
            return new OperationWarning("Can't undelete link with unknown child " + sr.getChild());
        }
        if (sr.getParent() != null && tr.getParent() == null) {
            return new OperationWarning("Couldn't undelete relationship with unknown parent " + sr.getParent(), OperationWarning.DANGEROUS);
        }
        if (tr.getParent() != null) {
            if (tr.getType() == null) {
                return new OperationWarning("Can't undelete relationship with unknown type " + sr.getType());
            }
            tr.getParent().addChild(tr);
        }
        return null;
    }

    public OperationWarning apply(TermMacroHistoryItem item) {
        item.lock(this.session);
        OperationWarning warning = new OperationWarning("Couldn't apply macro history item");
        boolean failure = false;
        for (int i = 0; i < item.size(); ++i) {
            try {
                OperationWarning w = this.apply(item.getItemAt(i));
                if (w == null) continue;
                logger.info((Object)("got warning " + w + " from " + item.getItemAt(i)));
                failure = true;
                warning.addWarning(w);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (failure) {
            return warning;
        }
        return null;
    }

    public OperationWarning reverse(TermMacroHistoryItem item) {
        OperationWarning warning = new OperationWarning("Couldn't apply macro history item");
        boolean failure = false;
        for (int i = item.size() - 1; i >= 0; --i) {
            OperationWarning w = this.reverse(item.getItemAt(i));
            if (w == null) continue;
            failure = true;
            warning.addWarning(w);
        }
        if (failure) {
            return warning;
        }
        return null;
    }

    public OperationWarning apply(LinkTypeHistoryItem item) {
        OBOProperty type = (OBOProperty)this.getRealObject(item.getRelationshipType());
        if (type == null) {
            return new OperationWarning("Couldn't do relationship type change with missing type " + item.getRelationshipType());
        }
        StringRelationship sr = item.getRel();
        Link tr = this.getRealRel(sr);
        if (tr.getParent() == null) {
            return new OperationWarning("Couldn't do relationship type change with missing parent " + sr.getParent());
        }
        if (tr.getChild() == null) {
            return new OperationWarning("Couldn't do relationship type change with missing child " + sr.getChild());
        }
        if (tr.getType() == null) {
            return new OperationWarning("Couldn't complete relationship type change with missing relationship type " + sr.getType());
        }
        if ((tr = HistoryUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't change type status of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setType(type);
        return null;
    }

    public OperationWarning reverse(LinkTypeHistoryItem item) {
        StringRelationship sr = item.getRel();
        OBOProperty type = (OBOProperty)this.getRealObject(sr.getType());
        if (type == null) {
            return new OperationWarning("Couldn't do relationship type change with missing type " + item.getRelationshipType());
        }
        Link tr = this.getRealRel(sr = new StringRelationship(sr.getChild(), item.getRelationshipType(), sr.getParent()));
        if (tr.getParent() == null) {
            return new OperationWarning("Couldn't undo relationship type change with missing parent " + sr.getParent());
        }
        if (tr.getChild() == null) {
            return new OperationWarning("Couldn't undo relationship type change with missing child " + sr.getChild());
        }
        if (tr.getType() == null) {
            return new OperationWarning("Couldn't undo relationship type change with missing relationship type " + sr.getType());
        }
        if ((tr = HistoryUtil.findChildRel(tr, tr.getParent())) == null) {
            OperationWarning cwarning = new OperationWarning("Couldn't undo type change of unknown term relationship " + tr + " because it doesn't exist in " + "the ontology");
            return cwarning;
        }
        tr.setType(type);
        return null;
    }

    public OperationWarning apply(NameChangeHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("no term for ID " + item.getTarget());
        }
        target.setName(item.getNewText());
        return null;
    }

    public OperationWarning reverse(NameChangeHistoryItem item) {
        LinkedObject target = this.getRealObject(item.getTarget());
        target.setName(item.getText());
        return null;
    }

    public OperationWarning apply(NamespaceHistoryItem item) {
        String nsid;
        LinkedObject target = this.getRealObject(item.getTarget());
        if (target == null) {
            return new OperationWarning("Could not change namespace of unrecognized term " + item.getTarget());
        }
        Namespace ns = null;
        if (item.getNewNamespace() != null && (ns = this.session.getNamespace(nsid = item.getNewNamespace().getID())) == null) {
            return new OperationWarning("Could not change namespace to unrecognized namespace " + nsid);
        }
        target.setNamespace(ns);
        return null;
    }

    public OperationWarning reverse(NamespaceHistoryItem item) {
        String nsid;
        LinkedObject target = this.getRealObject(item.getTarget());
        Namespace ns = null;
        if (item.getOldNamespace() != null && (ns = this.session.getNamespace(nsid = item.getOldNamespace().getID())) == null) {
            return new OperationWarning("Could not undo change of namespace to unrecognized namespace " + nsid);
        }
        target.setNamespace(ns);
        return null;
    }

    public OperationWarning apply(DefinitionChangeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof DefinedObject)) {
            return new OperationWarning("Could not apply definition change to non definable object " + item.getTarget());
        }
        DefinedObject target = (DefinedObject)o;
        target.setDefinition(item.getNewText());
        return null;
    }

    public OperationWarning reverse(DefinitionChangeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof DefinedObject)) {
            return new OperationWarning("Could not reverse definition change to non-definable object " + item.getTarget());
        }
        DefinedObject target = (DefinedObject)o;
        target.setDefinition(item.getText());
        return null;
    }

    public OperationWarning apply(CommentChangeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof CommentedObject)) {
            return new OperationWarning("Could not apply comment change to non-commentable object " + item.getTarget());
        }
        CommentedObject target = (CommentedObject)o;
        target.setComment(item.getNewText());
        return null;
    }

    public OperationWarning reverse(CommentChangeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof CommentedObject)) {
            return new OperationWarning("Could not reverse comment change to non-commentable object " + item.getTarget());
        }
        CommentedObject target = (CommentedObject)o;
        target.setComment(item.getText());
        return null;
    }

    public OperationWarning apply(SubsetChangeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SubsetObject)) {
            return new OperationWarning("Could not apply category change to non-categorizable object " + item.getTarget());
        }
        SubsetObject target = (SubsetObject)((Object)o);
        TermSubset cat = this.session.getCategory(item.getCategory());
        if (item.isDel()) {
            target.removeCategory(cat);
        } else {
            target.addCategory(cat);
        }
        return null;
    }

    public OperationWarning reverse(SubsetChangeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SubsetObject)) {
            return new OperationWarning("Could not reverse category change to non-categorizable object " + item.getTarget());
        }
        SubsetObject target = (SubsetObject)((Object)o);
        TermSubset cat = this.session.getCategory(item.getCategory());
        if (item.isDel()) {
            target.addCategory(cat);
        } else {
            target.removeCategory(cat);
        }
        return null;
    }

    public OperationWarning apply(ChangeSynScopeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not change synonym scope in non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        Synonym s = HistoryUtil.findSynonym(target, item.getSynonym());
        if (s == null) {
            return new OperationWarning("Couldn't modify non-existant synonym " + item.getSynonym());
        }
        s.setScope(item.getNewScope());
        return null;
    }

    public OperationWarning reverse(ChangeSynScopeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not change synonym scope in non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        Synonym s = HistoryUtil.findSynonym(target, item.getSynonym());
        if (s == null) {
            return new OperationWarning("Couldn't modify non-existant synonym " + item.getSynonym());
        }
        s.setScope(item.getOldScope());
        return null;
    }

    public OperationWarning apply(ChangeSynTypeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not change synonym type in non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        Synonym s = HistoryUtil.findSynonym(target, item.getSynonym());
        if (s == null) {
            return new OperationWarning("Couldn't modify non-existant synonym " + item.getSynonym());
        }
        SynonymType cat = null;
        if (item.getNewType() != null && (cat = this.session.getSynonymType(item.getNewType())) == null) {
            return new OperationWarning("Couldn't find category " + item.getNewType());
        }
        s.setSynonymType(cat);
        return null;
    }

    public OperationWarning reverse(ChangeSynTypeHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not change synonym category in non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        Synonym s = HistoryUtil.findSynonym(target, item.getSynonym());
        if (s == null) {
            return new OperationWarning("Couldn't modify non-existant synonym " + item.getSynonym());
        }
        SynonymType cat = null;
        if (item.getOldType() != null && (cat = this.session.getSynonymType(item.getOldType())) == null) {
            return new OperationWarning("Couldn't find type " + item.getOldType());
        }
        s.setSynonymType(cat);
        return null;
    }

    public OperationWarning apply(AddConsiderHistoryItem item) {
        LinkedObject o = this.getRealObject(item.getTarget());
        if (o == null) {
            return new OperationWarning("Could not add consider term to unknown target " + item.getTarget());
        }
        if (!(o instanceof ObsoletableObject)) {
            return new OperationWarning("Could not add consider term to non-obsoletable term " + o);
        }
        ObsoletableObject target = (ObsoletableObject)((Object)o);
        LinkedObject consider = this.getRealObject(item.getConsider());
        if (consider == null) {
            return new OperationWarning("Could not add unknown consider term " + item.getConsider() + " to " + target);
        }
        if (!(consider instanceof ObsoletableObject)) {
            return new OperationWarning("Could not add non-obsoletable term " + consider + " as consider term for " + target);
        }
        target.addConsiderReplacement((ObsoletableObject)((Object)consider));
        return null;
    }

    public OperationWarning reverse(AddConsiderHistoryItem item) {
        LinkedObject o = this.getRealObject(item.getTarget());
        if (o == null) {
            return new OperationWarning("Could not reverse addition of consider term to unknown target " + item.getTarget());
        }
        if (!(o instanceof ObsoletableObject)) {
            return new OperationWarning("Could not reverse addition of consider term to non-obsoletable term " + o);
        }
        ObsoletableObject target = (ObsoletableObject)((Object)o);
        LinkedObject consider = this.getRealObject(item.getConsider());
        if (consider == null) {
            return new OperationWarning("Could not reverse addition of unknown consider term " + item.getConsider() + " to " + target);
        }
        if (!(consider instanceof ObsoletableObject)) {
            return new OperationWarning("Could not reverse addition of non-obsoletable term " + consider + " as consider term for " + target);
        }
        target.removeConsiderReplacement((ObsoletableObject)((Object)consider));
        return null;
    }

    public OperationWarning apply(RemoveConsiderHistoryItem item) {
        LinkedObject o = this.getRealObject(item.getTarget());
        if (o == null) {
            return new OperationWarning("Could not rremove consider term from unknown target " + item.getTarget());
        }
        if (!(o instanceof ObsoletableObject)) {
            return new OperationWarning("Could not remove consider term from non-obsoletable term " + o);
        }
        ObsoletableObject target = (ObsoletableObject)((Object)o);
        LinkedObject consider = this.getRealObject(item.getConsider());
        if (consider == null) {
            return new OperationWarning("Could not remove unknown consider term " + item.getConsider() + " from " + target);
        }
        if (!(consider instanceof ObsoletableObject)) {
            return new OperationWarning("Could not remove non-obsoletable term " + consider + " as consider term for " + target);
        }
        target.removeConsiderReplacement((ObsoletableObject)((Object)consider));
        return null;
    }

    public OperationWarning reverse(RemoveConsiderHistoryItem item) {
        LinkedObject o = this.getRealObject(item.getTarget());
        if (o == null) {
            return new OperationWarning("Could not remove consider term from unknown target " + item.getTarget());
        }
        if (!(o instanceof ObsoletableObject)) {
            return new OperationWarning("Could not remove consider term from non-obsoletable term " + o);
        }
        ObsoletableObject target = (ObsoletableObject)((Object)o);
        LinkedObject consider = this.getRealObject(item.getConsider());
        if (consider == null) {
            return new OperationWarning("Could not remove unknown consider term " + item.getConsider() + " from " + target);
        }
        if (!(consider instanceof ObsoletableObject)) {
            return new OperationWarning("Could not remove non-obsoletable term " + consider + " as consider term for " + target);
        }
        target.addConsiderReplacement((ObsoletableObject)((Object)consider));
        return null;
    }

    public OperationWarning apply(AddSynonymHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not add synonym to non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        Synonym s = this.session.getObjectFactory().createSynonym(item.getSynonym(), 0);
        if (HistoryUtil.findSynonym(target, s) != null) {
            return new OperationWarning("Could not add synonym " + s + " to " + item.getTarget() + " because that synonym has already been added");
        }
        target.addSynonym(s);
        return null;
    }

    public OperationWarning reverse(AddSynonymHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not remove synonym from non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        Synonym s = HistoryUtil.findSynonym(target, item.getSynonym());
        if (s == null) {
            return new OperationWarning("Could not delete non-existant synonym " + s + " of " + target);
        }
        target.removeSynonym(s);
        return null;
    }

    public OperationWarning reverse(DelSynonymHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not add synonym to non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        target.addSynonym(this.session.getObjectFactory().createSynonym(item.getSynonym(), 0));
        return null;
    }

    public OperationWarning apply(DelSynonymHistoryItem item) {
        IdentifiedObject o = this.getRealIDObject(item.getTarget());
        if (!(o instanceof SynonymedObject)) {
            return new OperationWarning("Could not reverse synonym change to non-synonymable object " + item.getTarget());
        }
        SynonymedObject target = (SynonymedObject)o;
        Synonym s = HistoryUtil.findSynonym(target, item.getSynonym());
        if (s == null) {
            return new OperationWarning("Could not delete non-existant synonym " + s + " of " + target);
        }
        target.removeSynonym(s);
        return null;
    }

    @Override
    public OperationWarning reverse(HistoryItem item) {
        OperationWarning warning = item instanceof CreateObjectHistoryItem ? this.reverse((CreateObjectHistoryItem)item) : (item instanceof CreateLinkHistoryItem ? this.reverse((CreateLinkHistoryItem)item) : (item instanceof DeleteLinkHistoryItem ? this.reverse((DeleteLinkHistoryItem)item) : (item instanceof DestroyObjectHistoryItem ? this.reverse((DestroyObjectHistoryItem)item) : (item instanceof ObsoleteObjectHistoryItem ? this.reverse((ObsoleteObjectHistoryItem)item) : (item instanceof TermMacroHistoryItem ? this.reverse((TermMacroHistoryItem)item) : (item instanceof LinkTypeHistoryItem ? this.reverse((LinkTypeHistoryItem)item) : (item instanceof NamespaceHistoryItem ? this.reverse((NamespaceHistoryItem)item) : (item instanceof NameChangeHistoryItem ? this.reverse((NameChangeHistoryItem)item) : (item instanceof DefinitionChangeHistoryItem ? this.reverse((DefinitionChangeHistoryItem)item) : (item instanceof AddSynonymHistoryItem ? this.reverse((AddSynonymHistoryItem)item) : (item instanceof DelSynonymHistoryItem ? this.reverse((DelSynonymHistoryItem)item) : (item instanceof TermSubsetHistoryItem ? this.reverse((TermSubsetHistoryItem)item) : (item instanceof SynonymTypeHistoryItem ? this.reverse((SynonymTypeHistoryItem)item) : (item instanceof ChangeSynTypeHistoryItem ? this.reverse((ChangeSynTypeHistoryItem)item) : (item instanceof ChangeSynScopeHistoryItem ? this.reverse((ChangeSynScopeHistoryItem)item) : (item instanceof TermNamespaceHistoryItem ? this.reverse((TermNamespaceHistoryItem)item) : (item instanceof AddDbxrefHistoryItem ? this.reverse((AddDbxrefHistoryItem)item) : (item instanceof DelDbxrefHistoryItem ? this.reverse((DelDbxrefHistoryItem)item) : (item instanceof CommentChangeHistoryItem ? this.reverse((CommentChangeHistoryItem)item) : (item instanceof SubsetChangeHistoryItem ? this.reverse((SubsetChangeHistoryItem)item) : (item instanceof SecondaryIDHistoryItem ? this.reverse((SecondaryIDHistoryItem)item) : (item instanceof NecessarilyTrueHistoryItem ? this.reverse((NecessarilyTrueHistoryItem)item) : (item instanceof InverseNecHistoryItem ? this.reverse((InverseNecHistoryItem)item) : (item instanceof CardinalityHistoryItem ? this.reverse((CardinalityHistoryItem)item) : (item instanceof CompletesHistoryItem ? this.reverse((CompletesHistoryItem)item) : (item instanceof TRNamespaceHistoryItem ? this.reverse((TRNamespaceHistoryItem)item) : (item instanceof RangeHistoryItem ? this.reverse((RangeHistoryItem)item) : (item instanceof DomainHistoryItem ? this.reverse((DomainHistoryItem)item) : (item instanceof AddReplacementHistoryItem ? this.reverse((AddReplacementHistoryItem)item) : (item instanceof RemoveReplacementHistoryItem ? this.reverse((RemoveReplacementHistoryItem)item) : (item instanceof CyclicHistoryItem ? this.reverse((CyclicHistoryItem)item) : (item instanceof SymmetricHistoryItem ? this.reverse((SymmetricHistoryItem)item) : (item instanceof TransitiveHistoryItem ? this.reverse((TransitiveHistoryItem)item) : (item instanceof CardinalityHistoryItem ? this.reverse((CardinalityHistoryItem)item) : (item instanceof MinCardinalityHistoryItem ? this.reverse((MinCardinalityHistoryItem)item) : (item instanceof MaxCardinalityHistoryItem ? this.reverse((MaxCardinalityHistoryItem)item) : (item instanceof AddConsiderHistoryItem ? this.reverse((AddConsiderHistoryItem)item) : (item instanceof RemoveConsiderHistoryItem ? this.reverse((RemoveConsiderHistoryItem)item) : (item instanceof AddPropertyValueHistoryItem ? this.reverse((AddPropertyValueHistoryItem)item) : (item instanceof DeletePropertyValueHistoryItem ? this.reverse((DeletePropertyValueHistoryItem)item) : new OperationWarning("Unknown history item found!")))))))))))))))))))))))))))))))))))))))));
        for (OperationModel lockstepModel : this.lockstepModels) {
            OperationWarning lwarning = lockstepModel.reverse(item);
            if (lwarning == null) continue;
            warning.addWarning(lwarning);
        }
        return warning;
    }

    @Override
    public void addLockstepModel(OperationModel model) {
        this.lockstepModels.add(model);
    }

    @Override
    public void removeLockstepModel(OperationModel model) {
        this.lockstepModels.remove(model);
    }
}

