/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.bbop.util.Subset;
import org.bbop.util.VectorFilter;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.impl.AbstractLinkDatabase;
import org.obo.filters.Filter;

public class FilteredLinkDatabase
extends AbstractLinkDatabase {
    protected static final Logger logger = Logger.getLogger(FilteredLinkDatabase.class);
    private static final long serialVersionUID = 8789956339731954652L;
    protected Filter termFilter;
    protected Filter linkFilter;
    protected LinkDatabase linkDatabase;
    protected boolean allowDangling = false;
    protected boolean followIsaClosure = false;
    protected final VectorFilter childFilter = new VectorFilter(){
        private static final long serialVersionUID = -4341033786269422197L;

        public boolean satisfies(Object o) {
            if (o instanceof Link) {
                return FilteredLinkDatabase.this.satisfiesChild((Link)o);
            }
            return false;
        }
    };
    protected final VectorFilter parentFilter = new VectorFilter(){
        private static final long serialVersionUID = 8146325578230708703L;

        public boolean satisfies(Object o) {
            if (o instanceof Link) {
                return FilteredLinkDatabase.this.satisfiesParent((Link)o);
            }
            return false;
        }
    };
    protected Subset reusableSet;
    public static final int LOCAL_CACHE = 0;
    public static final int REUSABLE_ITERATOR = 4;
    protected int filterMethod;
    protected Subset reusableSubset = new Subset();

    public FilteredLinkDatabase(LinkDatabase linkDatabase) {
        this.setFilterMethod(0);
        this.linkDatabase = linkDatabase;
    }

    public void setLinkDatabase(LinkDatabase linkDatabase) {
        this.linkDatabase = linkDatabase;
    }

    public void setAllowDangling(boolean allowDangling) {
        this.allowDangling = allowDangling;
    }

    public boolean getAllowDangling() {
        return this.allowDangling;
    }

    public void setFollowIsaClosure(boolean followIsaClosure) {
        this.followIsaClosure = followIsaClosure;
    }

    public boolean getFollowIsaClosure() {
        return this.followIsaClosure;
    }

    protected boolean isPassThrough() {
        return this.linkFilter == null && this.termFilter == null;
    }

    public void setFilterMethod(int filterMethod) {
        this.reusableSet = filterMethod == 4 ? new Subset() : null;
        this.filterMethod = filterMethod;
    }

    public LinkDatabase getLinkDatabase() {
        return this.linkDatabase;
    }

    @Override
    public Collection<Link> getChildren(LinkedObject lo) {
        if (this.isPassThrough()) {
            return this.linkDatabase.getChildren(lo);
        }
        if (this.filterMethod == 0) {
            return new Subset(this.childFilter, this.linkDatabase.getChildren(lo));
        }
        if (this.filterMethod == 4) {
            this.reusableSubset.setFilter(this.childFilter);
            this.reusableSubset.setData(this.linkDatabase.getChildren(lo));
            return this.reusableSubset;
        }
        return null;
    }

    @Override
    public Collection<Link> getParents(LinkedObject lo) {
        if (this.isPassThrough()) {
            return this.linkDatabase.getParents(lo);
        }
        if (this.filterMethod == 0) {
            return new Subset(this.parentFilter, this.linkDatabase.getParents(lo));
        }
        if (this.filterMethod == 4) {
            this.reusableSubset.setFilter(this.parentFilter);
            this.reusableSubset.setData(this.linkDatabase.getParents(lo));
            return this.reusableSubset;
        }
        return null;
    }

    @Override
    public Collection<IdentifiedObject> getObjects() {
        if (this.termFilter == null) {
            return this.linkDatabase.getObjects();
        }
        return new Subset((VectorFilter)this.termFilter, this.linkDatabase.getObjects());
    }

    protected boolean satisfiesChild(Link link) {
        if (this.linkFilter == null) {
            return this.allowDangling || this.satisfies(link.getChild());
        }
        return this.linkFilter.satisfies(link) && (this.allowDangling || this.satisfies(link.getChild()));
    }

    protected boolean satisfiesParent(Link link) {
        if (this.linkFilter == null) {
            return this.satisfies(link.getChild()) && (this.allowDangling || this.satisfies(link.getParent()));
        }
        return this.linkFilter.satisfies(link) && (this.allowDangling || this.satisfies(link.getParent()));
    }

    protected boolean satisfies(LinkedObject lo) {
        return this.termFilter == null || this.termFilter.satisfies(lo);
    }

    public void setFilters(Filter termFilter, Filter linkFilter) {
        this.termFilter = termFilter;
        this.linkFilter = linkFilter;
    }

    public void setLinkFilter(Filter linkFilter) {
        this.linkFilter = linkFilter;
    }

    public void setTermFilter(Filter termFilter) {
        this.termFilter = termFilter;
    }

    @Override
    public IdentifiedObject getObject(String id) {
        IdentifiedObject out = this.linkDatabase.getObject(id);
        if (out == null) {
            return null;
        }
        if (this.termFilter == null || this.termFilter.satisfies(out)) {
            return out;
        }
        return null;
    }
}

