/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.obo.datamodel.Link;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.impl.AnnotatedObjectImpl;

public abstract class LinkedAnnotatedObjectImpl
extends AnnotatedObjectImpl
implements OBOObject {
    protected Collection<Link> parents = null;
    protected Collection<Link> children = null;

    public LinkedAnnotatedObjectImpl(String id) {
        super(id);
    }

    @Override
    public Collection<Link> getChildren() {
        if (this.children == null) {
            return Collections.emptySet();
        }
        return this.children;
    }

    @Override
    public void addChild(Link tr) {
        this.atomicAddChild(tr);
        if (tr.getChild() != null) {
            tr.getChild().atomicAddParent(tr);
        }
    }

    @Override
    public void removeChild(Link tr) {
        this.atomicRemoveChild(tr);
        if (tr.getChild() != null) {
            tr.getChild().atomicRemoveParent(tr);
        }
    }

    @Override
    public void addParent(Link tr) {
        this.atomicAddParent(tr);
        if (tr.getParent() != null) {
            tr.getParent().atomicAddChild(tr);
        }
    }

    @Override
    public void removeParent(Link tr) {
        this.atomicRemoveParent(tr);
        if (tr.getParent() != null) {
            tr.getParent().atomicRemoveChild(tr);
        }
    }

    @Override
    public void atomicAddChild(Link tr) {
        tr.setParent(this);
        if (this.children == null) {
            this.children = this.createCollection();
        }
        this.children.add(tr);
    }

    protected Collection<Link> createCollection() {
        return new LinkedHashSet<Link>();
    }

    @Override
    public void atomicRemoveChild(Link tr) {
        if (this.children != null) {
            this.children.remove(tr);
            if (this.children.size() == 0) {
                this.children = null;
            }
        }
    }

    @Override
    public void atomicAddParent(Link tr) {
        tr.setChild(this);
        if (this.parents == null) {
            this.parents = this.createCollection();
        }
        this.parents.add(tr);
    }

    @Override
    public void atomicRemoveParent(Link tr) {
        if (this.parents != null) {
            this.parents.remove(tr);
            if (this.parents.size() == 0) {
                this.parents = null;
            }
        }
    }

    @Override
    public Collection<Link> getParents() {
        if (this.parents == null) {
            return Collections.emptySet();
        }
        return this.parents;
    }

    @Override
    public Object clone() {
        try {
            LinkedAnnotatedObjectImpl out = (LinkedAnnotatedObjectImpl)super.clone();
            out.children = this.createCollection();
            for (Link tr : this.getChildren()) {
                out.atomicAddChild((Link)tr.clone());
            }
            out.parents = this.createCollection();
            for (Link tr : this.getParents()) {
                out.atomicAddParent((Link)tr.clone());
            }
            return out;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public int compareTo(Object in) {
        if (in instanceof OBOObject) {
            String namea = this.getName();
            String nameb = ((OBOObject)in).getName();
            if (namea == null && nameb == null) {
                return 0;
            }
            if (namea == null) {
                return -1;
            }
            if (nameb == null) {
                return 1;
            }
            int cmp = this.getName().toUpperCase().compareTo(((OBOObject)in).getName().toUpperCase());
            if (cmp == 0) {
                return this.getID().toUpperCase().compareTo(((OBOObject)in).getID().toUpperCase());
            }
            return cmp;
        }
        return this.toString().compareToIgnoreCase(in.toString());
    }
}

