/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.util.Subset;
import org.bbop.util.VectorFilter;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.impl.AbstractLinkDatabase;

public class MaskedLinkDatabase
extends AbstractLinkDatabase {
    protected static final Logger logger = Logger.getLogger(MaskedLinkDatabase.class);
    private static final long serialVersionUID = 7258651844551493906L;
    protected LinkDatabase linkDatabase;
    protected Set<IdentifiedObject> visibleObjects = new HashSet<IdentifiedObject>();
    protected VectorFilter parentFilter = new VectorFilter(){

        public boolean satisfies(Object in) {
            return MaskedLinkDatabase.this.visibleObjects.contains(((Link)in).getParent());
        }
    };
    protected VectorFilter childFilter = new VectorFilter(){

        public boolean satisfies(Object in) {
            return MaskedLinkDatabase.this.visibleObjects.contains(((Link)in).getChild());
        }
    };

    public MaskedLinkDatabase() {
    }

    public MaskedLinkDatabase(LinkDatabase linkDatabase) {
        this.linkDatabase = linkDatabase;
    }

    public void setVisible(IdentifiedObject io, boolean visible) {
        if (visible) {
            this.visibleObjects.add(io);
        } else {
            this.visibleObjects.remove(io);
        }
    }

    public void setVisible(Collection<? extends IdentifiedObject> c, boolean visible) {
        if (visible) {
            this.visibleObjects.addAll(c);
        } else {
            this.visibleObjects.removeAll(c);
        }
    }

    @Override
    public Collection<IdentifiedObject> getObjects() {
        return this.visibleObjects;
    }

    public void recache() {
        this.visibleObjects.clear();
    }

    @Override
    public Collection<Link> getParents(LinkedObject lo) {
        return new Subset(this.parentFilter, this.linkDatabase.getParents(lo));
    }

    @Override
    public Collection<Link> getChildren(LinkedObject lo) {
        return new Subset(this.childFilter, this.linkDatabase.getChildren(lo));
    }

    @Override
    public IdentifiedObject getObject(String id) {
        IdentifiedObject out = this.linkDatabase.getObject(id);
        if (this.visibleObjects.contains(out)) {
            return out;
        }
        return null;
    }
}

