/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.util.FastSuperset;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.impl.AbstractLinkDatabase;

public class MergedLinkDatabase
extends AbstractLinkDatabase
implements LinkDatabase {
    protected static final Logger logger = Logger.getLogger(MergedLinkDatabase.class);
    private static final long serialVersionUID = -1566436832426439038L;
    protected Set<LinkDatabase> databases = new LinkedHashSet<LinkDatabase>();

    public Set<LinkDatabase> getDatabases() {
        return this.databases;
    }

    public void addDatabase(LinkDatabase db) {
        this.databases.add(db);
    }

    public void removeDatabase(LinkDatabase db) {
        this.databases.remove(db);
    }

    @Override
    public Collection<IdentifiedObject> getObjects() {
        if (this.databases.size() == 1) {
            LinkDatabase db = this.databases.iterator().next();
            return db.getObjects();
        }
        FastSuperset out = new FastSuperset();
        for (LinkDatabase db : this.databases) {
            out.addSubset(db.getObjects());
        }
        return out;
    }

    @Override
    public Collection<Link> getParents(LinkedObject lo) {
        if (this.databases.size() == 1) {
            LinkDatabase db = this.databases.iterator().next();
            return db.getParents(lo);
        }
        FastSuperset out = new FastSuperset();
        for (LinkDatabase db : this.databases) {
            out.addSubset(db.getParents(lo));
        }
        return out;
    }

    @Override
    public Collection<Link> getChildren(LinkedObject lo) {
        if (this.databases.size() == 1) {
            LinkDatabase db = this.databases.iterator().next();
            return db.getChildren(lo);
        }
        FastSuperset out = new FastSuperset();
        for (LinkDatabase db : this.databases) {
            out.addSubset(db.getChildren(lo));
        }
        return out;
    }

    @Override
    public IdentifiedObject getObject(String id) {
        for (LinkDatabase linkDatabase : this.databases) {
            IdentifiedObject io = linkDatabase.getObject(id);
            if (io == null) continue;
            return io;
        }
        return null;
    }

    @Override
    public boolean hasChildren(LinkedObject lo) {
        for (LinkDatabase linkDatabase : this.databases) {
            if (!linkDatabase.hasChildren(lo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasParents(LinkedObject lo) {
        for (LinkDatabase linkDatabase : this.databases) {
            if (!linkDatabase.hasParents(lo)) continue;
            return true;
        }
        return false;
    }
}

